/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.mapping.xml;

import java.util.List;
import junit.framework.TestCase;
import org.teiid.query.mapping.xml.MappingAllNode;
import org.teiid.query.mapping.xml.MappingAttribute;
import org.teiid.query.mapping.xml.MappingChoiceNode;
import org.teiid.query.mapping.xml.MappingCommentNode;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingElement;
import org.teiid.query.mapping.xml.MappingRecursiveElement;
import org.teiid.query.mapping.xml.MappingSequenceNode;
import org.teiid.query.mapping.xml.Namespace;

public class TestMappingElement
extends TestCase {
    public void testRecusrive() {
        MappingElement element = new MappingElement("Test");
        TestMappingElement.assertFalse((boolean)element.isRecursive());
    }

    public void testNamespace() {
        MappingElement element = new MappingElement("Test");
        TestMappingElement.assertEquals((String)"Test", (String)element.getName());
        TestMappingElement.assertNull((Object)element.getNamespacePrefix());
        Namespace namespace = new Namespace("foo", "protocol://someuri");
        element = new MappingElement("Test", namespace);
        TestMappingElement.assertEquals((String)"foo", (String)element.getNamespacePrefix());
        TestMappingElement.assertEquals((int)element.getNamespaces().length, (int)0);
        element.addNamespace(namespace);
        TestMappingElement.assertEquals((int)element.getNamespaces().length, (int)1);
        element.addNamespace(new Namespace("ns1", "http://mm.com"));
        TestMappingElement.assertEquals((int)element.getNamespaces().length, (int)2);
        TestMappingElement.assertEquals((String)"ns1", (String)element.getNamespaces()[0].getPrefix());
        TestMappingElement.assertEquals((String)"foo", (String)element.getNamespaces()[1].getPrefix());
    }

    public void testNameInSource() {
        MappingElement element = new MappingElement("Test");
        TestMappingElement.assertNull((Object)element.getNameInSource());
        element.setNameInSource(null);
        TestMappingElement.assertNull((Object)element.getNameInSource());
        element.setNameInSource("sourceName");
        TestMappingElement.assertEquals((String)"sourceName", (String)element.getNameInSource());
        element = new MappingElement("Test", "sourceName");
        TestMappingElement.assertEquals((String)"sourceName", (String)element.getNameInSource());
    }

    public void testNillable() {
        MappingElement element = new MappingElement("Test");
        TestMappingElement.assertFalse((boolean)element.isNillable());
        element.setNillable(true);
        TestMappingElement.assertTrue((boolean)element.isNillable());
    }

    public void testDefaultValue() {
        MappingElement element = new MappingElement("Test");
        TestMappingElement.assertNull((Object)element.getDefaultValue());
        element.setDefaultValue("foo");
        TestMappingElement.assertEquals((String)"foo", (String)element.getDefaultValue());
    }

    public void testFixedValue() {
        MappingElement element = new MappingElement("Test");
        TestMappingElement.assertNull((Object)element.getValue());
        element.setValue("foo");
        TestMappingElement.assertEquals((String)"foo", (String)element.getValue());
    }

    public void testOptional() {
        MappingElement element = new MappingElement("Test");
        TestMappingElement.assertFalse((boolean)element.isOptional());
        element.setOptional(true);
        TestMappingElement.assertTrue((boolean)element.isOptional());
    }

    public void testNormalizeText() {
        MappingElement element = new MappingElement("Test");
        TestMappingElement.assertEquals((String)"preserve", (String)element.getNormalizeText());
        element.setNormalizeText("foo");
        TestMappingElement.assertEquals((String)"foo", (String)element.getNormalizeText());
    }

    public void testType() {
        MappingElement element = new MappingElement("Test");
        TestMappingElement.assertNull((Object)element.getType());
        element.setType("int");
        TestMappingElement.assertEquals((String)"int", (String)element.getType());
    }

    public void testInclude() {
        MappingElement element = new MappingElement("Test");
        TestMappingElement.assertTrue((boolean)element.isAlwaysInclude());
        element.setAlwaysInclude(false);
        TestMappingElement.assertFalse((boolean)element.isAlwaysInclude());
    }

    public void testMinOccurence() {
        MappingElement element = new MappingElement("Test");
        TestMappingElement.assertEquals((int)1, (int)element.getMinOccurence());
        element.setMinOccurrs(2);
        TestMappingElement.assertEquals((int)2, (int)element.getMinOccurence());
    }

    public void testMaxOccurence() {
        MappingElement element = new MappingElement("Test");
        TestMappingElement.assertEquals((int)1, (int)element.getMaxOccurence());
        element.setMaxOccurrs(2);
        TestMappingElement.assertEquals((int)2, (int)element.getMaxOccurence());
    }

    public void testExclude() {
        MappingElement element = new MappingElement("Test");
        TestMappingElement.assertFalse((boolean)element.isExcluded());
        element.setExclude(true);
        TestMappingElement.assertTrue((boolean)element.isExcluded());
    }

    public void testSource() {
        MappingElement element = new MappingElement("Test");
        TestMappingElement.assertNull((Object)element.getSource());
    }

    public void testChildren() {
        MappingElement element = new MappingElement("Test");
        element.addCommentNode(new MappingCommentNode("this is comment text"));
        element.addAttribute(new MappingAttribute("foo", "fooReal"));
        element.addChildElement(new MappingElement("child1"));
        element.addChoiceNode(new MappingChoiceNode());
        element.addSequenceNode(new MappingSequenceNode());
        element.addAllNode(new MappingAllNode());
        TestMappingElement.assertEquals((int)5, (int)element.getNodeChildren().size());
        TestMappingElement.assertEquals((int)1, (int)element.getAttributes().size());
        List list = element.getNodeChildren();
        TestMappingElement.assertTrue((boolean)(list.get(0) instanceof MappingCommentNode));
        TestMappingElement.assertTrue((boolean)(list.get(1) instanceof MappingElement));
        TestMappingElement.assertTrue((boolean)(list.get(2) instanceof MappingChoiceNode));
        TestMappingElement.assertTrue((boolean)(list.get(3) instanceof MappingSequenceNode));
        TestMappingElement.assertTrue((boolean)(list.get(4) instanceof MappingAllNode));
    }

    public void testAddRecursiveElement() {
        MappingDocument doc = new MappingDocument(false);
        MappingElement root = doc.addChildElement(new MappingElement("root"));
        MappingElement nodeA = root.addChildElement(new MappingElement("NodeA", "test.nodea"));
        nodeA.setSource("recursive.test");
        MappingSequenceNode seq = nodeA.addSequenceNode(new MappingSequenceNode());
        MappingElement nodeB = seq.addChildElement(new MappingElement("NodeB", "test.nodeb"));
        TestMappingElement.assertFalse((boolean)nodeA.isRootRecursiveNode());
        MappingRecursiveElement rElem = (MappingRecursiveElement)nodeB.addChildElement((MappingElement)new MappingRecursiveElement("RecursiveNodeA", "recursive.test"));
        TestMappingElement.assertTrue((boolean)rElem.isRecursive());
        TestMappingElement.assertTrue((boolean)nodeA.isRootRecursiveNode());
    }

    public void testAddBADRecursiveElement() {
        MappingDocument doc = new MappingDocument(false);
        MappingElement root = doc.addChildElement(new MappingElement("root"));
        MappingElement nodeA = root.addChildElement(new MappingElement("NodeA", "test.nodea"));
        nodeA.setSource("recursive.test");
        MappingSequenceNode seq = nodeA.addSequenceNode(new MappingSequenceNode());
        MappingElement nodeB = seq.addChildElement(new MappingElement("NodeB", "test.nodeb"));
        TestMappingElement.assertFalse((boolean)nodeA.isRootRecursiveNode());
        try {
            nodeB.addChildElement((MappingElement)new MappingRecursiveElement("RecursiveNodeA", "unknown mapping"));
            TestMappingElement.fail((String)"should have failed to add a node with unknown mapping class");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
    }

    public void testAddNullStagingTable() {
        MappingElement element = new MappingElement("Test");
        element.addStagingTable(null);
        List stagingTables = element.getStagingTables();
        TestMappingElement.assertTrue((boolean)stagingTables.isEmpty());
    }
}

