/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.List;
import junit.framework.TestCase;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.XMLType;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.Into;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;

public class TestQuery
extends TestCase {
    public TestQuery(String name) {
        super(name);
    }

    public static final Query sample1() {
        Query q2 = new Query();
        Select select = new Select();
        select.addSymbol((Expression)new ElementSymbol("y"));
        q2.setSelect(select);
        From from = new From();
        from.addGroup(new GroupSymbol("h"));
        q2.setFrom(from);
        OrderBy orderBy = new OrderBy();
        orderBy.addVariable((Expression)new ElementSymbol("x"));
        q2.setOrderBy(orderBy);
        return q2;
    }

    public static final Query sample2() {
        Query q1 = new Query();
        Select select = new Select();
        select.addSymbol((Expression)new ElementSymbol("xml"));
        q1.setSelect(select);
        q1.setIsXML(true);
        From from = new From();
        from.addGroup(new GroupSymbol("xmltest.doc1"));
        q1.setFrom(from);
        return q1;
    }

    public void testSelfEquivalence() {
        Query s1 = TestQuery.sample1();
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s1);
    }

    public void testEquivalence() {
        Query s1 = TestQuery.sample1();
        Query s1a = TestQuery.sample1();
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s1a);
    }

    public void testNonEquivalence() {
        Query s1 = TestQuery.sample1();
        Query s2 = TestQuery.sample2();
        int equals = -1;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s2);
    }

    public void testNonEquivalence2() {
        Query s1 = TestQuery.sample1();
        Query s2 = TestQuery.sample1();
        s2.setIsXML(true);
        int equals = -1;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s2);
    }

    public void testClone() {
        Query q = TestQuery.sample2();
        Query qclone = (Query)q.clone();
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)q, (Object)qclone);
    }

    public void testAreResultsCachable() {
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((Expression)new ElementSymbol("y"));
        query.setSelect(select);
        From from = new From();
        from.addGroup(new GroupSymbol("h"));
        query.setFrom(from);
        TestQuery.assertTrue((boolean)query.areResultsCachable());
        select = new Select();
        ElementSymbol column = new ElementSymbol("y");
        column.setType(BlobType.class);
        select.addSymbol((Expression)column);
        query.setSelect(select);
        query.setFrom(from);
        TestQuery.assertTrue((boolean)query.areResultsCachable());
        select = new Select();
        column = new ElementSymbol("y");
        column.setType(ClobType.class);
        select.addSymbol((Expression)column);
        query.setSelect(select);
        query.setFrom(from);
        TestQuery.assertTrue((boolean)query.areResultsCachable());
        select = new Select();
        column = new ElementSymbol("y");
        column.setType(XMLType.class);
        select.addSymbol((Expression)column);
        query.setSelect(select);
        query.setFrom(from);
        TestQuery.assertTrue((boolean)query.areResultsCachable());
    }

    public void testClone2() {
        Query q = TestQuery.sample2();
        List projectedSymbols = q.getProjectedSymbols();
        TestQuery.assertTrue((projectedSymbols == q.getProjectedSymbols() ? 1 : 0) != 0);
        Query qclone = (Query)q.clone();
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)q, (Object)qclone);
        TestQuery.assertEquals((Object)projectedSymbols, (Object)qclone.getProjectedSymbols());
    }

    public void testClone3() {
        Query q = TestQuery.sample2();
        q.setInto(new Into(new GroupSymbol("#foo")));
        Query qclone = (Query)q.clone();
        TestQuery.assertNotNull((Object)qclone.getInto());
    }
}

