/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.xml;

import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.logging.LogManager;
import org.teiid.query.mapping.xml.MappingNodeConstants;
import org.teiid.query.processor.xml.DocumentInProgress;
import org.teiid.query.processor.xml.ProcessorInstruction;
import org.teiid.query.processor.xml.XMLContext;
import org.teiid.query.processor.xml.XMLProcessorEnvironment;

public class InitializeDocumentInstruction
extends ProcessorInstruction {
    private String encoding;
    private boolean isFormatted;

    public InitializeDocumentInstruction() {
        this.encoding = "UTF-8";
        this.isFormatted = MappingNodeConstants.Defaults.DEFAULT_FORMATTED_DOCUMENT;
    }

    public InitializeDocumentInstruction(String encoding, boolean isFormatted) {
        this.encoding = encoding;
        this.isFormatted = isFormatted;
    }

    void setXMLFormat(boolean isFormatted) {
        this.isFormatted = isFormatted;
    }

    @Override
    public XMLContext process(XMLProcessorEnvironment env, XMLContext context) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        LogManager.logTrace((String)"org.teiid.PROCESSOR.XML_PLAN", (Object)"DOC begin");
        if (!env.isRecursiveProgramInStack()) {
            DocumentInProgress doc = new DocumentInProgress(env.getBufferManager().createFileStore("xml"), this.encoding);
            env.setDocumentInProgress(doc);
            boolean formatted = this.isFormatted;
            String xmlFormat = env.getXMLFormat();
            if (xmlFormat != null) {
                if (xmlFormat.equalsIgnoreCase("Tree")) {
                    formatted = true;
                } else if (xmlFormat.equalsIgnoreCase("Compact")) {
                    formatted = false;
                }
            }
            doc.setDocumentFormat(formatted);
        }
        env.incrementCurrentProgramCounter();
        return context;
    }

    public String toString() {
        return "DOC  encoding: " + this.encoding + ", is formatted: " + this.isFormatted;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = new PlanNode("START DOCUMENT");
        props.addProperty("Encoding", this.encoding);
        props.addProperty("Formatted Flag", String.valueOf(this.isFormatted));
        return props;
    }
}

