/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.xml;

import junit.framework.TestCase;
import org.teiid.query.processor.xml.FakeXMLProcessorEnvironment;
import org.teiid.query.processor.xml.InitializeDocumentInstruction;
import org.teiid.query.processor.xml.NoOpInstruction;
import org.teiid.query.processor.xml.ProcessorInstruction;
import org.teiid.query.processor.xml.Program;
import org.teiid.query.processor.xml.XMLContext;
import org.teiid.query.processor.xml.XMLProcessorEnvironment;

public class TestProcessorEnvironment
extends TestCase {
    public TestProcessorEnvironment(String name) {
        super(name);
    }

    public void testProgramRecursionCount() {
        Program program = new Program();
        FakeXMLProcessorEnvironment env = new FakeXMLProcessorEnvironment();
        env.pushProgram(program);
        TestProcessorEnvironment.assertTrue((env.getProgramRecursionCount(program) == 0 ? 1 : 0) != 0);
    }

    public void testProgramRecursionCount2() {
        Program program = new Program();
        FakeXMLProcessorEnvironment env = new FakeXMLProcessorEnvironment();
        env.pushProgram(program);
        env.pushProgram(program, true);
        TestProcessorEnvironment.assertTrue((env.getProgramRecursionCount(program) == 1 ? 1 : 0) != 0);
    }

    public void testProgramRecursionCount3() {
        Program program = new Program();
        Program program2 = new Program();
        FakeXMLProcessorEnvironment env = new FakeXMLProcessorEnvironment();
        env.pushProgram(program);
        env.pushProgram(program2);
        env.pushProgram(program, true);
        TestProcessorEnvironment.assertTrue((env.getProgramRecursionCount(program) == 1 ? 1 : 0) != 0);
        TestProcessorEnvironment.assertTrue((env.getProgramRecursionCount(program2) == 0 ? 1 : 0) != 0);
    }

    public void testProgramRecursionCount4() {
        FakeXMLProcessorEnvironment env = new FakeXMLProcessorEnvironment();
        Program program = new Program();
        TestProcessorEnvironment.assertTrue((env.getProgramRecursionCount(program) == 0 ? 1 : 0) != 0);
    }

    public void testProgramRecursionCount5() {
        Program program = new Program();
        Program program2 = new Program();
        FakeXMLProcessorEnvironment env = new FakeXMLProcessorEnvironment();
        env.pushProgram(program);
        env.pushProgram(program, true);
        env.pushProgram(program2);
        TestProcessorEnvironment.assertTrue((env.getProgramRecursionCount(program) == 1 ? 1 : 0) != 0);
        TestProcessorEnvironment.assertTrue((env.getProgramRecursionCount(program2) == 0 ? 1 : 0) != 0);
    }

    public void testGetCurrentInstruction() throws Exception {
        XMLContext context = new XMLContext();
        NoOpInstruction i1 = new NoOpInstruction();
        NoOpInstruction i2 = new NoOpInstruction();
        NoOpInstruction i3 = new NoOpInstruction();
        NoOpInstruction i4 = new NoOpInstruction();
        Program p1 = new Program();
        p1.addInstruction((ProcessorInstruction)i1);
        p1.addInstruction((ProcessorInstruction)i2);
        Program p2 = new Program();
        p2.addInstruction((ProcessorInstruction)i3);
        p2.addInstruction((ProcessorInstruction)i4);
        FakeXMLProcessorEnvironment env = new FakeXMLProcessorEnvironment();
        env.pushProgram(p1);
        env.pushProgram(p2);
        env.pushProgram(p1, true);
        TestProcessorEnvironment.assertEquals((Object)p1, (Object)env.getCurrentProgram());
        TestProcessorEnvironment.assertEquals((Object)((Object)i1), (Object)env.getCurrentInstruction(null));
        TestProcessorEnvironment.assertEquals((Object)p1, (Object)env.getCurrentProgram());
        i1.process(env, context);
        TestProcessorEnvironment.assertEquals((Object)p1, (Object)env.getCurrentProgram());
        TestProcessorEnvironment.assertEquals((Object)((Object)i2), (Object)env.getCurrentInstruction(null));
        TestProcessorEnvironment.assertEquals((Object)p1, (Object)env.getCurrentProgram());
        i2.process(env, context);
        TestProcessorEnvironment.assertEquals((Object)p2, (Object)env.getCurrentProgram());
        TestProcessorEnvironment.assertEquals((Object)((Object)i3), (Object)env.getCurrentInstruction(null));
        TestProcessorEnvironment.assertEquals((Object)p2, (Object)env.getCurrentProgram());
        i3.process(env, context);
        TestProcessorEnvironment.assertEquals((Object)p2, (Object)env.getCurrentProgram());
        TestProcessorEnvironment.assertEquals((Object)((Object)i4), (Object)env.getCurrentInstruction(null));
        TestProcessorEnvironment.assertEquals((Object)p2, (Object)env.getCurrentProgram());
        i4.process(env, context);
        TestProcessorEnvironment.assertEquals((Object)p1, (Object)env.getCurrentProgram());
        TestProcessorEnvironment.assertEquals((Object)((Object)i1), (Object)env.getCurrentInstruction(null));
        TestProcessorEnvironment.assertEquals((Object)p1, (Object)env.getCurrentProgram());
        i1.process(env, context);
        TestProcessorEnvironment.assertEquals((Object)p1, (Object)env.getCurrentProgram());
        TestProcessorEnvironment.assertEquals((Object)((Object)i2), (Object)env.getCurrentInstruction(null));
        TestProcessorEnvironment.assertEquals((Object)p1, (Object)env.getCurrentProgram());
        i2.process(env, context);
        TestProcessorEnvironment.assertEquals((Object)p1, (Object)env.getCurrentProgram());
        TestProcessorEnvironment.assertEquals(null, (Object)env.getCurrentInstruction(null));
        TestProcessorEnvironment.assertEquals((Object)p1, (Object)env.getCurrentProgram());
    }

    public void testGetCurrentInstruction2() throws Exception {
        XMLContext context = new XMLContext();
        NoOpInstruction i1 = new NoOpInstruction();
        NoOpInstruction i2 = new NoOpInstruction();
        NoOpInstruction i3 = new NoOpInstruction();
        NoOpInstruction i4 = new NoOpInstruction();
        Program p1 = new Program();
        p1.addInstruction((ProcessorInstruction)i1);
        p1.addInstruction((ProcessorInstruction)i2);
        Program p2 = new Program();
        p2.addInstruction((ProcessorInstruction)i3);
        p2.addInstruction((ProcessorInstruction)i4);
        FakeXMLProcessorEnvironment env = new FakeXMLProcessorEnvironment();
        env.pushProgram(p1);
        env.pushProgram(p1, true);
        env.pushProgram(p2);
        TestProcessorEnvironment.assertEquals((Object)p2, (Object)env.getCurrentProgram());
        TestProcessorEnvironment.assertEquals((Object)((Object)i3), (Object)env.getCurrentInstruction(null));
        TestProcessorEnvironment.assertEquals((Object)p2, (Object)env.getCurrentProgram());
        i3.process(env, context);
        TestProcessorEnvironment.assertEquals((Object)p2, (Object)env.getCurrentProgram());
        TestProcessorEnvironment.assertEquals((Object)((Object)i4), (Object)env.getCurrentInstruction(null));
        TestProcessorEnvironment.assertEquals((Object)p2, (Object)env.getCurrentProgram());
        i4.process(env, context);
        TestProcessorEnvironment.assertEquals((Object)p1, (Object)env.getCurrentProgram());
        TestProcessorEnvironment.assertEquals((Object)((Object)i1), (Object)env.getCurrentInstruction(null));
        TestProcessorEnvironment.assertEquals((Object)p1, (Object)env.getCurrentProgram());
        i1.process(env, context);
        TestProcessorEnvironment.assertEquals((Object)p1, (Object)env.getCurrentProgram());
        TestProcessorEnvironment.assertEquals((Object)((Object)i2), (Object)env.getCurrentInstruction(null));
        TestProcessorEnvironment.assertEquals((Object)p1, (Object)env.getCurrentProgram());
        i2.process(env, context);
        TestProcessorEnvironment.assertEquals((Object)p1, (Object)env.getCurrentProgram());
        TestProcessorEnvironment.assertEquals((Object)((Object)i1), (Object)env.getCurrentInstruction(null));
        TestProcessorEnvironment.assertEquals((Object)p1, (Object)env.getCurrentProgram());
        i1.process(env, context);
        TestProcessorEnvironment.assertEquals((Object)p1, (Object)env.getCurrentProgram());
        TestProcessorEnvironment.assertEquals((Object)((Object)i2), (Object)env.getCurrentInstruction(null));
        TestProcessorEnvironment.assertEquals((Object)p1, (Object)env.getCurrentProgram());
        i2.process(env, context);
        TestProcessorEnvironment.assertEquals((Object)p1, (Object)env.getCurrentProgram());
        TestProcessorEnvironment.assertEquals(null, (Object)env.getCurrentInstruction(null));
        TestProcessorEnvironment.assertEquals((Object)p1, (Object)env.getCurrentProgram());
    }

    public void testInitializeDocInstruction() throws Exception {
        XMLContext context = new XMLContext();
        Program p0 = new Program();
        InitializeDocumentInstruction i1 = new InitializeDocumentInstruction();
        Program p1 = new Program();
        p1.addInstruction((ProcessorInstruction)i1);
        FakeXMLProcessorEnvironment env = new FakeXMLProcessorEnvironment();
        env.pushProgram(p0);
        env.pushProgram(p1);
        i1.process((XMLProcessorEnvironment)env, context);
        TestProcessorEnvironment.assertNotNull((Object)env.getDocumentInProgress());
    }

    public void testInitializeDocInstruction2() throws Exception {
        XMLContext context = new XMLContext();
        Program p0 = new Program();
        InitializeDocumentInstruction i1 = new InitializeDocumentInstruction();
        Program p1 = new Program();
        p1.addInstruction((ProcessorInstruction)i1);
        FakeXMLProcessorEnvironment env = new FakeXMLProcessorEnvironment();
        env.pushProgram(p0);
        env.pushProgram(p1);
        env.pushProgram(p0, true);
        env.pushProgram(p1);
        i1.process((XMLProcessorEnvironment)env, context);
        TestProcessorEnvironment.assertNull((Object)env.getDocumentInProgress());
    }
}

