/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.validator;

import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.validator.UpdateValidator;

public class TestUpdateValidator {
    private UpdateValidator helpTest(String sql, TransformationMetadata md, boolean shouldFail) {
        return this.helpTest(sql, md, shouldFail, shouldFail, shouldFail);
    }

    private UpdateValidator helpTest(String sql, TransformationMetadata md, boolean failInsert, boolean failUpdate, boolean failDelete) {
        try {
            String vGroup = "gx";
            Command command = TestUpdateValidator.createView(sql, md, vGroup);
            UpdateValidator uv = new UpdateValidator((QueryMetadataInterface)md, UpdateValidator.UpdateType.INHERENT, UpdateValidator.UpdateType.INHERENT, UpdateValidator.UpdateType.INHERENT);
            GroupSymbol gs = new GroupSymbol(vGroup);
            ResolverUtil.resolveGroup((GroupSymbol)gs, (QueryMetadataInterface)md);
            uv.validate(command, ResolverUtil.resolveElementsInGroup((GroupSymbol)gs, (QueryMetadataInterface)md));
            UpdateValidator.UpdateInfo info = uv.getUpdateInfo();
            Assert.assertEquals((String)uv.getReport().getFailureMessage(), (Object)failInsert, (Object)(info.getInsertValidationError() != null ? 1 : 0));
            Assert.assertEquals((String)uv.getReport().getFailureMessage(), (Object)failUpdate, (Object)(info.getUpdateValidationError() != null ? 1 : 0));
            Assert.assertEquals((String)uv.getReport().getFailureMessage(), (Object)failDelete, (Object)(info.getDeleteValidationError() != null ? 1 : 0));
            return uv;
        }
        catch (TeiidException e) {
            throw new RuntimeException(e);
        }
    }

    public static Command createView(String sql, TransformationMetadata md, String vGroup) throws QueryParserException, QueryResolverException, TeiidComponentException {
        QueryNode vm1g1n1 = new QueryNode(sql);
        Table vm1g1 = RealMetadataFactory.createUpdatableVirtualGroup(vGroup, md.getMetadataStore().getSchema("VM1"), vm1g1n1);
        Command command = QueryParser.getQueryParser().parseCommand(sql);
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)md);
        List symbols = command.getProjectedSymbols();
        String[] names = new String[symbols.size()];
        String[] types = new String[symbols.size()];
        int i = 0;
        for (Expression singleElementSymbol : symbols) {
            names[i] = Symbol.getShortName((Expression)singleElementSymbol);
            types[i++] = DataTypeManager.getDataTypeName((Class)singleElementSymbol.getType());
        }
        RealMetadataFactory.createElements(vm1g1, names, types);
        return command;
    }

    public static TransformationMetadata example1() {
        return TestUpdateValidator.example1(true);
    }

    public static TransformationMetadata example1(boolean allUpdatable) {
        MetadataStore metadataStore = new MetadataStore();
        Schema pm1 = RealMetadataFactory.createPhysicalModel("pm1", metadataStore);
        Schema vm1 = RealMetadataFactory.createVirtualModel("vm1", metadataStore);
        Table pm1g1 = RealMetadataFactory.createPhysicalGroup("g1", pm1);
        Table pm1g2 = RealMetadataFactory.createPhysicalGroup("g2", pm1);
        Table pm1g3 = RealMetadataFactory.createPhysicalGroup("g3", pm1);
        List<Column> pm1g1e = RealMetadataFactory.createElements(pm1g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        if (!allUpdatable) {
            pm1g1e.get(0).setUpdatable(false);
        }
        KeyRecord pk = RealMetadataFactory.createKey(KeyRecord.Type.Primary, "pk", pm1g1, pm1g1e.subList(0, 1));
        List<Column> pm1g2e = RealMetadataFactory.createElements(pm1g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createKey(KeyRecord.Type.Primary, "pk", pm1g2, pm1g1e.subList(1, 2));
        RealMetadataFactory.createForeignKey("fk", pm1g2, pm1g2e.subList(0, 1), pk);
        List<Column> pm1g3e = RealMetadataFactory.createElements(pm1g3, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        pm1g3e.get(0).setNullType(BaseColumn.NullType.No_Nulls);
        pm1g3e.get(0).setDefaultValue(null);
        pm1g3e.get(1).setNullType(BaseColumn.NullType.No_Nulls);
        pm1g3e.get(1).setAutoIncremented(true);
        pm1g3e.get(1).setDefaultValue(null);
        pm1g3e.get(2).setNullType(BaseColumn.NullType.No_Nulls);
        pm1g3e.get(2).setDefaultValue("xyz");
        QueryNode vm1g1n1 = new QueryNode("SELECT e1 as a, e2 FROM pm1.g1 WHERE e3 > 5");
        Table vm1g1 = RealMetadataFactory.createUpdatableVirtualGroup("g1", vm1, vm1g1n1);
        QueryNode vm1g2n1 = new QueryNode("SELECT e1, e2, e3, e4 FROM pm1.g2 WHERE e3 > 5");
        Table vm1g2 = RealMetadataFactory.createUpdatableVirtualGroup("g2", vm1, vm1g2n1);
        QueryNode vm1g3n1 = new QueryNode("SELECT e1, e3 FROM pm1.g3");
        Table vm1g3 = RealMetadataFactory.createUpdatableVirtualGroup("g3", vm1, vm1g3n1);
        QueryNode vm1g4n1 = new QueryNode("SELECT e1, e2 FROM pm1.g3");
        Table vm1g4 = RealMetadataFactory.createUpdatableVirtualGroup("g4", vm1, vm1g4n1);
        QueryNode vm1g5n1 = new QueryNode("SELECT e2, e3 FROM pm1.g3");
        Table vm1g5 = RealMetadataFactory.createVirtualGroup("g5", vm1, vm1g5n1);
        RealMetadataFactory.createElements(vm1g1, new String[]{"a", "e2"}, new String[]{"string", "integer"});
        RealMetadataFactory.createElements(vm1g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(vm1g3, new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        RealMetadataFactory.createElements(vm1g4, new String[]{"e1", "e3"}, new String[]{"string", "boolean"});
        RealMetadataFactory.createElements(vm1g5, new String[]{"e2", "e3"}, new String[]{"integer", "boolean"});
        ColumnSet<Procedure> rs1 = RealMetadataFactory.createResultSet("rs1", new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        QueryNode sq1n1 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT e1, e2 FROM pm1.g1; END");
        Procedure sq1 = RealMetadataFactory.createVirtualProcedure("sq1", pm1, Collections.EMPTY_LIST, sq1n1);
        sq1.setResultSet(rs1);
        return RealMetadataFactory.createTransformationMetadata(metadataStore, "example", new FunctionTree[0]);
    }

    @Test
    public void testCreateInsertCommand() {
        this.helpTest("select e1 as a, e2 from pm1.g1 where e4 > 5", TestUpdateValidator.example1(), false);
    }

    @Test
    public void testCreateInsertCommand2() {
        this.helpTest("select e1 as a, 5 from pm1.g1 where e4 > 5", TestUpdateValidator.example1(), false);
    }

    @Test
    public void testCreateInsertCommand3() {
        this.helpTest("select * from pm1.g2 where e4 > 5", TestUpdateValidator.example1(), false);
    }

    @Test
    public void testCreateInsertCommand4() {
        this.helpTest("select * from pm1.g2 as g_alias", TestUpdateValidator.example1(), false);
    }

    @Test
    public void testCreateInsertCommand5() {
        this.helpTest("select e1 as a, e2 from pm1.g1 as g_alias where e4 > 5", TestUpdateValidator.example1(), false);
    }

    @Test
    public void testCreateUpdateCommand() {
        this.helpTest("select e1 as a, e2 from pm1.g1 where e4 > 5", TestUpdateValidator.example1(), false);
    }

    @Test
    public void testCreateDeleteCommand() {
        this.helpTest("select e1 as a, e2 from pm1.g1 where e4 > 5", TestUpdateValidator.example1(), false);
    }

    @Test
    public void testCreateInsertCommand1() {
        this.helpTest("SELECT pm1.g1.e1 FROM pm1.g1, pm1.g2", TestUpdateValidator.example1(), true);
    }

    @Test
    public void testCreateInsertCommand14() {
        this.helpTest("SELECT pm1.g2.e1 FROM pm1.g1, pm1.g2 where g1.e1 = g2.e1", TestUpdateValidator.example1(), false);
    }

    @Test
    public void testCreateInsertCommand2_fail() {
        this.helpTest("SELECT CONCAT(pm1.g1.e1, convert(pm1.g2.e1, string)) as x FROM pm1.g1, pm1.g2", TestUpdateValidator.example1(), true);
    }

    @Test
    public void testCreateInsertCommand3_fail() {
        this.helpTest("SELECT e1 FROM pm1.g1 UNION SELECT e1 FROM pm1.g2", TestUpdateValidator.example1(), true);
    }

    @Test
    public void testCreateInsertCommand4_fail() {
        this.helpTest("SELECT COUNT(*) FROM pm1.g1", TestUpdateValidator.example1(), true);
    }

    @Test
    public void testCreateInsertCommand5_fail() {
        this.helpTest("SELECT * FROM pm1.g1 GROUP BY e1", TestUpdateValidator.example1(), true);
    }

    @Test
    public void testCreateInsertCommand6_fail() {
        this.helpTest("EXEC pm1.sq1()", TestUpdateValidator.example1(), true);
    }

    @Test
    public void testCreateInsertCommand7_fail() {
        this.helpTest("INSERT INTO pm1.g1 (e1) VALUES ('x')", TestUpdateValidator.example1(), true);
    }

    @Test
    public void testCreateInsertCommand8_fail() {
        this.helpTest("UPDATE pm1.g1 SET e1='x'", TestUpdateValidator.example1(), true);
    }

    @Test
    public void testCreateInsertCommand9_fail() {
        this.helpTest("DELETE FROM pm1.g1", TestUpdateValidator.example1(), true);
    }

    @Test
    public void testCreateInsertCommand10_fail() {
        this.helpTest("SELECT COUNT(*) FROM pm1.g1", TestUpdateValidator.example1(), true);
    }

    @Test
    public void testCreateInsertCommand11_fail() {
        this.helpTest("SELECT COUNT(e1) as x FROM pm1.g1", TestUpdateValidator.example1(), true);
    }

    @Test
    public void testCreateInsertCommand12_fail() {
        this.helpTest("SELECT * FROM (EXEC pm1.sq1()) AS a", TestUpdateValidator.example1(), true);
    }

    @Test
    public void testCreateInsertCommand13_fail() {
        this.helpTest("SELECT 1", TestUpdateValidator.example1(), true);
    }

    @Test
    public void testRequiredElements1() {
        this.helpTest("SELECT e1, e2 FROM pm1.g3", TestUpdateValidator.example1(), false);
    }

    @Test
    public void testRequiredElements2() {
        this.helpTest("SELECT e1, e3 FROM pm1.g3", TestUpdateValidator.example1(), false);
    }

    @Test
    public void testRequiredElements3() {
        this.helpTest("SELECT e2, e3 FROM pm1.g3", TestUpdateValidator.example1(), true, false, false);
    }

    @Test
    public void testNonUpdateableElements() {
        this.helpTest("select e1 as a, e2 from pm1.g1 where e4 > 5", TestUpdateValidator.example1(false), false);
    }

    @Test
    public void testNonUpdateableElements2() {
        this.helpTest("SELECT e1, e2 FROM pm1.g1", TestUpdateValidator.example1(false), false);
    }

    @Test
    public void testSelectDistinct() {
        this.helpTest("SELECT distinct e1, e2 FROM pm1.g1", TestUpdateValidator.example1(), true);
    }

    @Test
    public void testNonUpdatable() {
        this.helpTest("SELECT e2 FROM vm1.g5", TestUpdateValidator.example1(), true);
    }

    @Test
    public void testAnsiJoin() {
        this.helpTest("SELECT g1.e1, x.e2 FROM pm1.g2 x inner join pm1.g1 on (x.e1 = g1.e1)", TestUpdateValidator.example1(), false);
    }

    @Test
    public void testUnionAll() {
        this.helpTest("SELECT g1.e1, x.e2 FROM pm1.g2 x inner join pm1.g1 on (x.e1 = g1.e1) union all select pm1.g2.e1, pm1.g2.e2 from pm1.g2", TestUpdateValidator.example1(), true, false, false);
    }

    @Test
    public void testParitionedUnionAll() {
        this.helpTest("SELECT g1.e1, x.e2 FROM pm1.g2 x inner join pm1.g1 on (x.e1 = g1.e1) where x.e2 in (1, 2) union all select pm1.g2.e1, pm1.g2.e2 from pm1.g2 where pm1.g2.e2 in (3, 4)", TestUpdateValidator.example1(), false, false, false);
    }
}

