/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.relational.SubqueryAwareRelationalNode;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.ObjectTable;
import org.teiid.query.util.CommandContext;

public class ObjectTableNode
extends SubqueryAwareRelationalNode {
    private static final String TEIID_ROW_NUMBER = "teiid_row_number";
    private static final String TEIID_ROW = "teiid_row";
    private static final String TEIID_CONTEXT = "teiid_context";
    private ObjectTable table;
    private List<ObjectTable.ObjectColumn> projectedColumns;
    private int rowCount = 0;
    private Object item;
    private Iterator<?> result;
    private SimpleScriptContext scriptContext;

    public ObjectTableNode(int nodeID) {
        super(nodeID);
    }

    @Override
    public void initialize(CommandContext context, BufferManager bufferManager, ProcessorDataManager dataMgr) {
        super.initialize(context, bufferManager, dataMgr);
        this.scriptContext = new SimpleScriptContext();
    }

    @Override
    public void open() throws TeiidComponentException, TeiidProcessingException {
        super.open();
        if (this.table.getScriptEngine() == null) {
            this.table.setScriptEngine(this.getContext().getMetadata().getScriptEngine(this.table.getScriptingLanguage()));
        }
        this.scriptContext.setAttribute(TEIID_CONTEXT, this.getContext(), 100);
    }

    @Override
    public synchronized void closeDirect() {
        if (this.scriptContext != null) {
            try {
                this.scriptContext.getErrorWriter().flush();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                this.scriptContext.getWriter().flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.closeDirect();
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        this.item = null;
        this.result = null;
        this.rowCount = 0;
        if (this.scriptContext != null) {
            this.scriptContext.getBindings(100).clear();
        }
    }

    public void setTable(ObjectTable table) {
        this.table = table;
    }

    public void setProjectedColumns(List<ObjectTable.ObjectColumn> projectedColumns) {
        this.projectedColumns = projectedColumns;
    }

    @Override
    public ObjectTableNode clone() {
        ObjectTableNode clone = new ObjectTableNode(this.getID());
        this.copyTo(clone);
        clone.setTable(this.table);
        clone.setProjectedColumns(this.projectedColumns);
        return clone;
    }

    @Override
    protected synchronized TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        this.evaluate();
        while (!this.isBatchFull() && this.result.hasNext()) {
            if (this.item == null) {
                this.item = this.result.next();
                if (this.item == null) continue;
                ++this.rowCount;
            }
            this.addBatchRow(this.processRow());
        }
        if (!this.result.hasNext()) {
            this.terminateBatches();
        }
        return this.pullBatch();
    }

    private void evaluate() throws TeiidComponentException, ExpressionEvaluationException, BlockedException, TeiidProcessingException {
        if (this.result != null) {
            return;
        }
        this.setReferenceValues(this.table);
        Evaluator eval = this.getEvaluator(Collections.emptyMap());
        eval.evaluateParameters(this.table.getPassing(), null, this.scriptContext.getBindings(100));
        Object value = this.evalScript(this.table.getCompiledScript(), this.table.getRowScript());
        this.result = value instanceof Iterable ? ((Iterable)value).iterator() : (value instanceof Iterator ? (Iterator<Object>)value : Arrays.asList(value).iterator());
    }

    private Object evalScript(CompiledScript compiledScript, String script) throws TeiidProcessingException {
        try {
            if (compiledScript != null) {
                return compiledScript.eval(this.scriptContext);
            }
            return this.table.getScriptEngine().eval(script, (ScriptContext)this.scriptContext);
        }
        catch (ScriptException e) {
            throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID31110, (Throwable)e, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31110, new Object[]{script, e.getMessage()}));
        }
    }

    private List<?> processRow() throws ExpressionEvaluationException, TeiidComponentException, TeiidProcessingException {
        ArrayList<Object> tuple = new ArrayList<Object>(this.projectedColumns.size());
        this.scriptContext.setAttribute(TEIID_ROW, this.item, 100);
        this.scriptContext.setAttribute(TEIID_ROW_NUMBER, this.rowCount, 100);
        for (ObjectTable.ObjectColumn proColumn : this.projectedColumns) {
            Object value = this.evalScript(proColumn.getCompiledScript(), proColumn.getPath());
            if (value == null) {
                if (proColumn.getDefaultExpression() != null) {
                    tuple.add(this.getEvaluator(Collections.emptyMap()).evaluate(proColumn.getDefaultExpression(), null));
                    continue;
                }
                tuple.add(null);
                continue;
            }
            value = FunctionDescriptor.importValue(value, proColumn.getSymbol().getType());
            tuple.add(value);
        }
        this.item = null;
        return tuple;
    }

    @Override
    protected Collection<? extends LanguageObject> getObjects() {
        return this.table.getPassing();
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = super.getDescriptionProperties();
        AnalysisRecord.addLanaguageObjects(props, "Table Function", Arrays.asList(this.table));
        return props;
    }
}

