/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.test.client.ctc;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Symbol;

public class QueryResults
implements Externalizable {
    static final long serialVersionUID = 5397138282301824378L;
    private List fields;
    private Map columnInfos;
    private List records;

    public QueryResults() {
    }

    public QueryResults(List fields) {
        this(fields, 0);
    }

    public QueryResults(List fields, int numberOfRecords) {
        if (fields != null) {
            for (ColumnInfo info : fields) {
                this.addField(info);
            }
            for (int k = 0; k < numberOfRecords; ++k) {
                this.addRecord();
            }
        }
    }

    public QueryResults(List elements, TupleBatch tupleBatch) {
        List columnInfos = QueryResults.createColumnInfos(elements);
        for (int i = 0; i < columnInfos.size(); ++i) {
            ColumnInfo info = (ColumnInfo)columnInfos.get(i);
            this.addField(info);
        }
        this.records = Arrays.asList(tupleBatch.getAllTuples());
    }

    public List getFieldIdents() {
        return this.fields != null ? this.fields : new ArrayList();
    }

    public ColumnInfo getColumnInfo(String columnName) {
        if (this.columnInfos != null) {
            return (ColumnInfo)this.columnInfos.get(columnName);
        }
        return null;
    }

    public int getFieldCount() {
        return this.fields != null ? this.fields.size() : 0;
    }

    public int getRecordCount() {
        return this.records != null ? this.records.size() : 0;
    }

    public Object getValue(String columnName, int recordNumber) throws IllegalArgumentException, IndexOutOfBoundsException {
        int columnNumber = this.getIndexOfField(columnName);
        return this.records != null ? ((List)this.records.get(recordNumber)).get(columnNumber) : null;
    }

    public List getRecordValues(int recordNumber) throws IndexOutOfBoundsException {
        if (this.records != null) {
            return (List)this.records.get(recordNumber);
        }
        throw new IndexOutOfBoundsException("Record number " + recordNumber + " is not valid.");
    }

    public List getRecords() {
        return this.records;
    }

    public boolean containsField(String field) {
        if (this.fields != null && field != null) {
            Iterator iter = this.fields.iterator();
            while (iter.hasNext()) {
                if (!((String)iter.next()).equalsIgnoreCase(field)) continue;
                return true;
            }
        }
        return false;
    }

    public List getTypes() {
        ArrayList<String> typeNames = new ArrayList<String>();
        int nFields = this.getFieldCount();
        for (int i = 0; i < nFields; ++i) {
            String aField = (String)this.fields.get(i);
            typeNames.add(((ColumnInfo)this.columnInfos.get(aField)).getDataType());
        }
        return typeNames;
    }

    public void addField(ColumnInfo info) {
        if (this.fields == null) {
            this.fields = new ArrayList();
        }
        this.fields.add(info.getName());
        if (this.columnInfos == null) {
            this.columnInfos = new HashMap();
        }
        this.columnInfos.put(info.getName(), info);
        if (this.records != null) {
            for (int i = 0; i < this.records.size(); ++i) {
                List record = (List)this.records.get(i);
                record.add(null);
            }
        }
    }

    public void addFields(Collection fields) {
        for (ColumnInfo ident : fields) {
            this.addField(ident);
        }
    }

    public int addRecord() {
        int nField = this.getFieldCount();
        if (nField == 0) {
            throw new IllegalArgumentException("Cannot add record; no fields have been defined");
        }
        ArrayList<Object> record = new ArrayList<Object>(nField);
        for (int j = 0; j < nField; ++j) {
            record.add(null);
        }
        return this.addRecord(record);
    }

    public int addRecord(List record) {
        if (record == null) {
            throw new IllegalArgumentException("Attempt to add null record.");
        }
        if (record.size() != this.getFieldCount()) {
            throw new IllegalArgumentException("Attempt to add record with " + record.size() + " values when " + this.getFieldCount() + " fields are defined.");
        }
        if (this.records == null) {
            this.records = new ArrayList();
        }
        this.records.add(record);
        return this.records.size();
    }

    public void setValue(String field, int recordNumber, Object value) throws IllegalArgumentException, IndexOutOfBoundsException {
        List record = (List)this.records.get(recordNumber);
        int fieldIndex = this.getIndexOfField(field);
        record.set(fieldIndex, value);
    }

    public int getIndexOfField(String field) throws IllegalArgumentException {
        int index = -1;
        if (this.fields != null && field != null) {
            Iterator iter = this.fields.iterator();
            int i = 0;
            while (iter.hasNext()) {
                if (field.equalsIgnoreCase((String)iter.next())) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        if (index == -1) {
            throw new IllegalArgumentException("Field with identifier " + field + " is not in result set");
        }
        return index;
    }

    public static List createColumnInfos(List symbols) {
        ArrayList<ColumnInfo> infos = new ArrayList<ColumnInfo>(symbols.size());
        for (Expression symbol : symbols) {
            String name = Symbol.getName((Expression)symbol);
            if (symbol instanceof AliasSymbol) {
                AliasSymbol alias = (AliasSymbol)symbol;
                symbol = alias.getSymbol();
            }
            if (symbol instanceof ElementSymbol) {
                ElementSymbol element = (ElementSymbol)symbol;
                GroupSymbol group = element.getGroupSymbol();
                Object groupID = null;
                if (group != null) {
                    groupID = group.getMetadataID();
                }
                infos.add(new ColumnInfo(name, DataTypeManager.getDataTypeName((Class)element.getType()), element.getType(), groupID, element.getMetadataID()));
                continue;
            }
            infos.add(new ColumnInfo(name, DataTypeManager.getDataTypeName((Class)symbol.getType()), symbol.getType()));
        }
        return infos;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!this.getClass().isInstance(object)) {
            return false;
        }
        QueryResults other = (QueryResults)object;
        if (!this.getFieldIdents().equals(other.getFieldIdents())) {
            return false;
        }
        List thisRecords = this.getRecords();
        List otherRecords = other.getRecords();
        if (thisRecords == null) {
            return otherRecords == null;
        }
        if (otherRecords == null) {
            return false;
        }
        return thisRecords.equals(otherRecords);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Query Results...\n");
        buffer.append(QueryResults.printFieldIdentsAndTypes(this.getFieldIdents(), this.columnInfos));
        buffer.append("\n");
        for (int r = 0; r < this.getRecordCount(); ++r) {
            buffer.append(r);
            buffer.append(": ");
            List record = this.getRecordValues(r);
            for (int c = 0; c < this.getFieldCount(); ++c) {
                buffer.append(record.get(c));
                if (c >= this.getFieldCount() - 1) continue;
                buffer.append(", ");
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }

    private static String printFieldIdentsAndTypes(List fieldIdents, Map columnInfos) {
        StringBuffer buf = new StringBuffer();
        for (String aField : fieldIdents) {
            if (aField != null) {
                buf.append("[");
                buf.append(aField);
                buf.append(" - [");
                ColumnInfo colInfo = (ColumnInfo)columnInfos.get(aField);
                buf.append(colInfo.getDataType());
                buf.append(", ");
                buf.append(colInfo.getJavaClass());
                buf.append("]");
            }
            buf.append("] ");
        }
        return buf.toString();
    }

    @Override
    public void readExternal(ObjectInput s) throws ClassNotFoundException, IOException {
        int numRows;
        int numFields = s.readInt();
        if (numFields > 0) {
            this.fields = new ArrayList(numFields);
            this.columnInfos = new HashMap();
            for (int i = 0; i < numFields; ++i) {
                String fieldName = s.readUTF();
                this.fields.add(fieldName);
                Object colInfo = s.readObject();
                this.columnInfos.put(fieldName, colInfo);
            }
        }
        if ((numRows = s.readInt()) > 0) {
            this.records = new ArrayList(numRows);
            for (int row = 0; row < numRows; ++row) {
                ArrayList<Object> record = new ArrayList<Object>(numFields);
                for (int col = 0; col < numFields; ++col) {
                    record.add(s.readObject());
                }
                this.records.add(record);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput s) throws IOException {
        int numFields = 0;
        if (this.fields == null) {
            s.writeInt(0);
        } else {
            numFields = this.fields.size();
            s.writeInt(numFields);
            for (int i = 0; i < numFields; ++i) {
                String fieldName = (String)this.fields.get(i);
                s.writeUTF(fieldName);
                s.writeObject(this.columnInfos.get(fieldName));
            }
        }
        if (this.records == null) {
            s.writeInt(0);
        } else {
            int numRows = this.records.size();
            s.writeInt(numRows);
            for (int row = 0; row < numRows; ++row) {
                List record = (List)this.records.get(row);
                for (int col = 0; col < numFields; ++col) {
                    s.writeObject(record.get(col));
                }
            }
        }
    }

    public static class ColumnInfo
    implements Serializable {
        static final long serialVersionUID = -7131157612965891051L;
        private String name;
        private String dataType;
        private Class javaClass;
        private Object groupID;
        private Object elementID;

        public ColumnInfo(String name, String dataType, Class javaClass) {
            if (name == null) {
                throw new IllegalArgumentException("QueryResults column cannot have name==null");
            }
            this.name = name;
            this.dataType = dataType;
            this.javaClass = javaClass;
        }

        public ColumnInfo(String name, String dataType, Class javaClass, Object groupID, Object elementID) {
            this(name, dataType, javaClass);
            this.groupID = groupID;
            this.elementID = elementID;
        }

        public String getName() {
            return this.name;
        }

        public String getDataType() {
            return this.dataType;
        }

        public Class getJavaClass() {
            return this.javaClass;
        }

        public Object getGroupID() {
            return this.groupID;
        }

        public Object getElementID() {
            return this.elementID;
        }

        public String toString() {
            StringBuffer str = new StringBuffer("Column[");
            str.append(this.name);
            str.append(", ");
            str.append(this.dataType);
            if (this.groupID != null) {
                str.append(", ");
                str.append(this.groupID);
                str.append(".");
                str.append(this.elementID);
            }
            str.append("]");
            return str.toString();
        }
    }
}

