/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import javax.sql.rowset.serial.SerialBlob;
import junit.framework.TestCase;
import org.junit.Test;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.util.UnitTestUtil;

public class TestBlobValue
extends TestCase {
    public void testBlobValue() throws Exception {
        String testString = "this is test blob";
        SerialBlob blob = new SerialBlob(testString.getBytes());
        BlobType bv = new BlobType((Blob)blob);
        TestBlobValue.assertEquals((String)testString, (String)new String(bv.getBytes(1L, (int)bv.length())));
    }

    public void testBlobValuePersistence() throws Exception {
        String testString = "this is test clob";
        SerialBlob blob = new SerialBlob(testString.getBytes());
        BlobType bv = new BlobType((Blob)blob);
        String key = bv.getReferenceStreamId();
        BlobType read = UnitTestUtil.helpSerialize(bv);
        TestBlobValue.assertEquals((String)key, (String)read.getReferenceStreamId());
        TestBlobValue.assertNull((Object)read.getReference());
    }

    @Test
    public void testReferencePersistence() throws Exception {
        String testString = "this is test clob";
        SerialBlob blob = new SerialBlob(testString.getBytes());
        BlobType bv = new BlobType((Blob)blob);
        bv.setReferenceStreamId(null);
        BlobType read = UnitTestUtil.helpSerialize(bv);
        TestBlobValue.assertNull((Object)read.getReferenceStreamId());
        TestBlobValue.assertEquals((String)testString, (String)new String(read.getBytes(1L, (int)blob.length())));
    }

    public void testBlobCompare() throws Exception {
        String testString = "this is test clob";
        SerialBlob blob = new SerialBlob(testString.getBytes());
        BlobType bv = new BlobType((Blob)blob);
        SerialBlob blob1 = new SerialBlob(testString.getBytes());
        BlobType bv1 = new BlobType((Blob)blob1);
        TestBlobValue.assertEquals((int)0, (int)bv1.compareTo(bv));
    }

    public void testBlobImplGetBytes() throws Exception {
        BlobImpl b = new BlobImpl(new InputStreamFactory(){

            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(new byte[0]);
            }
        });
        byte[] b1 = b.getBytes(1L, 0);
        TestBlobValue.assertEquals((int)0, (int)b1.length);
        byte[] b2 = b.getBytes(1L, 1);
        TestBlobValue.assertEquals((int)0, (int)b2.length);
    }
}

