/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import junit.framework.TestCase;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestResolvedFunctions
extends TestCase {
    public void testPowerIntegers() throws Exception {
        String sql = "power(10, 10)";
        TestResolvedFunctions.assertEquals((Object)DataTypeManager.DefaultDataClasses.BIG_INTEGER, this.getFunctionResult(sql).getClass());
    }

    public void testPowerDoubles() throws Exception {
        String sql = "power(10.01, 10.01)";
        TestResolvedFunctions.assertEquals((Object)DataTypeManager.DefaultDataClasses.DOUBLE, this.getFunctionResult(sql).getClass());
    }

    public void testPowerFloats() throws Exception {
        String sql = "power(convert(10.01, float), convert(10.01, float))";
        TestResolvedFunctions.assertEquals((Object)DataTypeManager.DefaultDataClasses.DOUBLE, this.getFunctionResult(sql).getClass());
    }

    public void testPowerBigInteger() throws Exception {
        String sql = "power(convert(10.01, BigInteger), 10)";
        TestResolvedFunctions.assertEquals((Object)DataTypeManager.DefaultDataClasses.BIG_INTEGER, this.getFunctionResult(sql).getClass());
    }

    public void testCeilingFloat() throws Exception {
        String sql = "ceiling(convert(10.01, float))";
        TestResolvedFunctions.assertEquals((Object)DataTypeManager.DefaultDataClasses.DOUBLE, this.getFunctionResult(sql).getClass());
    }

    public void testFloorFloat() throws Exception {
        String sql = "floor(convert(10.01, float))";
        TestResolvedFunctions.assertEquals((Object)DataTypeManager.DefaultDataClasses.DOUBLE, this.getFunctionResult(sql).getClass());
    }

    private Object getFunctionResult(String sql) throws QueryParserException, ExpressionEvaluationException, BlockedException, TeiidComponentException, QueryResolverException {
        Expression expr = QueryParser.getQueryParser().parseExpression(sql);
        ResolverVisitor.resolveLanguageObject((LanguageObject)expr, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        return Evaluator.evaluate((Expression)expr);
    }
}

