/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.parser;

import org.junit.Assert;
import org.junit.Test;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.sql.lang.StoredProcedure;

public class TestCallableStatementParsing {
    private void helpTestIllegalCall(String call) {
        try {
            QueryParser.getQueryParser().parseCommand(call);
            Assert.fail((String)"expected exception");
        }
        catch (QueryParserException queryParserException) {
            // empty catch block
        }
    }

    private void helpTestGetExec(String call, boolean returnValue) throws QueryParserException {
        StoredProcedure sp = this.helpTest(call, returnValue);
        Assert.assertEquals((Object)((returnValue ? "? = " : "") + "EXEC procedure_name(?, ?, ?)"), (Object)sp.toString());
    }

    private StoredProcedure helpTest(String call, boolean returnValue) throws QueryParserException {
        StoredProcedure sp = (StoredProcedure)QueryParser.getQueryParser().parseCommand(call);
        Assert.assertTrue((boolean)sp.isCallableStatement());
        Assert.assertEquals((Object)returnValue, (Object)sp.returnsScalarValue());
        Assert.assertEquals((Object)"procedure_name", (Object)sp.getProcedureName());
        return sp;
    }

    @Test
    public void testCallNoParams() throws QueryParserException {
        StoredProcedure sp = (StoredProcedure)QueryParser.getQueryParser().parseCommand("{call procedure_name}");
        Assert.assertFalse((boolean)sp.returnsScalarValue());
        Assert.assertEquals((Object)"procedure_name", (Object)sp.getProcedureName());
        Assert.assertEquals((long)0L, (long)sp.getParameters().size());
    }

    @Test
    public void testCallWithReturnParam() throws QueryParserException {
        this.helpTestGetExec("{?=call procedure_name(?, ?, ?)}", true);
        this.helpTestGetExec(" {?=call procedure_name(?, ?, ?)}", true);
        this.helpTestGetExec("{ ?=call procedure_name(?, ?, ?)}", true);
        this.helpTestGetExec("{? =call procedure_name(?, ?, ?)}", true);
        this.helpTestGetExec("{?= call procedure_name(?, ?, ?)}", true);
        this.helpTestGetExec("{?=\ncall procedure_name(?, ?, ?)}", true);
    }

    @Test
    public void testIllegalCalls() {
        this.helpTestIllegalCall("{call procedure_name");
        this.helpTestIllegalCall("call procedure_name}");
        this.helpTestIllegalCall("{call procedure_name(}");
        this.helpTestIllegalCall("{callprocedure_name()}");
        this.helpTestIllegalCall("{call procedure_name)}");
        this.helpTestIllegalCall("{call procedure name}");
        this.helpTestIllegalCall("{call procedure name()}");
        this.helpTestIllegalCall("{?call procedure_name}");
        this.helpTestIllegalCall("{=call procedure_name}");
        this.helpTestIllegalCall("{?=cal procedure_name}");
    }

    @Test
    public void testGetExec() throws QueryParserException {
        this.helpTestGetExec("{call procedure_name(?, ?, ?)}", false);
        this.helpTestGetExec(" {call procedure_name(?, ?, ?)}", false);
        this.helpTestGetExec("{ call procedure_name(?, ?, ?)}", false);
        this.helpTestGetExec("{call\tprocedure_name(?, ?, ?)}", false);
        this.helpTestGetExec("{call procedure_name (?, ?, ?)}", false);
        this.helpTestGetExec("{call procedure_name(?, ?, ?) }", false);
        this.helpTestGetExec("{CALL procedure_name(?, ?, ?)} ", false);
    }

    @Test
    public void testNamedParams() throws QueryParserException {
        Assert.assertEquals((Object)"? = EXEC procedure_name(a => ?)", (Object)this.helpTest("{?=call procedure_name(a=>?)}", true).toString());
    }

    @Test(expected=QueryParserException.class)
    public void testBadCallKeyword() throws Exception {
        QueryParser.getQueryParser().parseCommand("{calli procedure_name}");
    }
}

