/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.validator;

import java.util.Collection;
import java.util.Iterator;
import org.teiid.query.QueryPlugin;
import org.teiid.query.report.ActivityReport;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.validator.ValidatorFailure;

public class ValidatorReport
extends ActivityReport<ValidatorFailure> {
    public static final String VALIDATOR_REPORT = "Validator Report";

    public ValidatorReport() {
        super(VALIDATOR_REPORT);
    }

    public ValidatorReport(String name) {
        super(name);
    }

    public void collectInvalidObjects(Collection<LanguageObject> invalidObjects) {
        for (ValidatorFailure failure : this.getItems()) {
            if (failure.getInvalidObjectCount() <= 0) continue;
            invalidObjects.addAll(failure.getInvalidObjects());
        }
    }

    public String getFailureMessage() {
        Collection failures = this.getItems();
        if (failures.size() == 0) {
            return QueryPlugin.Util.getString("ERR.015.012.0064");
        }
        if (failures.size() == 1) {
            return ((ValidatorFailure)failures.iterator().next()).toString();
        }
        StringBuffer err = new StringBuffer();
        err.append(QueryPlugin.Util.getString("ERR.015.012.0063"));
        Iterator iter = failures.iterator();
        while (iter.hasNext()) {
            err.append(iter.next());
            if (!iter.hasNext()) continue;
            err.append(", ");
        }
        return err.toString();
    }

    @Override
    public String toString() {
        return this.getFailureMessage();
    }

    public void handleValidationWarning(String message) {
        ValidatorFailure vf = new ValidatorFailure(message);
        vf.setStatus(ValidatorFailure.Status.WARNING);
        this.addItem(vf);
    }

    public void handleValidationError(String message) {
        this.addItem(new ValidatorFailure(message));
    }

    public void handleValidationError(String message, LanguageObject invalidObj) {
        this.addItem(new ValidatorFailure(message, invalidObj));
    }

    public void handleValidationError(String message, Collection<? extends LanguageObject> invalidObjs) {
        this.addItem(new ValidatorFailure(message, invalidObjs));
    }
}

