/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import java.util.ArrayList;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.common.buffer.Cache;
import org.teiid.common.buffer.impl.BufferManagerImpl;
import org.teiid.common.buffer.impl.MemoryStorageManager;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.sql.symbol.ElementSymbol;

public class TestBufferManagerImpl {
    @Test
    public void testReserve() throws Exception {
        BufferManagerImpl bufferManager = new BufferManagerImpl();
        bufferManager.setCache((Cache)new MemoryStorageManager());
        bufferManager.setMaxProcessingKB(1024);
        bufferManager.setMaxReserveKB(1024);
        bufferManager.initialize();
        bufferManager.setNominalProcessingMemoryMax(512000);
        Assert.assertEquals((long)512000L, (long)bufferManager.reserveBuffers(1024000, BufferManager.BufferReserveMode.NO_WAIT));
        Assert.assertEquals((long)1024000L, (long)bufferManager.reserveBuffersBlocking(1024000, new long[]{0L, 0L}, true));
        Assert.assertEquals((long)0L, (long)bufferManager.reserveBuffersBlocking(1024000, new long[]{0L, 0L}, false));
        bufferManager.releaseBuffers(512000);
        Assert.assertEquals((long)24576L, (long)bufferManager.reserveBuffers(1024000, BufferManager.BufferReserveMode.NO_WAIT));
    }

    @Test
    public void testLargeReserve() throws Exception {
        BufferManagerImpl bufferManager = new BufferManagerImpl();
        bufferManager.setCache((Cache)new MemoryStorageManager());
        bufferManager.setMaxReserveKB(0x40000B);
        Assert.assertEquals((long)0x40000BL, (long)bufferManager.getMaxReserveKB());
    }

    @Test
    public void testProcessorBatchSize() {
        BufferManagerImpl bm = BufferManagerFactory.createBufferManager();
        int processorBatchSize = bm.getProcessorBatchSize();
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        ElementSymbol a = new ElementSymbol("a");
        a.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        ElementSymbol b = new ElementSymbol("b");
        b.setType(DataTypeManager.DefaultDataClasses.STRING);
        elements.add(a);
        Assert.assertEquals((long)(processorBatchSize * 8), (long)bm.getProcessorBatchSize(elements));
        elements.add(b);
        Assert.assertEquals((long)(processorBatchSize * 4), (long)bm.getProcessorBatchSize(elements));
        elements.add(b);
        Assert.assertEquals((long)(processorBatchSize * 2), (long)bm.getProcessorBatchSize(elements));
        elements.add(b);
        elements.add(b);
        Assert.assertEquals((long)processorBatchSize, (long)bm.getProcessorBatchSize(elements));
        elements.addAll(Collections.nCopies(28, b));
        Assert.assertEquals((long)(processorBatchSize / 2), (long)bm.getProcessorBatchSize(elements));
        elements.addAll(Collections.nCopies(100, b));
        Assert.assertEquals((long)(processorBatchSize / 4), (long)bm.getProcessorBatchSize(elements));
        elements.addAll(Collections.nCopies(375, b));
        Assert.assertEquals((long)(processorBatchSize / 8), (long)bm.getProcessorBatchSize(elements));
    }
}

