/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import java.util.Enumeration;
import java.util.List;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.NamespaceContext;

public final class JAXPNamespaceContextWrapper
implements NamespaceContext {
    private javax.xml.namespace.NamespaceContext fNamespaceContext;
    private SymbolTable fSymbolTable;
    private List fPrefixes;

    public JAXPNamespaceContextWrapper(SymbolTable symbolTable) {
        this.setSymbolTable(symbolTable);
    }

    public void setNamespaceContext(javax.xml.namespace.NamespaceContext context) {
        this.fNamespaceContext = context;
    }

    public javax.xml.namespace.NamespaceContext getNamespaceContext() {
        return this.fNamespaceContext;
    }

    public void setSymbolTable(SymbolTable symbolTable) {
        this.fSymbolTable = symbolTable;
    }

    public SymbolTable getSymbolTable() {
        return this.fSymbolTable;
    }

    public void setDeclaredPrefixes(List prefixes) {
        this.fPrefixes = prefixes;
    }

    public List getDeclaredPrefixes() {
        return this.fPrefixes;
    }

    @Override
    public String getURI(String prefix) {
        String uri;
        if (this.fNamespaceContext != null && (uri = this.fNamespaceContext.getNamespaceURI(prefix)) != null && !"".equals(uri)) {
            return this.fSymbolTable != null ? this.fSymbolTable.addSymbol(uri) : uri.intern();
        }
        return null;
    }

    @Override
    public String getPrefix(String uri) {
        if (this.fNamespaceContext != null) {
            String prefix;
            if (uri == null) {
                uri = "";
            }
            if ((prefix = this.fNamespaceContext.getPrefix(uri)) == null) {
                prefix = "";
            }
            return this.fSymbolTable != null ? this.fSymbolTable.addSymbol(prefix) : prefix.intern();
        }
        return null;
    }

    @Override
    public Enumeration getAllPrefixes() {
        return new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            public Object nextElement() {
                return null;
            }
        };
    }

    @Override
    public void pushContext() {
    }

    @Override
    public void popContext() {
    }

    @Override
    public boolean declarePrefix(String prefix, String uri) {
        return true;
    }

    @Override
    public int getDeclaredPrefixCount() {
        return this.fPrefixes != null ? this.fPrefixes.size() : 0;
    }

    @Override
    public String getDeclaredPrefixAt(int index) {
        return (String)this.fPrefixes.get(index);
    }

    @Override
    public void reset() {
    }
}

