/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.query.sql.lang.DynamicCommand;
import org.teiid.query.sql.lang.SetClauseList;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;

public class TestDynamicCommand
extends TestCase {
    public TestDynamicCommand(String name) {
        super(name);
    }

    public void testClone1() {
        ArrayList<ElementSymbol> symbols = new ArrayList<ElementSymbol>();
        ElementSymbol a1 = new ElementSymbol("a1");
        a1.setType(DataTypeManager.DefaultDataClasses.STRING);
        symbols.add(a1);
        DynamicCommand sqlCmd = new DynamicCommand();
        Constant sql = new Constant((Object)"SELECT a1 FROM g WHERE a2 = 5");
        sqlCmd.setSql((Expression)sql);
        sqlCmd.setAsColumns(symbols);
        sqlCmd.setAsClauseSet(true);
        sqlCmd.setIntoGroup(new GroupSymbol("#g"));
        UnitTestUtil.helpTestEquivalence((int)0, (Object)sqlCmd, (Object)sqlCmd.clone());
    }

    public void testClone2() {
        ArrayList<ElementSymbol> symbols = new ArrayList<ElementSymbol>();
        ElementSymbol a1 = new ElementSymbol("a1");
        a1.setType(DataTypeManager.DefaultDataClasses.STRING);
        symbols.add(a1);
        Constant sql = new Constant((Object)"SELECT * FROM g");
        SetClauseList using = new SetClauseList();
        using.addClause(a1, (Expression)a1);
        DynamicCommand sqlCmd = new DynamicCommand((Expression)sql, symbols, new GroupSymbol("#g"), using);
        UnitTestUtil.helpTestEquivalence((int)0, (Object)sqlCmd, (Object)sqlCmd.clone());
    }

    public void testClone3() {
        ArrayList<ElementSymbol> symbols = new ArrayList<ElementSymbol>();
        ElementSymbol a1 = new ElementSymbol("a1");
        a1.setType(DataTypeManager.DefaultDataClasses.STRING);
        symbols.add(a1);
        DynamicCommand sqlCmd = new DynamicCommand();
        Constant sql = new Constant((Object)"SELECT a1 FROM g WHERE a2 = 5");
        sqlCmd.setSql((Expression)sql);
        sqlCmd.setAsColumns(symbols);
        sqlCmd.setAsClauseSet(true);
        sqlCmd.setIntoGroup(new GroupSymbol("#g"));
        List projectedSymbols = sqlCmd.getProjectedSymbols();
        UnitTestUtil.helpTestEquivalence((int)0, (Object)sqlCmd, (Object)sqlCmd.clone());
        TestDynamicCommand.assertEquals((Object)projectedSymbols, (Object)((DynamicCommand)sqlCmd.clone()).getProjectedSymbols());
    }

    public void testUpdatingModelCount() {
        DynamicCommand sqlCmd = new DynamicCommand();
        sqlCmd.setUpdatingModelCount(1);
        TestDynamicCommand.assertEquals((int)1, (int)sqlCmd.getUpdatingModelCount());
        sqlCmd.setUpdatingModelCount(3);
        TestDynamicCommand.assertEquals((int)2, (int)sqlCmd.getUpdatingModelCount());
        sqlCmd.setUpdatingModelCount(-1);
        TestDynamicCommand.assertEquals((int)0, (int)sqlCmd.getUpdatingModelCount());
    }
}

