/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.test.framework.connection;

import java.sql.Connection;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.teiid.test.framework.connection.ConnectionStrategy;
import org.teiid.test.framework.exception.QueryTestFailedException;
import org.teiid.test.framework.exception.TransactionRuntimeException;

public class JEEConnection
extends ConnectionStrategy {
    public static final String DS_JNDINAME = "ds-jndiname";
    private String jndi_name = null;

    public JEEConnection(Properties props) throws QueryTestFailedException {
        super(props);
    }

    @Override
    public Connection getConnection() throws QueryTestFailedException {
        this.validate();
        try {
            InitialContext ctx = new InitialContext();
            DataSource source = (DataSource)ctx.lookup(this.jndi_name);
            if (source == null) {
                String msg = "Unable to find jndi source " + this.jndi_name;
                QueryTestFailedException mme = new QueryTestFailedException(msg);
                throw mme;
            }
            Connection conn = source.getConnection();
            return conn;
        }
        catch (QueryTestFailedException qtfe) {
            throw qtfe;
        }
        catch (Exception e) {
            throw new QueryTestFailedException(e);
        }
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }

    public void validate() {
        this.jndi_name = this.getEnvironment().getProperty(DS_JNDINAME);
        if (this.jndi_name == null || this.jndi_name.length() == 0) {
            throw new TransactionRuntimeException("Property ds-jndiname was not specified");
        }
    }
}

