/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.teiid.client.RequestMessage;
import org.teiid.client.ResizingArrayList;
import org.teiid.client.ResultsMessage;
import org.teiid.client.lob.LobChunk;
import org.teiid.client.metadata.ParameterInfo;
import org.teiid.client.plan.PlanNode;
import org.teiid.client.util.ExceptionUtil;
import org.teiid.client.util.ResultsReceiver;
import org.teiid.client.xa.XATransactionException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.dqp.internal.datamgr.ThreadCpuTimer;
import org.teiid.dqp.internal.process.AbstractWorkItem;
import org.teiid.dqp.internal.process.AuthorizationValidator;
import org.teiid.dqp.internal.process.CachedResults;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.DataTierTupleSource;
import org.teiid.dqp.internal.process.FutureWork;
import org.teiid.dqp.internal.process.LobWorkItem;
import org.teiid.dqp.internal.process.Request;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.dqp.internal.process.ThreadReuseExecutor;
import org.teiid.dqp.message.AtomicRequestID;
import org.teiid.dqp.message.RequestID;
import org.teiid.dqp.service.TransactionContext;
import org.teiid.dqp.service.TransactionService;
import org.teiid.jdbc.EnhancedTimer;
import org.teiid.logging.CommandLogMessage;
import org.teiid.logging.LogManager;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.parser.ParseInfo;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.processor.BatchCollector;
import org.teiid.query.processor.QueryProcessor;
import org.teiid.query.sql.lang.CacheHint;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.util.CommandContext;
import org.teiid.query.util.GeneratedKeysImpl;
import org.teiid.query.util.Options;

public class RequestWorkItem
extends AbstractWorkItem
implements ThreadReuseExecutor.PrioritizedRunnable {
    public static final String REQUEST_KEY = "teiid-request";
    private static final int OUTPUT_BUFFER_MAX_BATCHES = 8;
    private static final int CLIENT_FETCH_MAX_BATCHES = 3;
    private ProcessingState state = ProcessingState.NEW;
    private TransactionState transactionState = TransactionState.NONE;
    private int totalThreads;
    private LinkedList<WorkWrapper<?>> queue = new LinkedList();
    protected final DQPCore dqpCore;
    final RequestMessage requestMsg;
    final RequestID requestID;
    private Request request;
    private Options options;
    private final int processorTimeslice;
    private SessionAwareCache.CacheID cid;
    private final TransactionService transactionService;
    private final DQPWorkContext dqpWorkContext;
    boolean active;
    private volatile QueryProcessor processor;
    private BatchCollector collector;
    private Command originalCommand;
    private AnalysisRecord analysisRecord;
    private TransactionContext transactionContext;
    TupleBuffer resultsBuffer;
    private boolean returnsUpdateCount;
    private Throwable processingException;
    private Map<AtomicRequestID, DataTierTupleSource> connectorInfo = Collections.synchronizedMap(new HashMap(4));
    private volatile boolean doneProducingBatches;
    private volatile boolean isClosed;
    private volatile boolean isCanceled;
    private volatile boolean closeRequested;
    private ResultsReceiver<ResultsMessage> resultsReceiver;
    private int begin;
    private int end;
    private TupleBatch savedBatch;
    private Map<Integer, LobWorkItem> lobStreams = Collections.synchronizedMap(new HashMap(4));
    private long processingTimestamp = System.currentTimeMillis();
    protected boolean useCallingThread;
    private volatile boolean hasThread;
    private Future<Void> cancelTask;
    private Future<Void> moreWorkTask;
    private boolean explicitSourceClose;
    private int schemaSize;
    AtomicLong dataBytes = new AtomicLong();
    private long planningStart;
    private long planningEnd;
    private ThreadCpuTimer timer = new ThreadCpuTimer();

    public RequestWorkItem(DQPCore dqpCore, RequestMessage requestMsg, Request request, ResultsReceiver<ResultsMessage> receiver, RequestID requestID, DQPWorkContext workContext) {
        this.requestMsg = requestMsg;
        this.requestID = requestID;
        this.processorTimeslice = dqpCore.getProcessorTimeSlice();
        this.transactionService = dqpCore.getTransactionService();
        this.dqpCore = dqpCore;
        this.request = request;
        if (request != null) {
            this.options = request.options;
        }
        this.dqpWorkContext = workContext;
        this.requestResults(1, requestMsg.getFetchSize(), receiver);
    }

    private boolean isForwardOnly() {
        return this.cid == null && this.requestMsg.getCursorType() == 1003;
    }

    synchronized void requestResults(int beginRow, int endRow, ResultsReceiver<ResultsMessage> receiver) {
        if (this.resultsReceiver != null) {
            throw new IllegalStateException("Results already requested");
        }
        this.resultsReceiver = receiver;
        this.begin = beginRow;
        this.end = endRow;
    }

    @Override
    protected boolean isDoneProcessing() {
        return this.isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.hasThread = true;
        this.timer.start();
        LogManager.putMdc((String)REQUEST_KEY, (String)this.requestID.toString());
        try {
            while (!this.isDoneProcessing()) {
                super.run();
                if (!this.useCallingThread) {
                    return;
                }
                RequestWorkItem requestWorkItem = this;
                synchronized (requestWorkItem) {
                    if (this.resultsReceiver == null) {
                        return;
                    }
                    if (this.getThreadState() == AbstractWorkItem.ThreadState.MORE_WORK) {
                        continue;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        try {
                            this.requestCancel();
                        }
                        catch (TeiidComponentException e1) {
                            throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30543, (Throwable)e1);
                        }
                    }
                }
            }
            return;
        }
        finally {
            this.timer.stop();
            LogManager.removeMdc((String)REQUEST_KEY);
            this.hasThread = false;
        }
    }

    @Override
    protected void resumeProcessing() {
        if (!this.useCallingThread) {
            this.dqpCore.addWork(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doMoreWork() {
        boolean run = false;
        RequestWorkItem requestWorkItem = this;
        synchronized (requestWorkItem) {
            this.moreWork();
            if (!this.useCallingThread || this.getThreadState() != AbstractWorkItem.ThreadState.MORE_WORK) {
                return;
            }
            run = !this.hasThread;
        }
        if (run) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)"Restarting processing using the calling thread", (Object)this.requestID);
            this.run();
        }
    }

    @Override
    protected void process() {
        LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Request Thread", this.requestID, "with state", this.state});
        try {
            if (this.state == ProcessingState.NEW) {
                this.state = ProcessingState.PROCESSING;
                this.processNew();
                if (this.isCanceled) {
                    this.setCanceledException();
                    this.state = ProcessingState.CLOSE;
                }
            }
            this.resume();
            if (this.state == ProcessingState.PROCESSING) {
                if (!this.closeRequested) {
                    this.processMore();
                }
                if (this.closeRequested) {
                    this.state = ProcessingState.CLOSE;
                }
            }
        }
        catch (BlockedException e) {
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
                LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)"Request Thread", (Object)this.requestID, (Object)"- processor blocked");
            }
            if (e == BlockedException.BLOCKED_ON_MEMORY_EXCEPTION || e instanceof QueryProcessor.ExpiredTimeSliceException) {
                this.moreWork();
            }
        }
        catch (Throwable e) {
            this.handleThrowable(e);
        }
        finally {
            if (this.isClosed) {
                if (this.processingException == null) {
                    this.processingException = new IllegalStateException("Request is already closed");
                }
                this.sendError();
            } else if (this.state == ProcessingState.CLOSE) {
                this.close();
            }
            this.suspend();
        }
    }

    private void setCanceledException() {
        this.processingException = new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30563, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30563, new Object[]{this.requestID}));
    }

    private void handleThrowable(Throwable e) {
        if (!this.isCanceled()) {
            this.dqpCore.logMMCommand(this, CommandLogMessage.Event.ERROR, null, null);
            if (this.options.isSanitizeMessages() && !LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
                e = ExceptionUtil.sanitize((Throwable)e, (boolean)true);
            }
            if (e instanceof TeiidProcessingException) {
                Throwable cause;
                for (cause = e; cause.getCause() != null && cause.getCause() != cause; cause = cause.getCause()) {
                }
                StackTraceElement[] elems = cause.getStackTrace();
                Object elem = null;
                String causeMsg = cause.getMessage();
                if (elems.length > 0) {
                    StackTraceElement ste = cause.getStackTrace()[0];
                    elem = ste.getLineNumber() > 0 && ste.getFileName() != null ? ste.getFileName() + ":" + ste.getLineNumber() : ste;
                    String msg = e.getMessage();
                    if (causeMsg != null && cause != e && !msg.contains(causeMsg)) {
                        elem = "'" + causeMsg + "' " + elem;
                    }
                } else if (cause != e && causeMsg != null) {
                    elem = "'" + cause.getMessage() + "'";
                }
                String msg = QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30020, new Object[]{e.getMessage(), this.requestID, e.getClass().getSimpleName(), elem});
                if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
                    LogManager.logWarning((String)"org.teiid.PROCESSOR", (Throwable)e, (Object)msg);
                } else {
                    LogManager.logWarning((String)"org.teiid.PROCESSOR", (Object)(msg + QueryPlugin.Util.getString("stack_info")));
                }
            } else {
                LogManager.logError((String)"org.teiid.PROCESSOR", (Throwable)e, (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30019, new Object[]{this.requestID}));
            }
        } else {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Throwable)e, (Object[])new Object[]{"Request Thread", this.requestID, "- error occurred after cancel"});
        }
        this.processingException = e;
        this.state = ProcessingState.CLOSE;
    }

    private void resume() throws XATransactionException {
        if (this.transactionState == TransactionState.ACTIVE) {
            this.transactionService.resume(this.transactionContext);
        }
    }

    private boolean isSuspendable() {
        return this.transactionContext.getTransaction() != null && (!this.useCallingThread || this.transactionContext.getTransactionType() != TransactionContext.Scope.GLOBAL);
    }

    private void suspend() {
        if (this.transactionState != TransactionState.NONE && this.isSuspendable()) {
            try {
                this.transactionService.suspend(this.transactionContext);
            }
            catch (XATransactionException e) {
                LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)((Object)e), (Object)"Error suspending active transaction");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMore() throws BlockedException, TeiidException {
        if (!this.doneProducingBatches) {
            LinkedList<WorkWrapper<?>> linkedList = this.queue;
            synchronized (linkedList) {
                while (!this.queue.isEmpty() && this.totalThreads < this.dqpCore.getUserRequestSourceConcurrency()) {
                    WorkWrapper<?> w = this.queue.removeFirst();
                    this.dqpCore.addWork(w.work);
                    w.submitted = true;
                    ++this.totalThreads;
                }
            }
            this.processor.getContext().setTimeSliceEnd(System.currentTimeMillis() + (long)this.processorTimeslice);
            this.sendResultsIfNeeded(null);
            if (this.resultsReceiver == null && this.cursorRequestExpected()) {
                return;
            }
            try {
                CommandContext.pushThreadLocalContext(this.processor.getContext());
                this.resultsBuffer = this.collector.collectTuples();
            }
            finally {
                CommandContext.popThreadLocalContext();
            }
            if (!this.doneProducingBatches) {
                this.done();
            }
        }
        if (this.transactionState == TransactionState.ACTIVE) {
            this.transactionState = TransactionState.DONE;
            if (this.transactionContext.getTransactionType() == TransactionContext.Scope.REQUEST) {
                for (DataTierTupleSource connectorRequest : this.getConnectorRequests()) {
                    if (!connectorRequest.isTransactional()) continue;
                    connectorRequest.fullyCloseSource();
                }
                this.transactionService.commit(this.transactionContext);
            } else {
                this.suspend();
            }
        }
        this.sendResultsIfNeeded(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        int rowcount = -1;
        try {
            this.cancelCancelTask();
            if (this.moreWorkTask != null) {
                this.moreWorkTask.cancel(false);
                this.moreWorkTask = null;
            }
            if (this.resultsBuffer != null) {
                if (this.processor != null) {
                    try {
                        CommandContext.pushThreadLocalContext(this.processor.getContext());
                        this.processor.closeProcessing();
                        if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
                            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)("Removing tuplesource for the request " + this.requestID));
                        }
                        rowcount = this.resultsBuffer.getRowCount();
                        if (this.cid == null || !this.doneProducingBatches) {
                            this.resultsBuffer.remove();
                        }
                        for (DataTierTupleSource connectorRequest : this.getConnectorRequests()) {
                            connectorRequest.fullyCloseSource();
                        }
                        CommandContext cc = this.processor.getContext();
                        cc.close();
                    }
                    finally {
                        CommandContext.popThreadLocalContext();
                    }
                }
                this.resultsBuffer = null;
                if (!this.lobStreams.isEmpty()) {
                    ArrayList<LobWorkItem> lobs = null;
                    Map<Integer, LobWorkItem> map = this.lobStreams;
                    synchronized (map) {
                        lobs = new ArrayList<LobWorkItem>(this.lobStreams.values());
                    }
                    for (LobWorkItem lobWorkItem : lobs) {
                        lobWorkItem.close();
                    }
                }
            }
            if (this.transactionState == TransactionState.ACTIVE) {
                this.transactionState = TransactionState.DONE;
                if (this.transactionContext.getTransactionType() == TransactionContext.Scope.REQUEST) {
                    try {
                        this.transactionService.rollback(this.transactionContext);
                    }
                    catch (XATransactionException e1) {
                        LogManager.logWarning((String)"org.teiid.PROCESSOR", (Throwable)e1, (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30028, new Object[0]));
                    }
                } else {
                    this.suspend();
                }
            }
            RequestWorkItem e1 = this;
            synchronized (e1) {
                if (this.processingException == null && this.resultsReceiver != null) {
                    this.setCanceledException();
                }
            }
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        finally {
            this.isClosed = true;
            this.dqpCore.removeRequest(this);
            if (this.processingException != null) {
                this.sendError();
            }
            this.dqpCore.logMMCommand(this, CommandLogMessage.Event.END, rowcount, this.timer.stop());
        }
    }

    private void cancelCancelTask() {
        if (this.cancelTask != null) {
            this.cancelTask.cancel(false);
            this.cancelTask = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processNew() throws TeiidProcessingException, TeiidComponentException {
        this.planningStart = System.currentTimeMillis();
        SessionAwareCache<CachedResults> rsCache = this.dqpCore.getRsCache();
        boolean cachable = false;
        SessionAwareCache.CacheID cacheId = null;
        if (rsCache != null) {
            boolean canUseCache = true;
            if (this.requestMsg.getRequestOptions().isContinuous()) {
                canUseCache = false;
                LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)this.requestID, (Object)"Command is continuous, result set caching will not be used");
            } else if (!this.requestMsg.useResultSetCache() && this.getCacheHint() == null) {
                canUseCache = false;
                LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)this.requestID, (Object)"Command has no cache hint and result set cache mode is not on.");
            }
            if (canUseCache) {
                ParseInfo pi = Request.createParseInfo(this.requestMsg);
                cacheId = new SessionAwareCache.CacheID(this.dqpWorkContext, pi, this.requestMsg.getCommandString());
                cachable = cacheId.setParameters(this.requestMsg.getParameterValues());
                if (cachable) {
                    CachedResults cr;
                    TransactionContext tc;
                    if (rsCache.isTransactional() && (tc = this.request.getTransactionContext(false)) != null && tc.getTransactionType() != TransactionContext.Scope.NONE) {
                        this.initTransactionState(tc);
                        this.resume();
                    }
                    if ((cr = rsCache.get(cacheId)) != null && (cr.getRowLimit() == 0 || this.requestMsg.getRowLimit() != 0 && this.requestMsg.getRowLimit() <= cr.getRowLimit())) {
                        this.request.initMetadata();
                        this.originalCommand = cr.getCommand(this.requestMsg.getCommandString(), this.request.metadata, pi);
                        if (!this.request.validateAccess(this.requestMsg.getCommands(), this.originalCommand, AuthorizationValidator.CommandType.CACHED)) {
                            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)this.requestID, (Object)"Using result set cached results", (Object)cacheId);
                            this.resultsBuffer = cr.getResults();
                            this.doneProducingBatches();
                            return;
                        }
                        LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)this.requestID, (Object)"Cached result command to be modified, will not use the cached results", (Object)cacheId);
                    }
                } else {
                    LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)this.requestID, (Object)"Parameters are not serializable - cache cannot be used for", (Object)cacheId);
                }
            }
        } else {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)this.requestID, (Object)"Result set caching is disabled.");
        }
        try {
            this.request.processRequest();
        }
        finally {
            this.analysisRecord = this.request.analysisRecord;
        }
        this.originalCommand = this.request.userCommand;
        if (cachable && (this.requestMsg.useResultSetCache() || this.originalCommand.getCacheHint() != null) && rsCache != null && this.originalCommand.areResultsCachable()) {
            this.cid = cacheId;
            this.request.processor.getContext().setDataObjects(new HashSet<Object>(4));
        }
        this.request.processor.getContext().setWorkItem(this);
        this.processor = this.request.processor;
        this.planningEnd = System.currentTimeMillis();
        this.dqpCore.logMMCommand(this, CommandLogMessage.Event.PLAN, null, null);
        this.collector = new BatchCollector(this.processor, this.processor.getBufferManager(), this.request.context, this.isForwardOnly()){
            int maxRows;
            {
                this.maxRows = 0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void flushBatchDirect(TupleBatch batch, boolean add) throws TeiidComponentException, TeiidProcessingException {
                RequestWorkItem.this.resultsBuffer = this.getTupleBuffer();
                if (this.maxRows == 0) {
                    this.maxRows = 8 * RequestWorkItem.this.resultsBuffer.getBatchSize();
                }
                if (RequestWorkItem.this.cid != null) {
                    super.flushBatchDirect(batch, add);
                }
                Map map = RequestWorkItem.this.lobStreams;
                synchronized (map) {
                    if (RequestWorkItem.this.cid == null && RequestWorkItem.this.resultsBuffer.isLobs()) {
                        super.flushBatchDirect(batch, false);
                    }
                    if (batch.getTerminationFlag()) {
                        RequestWorkItem.this.done();
                    }
                    add = RequestWorkItem.this.sendResultsIfNeeded(batch);
                    if (RequestWorkItem.this.cid != null) {
                        return;
                    }
                    super.flushBatchDirect(batch, add);
                    if (!add && !RequestWorkItem.this.processor.hasBuffer(false)) {
                        RequestWorkItem.this.resultsBuffer.setRowCount(batch.getEndRow());
                    }
                    if (RequestWorkItem.this.transactionState != TransactionState.ACTIVE && (RequestWorkItem.this.requestMsg.getRequestOptions().isContinuous() || RequestWorkItem.this.useCallingThread && RequestWorkItem.this.isForwardOnly())) {
                        1 var4_4 = this;
                        synchronized (var4_4) {
                            if (RequestWorkItem.this.resultsReceiver == null) {
                                throw BlockedException.block(RequestWorkItem.this.requestID, "Blocking to allow asynch processing");
                            }
                        }
                        if (add && !RequestWorkItem.this.returnsUpdateCount) {
                            throw new AssertionError((Object)"Should not add batch to buffer");
                        }
                    }
                    if (add) {
                        this.flowControl(batch);
                    }
                }
            }

            private void flowControl(TupleBatch batch) throws BlockedException {
                if (RequestWorkItem.this.processor.hasBuffer(false) || batch.getTerminationFlag() || RequestWorkItem.this.transactionState == TransactionState.ACTIVE) {
                    return;
                }
                if (!RequestWorkItem.this.isForwardOnly() && RequestWorkItem.this.resultsReceiver != null && RequestWorkItem.this.begin > RequestWorkItem.this.resultsBuffer.getRowCount()) {
                    return;
                }
                if (RequestWorkItem.this.resultsBuffer.getManagedRowCount() < this.maxRows) {
                    return;
                }
                int timeOut = 500;
                if (!RequestWorkItem.this.connectorInfo.isEmpty()) {
                    if (RequestWorkItem.this.explicitSourceClose) {
                        for (DataTierTupleSource ts : RequestWorkItem.this.getConnectorRequests()) {
                            if (ts.isExplicitClose()) continue;
                            timeOut = 100;
                            break;
                        }
                    } else {
                        timeOut = 100;
                    }
                }
                if (RequestWorkItem.this.dqpCore.blockOnOutputBuffer(RequestWorkItem.this)) {
                    if (RequestWorkItem.this.moreWorkTask != null) {
                        RequestWorkItem.this.moreWorkTask.cancel(false);
                        RequestWorkItem.this.moreWorkTask = null;
                    }
                    if (RequestWorkItem.this.getThreadState() != AbstractWorkItem.ThreadState.MORE_WORK) {
                        RequestWorkItem.this.moreWorkTask = RequestWorkItem.this.scheduleWork(timeOut);
                    }
                    throw BlockedException.block(RequestWorkItem.this.requestID, "Blocking due to full results TupleBuffer", this.getTupleBuffer(), "rows", this.getTupleBuffer().getManagedRowCount(), "batch size", this.getTupleBuffer().getBatchSize());
                }
                if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
                    LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)RequestWorkItem.this.requestID, (Object)"Exceeding buffer limit since there are pending active plans or this is using the calling thread.");
                }
            }
        };
        if (!this.request.addedLimit && this.requestMsg.getRowLimit() > 0 && this.requestMsg.getRowLimit() < Integer.MAX_VALUE) {
            this.collector.setRowLimit(this.requestMsg.getRowLimit());
            this.collector.setSaveLastRow(this.request.isReturingParams());
        }
        this.resultsBuffer = this.collector.getTupleBuffer();
        if (this.resultsBuffer == null) {
            this.resultsBuffer = this.processor.getBufferManager().createTupleBuffer(this.originalCommand.getProjectedSymbols(), this.request.context.getConnectionId(), BufferManager.TupleSourceType.FINAL);
        } else if (this.requestMsg.getRequestOptions().isContinuous()) {
            this.resultsBuffer.removeLobTracking();
        }
        this.initTransactionState(this.request.transactionContext);
        if (this.requestMsg.isNoExec()) {
            this.doneProducingBatches();
            this.resultsBuffer.close();
            this.cid = null;
        }
        this.returnsUpdateCount = this.request.returnsUpdateCount;
        if (this.returnsUpdateCount && this.requestMsg.getRequestOptions().isContinuous()) {
            throw new IllegalStateException("Continuous requests are not allowed to be updates.");
        }
        this.request = null;
    }

    private void initTransactionState(TransactionContext tc) {
        this.transactionContext = tc;
        if (this.transactionContext != null && this.transactionContext.getTransactionType() != TransactionContext.Scope.NONE) {
            if (this.requestMsg.getRequestOptions().isContinuous()) {
                throw new IllegalStateException("Continuous requests are not allowed to be transactional.");
            }
            this.transactionState = TransactionState.ACTIVE;
        }
    }

    private CacheHint getCacheHint() {
        if (this.requestMsg.getCommand() != null) {
            return ((Command)this.requestMsg.getCommand()).getCacheHint();
        }
        return QueryParser.getQueryParser().parseCacheHint(this.requestMsg.getCommandString());
    }

    private void addToCache() {
        if (!this.doneProducingBatches || this.cid == null) {
            return;
        }
        FunctionMethod.Determinism determinismLevel = this.processor.getContext().getDeterminismLevel();
        CachedResults cr = new CachedResults();
        cr.setCommand(this.originalCommand);
        cr.setResults(this.resultsBuffer, this.processor.getProcessorPlan());
        if (this.requestMsg.getRowLimit() > 0 && this.resultsBuffer.getRowCount() == this.requestMsg.getRowLimit() + (this.collector.isSaveLastRow() ? 1 : 0)) {
            cr.setRowLimit(this.requestMsg.getRowLimit());
        }
        if (this.originalCommand.getCacheHint() != null) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)this.requestID, (Object)"Using cache hint", (Object)((Object)this.originalCommand.getCacheHint()));
            if (this.originalCommand.getCacheHint().getMinRows() != null && (long)this.resultsBuffer.getRowCount() <= this.originalCommand.getCacheHint().getMinRows()) {
                LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)this.requestID, (Object)"Not caching result as there are fewer rows than needed", (Object)this.resultsBuffer.getRowCount());
                return;
            }
            this.resultsBuffer.setPrefersMemory(this.originalCommand.getCacheHint().isPrefersMemory());
            if (this.originalCommand.getCacheHint().getDeterminism() != null) {
                determinismLevel = this.originalCommand.getCacheHint().getDeterminism();
                LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Cache hint modified the query determinism from ", this.processor.getContext().getDeterminismLevel(), " to ", determinismLevel});
            }
            if (!this.originalCommand.getCacheHint().isUpdatable(true)) {
                cr.getAccessInfo().setSensitiveToMetadataChanges(false);
                cr.getAccessInfo().getObjectsAccessed().clear();
            }
        }
        if (determinismLevel.compareTo((Enum)FunctionMethod.Determinism.SESSION_DETERMINISTIC) <= 0) {
            LogManager.logInfo((String)"org.teiid.PROCESSOR", (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30008, new Object[]{this.originalCommand}));
        }
        try {
            this.resultsBuffer.persistLobs();
        }
        catch (TeiidException e) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)((Object)e), (Object)QueryPlugin.Util.getString("failed_to_cache"));
        }
        this.dqpCore.getRsCache().put(this.cid, determinismLevel, cr, this.originalCommand.getCacheHint() != null ? this.originalCommand.getCacheHint().getTtl() : null);
    }

    public SessionAwareCache<CachedResults> getRsCache() {
        return this.dqpCore.getRsCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean sendResultsIfNeeded(TupleBatch batch) throws TeiidComponentException {
        ResultsMessage response = null;
        ResultsReceiver<ResultsMessage> receiver = null;
        boolean result = true;
        RequestWorkItem requestWorkItem = this;
        synchronized (requestWorkItem) {
            StoredProcedure proc;
            if (this.resultsReceiver == null) {
                if (this.cursorRequestExpected()) {
                    if (batch != null) {
                        throw new AssertionError((Object)"batch has no handler");
                    }
                    throw BlockedException.block(this.requestID, "Blocking until client is ready");
                }
                return result;
            }
            if (!this.requestMsg.getRequestOptions().isContinuous()) {
                if (this.begin > (batch != null ? batch.getEndRow() : this.resultsBuffer.getRowCount()) && !this.doneProducingBatches || this.transactionState == TransactionState.ACTIVE || this.returnsUpdateCount && !this.doneProducingBatches) {
                    return result;
                }
                if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
                    LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"[RequestWorkItem.sendResultsIfNeeded] requestID:", this.requestID, "resultsID:", this.resultsBuffer, "done:", this.doneProducingBatches});
                }
                boolean fromBuffer = false;
                int count = this.end - this.begin + 1;
                if (this.returnsUpdateCount) {
                    count = Integer.MAX_VALUE;
                }
                if (batch == null || !batch.containsRow(this.begin) && (!batch.getTerminationFlag() || batch.getEndRow() > this.begin)) {
                    if (this.savedBatch != null && this.savedBatch.containsRow(this.begin)) {
                        batch = this.savedBatch;
                    } else {
                        TupleBatch next;
                        batch = this.resultsBuffer.getBatch(this.begin);
                        boolean first = true;
                        int rowSize = this.resultsBuffer.getRowSizeEstimate();
                        int batches = 3;
                        if (rowSize > 0) {
                            int multiplier;
                            int totalSize = rowSize * this.resultsBuffer.getBatchSize();
                            if (this.schemaSize == 0) {
                                this.schemaSize = this.dqpCore.getBufferManager().getSchemaSize(this.originalCommand.getProjectedSymbols());
                            }
                            if ((multiplier = this.schemaSize / totalSize) > 1) {
                                batches *= multiplier;
                            }
                        }
                        if (this.returnsUpdateCount) {
                            batches = Integer.MAX_VALUE;
                        }
                        for (int i = 1; i < batches && batch.getRowCount() + this.resultsBuffer.getBatchSize() <= count && !batch.getTerminationFlag() && (next = this.resultsBuffer.getBatch(batch.getEndRow() + 1)).getRowCount() != 0; ++i) {
                            if (first) {
                                first = false;
                                TupleBatch old = batch;
                                batch = new TupleBatch(batch.getBeginRow(), (List<? extends List<?>>)new ResizingArrayList(batch.getTuples()));
                                batch.setTermination(old.getTermination());
                            }
                            batch.getTuples().addAll(next.getTuples());
                            batch.setTermination(next.getTermination());
                        }
                    }
                    this.savedBatch = null;
                    fromBuffer = true;
                }
                if (batch.getRowCount() > count) {
                    int beginRow = this.isForwardOnly() ? this.begin : Math.min(this.begin, batch.getEndRow() - count + 1);
                    int endRow = Math.min(beginRow + count - 1, batch.getEndRow());
                    boolean last = false;
                    if (endRow == batch.getEndRow()) {
                        last = batch.getTerminationFlag();
                    } else if (this.isForwardOnly()) {
                        this.savedBatch = batch;
                    }
                    List<List<?>> memoryRows = batch.getTuples();
                    batch = new TupleBatch(beginRow, memoryRows.subList(beginRow - batch.getBeginRow(), endRow - batch.getBeginRow() + 1));
                    batch.setTerminationFlag(last);
                } else if (!fromBuffer) {
                    result = !this.isForwardOnly();
                }
            } else {
                if (batch == null) {
                    return result;
                }
                result = false;
            }
            int finalRowCount = this.resultsBuffer.isFinal() && !this.requestMsg.getRequestOptions().isContinuous() ? this.resultsBuffer.getRowCount() : (batch.getTerminationFlag() ? batch.getEndRow() : -1);
            response = this.createResultsMessage(batch.getTuples(), this.originalCommand.getProjectedSymbols());
            response.setFirstRow(batch.getBeginRow());
            if (batch.getTermination() == 2) {
                response.setLastRow(batch.getEndRow() - 1);
            } else {
                response.setLastRow(batch.getEndRow());
            }
            response.setUpdateResult(this.returnsUpdateCount);
            if (this.returnsUpdateCount && this.processor.getContext().isReturnAutoGeneratedKeys() && finalRowCount == 1 && this.processor.getContext().getGeneratedKeys() != null) {
                GeneratedKeysImpl keys = this.processor.getContext().getGeneratedKeys();
                response.setColumnNames(keys.getColumnNames());
                String[] dataTypes = new String[keys.getColumnNames().length];
                for (int i = 0; i < dataTypes.length; ++i) {
                    dataTypes[i] = DataTypeManager.getDataTypeName(keys.getColumnTypes()[i]);
                }
                response.setUpdateCount(((Integer)((List)response.getResultsList().get(0)).get(0)).intValue());
                response.setDataTypes(dataTypes);
                response.setResults(keys.getKeys());
                response.setLastRow(keys.getKeys().size());
                finalRowCount = response.getLastRow();
            }
            response.setFinalRow(finalRowCount);
            if (response.getLastRow() == finalRowCount) {
                response.setDelayDeserialization(false);
            }
            this.setWarnings(response);
            if (this.originalCommand instanceof StoredProcedure && (proc = (StoredProcedure)this.originalCommand).returnParameters()) {
                response.setParameters(RequestWorkItem.getParameterInfo(proc));
            }
            receiver = this.resultsReceiver;
            this.resultsReceiver = null;
        }
        this.cancelCancelTask();
        if (!this.dqpWorkContext.getSession().isEmbedded() && this.requestMsg.isDelaySerialization() && this.requestMsg.getShowPlan() == RequestMessage.ShowPlan.ON || this.requestMsg.getShowPlan() == RequestMessage.ShowPlan.DEBUG || LogManager.isMessageToBeRecorded((String)"org.teiid.COMMAND_LOG", (int)6)) {
            try {
                boolean keep = !this.dqpWorkContext.getSession().isEmbedded() && this.requestMsg.isDelaySerialization();
                int bytes = response.serialize(keep);
                if (keep) {
                    response.setDelayDeserialization(true);
                }
                this.dataBytes.addAndGet(bytes);
                LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Sending results for", this.requestID, "start row", response.getFirstRow(), "end row", response.getLastRow(), bytes, "bytes"});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setAnalysisRecords(response);
        receiver.receiveResults((Object)response);
        return result;
    }

    private boolean cursorRequestExpected() {
        return this.transactionState != TransactionState.ACTIVE && (this.requestMsg.getRequestOptions().isContinuous() || this.useCallingThread && this.isForwardOnly());
    }

    private void setWarnings(ResultsMessage response) {
        List<Exception> currentWarnings;
        boolean sanitize = this.options.isSanitizeMessages() && !LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5);
        ArrayList<Throwable> responseWarnings = new ArrayList<Throwable>();
        if (this.processor != null && (currentWarnings = this.processor.getAndClearWarnings()) != null) {
            if (sanitize) {
                for (Exception e : currentWarnings) {
                    responseWarnings.add(ExceptionUtil.sanitize((Throwable)e, (boolean)false));
                }
            } else {
                responseWarnings.addAll(currentWarnings);
            }
        }
        response.setWarnings(responseWarnings);
    }

    public ResultsMessage createResultsMessage(List<? extends List<?>> batch, List<? extends Expression> columnSymbols) {
        String[] columnNames = new String[columnSymbols.size()];
        String[] dataTypes = new String[columnSymbols.size()];
        byte clientSerializationVersion = this.dqpWorkContext.getClientVersion().getClientSerializationVersion();
        for (int i = 0; i < columnSymbols.size(); ++i) {
            Expression symbol = columnSymbols.get(i);
            columnNames[i] = Symbol.getShortName(Symbol.getOutputName(symbol));
            dataTypes[i] = DataTypeManager.getDataTypeName(symbol.getType());
            if (!dataTypes[i].equals("geometry") || this.dqpWorkContext.getSession().isEmbedded() || clientSerializationVersion >= 4) continue;
            dataTypes[i] = "blob";
        }
        ResultsMessage result = new ResultsMessage(batch, columnNames, dataTypes);
        result.setClientSerializationVersion(clientSerializationVersion);
        result.setDelayDeserialization(this.requestMsg.isDelaySerialization() && this.originalCommand.returnsResultSet());
        return result;
    }

    private void setAnalysisRecords(ResultsMessage response) {
        if (this.analysisRecord != null) {
            if (this.requestMsg.getShowPlan() != RequestMessage.ShowPlan.OFF) {
                if (this.processor != null) {
                    PlanNode node = this.processor.getProcessorPlan().getDescriptionProperties();
                    node.addProperty("Data Bytes Sent", String.valueOf(this.dataBytes.get()));
                    if (this.planningEnd != 0L) {
                        node.addProperty("Planning Time", String.valueOf(this.planningEnd - this.planningStart));
                    }
                    response.setPlanDescription(node);
                }
                if (this.analysisRecord.getAnnotations() != null && !this.analysisRecord.getAnnotations().isEmpty()) {
                    response.setAnnotations(this.analysisRecord.getAnnotations());
                    this.analysisRecord.getAnnotations().clear();
                }
            }
            if (this.requestMsg.getShowPlan() == RequestMessage.ShowPlan.DEBUG) {
                response.setDebugLog(this.analysisRecord.getDebugLog());
                this.analysisRecord.stopDebugLog();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendError() {
        ResultsReceiver<ResultsMessage> receiver = null;
        RequestWorkItem requestWorkItem = this;
        synchronized (requestWorkItem) {
            receiver = this.resultsReceiver;
            this.resultsReceiver = null;
            if (receiver == null) {
                LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)this.processingException, (Object)"Unable to send error to client as results were already sent.", (Object)this.requestID);
                return;
            }
        }
        LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)this.processingException, (Object)"Sending error to client", (Object)this.requestID);
        ResultsMessage response = new ResultsMessage();
        Throwable exception = this.processingException;
        if (this.options.isSanitizeMessages() && !LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
            exception = ExceptionUtil.sanitize((Throwable)exception, (boolean)false);
        }
        if (this.isCanceled) {
            exception = this.addCancelCode(exception);
        }
        this.setWarnings(response);
        response.setException(exception);
        this.setAnalysisRecords(response);
        receiver.receiveResults((Object)response);
    }

    private Throwable addCancelCode(Throwable exception) {
        TeiidException te;
        if (exception instanceof TeiidException && "57014".equals((te = (TeiidException)exception).getCode())) {
            return exception;
        }
        TeiidProcessingException tpe = new TeiidProcessingException(exception);
        tpe.setCode("57014");
        return tpe;
    }

    private static List<ParameterInfo> getParameterInfo(StoredProcedure procedure) {
        ArrayList<ParameterInfo> paramInfos = new ArrayList<ParameterInfo>();
        for (SPParameter param : procedure.getParameters()) {
            ParameterInfo info = new ParameterInfo(param.getParameterType(), param.getResultSetColumns().size());
            paramInfos.add(info);
        }
        return paramInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLobChunkRequest(String id, int streamRequestId, ResultsReceiver<LobChunk> chunckReceiver) {
        LobWorkItem workItem = null;
        Map<Integer, LobWorkItem> map = this.lobStreams;
        synchronized (map) {
            workItem = this.lobStreams.get(streamRequestId);
            if (workItem == null) {
                workItem = new LobWorkItem(this, this.dqpCore, id, streamRequestId);
                this.lobStreams.put(streamRequestId, workItem);
            }
        }
        workItem.setResultsReceiver(chunckReceiver);
        if (this.dqpWorkContext.useCallingThread()) {
            workItem.run();
        } else {
            this.dqpCore.addWork((Runnable)((Object)workItem));
        }
    }

    public void removeLobStream(int streamRequestId) {
        this.lobStreams.remove(streamRequestId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestCancel() throws TeiidComponentException {
        RequestWorkItem requestWorkItem = this;
        synchronized (requestWorkItem) {
            if (this.isCanceled || this.closeRequested) {
                return false;
            }
            this.isCanceled = true;
        }
        if (this.processor != null) {
            this.processor.requestCanceled();
        }
        try {
            for (DataTierTupleSource connectorRequest : this.getConnectorRequests()) {
                connectorRequest.cancelRequest();
            }
        }
        finally {
            block19: {
                try {
                    if (this.transactionService == null) break block19;
                    try {
                        this.transactionService.cancelTransactions(this.requestID.getConnectionID(), true);
                    }
                    catch (XATransactionException err) {
                        throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30544, (Throwable)err);
                    }
                }
                finally {
                    this.moreWork();
                }
            }
        }
        return true;
    }

    public boolean requestAtomicRequestCancel(AtomicRequestID ari) throws TeiidComponentException {
        if (!this.requestMsg.supportsPartialResults()) {
            return this.requestCancel();
        }
        DataTierTupleSource connectorRequest = this.connectorInfo.get(ari);
        if (connectorRequest != null) {
            connectorRequest.cancelRequest();
            return true;
        }
        LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)"Connector request not found. AtomicRequestID=", (Object)ari);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestClose() throws TeiidComponentException {
        RequestWorkItem requestWorkItem = this;
        synchronized (requestWorkItem) {
            if (this.state == ProcessingState.CLOSE || this.closeRequested) {
                if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
                    LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)("Request already closing" + this.requestID));
                }
                return;
            }
        }
        if (!this.doneProducingBatches) {
            this.requestCancel();
        }
        this.closeRequested = true;
        this.doMoreWork();
    }

    public void requestMore(int batchFirst, int batchLast, ResultsReceiver<ResultsMessage> receiver) {
        this.requestResults(batchFirst, batchLast, receiver);
        this.doMoreWork();
    }

    public void closeAtomicRequest(AtomicRequestID atomicRequestId) {
        this.connectorInfo.remove(atomicRequestId);
        LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"closed atomic-request:", atomicRequestId});
    }

    public void addConnectorRequest(AtomicRequestID atomicRequestId, DataTierTupleSource connInfo) {
        this.explicitSourceClose |= connInfo.isExplicitClose();
        this.connectorInfo.put(atomicRequestId, connInfo);
    }

    boolean isCanceled() {
        return this.isCanceled;
    }

    Command getOriginalCommand() throws TeiidProcessingException {
        if (this.originalCommand == null) {
            if (this.processingException != null) {
                throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30545, this.processingException);
            }
            throw new IllegalStateException("Original command is not available");
        }
        return this.originalCommand;
    }

    void setOriginalCommand(Command originalCommand) {
        this.originalCommand = originalCommand;
    }

    TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<DataTierTupleSource> getConnectorRequests() {
        Map<AtomicRequestID, DataTierTupleSource> map = this.connectorInfo;
        synchronized (map) {
            return new ArrayList<DataTierTupleSource>(this.connectorInfo.values());
        }
    }

    DataTierTupleSource getConnectorRequest(AtomicRequestID id) {
        return this.connectorInfo.get(id);
    }

    @Override
    public String toString() {
        return this.requestID.toString();
    }

    @Override
    public DQPWorkContext getDqpWorkContext() {
        return this.dqpWorkContext;
    }

    public long getProcessingTimestamp() {
        return this.processingTimestamp;
    }

    @Override
    public void release() {
        try {
            this.requestCancel();
        }
        catch (TeiidComponentException e) {
            LogManager.logWarning((String)"org.teiid.PROCESSOR", (Throwable)e, (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30026, new Object[]{this.requestID}));
        }
    }

    private void done() {
        this.doneProducingBatches();
        this.addToCache();
        if (this.resultsBuffer.getLobCount() == 0) {
            for (DataTierTupleSource connectorRequest : this.getConnectorRequests()) {
                connectorRequest.fullyCloseSource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doneProducingBatches() {
        this.doneProducingBatches = true;
        LinkedList<WorkWrapper<?>> linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.clear();
        }
        this.dqpCore.finishProcessing(this);
    }

    @Override
    public int getPriority() {
        return this.closeRequested || this.isCanceled ? 0 : 1000;
    }

    @Override
    public long getCreationTime() {
        return this.processingTimestamp;
    }

    <T> FutureWork<T> addHighPriorityWork(Callable<T> callable) {
        FutureWork<T> work = new FutureWork<T>(callable, 0);
        work.setRequestId(this.requestID.toString());
        this.dqpCore.addWork(work);
        return work;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> FutureWork<T> addWork(Callable<T> callable, DQPCore.CompletionListener<T> listener, int priority) {
        FutureWork<T> work = new FutureWork<T>(callable, priority);
        work.setRequestId(this.requestID.toString());
        WorkWrapper<T> wl = new WorkWrapper<T>(work);
        work.addCompletionListener(wl);
        work.addCompletionListener(listener);
        LinkedList<WorkWrapper<?>> linkedList = this.queue;
        synchronized (linkedList) {
            if (this.totalThreads < this.dqpCore.getUserRequestSourceConcurrency()) {
                this.dqpCore.addWork(work);
                ++this.totalThreads;
                wl.submitted = true;
            } else {
                this.queue.add(wl);
                LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)this.requestID, (Object)" reached max source concurrency of ", (Object)this.dqpCore.getUserRequestSourceConcurrency());
            }
        }
        return work;
    }

    public Future<Void> scheduleWork(long delay) {
        return this.dqpCore.scheduleWork(new MoreWorkTask(this), delay);
    }

    public void setCancelTask(EnhancedTimer.Task cancelTask) {
        this.cancelTask = cancelTask;
    }

    public QueryProcessor getProcessor() {
        return this.processor;
    }

    public RequestID getRequestID() {
        return this.requestID;
    }

    private static enum TransactionState {
        NONE,
        ACTIVE,
        DONE;

    }

    private static enum ProcessingState {
        NEW,
        PROCESSING,
        CLOSE;

    }

    private final class WorkWrapper<T>
    implements DQPCore.CompletionListener<T> {
        boolean submitted;
        FutureWork<T> work;

        public WorkWrapper(FutureWork<T> work) {
            this.work = work;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompletion(FutureWork<T> future) {
            WorkWrapper nextWork = null;
            LinkedList linkedList = RequestWorkItem.this.queue;
            synchronized (linkedList) {
                if (!this.submitted) {
                    return;
                }
                RequestWorkItem requestWorkItem = RequestWorkItem.this;
                synchronized (requestWorkItem) {
                    if (RequestWorkItem.this.isProcessing()) {
                        RequestWorkItem.this.totalThreads--;
                        RequestWorkItem.this.moreWork();
                        return;
                    }
                }
                nextWork = (WorkWrapper)RequestWorkItem.this.queue.pollFirst();
                if (nextWork == null) {
                    RequestWorkItem.this.totalThreads--;
                } else {
                    nextWork.submitted = true;
                }
            }
            if (nextWork != null) {
                RequestWorkItem.this.dqpCore.addWork(nextWork.work);
            }
        }
    }

    public static final class MoreWorkTask
    implements Runnable {
        WeakReference<RequestWorkItem> ref;

        public MoreWorkTask(RequestWorkItem workItem) {
            this.ref = new WeakReference<RequestWorkItem>(workItem);
        }

        @Override
        public void run() {
            RequestWorkItem item = (RequestWorkItem)this.ref.get();
            if (item != null) {
                item.moreWork();
            }
        }
    }
}

