/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.NodeFactory;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.NewCalculateCostUtil;
import org.teiid.query.optimizer.relational.rules.RuleRaiseAccess;
import org.teiid.query.processor.relational.JoinNode;
import org.teiid.query.processor.relational.MergeJoinStrategy;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.GroupsUsedByElementsVisitor;
import org.teiid.query.util.CommandContext;

public class RuleImplementJoinStrategy
implements OptimizerRule {
    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capabilitiesFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        block0: for (PlanNode sourceNode : NodeEditor.findAllNodes(plan, 64, 1)) {
            SymbolMap references = (SymbolMap)sourceNode.getProperty(NodeConstants.Info.CORRELATED_REFERENCES);
            if (references == null) continue;
            Set<GroupSymbol> groups = GroupsUsedByElementsVisitor.getGroups(references.getValues());
            PlanNode joinNode = NodeEditor.findParent(sourceNode, 4, 64);
            while (joinNode != null) {
                if (joinNode.getGroups().containsAll(groups)) {
                    joinNode.setProperty(NodeConstants.Info.JOIN_STRATEGY, (Object)JoinNode.JoinStrategyType.NESTED_TABLE);
                    SymbolMap map = null;
                    NodeConstants.Info info = NodeConstants.Info.RIGHT_NESTED_REFERENCES;
                    if (!FrameUtil.findJoinSourceNode(joinNode.getFirstChild()).getGroups().containsAll(groups)) {
                        info = NodeConstants.Info.LEFT_NESTED_REFERENCES;
                    }
                    if ((map = (SymbolMap)joinNode.getProperty(info)) == null) {
                        map = new SymbolMap();
                    }
                    joinNode.setProperty(info, map);
                    map.asUpdatableMap().putAll(references.asMap());
                    if (joinNode.getProperty(NodeConstants.Info.DEPENDENT_VALUE_SOURCE) != null) {
                        throw new AssertionError((Object)"Cannot use a depenedent join when the join involves a correlated nested table.");
                    }
                    continue block0;
                }
                joinNode = NodeEditor.findParent(joinNode, 4, 64);
            }
        }
        for (PlanNode joinNode : NodeEditor.findAllNodes(plan, 4, 1)) {
            boolean pushedRight;
            Collection output;
            Set<GroupSymbol> groups;
            JoinNode.JoinStrategyType stype = (JoinNode.JoinStrategyType)((Object)joinNode.getProperty(NodeConstants.Info.JOIN_STRATEGY));
            if (!JoinNode.JoinStrategyType.MERGE.equals((Object)stype)) continue;
            List leftExpressions = (List)joinNode.getProperty(NodeConstants.Info.LEFT_EXPRESSIONS);
            List rightExpressions = (List)joinNode.getProperty(NodeConstants.Info.RIGHT_EXPRESSIONS);
            int origExpressionCount = leftExpressions.size();
            Object key = null;
            boolean right = true;
            if (joinNode.getLastChild().getType() == 1 && NewCalculateCostUtil.isSingleTable(joinNode.getLastChild())) {
                key = NewCalculateCostUtil.getKeyUsed(rightExpressions, null, metadata, null);
            }
            if (key == null && joinNode.getFirstChild().getType() == 1 && NewCalculateCostUtil.isSingleTable(joinNode.getFirstChild())) {
                key = NewCalculateCostUtil.getKeyUsed(leftExpressions, null, metadata, null);
                right = false;
            }
            JoinType joinType = (JoinType)joinNode.getProperty(NodeConstants.Info.JOIN_TYPE);
            boolean pushLeft = true;
            boolean pushRight = true;
            if ((joinType == JoinType.JOIN_INNER || joinType == JoinType.JOIN_LEFT_OUTER) && context != null) {
                float leftCost = NewCalculateCostUtil.computeCostForTree(joinNode.getFirstChild(), metadata);
                float rightCost = NewCalculateCostUtil.computeCostForTree(joinNode.getLastChild(), metadata);
                if (leftCost != -1.0f && rightCost != -1.0f && (leftCost > (float)context.getProcessorBatchSize() || rightCost > (float)context.getProcessorBatchSize())) {
                    pushLeft = leftCost < (float)context.getProcessorBatchSize() || leftCost / rightCost < 8.0f || key != null && !right;
                    boolean bl = pushRight = rightCost < (float)context.getProcessorBatchSize() || rightCost / leftCost < 8.0f || joinType == JoinType.JOIN_LEFT_OUTER || key != null && right;
                }
            }
            if (key != null && joinNode.getProperty(NodeConstants.Info.DEPENDENT_VALUE_SOURCE) == null) {
                List keyCols = metadata.getElementIDsInKey(key);
                int[] reorder = new int[keyCols.size()];
                LinkedHashSet<Integer> toCriteria = new LinkedHashSet<Integer>();
                List keyExpressions = right ? rightExpressions : leftExpressions;
                LinkedHashMap<Object, Integer> indexMap = new LinkedHashMap<Object, Integer>();
                for (int i = 0; i < keyExpressions.size(); ++i) {
                    Expression ses = (Expression)keyExpressions.get(i);
                    if (!(ses instanceof ElementSymbol)) {
                        toCriteria.add(i);
                        continue;
                    }
                    Integer existing = indexMap.put(((ElementSymbol)ses).getMetadataID(), i);
                    if (existing == null) continue;
                    toCriteria.add(existing);
                }
                boolean found = true;
                for (int i = 0; i < keyCols.size(); ++i) {
                    Object id = keyCols.get(i);
                    Integer index = (Integer)indexMap.remove(id);
                    if (index == null) {
                        found = false;
                        break;
                    }
                    reorder[i] = index;
                }
                if (found) {
                    toCriteria.addAll(indexMap.values());
                    ArrayList<CompareCriteria> joinCriteria = (ArrayList<CompareCriteria>)joinNode.getProperty(NodeConstants.Info.NON_EQUI_JOIN_CRITERIA);
                    Iterator iterator = toCriteria.iterator();
                    while (iterator.hasNext()) {
                        int index = (Integer)iterator.next();
                        Expression lses = (Expression)leftExpressions.get(index);
                        Expression rses = (Expression)rightExpressions.get(index);
                        CompareCriteria cc = new CompareCriteria(lses, 1, rses);
                        if (joinCriteria == null || joinCriteria.isEmpty()) {
                            joinCriteria = new ArrayList<CompareCriteria>();
                        }
                        joinCriteria.add(cc);
                    }
                    joinNode.setProperty(NodeConstants.Info.NON_EQUI_JOIN_CRITERIA, joinCriteria);
                    leftExpressions = RelationalNode.projectTuple(reorder, leftExpressions);
                    rightExpressions = RelationalNode.projectTuple(reorder, rightExpressions);
                    joinNode.setProperty(NodeConstants.Info.LEFT_EXPRESSIONS, leftExpressions);
                    joinNode.setProperty(NodeConstants.Info.RIGHT_EXPRESSIONS, rightExpressions);
                }
            }
            boolean pushedLeft = RuleImplementJoinStrategy.insertSort(joinNode.getFirstChild(), leftExpressions, joinNode, metadata, capabilitiesFinder, pushLeft);
            if (origExpressionCount == 1 && joinType == JoinType.JOIN_INNER && joinNode.getProperty(NodeConstants.Info.DEPENDENT_VALUE_SOURCE) != null && !joinNode.hasCollectionProperty(NodeConstants.Info.NON_EQUI_JOIN_CRITERIA) && Collections.disjoint(groups = GroupsUsedByElementsVisitor.getGroups(output = (Collection)joinNode.getProperty(NodeConstants.Info.OUTPUT_COLS)), FrameUtil.findJoinSourceNode(joinNode.getFirstChild()).getGroups())) {
                pushRight = false;
                joinNode.setProperty(NodeConstants.Info.IS_SEMI_DEP, Boolean.TRUE);
            }
            if ((pushedRight = RuleImplementJoinStrategy.insertSort(joinNode.getLastChild(), rightExpressions, joinNode, metadata, capabilitiesFinder, pushRight)) && pushedLeft || joinType != JoinType.JOIN_INNER && (joinType != JoinType.JOIN_LEFT_OUTER || pushedLeft)) continue;
            joinNode.setProperty(NodeConstants.Info.JOIN_STRATEGY, (Object)JoinNode.JoinStrategyType.ENHANCED_SORT);
        }
        return plan;
    }

    static boolean insertSort(PlanNode childNode, List<Expression> expressions, PlanNode jnode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, boolean attemptPush) throws QueryMetadataException, TeiidComponentException {
        LinkedHashSet<Expression> orderSymbols = new LinkedHashSet<Expression>(expressions);
        PlanNode sourceNode = FrameUtil.findJoinSourceNode(childNode);
        PlanNode joinNode = childNode.getParent();
        LinkedHashSet<Expression> outputSymbols = new LinkedHashSet<Expression>((List)childNode.getProperty(NodeConstants.Info.OUTPUT_COLS));
        int oldSize = outputSymbols.size();
        outputSymbols.addAll(expressions);
        boolean needsCorrection = outputSymbols.size() > oldSize;
        PlanNode sortNode = RuleImplementJoinStrategy.createSortNode(new ArrayList<Expression>(orderSymbols), outputSymbols);
        boolean distinct = false;
        if (sourceNode.getFirstChild() != null && sourceNode.getType() == 64 && outputSymbols.size() == expressions.size() && outputSymbols.containsAll(expressions)) {
            PlanNode setOp = NodeEditor.findNodePreOrder(sourceNode.getFirstChild(), 256, 64);
            if (setOp != null) {
                if (setOp.hasBooleanProperty(NodeConstants.Info.USE_ALL)) {
                    distinct = true;
                }
            } else if (NodeEditor.findNodePreOrder(sourceNode.getFirstChild(), 2, 8) != null) {
                distinct = true;
            }
        }
        boolean sort = true;
        if (sourceNode.getType() == 1) {
            if (distinct || NewCalculateCostUtil.usesKey(sourceNode, expressions, metadata)) {
                joinNode.setProperty(joinNode.getFirstChild() == childNode ? NodeConstants.Info.IS_LEFT_DISTINCT : NodeConstants.Info.IS_RIGHT_DISTINCT, true);
            }
            if (attemptPush && RuleRaiseAccess.canRaiseOverSort(sourceNode, metadata, capFinder, sortNode, null, false, true)) {
                sourceNode.getFirstChild().addAsParent(sortNode);
                if (needsCorrection) {
                    RuleImplementJoinStrategy.correctOutputElements(joinNode, outputSymbols, sortNode);
                }
                return true;
            }
        } else if (sourceNode.getType() == 128 && !sourceNode.hasBooleanProperty(NodeConstants.Info.ROLLUP)) {
            sourceNode.addAsParent(sortNode);
            sort = false;
        }
        if (distinct) {
            joinNode.setProperty(joinNode.getFirstChild() == childNode ? NodeConstants.Info.IS_LEFT_DISTINCT : NodeConstants.Info.IS_RIGHT_DISTINCT, true);
        }
        if (sort) {
            joinNode.setProperty(joinNode.getFirstChild() == childNode ? NodeConstants.Info.SORT_LEFT : NodeConstants.Info.SORT_RIGHT, (Object)MergeJoinStrategy.SortOption.SORT);
        }
        if (needsCorrection) {
            PlanNode projectNode = NodeFactory.getNewNode(8);
            projectNode.setProperty(NodeConstants.Info.PROJECT_COLS, new ArrayList<Expression>(outputSymbols));
            childNode.addAsParent(projectNode);
            RuleImplementJoinStrategy.correctOutputElements(joinNode, outputSymbols, projectNode);
        }
        return false;
    }

    private static PlanNode createSortNode(List<Expression> orderSymbols, Collection<Expression> outputElements) {
        PlanNode sortNode = NodeFactory.getNewNode(32);
        OrderBy order = new OrderBy(orderSymbols);
        sortNode.setProperty(NodeConstants.Info.SORT_ORDER, order);
        sortNode.setProperty(NodeConstants.Info.OUTPUT_COLS, new ArrayList<Expression>(outputElements));
        return sortNode;
    }

    private static void correctOutputElements(PlanNode endNode, Collection<Expression> outputElements, PlanNode startNode) {
        while (startNode != endNode) {
            startNode.setProperty(NodeConstants.Info.OUTPUT_COLS, new ArrayList<Expression>(outputElements));
            startNode = startNode.getParent();
        }
    }

    public String toString() {
        return "ImplementJoinStrategy";
    }
}

