/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.query.processor.relational.FakeRelationalNode;
import org.teiid.query.processor.relational.LimitNode;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.Expression;

public class TestLimitNode {
    @Test
    public void testLimitInFirstBatch() throws Exception {
        LimitNode node = TestLimitNode.getLimitNode(40, new FakeRelationalNode(2, TestLimitNode.getRows(100), 50));
        TupleBatch batch = node.nextBatch();
        Assert.assertNotNull((Object)batch);
        Assert.assertEquals((long)40L, (long)batch.getRowCount());
        Assert.assertEquals((long)1L, (long)batch.getBeginRow());
        Assert.assertEquals((long)40L, (long)batch.getEndRow());
        Assert.assertTrue((boolean)batch.getTerminationFlag());
    }

    @Test
    public void testLimitAtBatchSize() throws Exception {
        LimitNode node = TestLimitNode.getLimitNode(50, new FakeRelationalNode(2, TestLimitNode.getRows(100), 50));
        TupleBatch batch = node.nextBatch();
        Assert.assertNotNull((Object)batch);
        Assert.assertEquals((long)50L, (long)batch.getRowCount());
        Assert.assertEquals((long)1L, (long)batch.getBeginRow());
        Assert.assertEquals((long)50L, (long)batch.getEndRow());
        Assert.assertTrue((boolean)batch.getTerminationFlag());
    }

    @Test
    public void testLimitInSecondBatch() throws Exception {
        LimitNode node = TestLimitNode.getLimitNode(55, new FakeRelationalNode(2, TestLimitNode.getRows(100), 50));
        TupleBatch batch = node.nextBatch();
        Assert.assertNotNull((Object)batch);
        Assert.assertEquals((long)50L, (long)batch.getRowCount());
        Assert.assertEquals((long)1L, (long)batch.getBeginRow());
        Assert.assertEquals((long)50L, (long)batch.getEndRow());
        Assert.assertFalse((boolean)batch.getTerminationFlag());
        batch = node.nextBatch();
        Assert.assertEquals((long)5L, (long)batch.getRowCount());
        Assert.assertEquals((long)51L, (long)batch.getBeginRow());
        Assert.assertEquals((long)55L, (long)batch.getEndRow());
        Assert.assertTrue((boolean)batch.getTerminationFlag());
    }

    @Test
    public void testLimitMultipleOfBatchSize() throws Exception {
        LimitNode node = TestLimitNode.getLimitNode(100, new FakeRelationalNode(2, TestLimitNode.getRows(150), 50));
        TupleBatch batch = node.nextBatch();
        Assert.assertNotNull((Object)batch);
        Assert.assertEquals((long)50L, (long)batch.getRowCount());
        Assert.assertEquals((long)1L, (long)batch.getBeginRow());
        Assert.assertEquals((long)50L, (long)batch.getEndRow());
        Assert.assertFalse((boolean)batch.getTerminationFlag());
        batch = node.nextBatch();
        Assert.assertEquals((long)50L, (long)batch.getRowCount());
        Assert.assertEquals((long)51L, (long)batch.getBeginRow());
        Assert.assertEquals((long)100L, (long)batch.getEndRow());
        Assert.assertTrue((boolean)batch.getTerminationFlag());
    }

    @Test
    public void testLimitProducesMultipleBatches() throws Exception {
        LimitNode node = TestLimitNode.getLimitNode(130, new FakeRelationalNode(2, TestLimitNode.getRows(300), 50));
        TupleBatch batch = node.nextBatch();
        Assert.assertNotNull((Object)batch);
        Assert.assertEquals((long)50L, (long)batch.getRowCount());
        Assert.assertEquals((long)1L, (long)batch.getBeginRow());
        Assert.assertEquals((long)50L, (long)batch.getEndRow());
        Assert.assertFalse((boolean)batch.getTerminationFlag());
        batch = node.nextBatch();
        Assert.assertNotNull((Object)batch);
        Assert.assertEquals((long)50L, (long)batch.getRowCount());
        Assert.assertEquals((long)51L, (long)batch.getBeginRow());
        Assert.assertEquals((long)100L, (long)batch.getEndRow());
        Assert.assertFalse((boolean)batch.getTerminationFlag());
        batch = node.nextBatch();
        Assert.assertNotNull((Object)batch);
        Assert.assertEquals((long)30L, (long)batch.getRowCount());
        Assert.assertEquals((long)101L, (long)batch.getBeginRow());
        Assert.assertEquals((long)130L, (long)batch.getEndRow());
        Assert.assertTrue((boolean)batch.getTerminationFlag());
    }

    @Test
    public void testLimitGetsNoRows() throws Exception {
        LimitNode node = TestLimitNode.getLimitNode(100, new FakeRelationalNode(2, TestLimitNode.getRows(0), 50));
        TupleBatch batch = node.nextBatch();
        Assert.assertNotNull((Object)batch);
        Assert.assertEquals((long)0L, (long)batch.getRowCount());
        Assert.assertTrue((boolean)batch.getTerminationFlag());
    }

    @Test
    public void testZeroLimit() throws Exception {
        LimitNode node = TestLimitNode.getLimitNode(0, new FakeRelationalNode(2, TestLimitNode.getRows(100), 50));
        TupleBatch batch = node.nextBatch();
        batch = node.nextBatch();
        Assert.assertNotNull((Object)batch);
        Assert.assertEquals((long)0L, (long)batch.getRowCount());
        Assert.assertEquals((long)1L, (long)batch.getBeginRow());
        Assert.assertEquals((long)0L, (long)batch.getEndRow());
        Assert.assertTrue((boolean)batch.getTerminationFlag());
    }

    @Test
    public void testOffsetInFirstBatch() throws Exception {
        LimitNode node = TestLimitNode.getOffsetNode(49, new FakeRelationalNode(2, TestLimitNode.getRows(100), 50));
        TupleBatch batch = node.nextBatch();
        Assert.assertNotNull((Object)batch);
        Assert.assertEquals((long)1L, (long)batch.getRowCount());
        Assert.assertEquals((long)1L, (long)batch.getBeginRow());
        Assert.assertEquals((long)1L, (long)batch.getEndRow());
        Assert.assertEquals(Arrays.asList(new Integer(50)), (Object)batch.getTuple(1));
        Assert.assertFalse((boolean)batch.getTerminationFlag());
        batch = node.nextBatch();
        Assert.assertNotNull((Object)batch);
        Assert.assertEquals((long)50L, (long)batch.getRowCount());
        Assert.assertEquals((long)2L, (long)batch.getBeginRow());
        Assert.assertEquals((long)51L, (long)batch.getEndRow());
        Assert.assertEquals(Arrays.asList(new Integer(51)), (Object)batch.getTuple(2));
        Assert.assertTrue((boolean)batch.getTerminationFlag());
    }

    @Test
    public void testOffsetAtBatchSize() throws Exception {
        LimitNode node = TestLimitNode.getOffsetNode(50, new FakeRelationalNode(2, TestLimitNode.getRows(100), 50));
        TupleBatch batch = node.nextBatch();
        Assert.assertNotNull((Object)batch);
        Assert.assertEquals((long)50L, (long)batch.getRowCount());
        Assert.assertEquals((long)1L, (long)batch.getBeginRow());
        Assert.assertEquals((long)50L, (long)batch.getEndRow());
        Assert.assertEquals(Arrays.asList(new Integer(51)), (Object)batch.getTuple(1));
        Assert.assertTrue((boolean)batch.getTerminationFlag());
    }

    @Test
    public void testOffsetInSecondBatch() throws Exception {
        LimitNode node = TestLimitNode.getOffsetNode(55, new FakeRelationalNode(2, TestLimitNode.getRows(100), 50));
        TupleBatch batch = node.nextBatch();
        Assert.assertNotNull((Object)batch);
        Assert.assertEquals((long)45L, (long)batch.getRowCount());
        Assert.assertEquals((long)1L, (long)batch.getBeginRow());
        Assert.assertEquals((long)45L, (long)batch.getEndRow());
        Assert.assertEquals(Arrays.asList(new Integer(56)), (Object)batch.getTuple(1));
        Assert.assertTrue((boolean)batch.getTerminationFlag());
    }

    @Test
    public void testOffsetMultipleOfBatchSize() throws Exception {
        LimitNode node = TestLimitNode.getOffsetNode(100, new FakeRelationalNode(2, TestLimitNode.getRows(300), 50));
        TupleBatch batch = node.nextBatch();
        Assert.assertNotNull((Object)batch);
        Assert.assertEquals((long)50L, (long)batch.getRowCount());
        Assert.assertEquals((long)1L, (long)batch.getBeginRow());
        Assert.assertEquals((long)50L, (long)batch.getEndRow());
        Assert.assertEquals(Arrays.asList(new Integer(101)), (Object)batch.getTuple(1));
        Assert.assertFalse((boolean)batch.getTerminationFlag());
    }

    @Test
    public void testOffsetGreaterThanRowCount() throws Exception {
        LimitNode node = TestLimitNode.getOffsetNode(100, new FakeRelationalNode(2, TestLimitNode.getRows(10), 50));
        TupleBatch batch = node.nextBatch();
        Assert.assertNotNull((Object)batch);
        Assert.assertEquals((long)0L, (long)batch.getRowCount());
        Assert.assertTrue((boolean)batch.getTerminationFlag());
    }

    @Test
    public void testOffsetNoRows() throws Exception {
        LimitNode node = TestLimitNode.getOffsetNode(100, new FakeRelationalNode(2, TestLimitNode.getRows(0), 50));
        TupleBatch batch = node.nextBatch();
        Assert.assertNotNull((Object)batch);
        Assert.assertEquals((long)0L, (long)batch.getRowCount());
        Assert.assertTrue((boolean)batch.getTerminationFlag());
    }

    @Test
    public void testZeroOffset() throws Exception {
        LimitNode node = TestLimitNode.getOffsetNode(0, new FakeRelationalNode(2, TestLimitNode.getRows(100), 50));
        TupleBatch batch = node.nextBatch();
        Assert.assertNotNull((Object)batch);
        Assert.assertEquals((long)50L, (long)batch.getRowCount());
        Assert.assertEquals((long)1L, (long)batch.getBeginRow());
        Assert.assertEquals((long)50L, (long)batch.getEndRow());
        Assert.assertFalse((boolean)batch.getTerminationFlag());
        batch = node.nextBatch();
        Assert.assertNotNull((Object)batch);
        Assert.assertEquals((long)50L, (long)batch.getRowCount());
        Assert.assertEquals((long)51L, (long)batch.getBeginRow());
        Assert.assertEquals((long)100L, (long)batch.getEndRow());
        Assert.assertTrue((boolean)batch.getTerminationFlag());
    }

    @Test
    public void testOffsetWithoutLimit() throws Exception {
        LimitNode node = new LimitNode(1, null, (Expression)new Constant((Object)new Integer(10)));
        node.addChild((RelationalNode)new FakeRelationalNode(2, TestLimitNode.getRows(10), 50));
        node.open();
        TupleBatch batch = node.nextBatch();
        Assert.assertNotNull((Object)batch);
        Assert.assertEquals((long)0L, (long)batch.getRowCount());
        Assert.assertTrue((boolean)batch.getTerminationFlag());
    }

    static List<?>[] getRows(int rows) {
        List[] data = new List[rows];
        for (int i = 0; i < rows; ++i) {
            data[i] = Arrays.asList(new Integer(i + 1));
        }
        return data;
    }

    private static LimitNode getOffsetNode(int offset, RelationalNode child) throws Exception {
        LimitNode node = new LimitNode(1, null, (Expression)new Constant((Object)new Integer(offset)));
        node.addChild(child);
        node.open();
        return node;
    }

    private static LimitNode getLimitNode(int limit, RelationalNode child) throws Exception {
        LimitNode node = new LimitNode(1, (Expression)new Constant((Object)new Integer(limit)), (Expression)new Constant((Object)new Integer(0)));
        node.addChild(child);
        node.open();
        return node;
    }

    @Test
    public void testClone() {
        LimitNode node = new LimitNode(1, (Expression)new Constant((Object)new Integer(-1)), null);
        LimitNode clone = (LimitNode)node.clone();
        Assert.assertEquals((Object)node.getLimitExpr(), (Object)clone.getLimitExpr());
        Assert.assertNull((Object)clone.getOffsetExpr());
        node = new LimitNode(1, null, (Expression)new Constant((Object)new Integer(-1)));
        clone = (LimitNode)node.clone();
        Assert.assertNull((Object)clone.getLimitExpr());
    }
}

