/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.xml;

import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.TimeZone;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.TimestampWithTimezone;
import org.teiid.query.processor.xml.XMLValueTranslator;
import org.teiid.query.unittest.TimestampUtil;
import org.teiid.query.util.CommandContext;

public class TestXMLValueTranslator {
    @BeforeClass
    public static void setUp() {
        TimestampWithTimezone.resetCalendar((TimeZone)TimeZone.getTimeZone("GMT-06:00"));
    }

    @AfterClass
    public static void tearDown() {
        TimestampWithTimezone.resetCalendar(null);
    }

    @Test
    public void test24HourDateTimeTranslation() throws Exception {
        Timestamp ts = TimestampUtil.createTimestamp((int)100, (int)0, (int)2, (int)14, (int)14, (int)5, (int)6000);
        String value = XMLValueTranslator.translateToXMLValue((Object)ts, (Class)DataTypeManager.DefaultDataClasses.TIMESTAMP, (String)"dateTime", (CommandContext)new CommandContext());
        Assert.assertEquals((Object)"2000-01-02T20:14:05.000006Z", (Object)value);
    }

    @Test
    public void testDateTimeTranslation() throws Exception {
        Timestamp ts = TimestampUtil.createTimestamp((int)100, (int)0, (int)2, (int)3, (int)4, (int)5, (int)6);
        String value = XMLValueTranslator.translateToXMLValue((Object)ts, (Class)DataTypeManager.DefaultDataClasses.TIMESTAMP, (String)"dateTime", (CommandContext)new CommandContext());
        Assert.assertEquals((Object)"2000-01-02T09:04:05Z", (Object)value);
        ts.setNanos(6000);
        value = XMLValueTranslator.translateToXMLValue((Object)ts, (Class)DataTypeManager.DefaultDataClasses.TIMESTAMP, (String)"dateTime", (CommandContext)new CommandContext());
        Assert.assertEquals((Object)"2000-01-02T09:04:05.000006Z", (Object)value);
        ts.setNanos(0);
        value = XMLValueTranslator.translateToXMLValue((Object)ts, (Class)DataTypeManager.DefaultDataClasses.TIMESTAMP, (String)"dateTime", (CommandContext)new CommandContext());
        Assert.assertEquals((Object)"2000-01-02T09:04:05Z", (Object)value);
        ts = TimestampUtil.createTimestamp((int)-2000, (int)0, (int)2, (int)3, (int)4, (int)5, (int)6);
        value = XMLValueTranslator.translateToXMLValue((Object)ts, (Class)DataTypeManager.DefaultDataClasses.TIMESTAMP, (String)"dateTime", (CommandContext)new CommandContext());
        Assert.assertEquals((Object)"-0102-12-30T09:04:05Z", (Object)value);
    }

    @Test
    public void testgYearTranslation() throws Exception {
        String value = XMLValueTranslator.translateToXMLValue((Object)new BigInteger("5"), (Class)DataTypeManager.DefaultDataClasses.BIG_INTEGER, (String)"gYear", (CommandContext)new CommandContext());
        Assert.assertEquals((Object)"0005", (Object)value);
        value = XMLValueTranslator.translateToXMLValue((Object)new BigInteger("-10000"), (Class)DataTypeManager.DefaultDataClasses.BIG_INTEGER, (String)"gYear", (CommandContext)new CommandContext());
        Assert.assertEquals((Object)"-10000", (Object)value);
    }

    @Test
    public void testgYearMonthTranslation() throws Exception {
        Timestamp ts = TimestampUtil.createTimestamp((int)100, (int)0, (int)4, (int)6, (int)8, (int)10, (int)12);
        String value = XMLValueTranslator.translateToXMLValue((Object)ts, (Class)DataTypeManager.DefaultDataClasses.TIMESTAMP, (String)"gYearMonth", (CommandContext)new CommandContext());
        Assert.assertEquals((Object)"2000-01Z", (Object)value);
        ts = TimestampUtil.createTimestamp((int)-30000, (int)0, (int)4, (int)6, (int)8, (int)10, (int)12);
        value = XMLValueTranslator.translateToXMLValue((Object)ts, (Class)DataTypeManager.DefaultDataClasses.TIMESTAMP, (String)"gYearMonth", (CommandContext)new CommandContext());
        Assert.assertEquals((Object)"-28102-06Z", (Object)value);
    }

    @Test
    public void testDefaultTranslation() throws Exception {
        String value = XMLValueTranslator.translateToXMLValue((Object)"", (Class)DataTypeManager.DefaultDataClasses.STRING, (String)"string", (CommandContext)new CommandContext());
        Assert.assertNull((Object)value);
    }
}

