/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr;

import java.io.InputStream;
import java.io.StringReader;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.transaction.xa.Xid;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.client.RequestMessage;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.XMLType;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorWork;
import org.teiid.dqp.internal.datamgr.ConnectorWorkItem;
import org.teiid.dqp.internal.datamgr.FakeConnector;
import org.teiid.dqp.internal.datamgr.FakeProcedureExecution;
import org.teiid.dqp.internal.datamgr.LanguageBridgeFactory;
import org.teiid.dqp.internal.datamgr.ProcedureBatchHandler;
import org.teiid.dqp.internal.datamgr.TestConnectorManager;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.message.AtomicRequestMessage;
import org.teiid.dqp.message.AtomicResultsMessage;
import org.teiid.dqp.message.RequestID;
import org.teiid.dqp.service.AutoGenDataService;
import org.teiid.dqp.service.TransactionContext;
import org.teiid.language.Call;
import org.teiid.language.QueryExpression;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.sql.lang.BatchedUpdateCommand;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.SourceHint;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.util.CommandContext;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;

public class TestConnectorWorkItem {
    private static final QueryMetadataInterface EXAMPLE_BQT = RealMetadataFactory.exampleBQTCached();

    private static Command helpGetCommand(String sql, QueryMetadataInterface metadata) throws Exception {
        Command command = QueryParser.getQueryParser().parseCommand(sql);
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        return command;
    }

    static AtomicRequestMessage createNewAtomicRequestMessage(int requestid, int nodeid) throws Exception {
        RequestMessage rm = new RequestMessage();
        DQPWorkContext workContext = RealMetadataFactory.buildWorkContext(EXAMPLE_BQT, RealMetadataFactory.exampleBQTVDB());
        workContext.getSession().setSessionId(String.valueOf(1));
        workContext.getSession().setUserName("foo");
        AtomicRequestMessage request = new AtomicRequestMessage(rm, workContext, nodeid);
        request.setCommand(TestConnectorWorkItem.helpGetCommand("SELECT BQT1.SmallA.INTKEY FROM BQT1.SmallA", EXAMPLE_BQT));
        request.setRequestID(new RequestID((long)requestid));
        request.setConnectorName("testing");
        request.setFetchSize(5);
        request.setCommandContext(new CommandContext());
        return request;
    }

    @Test
    public void testProcedureBatching() throws Exception {
        FakeProcedureExecution exec = new FakeProcedureExecution(2, 1);
        int total_columns = 3;
        StoredProcedure command = (StoredProcedure)TestConnectorWorkItem.helpGetCommand("{call pm2.spTest8(?)}", EXAMPLE_BQT);
        ((SPParameter)command.getInputParameters().get(0)).setExpression((Expression)new Constant((Object)1));
        Call proc = new LanguageBridgeFactory(EXAMPLE_BQT).translate(command);
        ProcedureBatchHandler pbh = new ProcedureBatchHandler(proc, (ProcedureExecution)exec);
        Assert.assertEquals((long)total_columns, (long)pbh.padRow(Arrays.asList(null, null)).size());
        List params = pbh.getParameterRow();
        Assert.assertEquals((long)total_columns, (long)params.size());
        Assert.assertEquals((Object)0, params.get(2));
        try {
            pbh.padRow(Arrays.asList(1));
            Assert.fail((String)"Expected exception from resultset mismatch");
        }
        catch (TranslatorException err) {
            Assert.assertEquals((Object)"TEIID30479 Could not process stored procedure results for EXEC spTest8(1).  Expected 2 result set columns, but was 1.  Please update your models to allow for stored procedure results batching.", (Object)err.getMessage());
        }
    }

    @Test
    public void testUpdateExecution() throws Throwable {
        AtomicResultsMessage results = this.helpExecuteUpdate(false, true);
        Assert.assertEquals((Object)1, results.getResults()[0].get(0));
    }

    private AtomicResultsMessage helpExecuteUpdate(boolean batch, boolean single) throws Exception, Throwable {
        Command command = TestConnectorWorkItem.helpGetCommand("update bqt1.smalla set stringkey = 1 where stringkey = 2", EXAMPLE_BQT);
        if (batch) {
            command = new BatchedUpdateCommand(Arrays.asList(command, command));
        }
        AtomicRequestMessage arm = TestConnectorWorkItem.createNewAtomicRequestMessage(1, 1);
        arm.setCommand(command);
        ConnectorManager connectorManager = TestConnectorManager.getConnectorManager();
        ((FakeConnector)connectorManager.getExecutionFactory()).setReturnSingleUpdate(single);
        ConnectorWorkItem synchConnectorWorkItem = new ConnectorWorkItem(arm, connectorManager);
        synchConnectorWorkItem.execute();
        return synchConnectorWorkItem.more();
    }

    @Test
    public void testBatchUpdateExecution() throws Throwable {
        AtomicResultsMessage results = this.helpExecuteUpdate(true, false);
        Assert.assertEquals((long)2L, (long)results.getResults().length);
        Assert.assertEquals((Object)1, results.getResults()[0].get(0));
        Assert.assertEquals((Object)1, results.getResults()[1].get(0));
    }

    @Test
    public void testBatchUpdateExecutionSingleResult() throws Throwable {
        AtomicResultsMessage results = this.helpExecuteUpdate(true, true);
        Assert.assertEquals((long)2L, (long)results.getResults().length);
        Assert.assertEquals((Object)1, results.getResults()[0].get(0));
        Assert.assertEquals((Object)1, results.getResults()[1].get(0));
    }

    @Test
    public void testExecutionWarning() throws Throwable {
        AtomicResultsMessage results = this.helpExecuteUpdate(false, false);
        Assert.assertEquals((long)1L, (long)results.getWarnings().size());
    }

    @Test
    public void testSourceNotRequired() throws Exception {
        Command command = TestConnectorWorkItem.helpGetCommand("update bqt1.smalla set stringkey = 1 where stringkey = 2", EXAMPLE_BQT);
        AtomicRequestMessage arm = TestConnectorWorkItem.createNewAtomicRequestMessage(1, 1);
        arm.setCommand(command);
        ConnectorManager cm = TestConnectorManager.getConnectorManager();
        cm.getExecutionFactory().setSourceRequired(false);
        ConnectorWork synchConnectorWorkItem = cm.registerRequest(arm);
        synchConnectorWorkItem.execute();
        synchConnectorWorkItem.close();
        FakeConnector fc = (FakeConnector)cm.getExecutionFactory();
        Assert.assertEquals((long)1L, (long)fc.getConnectionCount());
        Assert.assertEquals((long)1L, (long)fc.getCloseCount());
    }

    @Ignore
    @Test
    public void testIsImmutablePropertySucceeds() throws Exception {
        ConnectorManager cm = TestConnectorManager.getConnectorManager();
        ((FakeConnector)cm.getExecutionFactory()).setImmutable(true);
        Command command = TestConnectorWorkItem.helpGetCommand("update bqt1.smalla set stringkey = 1 where stringkey = 2", EXAMPLE_BQT);
        AtomicRequestMessage requestMsg = TestConnectorWorkItem.createNewAtomicRequestMessage(1, 1);
        requestMsg.setCommand(command);
        requestMsg.setTransactionContext(new TransactionContext(){

            public Xid getXid() {
                return (Xid)Mockito.mock(Xid.class);
            }
        });
        new ConnectorWorkItem(requestMsg, cm);
    }

    @Ignore
    @Test(expected=TranslatorException.class)
    public void testIsImmutablePropertyFails() throws Exception {
        ConnectorManager cm = TestConnectorManager.getConnectorManager();
        ((FakeConnector)cm.getExecutionFactory()).setImmutable(false);
        Command command = TestConnectorWorkItem.helpGetCommand("update bqt1.smalla set stringkey = 1 where stringkey = 2", EXAMPLE_BQT);
        AtomicRequestMessage requestMsg = TestConnectorWorkItem.createNewAtomicRequestMessage(1, 1);
        requestMsg.setCommand(command);
        requestMsg.setTransactionContext(new TransactionContext(){

            public Xid getXid() {
                return (Xid)Mockito.mock(Xid.class);
            }
        });
        new ConnectorWorkItem(requestMsg, cm);
    }

    @Test
    public void testTypeConversion() throws Exception {
        BufferManager bm = BufferManagerFactory.getStandaloneBufferManager();
        String str = "hello world";
        Source source = new StreamSource(new StringReader(str));
        XMLType xml = (XMLType)ConnectorWorkItem.convertToRuntimeType((BufferManager)bm, (Object)source, (Class)DataTypeManager.DefaultDataClasses.XML, null);
        Assert.assertEquals((Object)str, (Object)xml.getString());
        source = new StAXSource(XMLType.getXmlInputFactory().createXMLEventReader(new StringReader("<a/>")));
        xml = (XMLType)ConnectorWorkItem.convertToRuntimeType((BufferManager)bm, (Object)source, (Class)DataTypeManager.DefaultDataClasses.XML, null);
        XMLInputFactory in = XMLType.getXmlInputFactory();
        XMLStreamReader reader = in.createXMLStreamReader(new StringReader(xml.getString()));
        Assert.assertEquals((long)7L, (long)reader.getEventType());
        Assert.assertEquals((long)1L, (long)reader.next());
        Assert.assertEquals((Object)"a", (Object)reader.getLocalName());
        Assert.assertEquals((long)2L, (long)reader.next());
        byte[] bytes = str.getBytes("UTF-8");
        source = new InputStreamFactory.BlobInputStreamFactory((Blob)BlobType.createBlob((byte[])bytes));
        BlobType blob = (BlobType)ConnectorWorkItem.convertToRuntimeType((BufferManager)bm, (Object)source, (Class)DataTypeManager.DefaultDataClasses.BLOB, null);
        Assert.assertArrayEquals((byte[])bytes, (byte[])ObjectConverterUtil.convertToByteArray((InputStream)blob.getBinaryStream()));
    }

    @Test
    public void testLobs() throws Exception {
        BufferManager bm = BufferManagerFactory.getStandaloneBufferManager();
        ExecutionFactory<Object, Object> ef = new ExecutionFactory<Object, Object>(){

            public boolean isSourceRequired() {
                return false;
            }

            public ResultSetExecution createResultSetExecution(QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, Object connection) throws TranslatorException {
                return new ResultSetExecution(){
                    private boolean returned;

                    public void execute() throws TranslatorException {
                    }

                    public void close() {
                    }

                    public void cancel() throws TranslatorException {
                    }

                    public List<?> next() throws TranslatorException, DataNotAvailableException {
                        if (this.returned) {
                            return null;
                        }
                        this.returned = true;
                        return Arrays.asList(AutoGenDataService.CLOB_VAL);
                    }
                };
            }
        };
        ConnectorManager cm = new ConnectorManager("FakeConnector", "FakeConnector", (ExecutionFactory)ef){
            final /* synthetic */ ExecutionFactory val$ef;
            {
                this.val$ef = executionFactory;
                super(x0, x1);
            }

            public ExecutionFactory getExecutionFactory() {
                return this.val$ef;
            }

            public Object getConnectionFactory() {
                return null;
            }
        };
        cm.start();
        ef.setCopyLobs(true);
        AtomicRequestMessage requestMsg = TestConnectorWorkItem.createNewAtomicRequestMessage(1, 1);
        requestMsg.setCommand(TestConnectorWorkItem.helpGetCommand("SELECT CLOB_COLUMN FROM LOB_TESTING_ONE", EXAMPLE_BQT));
        requestMsg.setBufferManager(bm);
        ConnectorWorkItem cwi = new ConnectorWorkItem(requestMsg, cm);
        cwi.execute();
        AtomicResultsMessage message = cwi.more();
        List[] resutls = message.getResults();
        List tuple = resutls[0];
        ClobType clob = (ClobType)tuple.get(0);
        Assert.assertEquals((Object)InputStreamFactory.StorageMode.MEMORY, (Object)InputStreamFactory.getStorageMode((Object)clob));
        Assert.assertTrue((boolean)message.supportsImplicitClose());
        ef.setCopyLobs(false);
        cwi = new ConnectorWorkItem(requestMsg, cm);
        cwi.execute();
        message = cwi.more();
        resutls = message.getResults();
        tuple = resutls[0];
        clob = (ClobType)tuple.get(0);
        Assert.assertEquals((Object)InputStreamFactory.StorageMode.OTHER, (Object)InputStreamFactory.getStorageMode((Object)clob));
        Assert.assertFalse((boolean)message.supportsImplicitClose());
    }

    @Test
    public void testConversionError() throws Exception {
        BufferManager bm = BufferManagerFactory.getStandaloneBufferManager();
        ExecutionFactory<Object, Object> ef = new ExecutionFactory<Object, Object>(){

            public boolean isSourceRequired() {
                return false;
            }

            public ResultSetExecution createResultSetExecution(QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, Object connection) throws TranslatorException {
                ArrayList<String> list1 = new ArrayList<String>();
                list1.add("1");
                ArrayList<String> list2 = new ArrayList<String>();
                list2.add("a");
                final Iterator<List> iter = Arrays.asList(list1, list2).iterator();
                return new ResultSetExecution(){

                    public void execute() throws TranslatorException {
                    }

                    public void close() {
                    }

                    public void cancel() throws TranslatorException {
                    }

                    public List<?> next() throws TranslatorException, DataNotAvailableException {
                        if (iter.hasNext()) {
                            return (List)iter.next();
                        }
                        return null;
                    }
                };
            }
        };
        ConnectorManager cm = new ConnectorManager("FakeConnector", "FakeConnector", (ExecutionFactory)ef){
            final /* synthetic */ ExecutionFactory val$ef;
            {
                this.val$ef = executionFactory;
                super(x0, x1);
            }

            public ExecutionFactory getExecutionFactory() {
                return this.val$ef;
            }

            public Object getConnectionFactory() {
                return null;
            }
        };
        cm.start();
        ef.setCopyLobs(true);
        AtomicRequestMessage requestMsg = TestConnectorWorkItem.createNewAtomicRequestMessage(1, 1);
        requestMsg.setCommand(TestConnectorWorkItem.helpGetCommand("SELECT intkey FROM bqt1.smalla", EXAMPLE_BQT));
        requestMsg.setBufferManager(bm);
        ConnectorWorkItem cwi = new ConnectorWorkItem(requestMsg, cm);
        cwi.execute();
        AtomicResultsMessage message = cwi.more();
        List[] results = message.getResults();
        Assert.assertEquals((long)1L, (long)results.length);
        List tuple = results[0];
        Assert.assertEquals((Object)1, tuple.get(0));
        Assert.assertEquals((long)-1L, (long)message.getFinalRow());
        try {
            cwi.more();
            Assert.fail();
        }
        catch (TranslatorException e) {
            // empty catch block
        }
    }

    @Test
    public void testUnmodifibleList() throws Exception {
        BufferManager bm = BufferManagerFactory.getStandaloneBufferManager();
        ExecutionFactory<Object, Object> ef = new ExecutionFactory<Object, Object>(){

            public boolean isSourceRequired() {
                return false;
            }

            public ResultSetExecution createResultSetExecution(QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, Object connection) throws TranslatorException {
                List<String> list1 = Collections.singletonList("1");
                final Iterator<List> iter = Arrays.asList(list1).iterator();
                return new ResultSetExecution(){

                    public void execute() throws TranslatorException {
                    }

                    public void close() {
                    }

                    public void cancel() throws TranslatorException {
                    }

                    public List<?> next() throws TranslatorException, DataNotAvailableException {
                        if (iter.hasNext()) {
                            return (List)iter.next();
                        }
                        return null;
                    }
                };
            }
        };
        ConnectorManager cm = new ConnectorManager("FakeConnector", "FakeConnector", (ExecutionFactory)ef){
            final /* synthetic */ ExecutionFactory val$ef;
            {
                this.val$ef = executionFactory;
                super(x0, x1);
            }

            public ExecutionFactory getExecutionFactory() {
                return this.val$ef;
            }

            public Object getConnectionFactory() {
                return null;
            }
        };
        cm.start();
        AtomicRequestMessage requestMsg = TestConnectorWorkItem.createNewAtomicRequestMessage(1, 1);
        requestMsg.setCommand(TestConnectorWorkItem.helpGetCommand("SELECT intkey FROM bqt1.smalla", EXAMPLE_BQT));
        requestMsg.setBufferManager(bm);
        ConnectorWorkItem cwi = new ConnectorWorkItem(requestMsg, cm);
        cwi.execute();
        AtomicResultsMessage message = cwi.more();
        List[] results = message.getResults();
        Assert.assertEquals((long)1L, (long)results.length);
        List tuple = results[0];
        Assert.assertEquals((Object)1, tuple.get(0));
        Assert.assertEquals((long)1L, (long)message.getFinalRow());
    }

    @Test
    public void testSourcHints() throws Exception {
        Command command = TestConnectorWorkItem.helpGetCommand("update bqt1.smalla set stringkey = 1 where stringkey = 2", EXAMPLE_BQT);
        command.setSourceHint(new SourceHint());
        AtomicRequestMessage arm = TestConnectorWorkItem.createNewAtomicRequestMessage(1, 1);
        arm.setCommand(command);
        ConnectorManager cm = TestConnectorManager.getConnectorManager();
        cm.registerRequest(arm);
    }
}

