/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.net;

import java.net.MalformedURLException;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.net.HostInfo;
import org.teiid.net.TeiidURL;

public class TestTeiidURL {
    @Test
    public final void testTeiidURL() throws Exception {
        String SERVER_URL = "mm://localhost:31000";
        Assert.assertTrue((boolean)TeiidURL.isValidServerURL((String)SERVER_URL));
        TeiidURL url = new TeiidURL(SERVER_URL);
        List hosts = url.getHostInfo();
        Assert.assertNotNull((String)"MMURL should have 1 Host", (Object)hosts);
        Assert.assertEquals((long)1L, (long)hosts.size());
    }

    @Test
    public final void testTeiidURLIPv6() throws Exception {
        String SERVER_URL = "mm://[3ffe:ffff:0100:f101::1]:31000";
        Assert.assertTrue((boolean)TeiidURL.isValidServerURL((String)SERVER_URL));
        TeiidURL url = new TeiidURL(SERVER_URL);
        List hosts = url.getHostInfo();
        Assert.assertNotNull((String)"TeiidURL should have 1 Host", (Object)hosts);
        Assert.assertEquals((long)1L, (long)hosts.size());
        Assert.assertEquals((Object)"3ffe:ffff:0100:f101::1", (Object)((HostInfo)hosts.get(0)).getHostName());
        Assert.assertEquals((long)31000L, (long)((HostInfo)hosts.get(0)).getPortNumber());
    }

    @Test
    public final void testBogusProtocol() throws Exception {
        String SERVER_URL = "foo://localhost:31000";
        Assert.assertFalse((boolean)TeiidURL.isValidServerURL((String)SERVER_URL));
    }

    @Test
    public final void testBogusProtocol1() {
        String SERVER_URL = "foo://localhost:31000";
        Assert.assertFalse((boolean)TeiidURL.isValidServerURL((String)SERVER_URL));
    }

    @Test
    public final void testTeiidURLSecure() throws Exception {
        String SERVER_URL = "mms://localhost:31000";
        Assert.assertTrue((boolean)TeiidURL.isValidServerURL((String)SERVER_URL));
        TeiidURL url = new TeiidURL(SERVER_URL);
        List hosts = url.getHostInfo();
        Assert.assertNotNull((String)"MMURL should have 1 Host", (Object)hosts);
        Assert.assertEquals((long)1L, (long)hosts.size());
    }

    @Test
    public final void testTeiidURLBadProtocolMM() {
        String SERVER_URL = "mmm://localhost:31000";
        Assert.assertFalse((boolean)TeiidURL.isValidServerURL((String)SERVER_URL));
    }

    @Test
    public final void testTeiidURLWrongSlash() {
        String SERVER_URL = "mm:\\\\localhost:31000";
        Assert.assertFalse((boolean)TeiidURL.isValidServerURL((String)SERVER_URL));
    }

    @Test
    public final void testTeiidURLOneSlash() {
        String SERVER_URL = "mm:/localhost:31000";
        Assert.assertFalse((boolean)TeiidURL.isValidServerURL((String)SERVER_URL));
    }

    @Test(expected=MalformedURLException.class)
    public final void testTeiidURLNoHost() throws Exception {
        String SERVER_URL = "mm://:31000";
        Assert.assertFalse((boolean)TeiidURL.isValidServerURL((String)SERVER_URL));
        new TeiidURL(SERVER_URL);
    }

    @Test(expected=MalformedURLException.class)
    public final void testTeiidURLNoHostAndPort() throws Exception {
        String SERVER_URL = "mm://:";
        Assert.assertFalse((boolean)TeiidURL.isValidServerURL((String)SERVER_URL));
        new TeiidURL(SERVER_URL);
    }

    @Test
    public final void testTeiidURLNoHostAndPort2() {
        String SERVER_URL = "mm://";
        Assert.assertFalse((boolean)TeiidURL.isValidServerURL((String)SERVER_URL));
    }

    @Test
    public final void testTeiidURLBadPort() {
        String SERVER_URL = "mm://localhost:port";
        Assert.assertFalse((boolean)TeiidURL.isValidServerURL((String)SERVER_URL));
    }

    @Test
    public final void testTeiidURL2Hosts() throws Exception {
        String SERVER_URL = "mm://localhost:31000,localhost:31001";
        Assert.assertTrue((boolean)TeiidURL.isValidServerURL((String)SERVER_URL));
        TeiidURL url = new TeiidURL(SERVER_URL);
        List hosts = url.getHostInfo();
        Assert.assertNotNull((String)"MMURL should have 2 Host", (Object)hosts);
        Assert.assertEquals((long)2L, (long)hosts.size());
    }

    @Test
    public final void testTeiidIPv6URL2Hosts() throws Exception {
        String SERVER_URL = "mm://[3ffe:ffff:0100:f101::1]:31000,[::1]:31001, 127.0.0.1:31003";
        Assert.assertTrue((boolean)TeiidURL.isValidServerURL((String)SERVER_URL));
        TeiidURL url = new TeiidURL(SERVER_URL);
        List hosts = url.getHostInfo();
        Assert.assertNotNull((String)"TeiidURL should have 3 Host", (Object)hosts);
        Assert.assertEquals((long)3L, (long)hosts.size());
        Assert.assertEquals((Object)"3ffe:ffff:0100:f101::1", (Object)((HostInfo)hosts.get(0)).getHostName());
        Assert.assertEquals((long)31001L, (long)((HostInfo)hosts.get(1)).getPortNumber());
        Assert.assertEquals((Object)"127.0.0.1", (Object)((HostInfo)hosts.get(2)).getHostName());
    }

    @Test
    public final void testTeiidURL3Hosts() throws Exception {
        String SERVER_URL = "mm://localhost:31000,localhost:31001,localhost:31002";
        Assert.assertTrue((boolean)TeiidURL.isValidServerURL((String)SERVER_URL));
        TeiidURL url = new TeiidURL(SERVER_URL);
        List hosts = url.getHostInfo();
        Assert.assertNotNull((String)"MMURL should have 3 Host", (Object)hosts);
        Assert.assertEquals((long)3L, (long)hosts.size());
    }

    @Test
    public final void testGetHostInfo() throws Exception {
        String SERVER_URL = "mm://localhost:31000";
        Assert.assertTrue((boolean)TeiidURL.isValidServerURL((String)SERVER_URL));
        TeiidURL url = new TeiidURL(SERVER_URL);
        Assert.assertNotNull((Object)url.getHostInfo());
    }

    @Test
    public final void testGetProtocolStandalone() throws Exception {
        TeiidURL url = new TeiidURL("mm://localhost:31000");
        Assert.assertNotNull((Object)url);
        Assert.assertEquals((Object)"mm://localhost:31000", (Object)url.getAppServerURL());
    }

    @Test
    public final void testHasMoreElements() throws Exception {
        TeiidURL url = new TeiidURL("mm://localhost:31000,localhost:31001");
        Assert.assertNotNull((Object)url);
        Assert.assertFalse((boolean)url.getHostInfo().isEmpty());
    }

    @Test
    public final void testNextElement() throws Exception {
        TeiidURL url = new TeiidURL("mm://localhost:31000,localhost:31001");
        Assert.assertEquals((long)2L, (long)url.getHostInfo().size());
    }

    @Test
    public final void testHostInfoEquals() throws Exception {
        HostInfo expectedResults = new HostInfo("localhost", 31000);
        TeiidURL url = new TeiidURL("mm://localhost:31000");
        HostInfo actualResults = (HostInfo)url.getHostInfo().get(0);
        Assert.assertEquals((Object)expectedResults, (Object)actualResults);
    }

    @Test
    public final void testWithEmbeddedSpaces() throws Exception {
        HostInfo expectedResults = new HostInfo("localhost", 12345);
        TeiidURL url = new TeiidURL("mm://localhost : 12345");
        List hosts = url.getHostInfo();
        Assert.assertNotNull((String)"MMURL should have 1 Host", (Object)hosts);
        Assert.assertEquals((long)1L, (long)hosts.size());
        HostInfo actualResults = (HostInfo)url.getHostInfo().get(0);
        Assert.assertEquals((Object)expectedResults, (Object)actualResults);
    }

    @Test
    public final void testHostPortConstructor() {
        HostInfo expectedResults = new HostInfo("myhost", 12345);
        TeiidURL url = new TeiidURL("myhost", 12345, false);
        List hosts = url.getHostInfo();
        Assert.assertNotNull((String)"MMURL should have 1 Host", (Object)hosts);
        Assert.assertEquals((long)1L, (long)hosts.size());
        HostInfo actualResults = (HostInfo)url.getHostInfo().get(0);
        Assert.assertEquals((Object)expectedResults, (Object)actualResults);
        Assert.assertEquals((Object)"mm://myhost:12345", (Object)url.getAppServerURL());
    }

    @Test
    public final void testHostPortConstructorSSL() {
        HostInfo expectedResults = new HostInfo("myhost", 12345);
        TeiidURL url = new TeiidURL("myhost", 12345, true);
        List hosts = url.getHostInfo();
        Assert.assertNotNull((String)"MMURL should have 1 Host", (Object)hosts);
        Assert.assertEquals((long)1L, (long)hosts.size());
        HostInfo actualResults = (HostInfo)url.getHostInfo().get(0);
        Assert.assertEquals((Object)expectedResults, (Object)actualResults);
        Assert.assertEquals((Object)"mms://myhost:12345", (Object)url.getAppServerURL());
    }
}

