/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.processor.relational.DependentValueSource;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.AbstractSetCriteria;
import org.teiid.query.sql.lang.Option;
import org.teiid.query.sql.symbol.Array;
import org.teiid.query.sql.symbol.ContextReference;
import org.teiid.query.sql.symbol.Expression;

public class DependentSetCriteria
extends AbstractSetCriteria
implements ContextReference {
    private Expression valueExpression;
    private String id;
    private float ndv = -1.0f;
    private float maxNdv = -1.0f;
    private float[] ndvs;
    private float[] maxNdvs;
    private DependentValueSource dependentValueSource;
    private Option.MakeDep makeDepOptions;

    public DependentSetCriteria(Expression expr, String id) {
        this.setExpression(expr);
        this.id = id;
    }

    public void setAttributes(List<AttributeComparison> attributes) {
        this.ndvs = new float[attributes.size()];
        this.maxNdvs = new float[attributes.size()];
        for (int i = 0; i < attributes.size(); ++i) {
            AttributeComparison comp = attributes.get(i);
            this.ndvs[i] = comp.ndv;
            this.maxNdvs[i] = comp.maxNdv;
        }
    }

    public List<AttributeComparison> getAttributes() {
        if (!this.hasMultipleAttributes()) {
            AttributeComparison comp = new AttributeComparison();
            comp.dep = this.getExpression();
            comp.ind = this.getValueExpression();
            comp.ndv = this.ndv;
            comp.maxNdv = this.maxNdv;
            return Arrays.asList(comp);
        }
        ArrayList<AttributeComparison> result = new ArrayList<AttributeComparison>();
        for (int i = 0; i < this.ndvs.length; ++i) {
            AttributeComparison comp = new AttributeComparison();
            comp.dep = ((Array)this.getExpression()).getExpressions().get(i);
            comp.ind = ((Array)this.getValueExpression()).getExpressions().get(i);
            comp.ndv = this.ndv;
            comp.maxNdv = this.maxNdv;
            result.add(comp);
        }
        return result;
    }

    public boolean hasMultipleAttributes() {
        return this.ndvs != null && this.ndvs.length > 1;
    }

    @Override
    public String getContextSymbol() {
        return this.id;
    }

    public float getMaxNdv() {
        return this.maxNdv;
    }

    public void setMaxNdv(float maxNdv) {
        this.maxNdv = maxNdv;
    }

    public float getNdv() {
        return this.ndv;
    }

    public void setNdv(float ndv) {
        this.ndv = ndv;
    }

    public Expression getValueExpression() {
        return this.valueExpression;
    }

    public void setValueExpression(Expression valueExpression) {
        this.valueExpression = valueExpression;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        int hc = 0;
        hc = HashCodeUtil.hashCode((int)hc, (Object[])new Object[]{this.getExpression()});
        return hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DependentSetCriteria)) {
            return false;
        }
        DependentSetCriteria sc = (DependentSetCriteria)obj;
        if (this.isNegated() != sc.isNegated()) {
            return false;
        }
        return EquivalenceUtil.areEqual((Object)this.getExpression(), (Object)sc.getExpression()) && EquivalenceUtil.areEqual((Object)this.getValueExpression(), (Object)sc.getValueExpression());
    }

    @Override
    public DependentSetCriteria clone() {
        Expression copy = null;
        if (this.getExpression() != null) {
            copy = (Expression)this.getExpression().clone();
        }
        DependentSetCriteria criteriaCopy = new DependentSetCriteria(copy, this.id);
        if (this.valueExpression != null) {
            criteriaCopy.setValueExpression((Expression)this.getValueExpression().clone());
        }
        criteriaCopy.id = this.id;
        criteriaCopy.ndv = this.ndv;
        criteriaCopy.maxNdv = this.maxNdv;
        criteriaCopy.maxNdvs = this.maxNdvs;
        criteriaCopy.ndvs = this.ndvs;
        criteriaCopy.makeDepOptions = this.makeDepOptions;
        return criteriaCopy;
    }

    @Override
    public void setNegated(boolean negationFlag) {
        if (!negationFlag) {
            throw new UnsupportedOperationException();
        }
    }

    public DependentValueSource getDependentValueSource() {
        return this.dependentValueSource;
    }

    public void setDependentValueSource(DependentValueSource dependentValueSource) {
        this.dependentValueSource = dependentValueSource;
    }

    public void setMakeDepOptions(Option.MakeDep makeDep) {
        this.makeDepOptions = makeDep;
        if (makeDep != null && makeDep.getMax() != null) {
            this.maxNdv = makeDep.getMax().intValue();
        }
    }

    public Option.MakeDep getMakeDepOptions() {
        return this.makeDepOptions;
    }

    public static class AttributeComparison {
        public Expression dep;
        public Expression ind;
        public float ndv;
        public float maxNdv = -1.0f;
    }
}

