/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.dqp.internal.datamgr.LanguageBridgeFactory;
import org.teiid.events.EventDistributor;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.processor.FakeTupleSource;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.RegisterRequestParameter;
import org.teiid.query.sql.lang.BatchedUpdateCommand;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.util.CommandContext;

public class HardcodedDataManager
implements ProcessorDataManager {
    private Map<String, List<?>[]> data = new HashMap<String, List<?>[]>();
    private Set<String> validModels;
    private boolean mustRegisterCommands = true;
    private boolean fullBatchedUpdate = false;
    private boolean blockOnce;
    protected List<Command> commandHistory = new ArrayList<Command>();
    private List<org.teiid.language.Command> pushdownCommands = new ArrayList<org.teiid.language.Command>();
    private LanguageBridgeFactory lbf;

    public HardcodedDataManager() {
        this(true);
    }

    public HardcodedDataManager(QueryMetadataInterface metadata) {
        this(true);
        this.lbf = new LanguageBridgeFactory(metadata);
    }

    public HardcodedDataManager(boolean mustRegisterCommands) {
        this.mustRegisterCommands = mustRegisterCommands;
    }

    public void addData(String sql, List<?> ... rows) {
        this.data.put(sql, rows);
    }

    public void clearData() {
        this.data.clear();
        this.commandHistory.clear();
    }

    public void setBlockOnce(boolean blockOnce) {
        this.blockOnce = blockOnce;
    }

    public void setValidModels(Set<String> models) {
        this.validModels = models;
    }

    public List<Command> getCommandHistory() {
        return this.commandHistory;
    }

    public List<org.teiid.language.Command> getPushdownCommands() {
        return this.pushdownCommands;
    }

    public Object lookupCodeValue(CommandContext context, String codeTableName, String returnElementName, String keyElementName, Object keyValue) throws BlockedException, TeiidComponentException {
        return null;
    }

    public TupleSource registerRequest(CommandContext context, Command command, String modelName, RegisterRequestParameter parameterObject) throws TeiidComponentException {
        if (modelName != null && this.validModels != null && !this.validModels.contains(modelName)) {
            throw new TeiidComponentException("Detected query against invalid model: " + modelName + ": " + command);
        }
        this.commandHistory.add(command);
        List projectedSymbols = command.getProjectedSymbols();
        String commandString = null;
        if (this.lbf == null) {
            commandString = command instanceof BatchedUpdateCommand && this.fullBatchedUpdate ? ((BatchedUpdateCommand)command).getStringForm(true) : command.toString();
        } else {
            org.teiid.language.Command cmd = this.lbf.translate(command);
            this.pushdownCommands.add(cmd);
            commandString = cmd.toString();
        }
        List[] rows = this.data.get(commandString);
        if (rows == null) {
            if (this.mustRegisterCommands) {
                throw new TeiidComponentException("Unknown command: " + commandString);
            }
            rows = new List[]{new ArrayList()};
            for (int i = 0; i < projectedSymbols.size(); ++i) {
                rows[0].add(null);
            }
        }
        FakeTupleSource source = new FakeTupleSource(projectedSymbols, rows);
        if (this.blockOnce) {
            source.setBlockOnce();
        }
        return source;
    }

    public void setMustRegisterCommands(boolean mustRegisterCommands) {
        this.mustRegisterCommands = mustRegisterCommands;
    }

    public void clearCodeTables() {
    }

    public EventDistributor getEventDistributor() {
        return null;
    }

    public void setFullBatchedUpdate(boolean fullBatchedUpdate) {
        this.fullBatchedUpdate = fullBatchedUpdate;
    }
}

