/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import org.junit.Assert;
import org.junit.Test;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;

public class TestElementSymbol {
    public static final GroupSymbol sampleGroup1() {
        return new GroupSymbol("m.g");
    }

    public static final GroupSymbol sampleGroup2() {
        return new GroupSymbol("gg", "m.g");
    }

    public static final ElementSymbol sampleElement1() {
        ElementSymbol element = new ElementSymbol("m.g.c", false);
        element.setGroupSymbol(TestElementSymbol.sampleGroup1());
        return element;
    }

    public static final ElementSymbol sampleElement2() {
        ElementSymbol element = new ElementSymbol("m.g.c");
        element.setGroupSymbol(TestElementSymbol.sampleGroup1());
        return element;
    }

    public static final ElementSymbol sampleElement3() {
        ElementSymbol element = new ElementSymbol("gg.c", false);
        element.setGroupSymbol(TestElementSymbol.sampleGroup2());
        return element;
    }

    public static final ElementSymbol sampleElement4() {
        ElementSymbol element = new ElementSymbol("gg.c");
        element.setGroupSymbol(TestElementSymbol.sampleGroup2());
        return element;
    }

    private void helpParser(ElementSymbol es, String expected) {
        String toString = es.toString();
        Assert.assertEquals((String)"Parser string does not match", (Object)expected, (Object)toString);
    }

    private void helpEquals(ElementSymbol es1, ElementSymbol es2, boolean equal) {
        if (equal) {
            Assert.assertTrue((String)("Element symbols should be equal: " + es1 + ", " + es2), (boolean)es1.equals((Object)es2));
            Assert.assertTrue((String)("Equal symbols should have same hash code: " + es1 + ", " + es2), (es1.hashCode() == es2.hashCode() ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((String)("Element symbols should not be equal: " + es1 + ", " + es2), (!es1.equals((Object)es2) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testParser1() {
        this.helpParser(TestElementSymbol.sampleElement1(), "c");
    }

    @Test
    public void testParser2() {
        this.helpParser(TestElementSymbol.sampleElement2(), "m.g.c");
    }

    @Test
    public void testParser3() {
        this.helpParser(TestElementSymbol.sampleElement3(), "c");
    }

    @Test
    public void testParser4() {
        this.helpParser(TestElementSymbol.sampleElement4(), "gg.c");
    }

    @Test
    public void testEquals1() {
        ElementSymbol es = TestElementSymbol.sampleElement1();
        this.helpEquals(es, es, true);
    }

    @Test
    public void testEquals2() {
        ElementSymbol es = TestElementSymbol.sampleElement2();
        this.helpEquals(es, es, true);
    }

    @Test
    public void testEquals3() {
        ElementSymbol es = TestElementSymbol.sampleElement3();
        this.helpEquals(es, es, true);
    }

    @Test
    public void testEquals4() {
        ElementSymbol es = TestElementSymbol.sampleElement4();
        this.helpEquals(es, es, true);
    }

    @Test
    public void testEquals5() {
        ElementSymbol es = TestElementSymbol.sampleElement1();
        this.helpEquals(es, es.clone(), true);
    }

    @Test
    public void testEquals6() {
        ElementSymbol es = TestElementSymbol.sampleElement2();
        this.helpEquals(es, es.clone(), true);
    }

    @Test
    public void testEquals7() {
        ElementSymbol es = TestElementSymbol.sampleElement3();
        this.helpEquals(es, es.clone(), true);
    }

    @Test
    public void testEquals8() {
        ElementSymbol es = TestElementSymbol.sampleElement4();
        this.helpEquals(es, es.clone(), true);
    }

    @Test
    public void testEquals9() {
        this.helpEquals(TestElementSymbol.sampleElement1(), TestElementSymbol.sampleElement2(), true);
    }

    @Test
    public void testEquals10() {
        this.helpEquals(TestElementSymbol.sampleElement3(), TestElementSymbol.sampleElement4(), true);
    }

    @Test
    public void testEquals11() {
        this.helpEquals(TestElementSymbol.sampleElement1(), TestElementSymbol.sampleElement3(), false);
    }

    @Test
    public void testEquals12() {
        this.helpEquals(TestElementSymbol.sampleElement2(), TestElementSymbol.sampleElement4(), false);
    }

    @Test
    public void testEquals13() {
        ElementSymbol es1 = new ElementSymbol("abcd");
        es1.setGroupSymbol(TestElementSymbol.sampleGroup1());
        ElementSymbol es2 = new ElementSymbol("AbCd");
        es2.setGroupSymbol(TestElementSymbol.sampleGroup1());
        this.helpEquals(es1, es2, false);
    }

    @Test
    public void testSelfEquivalence() {
        ElementSymbol s1 = TestElementSymbol.sampleElement1();
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s1);
    }

    @Test
    public void testEquivalence() {
        ElementSymbol s1 = TestElementSymbol.sampleElement1();
        ElementSymbol s1a = TestElementSymbol.sampleElement1();
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s1a);
    }

    @Test
    public void testCloneEquivalence() {
        ElementSymbol s1 = TestElementSymbol.sampleElement1();
        ElementSymbol s2 = s1.clone();
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s2);
    }

    @Test
    public void testNonEquivalence() {
        ElementSymbol s1 = TestElementSymbol.sampleElement1();
        ElementSymbol s3 = TestElementSymbol.sampleElement3();
        int equals = -1;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s3);
    }

    @Test
    public void testClone1() {
        ElementSymbol e1 = TestElementSymbol.sampleElement1();
        ElementSymbol copy = e1.clone();
        this.helpEquals(e1, copy, true);
    }

    @Test
    public void testClone2() {
        ElementSymbol e1 = TestElementSymbol.sampleElement2();
        ElementSymbol copy = e1.clone();
        this.helpEquals(e1, copy, true);
    }

    @Test
    public void testClone3() {
        ElementSymbol e1 = TestElementSymbol.sampleElement3();
        ElementSymbol copy = e1.clone();
        this.helpEquals(e1, copy, true);
    }

    @Test
    public void testClone4() {
        ElementSymbol e1 = TestElementSymbol.sampleElement4();
        ElementSymbol copy = e1.clone();
        this.helpEquals(e1, copy, true);
    }

    @Test
    public void testClone5() {
        ElementSymbol e1 = TestElementSymbol.sampleElement1();
        ElementSymbol copy = e1.clone();
        this.helpEquals(e1, copy, true);
        String originalName = e1.getName();
        Assert.assertTrue((String)"Cloned value changed but should not have: ", (boolean)copy.getName().equals(originalName));
        GroupSymbol originalGroup = e1.getGroupSymbol();
        e1.setGroupSymbol(new GroupSymbol("b"));
        Assert.assertTrue((String)"Cloned value changed but should not have: ", (boolean)copy.getGroupSymbol().equals((Object)originalGroup));
        boolean fullyQualified = e1.getDisplayFullyQualified();
        e1.setDisplayFullyQualified(!fullyQualified);
        Assert.assertTrue((String)"Cloned value changed but should not have: ", (copy.getDisplayFullyQualified() == fullyQualified ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsWithAndWithoutGroupSymbol() {
        ElementSymbol e1 = new ElementSymbol("x.y");
        ElementSymbol e2 = new ElementSymbol("y");
        e2.setGroupSymbol(new GroupSymbol("x"));
        this.helpEquals(e1, e2, true);
    }

    @Test
    public void testClone6() {
        ElementSymbol e1 = new ElementSymbol("x.y.z", new GroupSymbol("doc"));
        ElementSymbol copy = e1.clone();
        this.helpEquals(e1, copy, true);
    }
}

