/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.teiid.core.BundleUtil;
import org.teiid.core.CorePlugin;
import org.teiid.core.TeiidRuntimeException;

public final class StringUtil {
    public static final String SINGLE_QUOTE = "'";
    public static final String LINE_SEPARATOR_PROPERTY_NAME = "line.separator";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator", Constants.NEW_LINE);
    public static final Comparator<String> CASE_INSENSITIVE_ORDER = String.CASE_INSENSITIVE_ORDER;
    public static final Comparator<String> NULL_SAFE_CASE_INSENSITIVE_ORDER = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return String.CASE_INSENSITIVE_ORDER.compare(o1, o2);
        }
    };
    public static final Comparator<String> CASE_SENSITIVE_ORDER = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            if (o1 == o2) {
                return 0;
            }
            return o1.compareTo(o2);
        }
    };

    public static String getLineSeparator() {
        return LINE_SEPARATOR;
    }

    public static String join(Collection<String> strings, String delimiter) {
        if (strings == null || delimiter == null) {
            return null;
        }
        StringBuffer str = new StringBuffer();
        Iterator<String> iter = strings.iterator();
        while (iter.hasNext()) {
            str.append(iter.next());
            if (!iter.hasNext()) continue;
            str.append(delimiter);
        }
        return str.toString();
    }

    public static String toString(Object[] array, String delim) {
        return StringUtil.toString(array, delim, true);
    }

    public static String toString(Object[] array, String delim, boolean includeBrackets) {
        if (array == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (includeBrackets) {
            sb.append('[');
        }
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                sb.append(delim);
            }
            sb.append(array[i]);
        }
        if (includeBrackets) {
            sb.append(']');
        }
        return sb.toString();
    }

    public static String toString(Object[] array) {
        return StringUtil.toString(array, ",", true);
    }

    public static List<String> split(String str, String splitter) {
        StringTokenizer tokens = new StringTokenizer(str, splitter);
        ArrayList<String> l = new ArrayList<String>(tokens.countTokens());
        while (tokens.hasMoreTokens()) {
            l.add(tokens.nextToken());
        }
        return l;
    }

    public static String replace(String source, String search, String replace) {
        int start;
        if (source != null && search != null && search.length() > 0 && replace != null && (start = source.indexOf(search)) > -1) {
            return new StringBuffer(source).replace(start, start + search.length(), replace).toString();
        }
        return source;
    }

    public static String replaceAll(String source, String search, String replace) {
        if (source == null || search == null || search.length() == 0 || replace == null) {
            return source;
        }
        int start = source.indexOf(search);
        if (start > -1) {
            StringBuffer newString = new StringBuffer(source);
            while (start > -1) {
                int end = start + search.length();
                newString.replace(start, end, replace);
                start = newString.indexOf(search, start + replace.length());
            }
            return newString.toString();
        }
        return source;
    }

    public static String truncString(String in, int len) {
        String out = in;
        if (in != null && len > 0 && in.length() > len) {
            out = in.substring(0, len);
        }
        return out;
    }

    public static String wrap(String str, int maxCharPerLine) {
        int strLength = str.length();
        if (strLength > maxCharPerLine) {
            StringBuffer sb = new StringBuffer(str.length() + strLength / maxCharPerLine + 1);
            strLength = 0;
            List<String> tokens = StringUtil.split(str, Constants.SPACE);
            for (String token : tokens) {
                if (strLength + token.length() > maxCharPerLine) {
                    sb.append(Constants.NEW_LINE);
                    strLength = 0;
                }
                sb.append(token);
                sb.append(Constants.SPACE);
                strLength += token.length() + 1;
            }
            return sb.toString();
        }
        return str;
    }

    public static List<String> getTokens(String str, String delimiter) {
        ArrayList<String> l = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(str, delimiter);
        while (tokens.hasMoreTokens()) {
            l.add(tokens.nextToken());
        }
        return l;
    }

    public static String getLastToken(String str, String delimiter) {
        if (str == null) {
            return "";
        }
        int beginIndex = 0;
        if (str.lastIndexOf(delimiter) > 0) {
            beginIndex = str.lastIndexOf(delimiter) + 1;
        }
        return str.substring(beginIndex, str.length());
    }

    public static String getFirstToken(String str, String delimiter) {
        if (str == null) {
            return "";
        }
        int endIndex = str.indexOf(delimiter);
        if (endIndex < 0) {
            endIndex = str.length();
        }
        return str.substring(0, endIndex);
    }

    public static String computeDisplayableForm(String str, String defaultValue) {
        if (str == null || str.length() == 0) {
            return defaultValue;
        }
        StringBuffer newName = new StringBuffer(str);
        boolean previousCharUppercase = false;
        char prevChar = newName.charAt(0);
        if (Character.isLowerCase(prevChar)) {
            newName.setCharAt(0, Character.toUpperCase(prevChar));
            previousCharUppercase = true;
        }
        if (newName.length() > 1) {
            for (int i = 1; i != newName.length(); ++i) {
                boolean nextCharUppercase;
                char nextChar;
                prevChar = newName.charAt(i - 1);
                char currentChar = newName.charAt(i);
                previousCharUppercase = Character.isUpperCase(prevChar);
                boolean currentCharUppercase = Character.isUpperCase(currentChar);
                if (i != newName.length() - 1) {
                    nextChar = newName.charAt(i + 1);
                    nextCharUppercase = Character.isUpperCase(nextChar);
                } else {
                    nextCharUppercase = false;
                    nextChar = ' ';
                }
                if (prevChar == ' ') {
                    newName.setCharAt(i, Character.toUpperCase(currentChar));
                    continue;
                }
                if (!currentCharUppercase) continue;
                if (!previousCharUppercase) {
                    if (currentChar == 'M' && i >= 4 && newName.substring(i - 4).startsWith(CorePlugin.Util.getString("StringUtil.Displayable"))) continue;
                    newName.insert(i, ' ');
                    ++i;
                    continue;
                }
                if (nextCharUppercase || nextChar == 32) continue;
                newName.insert(i, ' ');
                ++i;
            }
        }
        return newName.toString();
    }

    public static String computePluralForm(String str) {
        return StringUtil.computePluralForm(str, "");
    }

    public static String computePluralForm(String str, String defaultValue) {
        if (str == null || str.length() == 0) {
            return defaultValue;
        }
        String result = str;
        if (!result.endsWith("es")) {
            result = result.endsWith("ss") || result.endsWith("x") || result.endsWith("ch") || result.endsWith("sh") ? result + "es" : (result.endsWith("y") && !result.endsWith("ay") && !result.endsWith("ey") && !result.endsWith("iy") && !result.endsWith("oy") && !result.endsWith("uy") && !result.equalsIgnoreCase("any") ? result.substring(0, result.length() - 1) + "ies" : result + "s");
        }
        return result;
    }

    public static String getStackTrace(Throwable t) {
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(bas);
        t.printStackTrace(pw);
        pw.close();
        return bas.toString();
    }

    public static boolean isBoolean(String text) {
        return Boolean.TRUE.toString().equalsIgnoreCase(text) || Boolean.FALSE.toString().equalsIgnoreCase(text);
    }

    public static boolean isEmpty(String text) {
        return text == null || text.length() == 0;
    }

    public static int indexOfIgnoreCase(String text, String str) {
        if (StringUtil.isEmpty(text)) {
            return -1;
        }
        if (StringUtil.isEmpty(str)) {
            return -1;
        }
        String lowerText = text.toLowerCase();
        String lowerStr = str.toLowerCase();
        return lowerText.indexOf(lowerStr);
    }

    public static boolean startsWithIgnoreCase(String text, String prefix) {
        if (text == null || prefix == null) {
            return false;
        }
        return text.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public static boolean endsWithIgnoreCase(String text, String suffix) {
        if (text == null || suffix == null) {
            return false;
        }
        return text.regionMatches(true, text.length() - suffix.length(), suffix, 0, suffix.length());
    }

    public static boolean isDigits(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (StringUtil.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private StringUtil() {
    }

    static String asRegEx(String pattern) {
        String result1 = Constants.PATTERN_BACK_SLASH.matcher(pattern).replaceAll("\\\\E\\\\\\\\\\\\Q");
        String result2 = Constants.PATTERN_STAR.matcher(result1).replaceAll("\\\\E.*\\\\Q");
        String result3 = Constants.PATTERN_QUESTION.matcher(result2).replaceAll("\\\\E.\\\\Q");
        return "\\Q" + result3 + "\\E";
    }

    public static Pattern createPattern(String pattern, boolean isCaseSensitive) {
        if (isCaseSensitive) {
            return Pattern.compile(StringUtil.asRegEx(pattern));
        }
        return Pattern.compile(StringUtil.asRegEx(pattern), 66);
    }

    public static String toFixedLength(String input, int desiredLength) {
        if (input == null) {
            input = "";
        }
        if (input.length() == desiredLength) {
            return input;
        }
        if (input.length() < desiredLength) {
            StringBuffer str = new StringBuffer(input);
            int needSpaces = desiredLength - input.length();
            for (int i = 0; i < needSpaces; ++i) {
                str.append(' ');
            }
            return str.toString();
        }
        return input.substring(0, desiredLength);
    }

    public static boolean isLetter(char c) {
        return StringUtil.isBasicLatinLetter(c) || Character.isLetter(c);
    }

    public static boolean isDigit(char c) {
        return StringUtil.isBasicLatinDigit(c) || Character.isDigit(c);
    }

    public static boolean isLetterOrDigit(char c) {
        return StringUtil.isBasicLatinLetter(c) || StringUtil.isBasicLatinDigit(c) || Character.isLetterOrDigit(c);
    }

    public static boolean isValid(String str) {
        return str != null && str.trim().length() != 0;
    }

    public static String createFileName(String str) {
        str = str.replaceAll(" \\| ", "_");
        str = str.replaceAll(">", "_");
        str = str.replaceAll(": ", "_");
        str = str.replaceAll(" ", "_");
        str = str.replaceAll("\\?", "_");
        if ((str = str.replaceAll("/", "_")).matches("[_]+")) {
            str = "file";
        }
        return str;
    }

    public static String firstLetterUppercase(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        if (str.length() == 1) {
            return str.toUpperCase();
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    private static boolean isBasicLatinLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static boolean isBasicLatinDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static <T> T valueOf(String value, Class type) {
        if (value == null) {
            return null;
        }
        if (type == String.class) {
            return (T)value;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return (T)Integer.decode(value);
        }
        if (type == Float.class || type == Float.TYPE) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class || type == Double.TYPE) {
            return (T)Double.valueOf(value);
        }
        if (type == Long.class || type == Long.TYPE) {
            return (T)Long.decode(value);
        }
        if (type == Short.class || type == Short.TYPE) {
            return (T)Short.decode(value);
        }
        if (type.isAssignableFrom(List.class)) {
            return (T)new ArrayList<String>(Arrays.asList(value.split(",")));
        }
        if (type.isAssignableFrom(Set.class)) {
            return (T)new HashSet<String>(Arrays.asList(value.split(",")));
        }
        if (type.isArray()) {
            String[] values = value.split(",");
            Object array = Array.newInstance(type.getComponentType(), values.length);
            for (int i = 0; i < values.length; ++i) {
                Array.set(array, i, StringUtil.valueOf(values[i], type.getComponentType()));
            }
            return (T)array;
        }
        if (type == Void.class) {
            return null;
        }
        if (type.isEnum()) {
            return Enum.valueOf(type, value);
        }
        if (type == URL.class) {
            try {
                return (T)new URL(value);
            }
            catch (MalformedURLException e) {
            }
        } else if (type.isAssignableFrom(Map.class)) {
            List<String> l = Arrays.asList(value.split(","));
            HashMap<String, String> m = new HashMap<String, String>();
            for (String key : l) {
                int index = key.indexOf(61);
                if (index == -1) continue;
                m.put(key.substring(0, index), key.substring(index + 1));
            }
            return (T)m;
        }
        throw new IllegalArgumentException("Conversion from String to " + type.getName() + " is not supported");
    }

    public static String[] getLines(String value) {
        StringReader stringReader = new StringReader(value);
        BufferedReader reader = new BufferedReader(stringReader);
        ArrayList<String> result = new ArrayList<String>();
        try {
            String line = reader.readLine();
            while (line != null) {
                result.add(line);
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new TeiidRuntimeException((BundleUtil.Event)CorePlugin.Event.TEIID10046, (Throwable)e);
        }
        return result.toArray(new String[result.size()]);
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        if (s1 != null) {
            return s1.equalsIgnoreCase(s2);
        }
        return s2 == null;
    }

    public static <T extends Enum<T>> T caseInsensitiveValueOf(Class<T> enumType, String name) {
        try {
            return Enum.valueOf(enumType, name);
        }
        catch (IllegalArgumentException e) {
            Enum[] vals;
            for (Enum t : vals = (Enum[])enumType.getEnumConstants()) {
                if (!name.equalsIgnoreCase(t.name())) continue;
                return (T)t;
            }
            throw e;
        }
    }

    public static List<String> tokenize(String str, char delim) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean escaped = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == delim) {
                if (escaped) {
                    current.append(c);
                    escaped = false;
                    continue;
                }
                escaped = true;
                continue;
            }
            if (escaped && current.length() > 0) {
                result.add(current.toString());
                current.setLength(0);
                escaped = false;
            }
            current.append(c);
        }
        if (current.length() > 0) {
            result.add(current.toString());
        }
        return result;
    }

    public static String unescape(CharSequence string, int quoteChar, boolean useAsciiEscapes, StringBuilder sb) {
        boolean escaped = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (escaped) {
                switch (c) {
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 'u': {
                        i = StringUtil.parseNumericValue(string, sb, i, 0, 4, 4);
                        break;
                    }
                    default: {
                        if (c == quoteChar) {
                            sb.append(quoteChar);
                            break;
                        }
                        if (!useAsciiEscapes) break;
                        int value = Character.digit(c, 8);
                        if (value == -1) {
                            sb.append(c);
                            break;
                        }
                        int possibleDigits = value < 3 ? 2 : 1;
                        int radixExp = 3;
                        i = StringUtil.parseNumericValue(string, sb, i, value, possibleDigits, radixExp);
                    }
                }
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == quoteChar) break;
            sb.append(c);
        }
        return sb.toString();
    }

    private static int parseNumericValue(CharSequence string, StringBuilder sb, int i, int value, int possibleDigits, int radixExp) {
        char digit;
        int val;
        for (int j = 0; j < possibleDigits && i + 1 != string.length() && (val = Character.digit(digit = string.charAt(i + 1), 1 << radixExp)) != -1; ++j) {
            ++i;
            value = (value << radixExp) + val;
        }
        sb.append((char)value);
        return i;
    }

    public static interface Constants {
        public static final char CARRIAGE_RETURN_CHAR = '\r';
        public static final char LINE_FEED_CHAR = '\n';
        public static final char NEW_LINE_CHAR = '\n';
        public static final char SPACE_CHAR = ' ';
        public static final char DOT_CHAR = '.';
        public static final char TAB_CHAR = '\t';
        public static final String CARRIAGE_RETURN = String.valueOf('\r');
        public static final String EMPTY_STRING = "";
        public static final String DBL_SPACE = "  ";
        public static final String LINE_FEED = String.valueOf('\n');
        public static final String NEW_LINE = String.valueOf('\n');
        public static final String SPACE = String.valueOf(' ');
        public static final String DOT = String.valueOf('.');
        public static final String TAB = String.valueOf('\t');
        public static final String[] EMPTY_STRING_ARRAY = new String[0];
        public static final Pattern PATTERN_BACK_SLASH = Pattern.compile("\\\\");
        public static final Pattern PATTERN_QUESTION = Pattern.compile("\\?");
        public static final Pattern PATTERN_STAR = Pattern.compile("\\*");
    }
}

