/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.xml;

import org.teiid.query.processor.xml.Condition;
import org.teiid.query.processor.xml.IfInstruction;
import org.teiid.query.processor.xml.ProcessorInstruction;
import org.teiid.query.processor.xml.Program;
import org.teiid.query.processor.xml.RecurseProgramCondition;
import org.teiid.query.processor.xml.WhileInstruction;

public final class ProgramUtil {
    private ProgramUtil() {
    }

    public static final String programToString(Program program) {
        StringBuffer str = new StringBuffer();
        int counter = 1;
        int tabs = 0;
        ProgramUtil.programToString(program, counter, tabs, str);
        return str.toString();
    }

    private static final int programToString(Program program, int counter, int tabs, StringBuffer str) {
        int instructionIndex = 0;
        ProcessorInstruction inst = program.getInstructionAt(instructionIndex);
        Program subprogram = null;
        while (inst != null) {
            ProgramUtil.printLine(counter++, tabs, inst.toString(), str);
            if (counter > 1000) {
                ProgramUtil.printLine(counter, tabs, "[OUTPUT TRUNCATED...]", str);
                break;
            }
            if (inst instanceof WhileInstruction) {
                subprogram = ((WhileInstruction)inst).getBlockProgram();
                counter = ProgramUtil.programToString(subprogram, counter, tabs + 1, str);
            } else if (inst instanceof IfInstruction) {
                IfInstruction ifInst = (IfInstruction)inst;
                int thenCount = ifInst.getThenCount();
                for (int i = 0; i < thenCount; ++i) {
                    Condition cond = ifInst.getThenCondition(i);
                    if (i == 0) {
                        ProgramUtil.printLine(counter++, tabs, "IF " + cond.toString(), str);
                    } else {
                        ProgramUtil.printLine(counter++, tabs, "ELSE IF " + cond.toString(), str);
                    }
                    if (cond instanceof RecurseProgramCondition) {
                        ProgramUtil.printLine(counter++, tabs, "THEN [recursive sub Program]", str);
                        continue;
                    }
                    subprogram = ifInst.getThenProgram(i);
                    ProgramUtil.printLine(counter++, tabs, "THEN", str);
                    counter = ProgramUtil.programToString(subprogram, counter, tabs + 1, str);
                }
                subprogram = ifInst.getElseProgram();
                if (subprogram != null) {
                    ProgramUtil.printLine(counter++, tabs, "ELSE", str);
                    counter = ProgramUtil.programToString(subprogram, counter, tabs + 1, str);
                }
            }
            inst = program.getInstructionAt(++instructionIndex);
        }
        return counter;
    }

    private static final void printLine(int counter, int tabs, String line, StringBuffer buffer) {
        String counterStr = "" + counter + ": ";
        if (counter < 10) {
            counterStr = counterStr + " ";
        }
        if (counterStr.length() == 1) {
            counterStr = counterStr + "  ";
        } else if (counterStr.length() == 2) {
            counterStr = counterStr + " ";
        }
        buffer.append(counterStr + ProgramUtil.getTab(tabs) + line + "\n");
    }

    private static final String getTab(int tabs) {
        if (tabs == 0) {
            return "";
        }
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < tabs; ++i) {
            str.append("    ");
        }
        return str.toString();
    }
}

