/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.cdk;

import java.util.ArrayList;
import java.util.List;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.dqp.internal.datamgr.LanguageBridgeFactory;
import org.teiid.language.LanguageFactory;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.relational.AliasGenerator;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.navigator.DeepPostOrderNavigator;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.MultipleElementSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.visitor.ExpressionMappingVisitor;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;

public class CommandBuilder {
    private QueryMetadataInterface metadata;
    private LanguageBridgeFactory languageBridgeFactory;

    public static LanguageFactory getLanuageFactory() {
        return LanguageFactory.INSTANCE;
    }

    public CommandBuilder(QueryMetadataInterface metadata) {
        this.metadata = metadata;
        this.languageBridgeFactory = new LanguageBridgeFactory(metadata);
    }

    public LanguageBridgeFactory getLanguageBridgeFactory() {
        return this.languageBridgeFactory;
    }

    public org.teiid.language.Command getCommand(String queryString) {
        return this.getCommand(queryString, false, false);
    }

    public org.teiid.language.Command getCommand(String queryString, boolean generateAliases, boolean supportsGroupAlias) {
        Command command = null;
        try {
            command = QueryParser.getQueryParser().parseCommand(queryString);
            QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)this.metadata);
            command = QueryRewriter.rewrite((Command)command, (QueryMetadataInterface)this.metadata, null);
            this.expandAllSymbol(command);
            if (generateAliases) {
                command = (Command)command.clone();
                command.acceptVisitor((LanguageVisitor)new AliasGenerator(supportsGroupAlias));
            }
            for (SubqueryContainer container : ValueIteratorProviderCollectorVisitor.getValueIteratorProviders((LanguageObject)command)) {
                ExpressionMappingVisitor visitor = new ExpressionMappingVisitor(null){

                    public Expression replaceExpression(Expression element) {
                        if (element instanceof Reference) {
                            return ((Reference)element).getExpression();
                        }
                        return element;
                    }
                };
                DeepPostOrderNavigator.doVisit((LanguageObject)command, (LanguageVisitor)visitor);
            }
            return this.languageBridgeFactory.translate(command);
        }
        catch (TeiidException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    protected void expandAllSymbol(Command command) {
        if (command instanceof Query) {
            Query query = (Query)command;
            Select select = query.getSelect();
            List originalSymbols = select.getSymbols();
            ArrayList<Expression> expandedSymbols = new ArrayList<Expression>();
            for (Expression next : originalSymbols) {
                if (next instanceof MultipleElementSymbol) {
                    MultipleElementSymbol allSymbol = (MultipleElementSymbol)next;
                    expandedSymbols.addAll(allSymbol.getElementSymbols());
                    continue;
                }
                expandedSymbols.add(next);
            }
            select.setSymbols(expandedSymbols);
        }
    }
}

