/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.teiid.core.types.DataTypeManager;
import org.teiid.language.ColumnReference;
import org.teiid.language.DerivedColumn;
import org.teiid.language.Expression;
import org.teiid.language.Literal;
import org.teiid.language.Select;

public class TestSelectSymbolImpl
extends TestCase {
    public TestSelectSymbolImpl(String name) {
        super(name);
    }

    public static DerivedColumn example(String symbolName, String alias) throws Exception {
        DerivedColumn selectSymbol = new DerivedColumn(alias, (Expression)new ColumnReference(null, symbolName, null, DataTypeManager.DefaultDataClasses.INTEGER));
        return selectSymbol;
    }

    public void testHasAlias() throws Exception {
        TestSelectSymbolImpl.assertNotNull((Object)TestSelectSymbolImpl.example("testName", "testAlias").getAlias());
        TestSelectSymbolImpl.assertNull((Object)TestSelectSymbolImpl.example("testName", null).getAlias());
    }

    public void testGetOutputName() throws Exception {
        TestSelectSymbolImpl.assertEquals((String)"testAlias", (String)TestSelectSymbolImpl.example("testName", "testAlias").getAlias());
    }

    public void testGetExpression() throws Exception {
        TestSelectSymbolImpl.assertNotNull((Object)TestSelectSymbolImpl.example("testName", null).getExpression());
    }

    public void testGetColumnDataTypes() {
        Class[] expectedResults = new Class[2];
        ArrayList<DerivedColumn> symbols = new ArrayList<DerivedColumn>();
        symbols.add(new DerivedColumn("c1", (Expression)new Literal((Object)"3", DataTypeManager.DefaultDataClasses.STRING)));
        expectedResults[0] = DataTypeManager.DefaultDataClasses.STRING;
        symbols.add(new DerivedColumn("c2", (Expression)new Literal((Object)new Integer(5), DataTypeManager.DefaultDataClasses.INTEGER)));
        expectedResults[1] = DataTypeManager.DefaultDataClasses.INTEGER;
        Select query = new Select(symbols, false, null, null, null, null, null);
        Class[] results = query.getColumnTypes();
        TestSelectSymbolImpl.assertEquals((Object)results[0], (Object)expectedResults[0]);
        TestSelectSymbolImpl.assertEquals((Object)results[1], (Object)expectedResults[1]);
    }
}

