/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.io.ByteArrayInputStream;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.deployers.VDBRepository;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.runtime.EmbeddedServer;
import org.teiid.runtime.MaterializationManager;

public class TestDataRoles {
    private ExtendedEmbeddedServer es;

    @After
    public void tearDown() {
        this.es.stop();
    }

    @Test
    public void testSecurity() throws Exception {
        this.es = new ExtendedEmbeddedServer();
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        this.es.start(ec);
        this.es.deployVDB(new ByteArrayInputStream(new String("<vdb name=\"role-1\" version=\"1\"><model name=\"myschema\" type=\"virtual\"><metadata type = \"DDL\"><![CDATA[CREATE VIEW vw as select 'a' as col;]]></metadata></model><data-role name=\"y\" any-authenticated=\"true\"/></vdb>").getBytes()));
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:role-1", null);
        Statement s = c.createStatement();
        try {
            s.execute("select * from vw");
            Assert.fail();
        }
        catch (SQLException e) {
            // empty catch block
        }
        this.es.getMaterializationManager().executeQuery(this.es.getVDBRepository().getLiveVDB("role-1"), "select * from vw");
    }

    @Test
    public void testExecuteImmediate() throws Exception {
        this.es = new ExtendedEmbeddedServer();
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        this.es.start(ec);
        this.es.deployVDB(new ByteArrayInputStream(new String("<vdb name=\"role-1\" version=\"1\"><model name=\"myschema\" type=\"virtual\"><metadata type = \"DDL\"><![CDATA[CREATE VIEW vw as select 'a' as col;]]></metadata></model><data-role name=\"y\" any-authenticated=\"true\"/></vdb>").getBytes()));
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:role-1", null);
        Statement s = c.createStatement();
        s.execute("set autoCommitTxn off");
        try {
            s.execute("begin execute immediate 'select * from vw'; end");
            Assert.fail();
        }
        catch (TeiidSQLException e) {
            // empty catch block
        }
        s.execute("begin execute immediate 'select 1'; end");
        try {
            s.execute("begin execute immediate 'select 1' as x integer into #temp; end");
            Assert.fail();
        }
        catch (TeiidSQLException e) {
            // empty catch block
        }
        try {
            s.execute("begin execute immediate 'begin execute immediate ''select * from vw''; end'; end");
            Assert.fail();
        }
        catch (TeiidSQLException e) {
            // empty catch block
        }
    }

    private static final class ExtendedEmbeddedServer
    extends EmbeddedServer {
        private ExtendedEmbeddedServer() {
        }

        public MaterializationManager getMaterializationManager() {
            return super.getMaterializationManager();
        }

        public VDBRepository getVDBRepository() {
            return super.getVDBRepository();
        }
    }
}

