/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeSet;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.tempdata.BaseIndexInfo;
import org.teiid.query.tempdata.SearchableTable;
import org.teiid.query.util.CommandContext;

abstract class RecordTable<T extends AbstractMetadataRecord>
implements SearchableTable {
    private static final SimpleIterator<?> empty = new SimpleIterator<Object>(){

        @Override
        public Object next() throws TeiidProcessingException, TeiidComponentException {
            return null;
        }
    };
    private Map<Expression, Integer> columnMap;
    private Expression[] pkColumns;
    protected Evaluator eval;

    public static <T> SimpleIterator<T> emptyIterator() {
        return empty;
    }

    public RecordTable(int[] pkColumnIndexs, List<ElementSymbol> columns) {
        this.columnMap = RelationalNode.createLookupMap(columns);
        this.pkColumns = new ElementSymbol[pkColumnIndexs.length];
        for (int i = 0; i < pkColumnIndexs.length; ++i) {
            this.pkColumns[i] = columns.get(pkColumnIndexs[i]);
        }
        this.eval = new Evaluator(this.columnMap, null, null);
    }

    @Override
    public int getPkLength() {
        return this.pkColumns.length;
    }

    @Override
    public Map<Expression, Integer> getColumnMap() {
        return this.columnMap;
    }

    @Override
    public Boolean matchesPkColumn(int pkIndex, Expression ex) {
        if (ex instanceof Function) {
            Function f = (Function)ex;
            ex = f.getArg(0);
        }
        return this.pkColumns[pkIndex].equals(ex);
    }

    @Override
    public boolean supportsOrdering(int pkIndex, Expression ex) {
        return !(ex instanceof ElementSymbol);
    }

    public abstract SimpleIterator<T> processQuery(VDBMetaData var1, CompositeMetadataStore var2, BaseIndexInfo<?> var3, TransformationMetadata var4);

    public SimpleIterator<T> processQuery(final VDBMetaData vdb, NavigableMap<String, ?> map, BaseIndexInfo<?> ii) {
        final Criteria crit = ii.getCoveredCriteria();
        final ArrayList rowBuffer = new ArrayList(1);
        if (!ii.getValueSet().isEmpty()) {
            final ArrayList<List<Object>> vals = ii.getValueSet();
            final NavigableMap<String, ?> fMap = map;
            return new SimpleIterator<T>(){
                int i = 0;
                TreeSet<String> seen = new TreeSet(String.CASE_INSENSITIVE_ORDER);

                @Override
                public T next() throws TeiidProcessingException, TeiidComponentException {
                    while (this.i < vals.size()) {
                        Object s;
                        String key;
                        if (!this.seen.add(key = (String)((List)vals.get(this.i++)).get(0)) || !RecordTable.this.isValid(s = RecordTable.this.extractRecord(fMap.get(key)), vdb, rowBuffer, crit)) continue;
                        return s;
                    }
                    return null;
                }
            };
        }
        try {
            if (ii.getLower() != null) {
                map = ii.getUpper() != null ? map.subMap((String)ii.getLower().get(0), true, (String)ii.getUpper().get(0), true) : map.tailMap((String)ii.getLower().get(0), true);
            } else if (ii.getUpper() != null) {
                map = map.headMap((String)ii.getUpper().get(0), true);
            }
            final Iterator iter = map.values().iterator();
            return new SimpleIterator<T>(){

                @Override
                public T next() throws TeiidProcessingException, TeiidComponentException {
                    while (iter.hasNext()) {
                        Object s = RecordTable.this.extractRecord(iter.next());
                        if (!RecordTable.this.isValid(s, vdb, rowBuffer, crit)) continue;
                        return s;
                    }
                    return null;
                }
            };
        }
        catch (IllegalArgumentException e) {
            return RecordTable.emptyIterator();
        }
    }

    protected T extractRecord(Object val) {
        return (T)((AbstractMetadataRecord)val);
    }

    public BaseIndexInfo<RecordTable<?>> planQuery(Query query, Criteria condition, CommandContext context) {
        BaseIndexInfo info = new BaseIndexInfo(this, Collections.EMPTY_LIST, condition, null, false);
        if (!info.getValueSet().isEmpty()) {
            info.sortValueSet(true, context.getBufferManager().getOptions().getDefaultNullOrder());
        }
        return info;
    }

    protected boolean isValid(T s, VDBMetaData vdb, List<Object> rowBuffer, Criteria condition) throws TeiidProcessingException, TeiidComponentException {
        if (s == null) {
            return false;
        }
        if (condition != null) {
            rowBuffer.clear();
            this.fillRow(s, rowBuffer);
            return this.eval.evaluate(condition, rowBuffer);
        }
        return true;
    }

    protected void fillRow(T s, List<Object> rowBuffer) {
        rowBuffer.add(s.getName());
    }

    public static abstract class ExpandingSimpleIterator<P, T>
    implements SimpleIterator<T> {
        private SimpleIterator<T> childIter;
        private SimpleIterator<P> parentIter;
        private P currentParent;

        public ExpandingSimpleIterator(SimpleIterator<P> parentIter) {
            this.parentIter = parentIter;
        }

        @Override
        public T next() throws TeiidProcessingException, TeiidComponentException {
            while (true) {
                T t;
                if (this.childIter == null) {
                    this.currentParent = this.parentIter.next();
                    if (this.currentParent == null) {
                        return null;
                    }
                    this.childIter = this.getChildIterator(this.currentParent);
                }
                if ((t = this.childIter.next()) != null) {
                    return t;
                }
                this.childIter = null;
            }
        }

        public P getCurrentParent() {
            return this.currentParent;
        }

        protected abstract SimpleIterator<T> getChildIterator(P var1);
    }

    public static class SimpleIteratorWrapper<T>
    implements SimpleIterator<T> {
        private Iterator<? extends T> iter;

        public SimpleIteratorWrapper(Iterator<? extends T> iter) {
            this.iter = iter;
        }

        public void setIterator(Iterator<? extends T> iter) {
            this.iter = iter;
        }

        @Override
        public T next() throws TeiidProcessingException, TeiidComponentException {
            while (this.iter.hasNext()) {
                T result = this.iter.next();
                if (result == null) continue;
                return result;
            }
            return null;
        }
    }

    public static interface SimpleIterator<T> {
        public T next() throws TeiidProcessingException, TeiidComponentException;
    }
}

