/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.ArrayImpl;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.parser.TestParser;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.TestResolver;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.symbol.Array;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestArrayProcessing {
    @Test
    public void testArrayCast() throws Exception {
        String sql = "select cast(cast((1,2) as object) as integer[])";
        TestResolver.helpResolve(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        sql = "select cast(cast((1,2) as object) as integer[])";
        HardcodedDataManager dataManager = new HardcodedDataManager();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        TestProcessor.helpProcess(plan, dataManager, null);
        sql = "select cast(cast((1,2) as object) as string[])";
        try {
            TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), (CapabilitiesFinder)DefaultCapabilitiesFinder.INSTANCE, TestProcessor.createCommandContext());
            Assert.fail();
        }
        catch (TeiidProcessingException teiidProcessingException) {
            // empty catch block
        }
    }

    @Test
    public void testArrayComparison() {
        String sql = "select count(e1) from pm1.g1 where (e1, e2) = ('a', 1)";
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1", Arrays.asList("a", 2), Arrays.asList("a", 1));
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, new List[]{Arrays.asList(1)});
        dataManager = new HardcodedDataManager((QueryMetadataInterface)RealMetadataFactory.example1Cached());
        dataManager.addData("SELECT g_0.e1 FROM g1 AS g_0 WHERE (g_0.e1, g_0.e2) = ('a', 1)", Arrays.asList("a"));
        BasicSourceCapabilities bsc = TestOptimizer.getTypicalCapabilities();
        bsc.setCapabilitySupport(SourceCapabilities.Capability.ARRAY_TYPE, true);
        plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)bsc));
        TestProcessor.helpProcess(plan, dataManager, new List[]{Arrays.asList(1)});
    }

    @Test
    public void testArraySort() {
        String sql = "select (e1, e2) from pm1.g1 order by (e1, e2), e3";
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT pm1.g1.e1, pm1.g1.e2, pm1.g1.e3 FROM pm1.g1", Arrays.asList("b", 4, true), Arrays.asList("a", 2, true), Arrays.asList("a", 1, false));
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, new List[]{Arrays.asList(new ArrayImpl(new Object[]{"a", 1})), Arrays.asList(new ArrayImpl(new Object[]{"a", 2})), Arrays.asList(new ArrayImpl(new Object[]{"b", 4}))});
    }

    @Test
    public void testArrayGetTyping() {
        String sql = "select array_agg(e1)[1], array_agg(e2)[3] from pm1.g1";
        Command command = TestResolver.helpResolve(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.STRING, (Object)((Expression)command.getProjectedSymbols().get(0)).getType());
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.INTEGER, (Object)((Expression)command.getProjectedSymbols().get(1)).getType());
    }

    @Test(expected=QueryResolverException.class)
    public void testArrayGetTypingFails() throws QueryResolverException, TeiidComponentException {
        String sql = "select array_agg(e1)[1][2] from pm1.g1";
        QueryResolver.resolveCommand((Command)TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testArrayParsing() throws Exception {
        TestParser.helpTestExpression("()", "()", (Expression)new Array(new ArrayList()));
        TestParser.helpTestExpression("(,)", "()", (Expression)new Array(new ArrayList()));
        TestParser.helpTestExpression("(1,)", "(1,)", (Expression)new Array(Arrays.asList(new Constant((Object)1))));
        TestParser.helpTestExpression("(1,2)", "(1, 2)", (Expression)new Array(Arrays.asList(new Constant((Object)1), new Constant((Object)2))));
        TestParser.helpTestExpression("(1,2,)", "(1, 2)", (Expression)new Array(Arrays.asList(new Constant((Object)1), new Constant((Object)2))));
    }

    @Test
    public void testArrayEquivalence() throws Exception {
        Array a1 = new Array(new ArrayList());
        UnitTestUtil.helpTestEquivalence((int)0, (Object)a1, (Object)a1);
        Array a2 = new Array(Arrays.asList(new Constant((Object)1)));
        UnitTestUtil.helpTestEquivalence((int)1, (Object)a1, (Object)a2);
    }

    @Test
    public void testArrayTable() throws Exception {
        String sql = "select x.* from arraytable(('a', 2-1, {d'2001-01-01'}) COLUMNS x string, y integer) x";
        List[] expected = new List[]{Arrays.asList("a", 1)};
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, new HardcodedDataManager(), expected);
    }

    @Test
    public void testMultiDimensionalGet() throws Exception {
        String sql = "select -((e2, e2), (e2, e2))[1][1] from pm1.g1";
        QueryResolver.resolveCommand((Command)TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        Command command = TestResolver.helpResolve(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.INTEGER, (Object)((Expression)command.getProjectedSymbols().get(0)).getType());
    }

    @Test
    public void testMultiDimensionalCast() throws Exception {
        String sql = "select cast( ((e2, e2), (e2, e2)) as object[])  from pm1.g1";
        QueryResolver.resolveCommand((Command)TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        Command command = TestResolver.helpResolve(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        Assert.assertEquals(Object[].class, (Object)((Expression)command.getProjectedSymbols().get(0)).getType());
        ProcessorPlan pp = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestOptimizer.getGenericFinder());
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT g_0.e2 FROM pm1.g1 AS g_0", Arrays.asList(1), Arrays.asList(2));
        TestProcessor.helpProcess(pp, dataManager, new List[]{Arrays.asList(new ArrayImpl((Object[])new Integer[][]{{1, 1}, {1, 1}})), Arrays.asList(new ArrayImpl((Object[])new Integer[][]{{2, 2}, {2, 2}}))});
        sql = "select cast(cast( ((e2, e2), (e2, e2)) as object[]) as integer[][])  from pm1.g1";
        QueryResolver.resolveCommand((Command)TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        command = TestResolver.helpResolve(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        Assert.assertEquals(Integer[][].class, (Object)((Expression)command.getProjectedSymbols().get(0)).getType());
    }

    @Test
    public void testMultiDimensionalArrayRewrite() throws Exception {
        String sql = "select (('a', 'b'),('c','d'))";
        QueryResolver.resolveCommand((Command)TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        Command command = TestResolver.helpResolve(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        Assert.assertEquals(String[][].class, (Object)((Expression)command.getProjectedSymbols().get(0)).getType());
        command = QueryRewriter.rewrite((Command)command, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null);
        Expression ex = SymbolMap.getExpression((Expression)((Expression)command.getProjectedSymbols().get(0)));
        Constant c = (Constant)ex;
        Assert.assertTrue((boolean)(c.getValue() instanceof ArrayImpl));
    }

    @Test
    public void testArrayResolvingNull() throws Exception {
        String sql = "select (null, 'a')";
        QueryResolver.resolveCommand((Command)TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        Command command = TestResolver.helpResolve(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        Assert.assertEquals(String[].class, (Object)((Expression)command.getProjectedSymbols().get(0)).getType());
        sql = "select ((null,), ('a',))";
        QueryResolver.resolveCommand((Command)TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        command = TestResolver.helpResolve(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        Assert.assertEquals(String[][].class, (Object)((Expression)command.getProjectedSymbols().get(0)).getType());
    }
}

