/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.JoinPredicate;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;

public class TestJoinPredicate
extends TestCase {
    public TestJoinPredicate(String name) {
        super(name);
    }

    public static JoinPredicate example(JoinType joinType, String joinOnElement) {
        JoinPredicate jp = new JoinPredicate();
        GroupSymbol g1 = new GroupSymbol("m.g1");
        GroupSymbol g2 = new GroupSymbol("m.g2");
        UnaryFromClause lc = new UnaryFromClause(g1);
        UnaryFromClause rc = new UnaryFromClause(g2);
        ElementSymbol le = new ElementSymbol("m.g1." + joinOnElement);
        ElementSymbol re = new ElementSymbol("m.g2." + joinOnElement);
        CompareCriteria c1 = new CompareCriteria((Expression)le, 1, (Expression)re);
        jp.setLeftClause((FromClause)lc);
        jp.setRightClause((FromClause)rc);
        jp.setJoinType(joinType != null ? joinType : JoinType.JOIN_LEFT_OUTER);
        jp.setJoinCriteria(Arrays.asList(c1));
        return jp;
    }

    public static JoinPredicate example(JoinType joinType, String joinOnElement, String andJoinOnElement) {
        JoinPredicate jp = TestJoinPredicate.example(joinType, joinOnElement);
        List joinCrits = jp.getJoinCriteria();
        ArrayList<Object> newJoinCrits = new ArrayList<Object>(1);
        ElementSymbol le = new ElementSymbol("m.g1." + andJoinOnElement);
        ElementSymbol re = new ElementSymbol("m.g2." + andJoinOnElement);
        CompareCriteria c1 = new CompareCriteria((Expression)le, 1, (Expression)re);
        Iterator ci = joinCrits.iterator();
        if (!ci.hasNext()) {
            newJoinCrits.add(c1);
        }
        while (ci.hasNext()) {
            Criteria crit = (Criteria)ci.next();
            if (ci.hasNext()) {
                newJoinCrits.add(crit);
                continue;
            }
            CompoundCriteria compundCrit = new CompoundCriteria(0, crit, (Criteria)c1);
            newJoinCrits.add(compundCrit);
        }
        jp.setJoinCriteria(newJoinCrits);
        return jp;
    }

    public void testEquals1() {
        JoinPredicate jp1 = TestJoinPredicate.example(JoinType.JOIN_LEFT_OUTER, "e1");
        JoinPredicate jp2 = TestJoinPredicate.example(JoinType.JOIN_LEFT_OUTER, "e1");
        TestJoinPredicate.assertTrue((String)("Equivalent join predicate don't compare as equal: " + jp1 + ", " + jp2), (boolean)jp1.equals((Object)jp2));
    }

    public void testEquals2() {
        JoinPredicate jp1 = TestJoinPredicate.example(JoinType.JOIN_LEFT_OUTER, "e1", "e2");
        JoinPredicate jp2 = TestJoinPredicate.example(JoinType.JOIN_LEFT_OUTER, "e1", "e2");
        TestJoinPredicate.assertTrue((String)("Equivalent join predicate don't compare as equal: " + jp1 + ", " + jp2), (boolean)jp1.equals((Object)jp2));
    }

    public void testEquals3() {
        JoinPredicate jp1 = TestJoinPredicate.example(JoinType.JOIN_LEFT_OUTER, "e1", "e2");
        JoinPredicate jp2 = TestJoinPredicate.example(JoinType.JOIN_RIGHT_OUTER, "e1", "e2");
        TestJoinPredicate.assertTrue((String)("Different join predicate compare as equal: " + jp1 + ", " + jp2), (!jp1.equals((Object)jp2) ? 1 : 0) != 0);
    }

    public void testEquals4() {
        JoinPredicate jp1 = TestJoinPredicate.example(JoinType.JOIN_INNER, "e1");
        JoinPredicate jp2 = TestJoinPredicate.example(JoinType.JOIN_INNER, "e2");
        TestJoinPredicate.assertTrue((String)("Different join predicate compare as equal: " + jp1 + ", " + jp2), (!jp1.equals((Object)jp2) ? 1 : 0) != 0);
    }

    public void testEquals5() {
        JoinPredicate jp1 = TestJoinPredicate.example(JoinType.JOIN_CROSS, "e1", "e2");
        JoinPredicate jp2 = TestJoinPredicate.example(JoinType.JOIN_CROSS, "e2", "e2");
        TestJoinPredicate.assertTrue((String)("Different join predicate compare as equal: " + jp1 + ", " + jp2), (!jp1.equals((Object)jp2) ? 1 : 0) != 0);
    }

    public void testSelfEquivalence() {
        JoinPredicate jp1 = TestJoinPredicate.example(JoinType.JOIN_FULL_OUTER, "e1");
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)jp1, (Object)jp1);
    }

    public void testEquivalence() {
        JoinPredicate jp1 = TestJoinPredicate.example(JoinType.JOIN_FULL_OUTER, "e1");
        JoinPredicate jp2 = TestJoinPredicate.example(JoinType.JOIN_FULL_OUTER, "e1");
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)jp1, (Object)jp2);
    }

    public void testCloneEquivalence() {
        JoinPredicate jp1 = TestJoinPredicate.example(JoinType.JOIN_UNION, "e1");
        JoinPredicate jp2 = (JoinPredicate)jp1.clone();
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)jp1, (Object)jp2);
    }

    public void testNonEquivalence1() {
        JoinPredicate jp1 = TestJoinPredicate.example(JoinType.JOIN_FULL_OUTER, "e1", "e2");
        JoinPredicate jp2 = TestJoinPredicate.example(JoinType.JOIN_FULL_OUTER, "e400");
        int equals = -1;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)jp1, (Object)jp2);
    }

    public void testNonEquivalence2() {
        JoinPredicate jp1 = TestJoinPredicate.example(JoinType.JOIN_LEFT_OUTER, "e1", "e2");
        JoinPredicate jp2 = TestJoinPredicate.example(JoinType.JOIN_LEFT_OUTER, "e2", "e1");
        int equals = -1;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)jp1, (Object)jp2);
    }

    public void testNonEquivalence3() {
        JoinPredicate jp1 = TestJoinPredicate.example(JoinType.JOIN_LEFT_OUTER, "e1");
        JoinPredicate jp2 = TestJoinPredicate.example(JoinType.JOIN_RIGHT_OUTER, "e1");
        int equals = -1;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)jp1, (Object)jp2);
    }
}

