/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.postgresql.Driver;
import org.teiid.jdbc.TestMMDatabaseMetaData;
import org.teiid.transport.TestODBCSocketTransport;

public class TestODBCSSL {
    TestODBCSocketTransport.FakeOdbcServer odbcServer = new TestODBCSocketTransport.FakeOdbcServer();

    @After
    public void tearDown() {
        this.odbcServer.stop();
    }

    @Test
    public void testSelectSsl() throws Exception {
        this.odbcServer.start(TestODBCSocketTransport.Mode.ENABLED);
        Driver d = new Driver();
        Properties p = new Properties();
        p.setProperty("user", "testuser");
        p.setProperty("password", "testpassword");
        p.setProperty("ssl", "true");
        p.setProperty("sslfactory", TestODBCSocketTransport.AnonSSLSocketFactory.class.getName());
        Connection conn = d.connect("jdbc:postgresql://" + this.odbcServer.addr.getHostName() + ":" + this.odbcServer.odbcTransport.getPort() + "/parts", p);
        Statement s = conn.createStatement();
        Assert.assertTrue((boolean)s.execute("select * from tables order by name"));
        TestMMDatabaseMetaData.compareResultSet("TestODBCSocketTransport/testSelect", s.getResultSet());
        p.remove("ssl");
        try {
            conn = d.connect("jdbc:postgresql://" + this.odbcServer.addr.getHostName() + ":" + this.odbcServer.odbcTransport.getPort() + "/parts", p);
            Assert.fail((String)"should require ssl");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Test(expected=SQLException.class)
    public void testLogin() throws Exception {
        this.odbcServer.start(TestODBCSocketTransport.Mode.LOGIN);
        Driver d = new Driver();
        Properties p = new Properties();
        p.setProperty("user", "testuser");
        p.setProperty("password", "testpassword");
        d.connect("jdbc:postgresql://" + this.odbcServer.addr.getHostName() + ":" + this.odbcServer.odbcTransport.getPort() + "/parts", p);
    }

    @Test(expected=SQLException.class)
    public void testNonSSL() throws Exception {
        this.odbcServer.start(TestODBCSocketTransport.Mode.DISABLED);
        Driver d = new Driver();
        Properties p = new Properties();
        p.setProperty("user", "testuser");
        p.setProperty("password", "testpassword");
        p.setProperty("ssl", "true");
        p.setProperty("sslfactory", TestODBCSocketTransport.AnonSSLSocketFactory.class.getName());
        d.connect("jdbc:postgresql://" + this.odbcServer.addr.getHostName() + ":" + this.odbcServer.odbcTransport.getPort() + "/parts", p);
    }
}

