/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.teiid.common.buffer.AutoCleanupUtil;
import org.teiid.common.buffer.ExtensibleBufferedInputStream;

public abstract class FileStore
implements AutoCleanupUtil.Removable {
    private AtomicBoolean removed = new AtomicBoolean();

    public abstract long getLength();

    public abstract void setLength(long var1) throws IOException;

    public int read(long fileOffset, byte[] b, int offSet, int length) throws IOException {
        this.checkRemoved();
        return this.readWrite(fileOffset, b, offSet, length, false);
    }

    private void checkRemoved() throws IOException {
        if (this.removed.get()) {
            throw new IOException("already removed");
        }
    }

    protected abstract int readWrite(long var1, byte[] var3, int var4, int var5, boolean var6) throws IOException;

    public void readFully(long fileOffset, byte[] b, int offSet, int length) throws IOException {
        int count;
        if (length == 0) {
            return;
        }
        int n = 0;
        do {
            if ((count = this.read(fileOffset + (long)n, b, offSet + n, length - n)) > 0 || length <= 0) continue;
            throw new IOException("not enough bytes available");
        } while ((n += count) < length);
    }

    public synchronized void write(byte[] bytes, int offset, int length) throws IOException {
        this.write(this.getLength(), bytes, offset, length);
    }

    public void write(long start, byte[] bytes, int offset, int length) throws IOException {
        int count;
        int n = 0;
        do {
            this.checkRemoved();
            count = this.readWrite(start + (long)n, bytes, offset + n, length - n, true);
            if (count > 0 || length <= 0) continue;
            throw new IOException("not enough bytes available");
        } while ((n += count) < length);
    }

    @Override
    public void remove() {
        if (this.removed.compareAndSet(false, true)) {
            this.removeDirect();
        }
    }

    protected abstract void removeDirect();

    public InputStream createInputStream(final long start, final long length) {
        return new ExtensibleBufferedInputStream(){
            private long offset;
            private long streamLength;
            private ByteBuffer bb;
            {
                this.offset = start;
                this.streamLength = length;
                this.bb = ByteBuffer.allocate(8192);
            }

            @Override
            protected ByteBuffer nextBuffer() throws IOException {
                int len = this.bb.capacity();
                if (this.streamLength != -1L && (long)len > this.streamLength) {
                    len = (int)this.streamLength;
                }
                if (this.streamLength == -1L || this.streamLength > 0L) {
                    int bytes = FileStore.this.read(this.offset, this.bb.array(), 0, len);
                    if (bytes == -1) {
                        return null;
                    }
                    this.bb.rewind();
                    this.bb.limit(bytes);
                    this.offset += (long)bytes;
                    if (this.streamLength != -1L) {
                        this.streamLength -= (long)bytes;
                    }
                    return this.bb;
                }
                return null;
            }
        };
    }

    public InputStream createInputStream(long start) {
        return this.createInputStream(start, -1L);
    }

    public OutputStream createOutputStream() {
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                throw new UnsupportedOperationException("buffered reading must be used");
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                FileStore.this.write(b, off, len);
            }
        };
    }

    public FileStoreOutputStream createOutputStream(int maxMemorySize) {
        return new FileStoreOutputStream(maxMemorySize);
    }

    public final class FileStoreOutputStream
    extends OutputStream {
        private byte[] buffer;
        private int count;
        private boolean bytesWritten;
        private boolean closed;
        private byte[] singleByte = new byte[1];

        public FileStoreOutputStream(int size) {
            this.buffer = new byte[size];
        }

        @Override
        public void write(int b) throws IOException {
            this.singleByte[0] = (byte)b;
            this.write(this.singleByte, 0, 1);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.checkOpen();
            if (len > this.buffer.length) {
                this.flushBuffer();
                this.writeDirect(b, off, len);
                return;
            }
            int bufferedLength = Math.min(len, this.buffer.length - this.count);
            if (this.count < this.buffer.length) {
                System.arraycopy(b, off, this.buffer, this.count, bufferedLength);
                this.count += bufferedLength;
                if (bufferedLength == len) {
                    return;
                }
            }
            this.flushBuffer();
            System.arraycopy(b, off + bufferedLength, this.buffer, this.count, len - bufferedLength);
            this.count += len - bufferedLength;
        }

        private void writeDirect(byte[] b, int off, int len) throws IOException {
            FileStore.this.write(b, off, len);
            this.bytesWritten = true;
        }

        public void flushBuffer() throws IOException {
            this.checkOpen();
            if (this.count > 0) {
                this.writeDirect(this.buffer, 0, this.count);
                this.count = 0;
            }
        }

        public byte[] getBuffer() {
            return this.buffer;
        }

        public int getCount() {
            return this.count;
        }

        public boolean bytesWritten() {
            return this.bytesWritten;
        }

        @Override
        public void flush() throws IOException {
            if (this.bytesWritten) {
                this.flushBuffer();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.flush();
            this.closed = true;
            this.buffer = (byte[])(this.bytesWritten ? null : Arrays.copyOf(this.buffer, this.count));
        }

        private void checkOpen() {
            if (this.closed) {
                throw new IllegalStateException("Alread closed");
            }
        }
    }
}

