/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core;

import java.lang.reflect.InvocationTargetException;
import org.teiid.core.BundleUtil;
import org.teiid.core.CorePlugin;
import org.teiid.core.TeiidException;
import org.teiid.core.util.ExceptionUtil;

public class TeiidRuntimeException
extends RuntimeException {
    public static final long serialVersionUID = -4035276728007979320L;
    public static final String CAUSED_BY_STRING = CorePlugin.Util.getString("RuntimeException.Caused_by");
    private String code;

    public TeiidRuntimeException() {
    }

    public TeiidRuntimeException(String message) {
        super(message);
    }

    TeiidRuntimeException(String code, String message) {
        super(message);
        this.setCode(code);
    }

    public TeiidRuntimeException(BundleUtil.Event code, String message) {
        super(message);
        this.setCode(code.toString());
    }

    public TeiidRuntimeException(BundleUtil.Event code, Throwable t) {
        super(t);
        this.setCode(code.toString());
    }

    public TeiidRuntimeException(Throwable e) {
        super(e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException().getMessage() : (e == null ? null : e.getMessage()), e);
        this.setCode(TeiidException.getCode(e));
    }

    public TeiidRuntimeException(BundleUtil.Event event, Throwable e, String message) {
        super(message, e);
        this.setCode(event.toString());
    }

    public String getCode() {
        return this.code;
    }

    private void setCode(String code) {
        this.code = code;
    }

    public String getFullMessage() {
        return ExceptionUtil.getLinkedMessagesVerbose(this);
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        if (this.code == null || this.code.length() == 0 || message.startsWith(this.code)) {
            return message;
        }
        return this.code + " " + message;
    }
}

