/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.Transform;
import org.teiid.core.types.TransformationException;

public class BooleanToNumberTransform
extends Transform {
    private Object trueVal;
    private Object falseVal;
    private Class<?> targetType;

    public BooleanToNumberTransform(Object trueVal, Object falseVal) {
        this.trueVal = trueVal;
        this.falseVal = falseVal;
        this.targetType = trueVal.getClass();
    }

    public Class getSourceType() {
        return DataTypeManager.DefaultDataClasses.BOOLEAN;
    }

    public Class getTargetType() {
        return this.targetType;
    }

    @Override
    public Object transformDirect(Object value) throws TransformationException {
        return value.equals(Boolean.TRUE) ? this.trueVal : this.falseVal;
    }
}

