/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr;

import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.dqp.internal.datamgr.RuntimeMetadataImpl;
import org.teiid.metadata.MetadataStore;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;

public class TestMetadataFactory {
    private static final String MY_RESOURCE_PATH = "my/resource/path";
    private RuntimeMetadataImpl metadataFactory;
    static VirtualFile root;
    static Closeable fileMount;

    @BeforeClass
    public static void beforeClass() throws IOException {
        FileWriter f = new FileWriter(UnitTestUtil.getTestScratchPath() + "/foo");
        f.write("ResourceContents");
        f.close();
        root = VFS.getChild((String)"location");
        fileMount = VFS.mountReal((File)new File(UnitTestUtil.getTestScratchPath()), (VirtualFile)root);
    }

    @AfterClass
    public static void afterClass() throws IOException {
        fileMount.close();
    }

    @Before
    public void setUp() {
        MetadataStore metadataStore = new MetadataStore();
        CompositeMetadataStore store = new CompositeMetadataStore(metadataStore);
        VDBMetaData vdbMetaData = new VDBMetaData();
        vdbMetaData.setName("foo");
        vdbMetaData.setVersion(1);
        LinkedHashMap<String, TransformationMetadata.Resource> vdbEntries = new LinkedHashMap<String, TransformationMetadata.Resource>();
        vdbEntries.put(MY_RESOURCE_PATH, new TransformationMetadata.Resource(root.getChild("foo"), true));
        this.metadataFactory = new RuntimeMetadataImpl((QueryMetadataInterface)new TransformationMetadata(vdbMetaData, store, vdbEntries, null, null));
    }

    @Test
    public void testGetVDBResourcePaths() throws Exception {
        String[] expectedPaths = new String[]{MY_RESOURCE_PATH};
        String[] mfPaths = this.metadataFactory.getVDBResourcePaths();
        Assert.assertEquals((long)expectedPaths.length, (long)mfPaths.length);
        for (int i = 0; i < expectedPaths.length; ++i) {
            Assert.assertEquals((Object)expectedPaths[i], (Object)mfPaths[i]);
        }
    }

    @Test
    public void testGetBinaryVDBResource() throws Exception {
        byte[] expectedBytes = "ResourceContents".getBytes();
        byte[] mfBytes = this.metadataFactory.getBinaryVDBResource(MY_RESOURCE_PATH);
        Assert.assertEquals((long)expectedBytes.length, (long)mfBytes.length);
        for (int i = 0; i < expectedBytes.length; ++i) {
            Assert.assertEquals((String)("Byte at index " + i + " differs from expected content"), (long)expectedBytes[i], (long)mfBytes[i]);
        }
    }

    @Test
    public void testGetCharacterVDBResource() throws Exception {
        Assert.assertEquals((Object)"ResourceContents", (Object)this.metadataFactory.getCharacterVDBResource(MY_RESOURCE_PATH));
    }
}

