/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.mockito.Mockito;
import org.teiid.adminapi.impl.RequestMetadata;
import org.teiid.client.RequestMessage;
import org.teiid.client.SourceWarning;
import org.teiid.core.TeiidException;
import org.teiid.dqp.internal.datamgr.FakeTransactionService;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.DataTierTupleSource;
import org.teiid.dqp.internal.process.RequestWorkItem;
import org.teiid.dqp.message.AtomicRequestMessage;
import org.teiid.dqp.message.RequestID;
import org.teiid.dqp.service.TransactionService;
import org.teiid.query.sql.lang.Command;

public class TestDQPCoreRequestHandling
extends TestCase {
    private static final String SESSION_STRING = "2";

    public TestDQPCoreRequestHandling(String name) {
        super(name);
    }

    private void compareReqInfos(Collection<RequestID> reqs1, Collection<RequestMetadata> reqs2) {
        HashSet<RequestID> reqIDs2 = new HashSet<RequestID>();
        for (RequestMetadata requestInfo : reqs2) {
            reqIDs2.add(new RequestID(requestInfo.getSessionId(), requestInfo.getExecutionId()));
        }
        TestDQPCoreRequestHandling.assertEquals((String)"Collections of request infos are not the same: ", new HashSet<RequestID>(reqs1), reqIDs2);
    }

    public void testGetRequestsSessionToken1() {
        DQPCore rm = new DQPCore();
        Set<RequestID> reqs = Collections.emptySet();
        List actualReqs = rm.getRequestsForSession(SESSION_STRING);
        this.compareReqInfos(reqs, actualReqs);
    }

    public void testGetRequestsSessionToken2() {
        DQPCore rm = new DQPCore();
        rm.setTransactionService((TransactionService)new FakeTransactionService());
        HashSet<RequestID> reqs = new HashSet<RequestID>();
        RequestID id = this.addRequest(rm, SESSION_STRING, 1);
        reqs.add(id);
        List actualReqs = rm.getRequestsForSession(SESSION_STRING);
        this.compareReqInfos(reqs, actualReqs);
    }

    private RequestID addRequest(DQPCore rm, String sessionId, int executionId) {
        RequestMessage r0 = new RequestMessage("test command");
        RequestID id = new RequestID(sessionId, (long)executionId);
        TestDQPCoreRequestHandling.addRequest(rm, r0, id, null, null);
        return id;
    }

    public void testGetRequestsSessionToken3() {
        DQPCore rm = new DQPCore();
        rm.setTransactionService((TransactionService)new FakeTransactionService());
        HashSet<RequestID> reqs = new HashSet<RequestID>();
        reqs.add(this.addRequest(rm, SESSION_STRING, 0));
        reqs.add(this.addRequest(rm, SESSION_STRING, 1));
        reqs.add(this.addRequest(rm, SESSION_STRING, 2));
        List actualReqs = rm.getRequestsForSession(SESSION_STRING);
        this.compareReqInfos(reqs, actualReqs);
    }

    private SourceWarning getSourceFailures(String model, String binding, String message) {
        return new SourceWarning(model, binding, (Throwable)new TeiidException(message), true);
    }

    public void testAddRequest() {
        DQPCore rm = new DQPCore();
        rm.setTransactionService((TransactionService)new FakeTransactionService());
        RequestMessage r0 = new RequestMessage("foo");
        RequestID requestID = new RequestID(SESSION_STRING, 1L);
        TestDQPCoreRequestHandling.addRequest(rm, r0, requestID, null, null);
    }

    static RequestWorkItem addRequest(DQPCore rm, RequestMessage requestMsg, RequestID id, Command originalCommand, DQPWorkContext workContext) {
        if (workContext == null) {
            workContext = new DQPWorkContext();
            workContext.getSession().setSessionId(id.getConnectionID());
            workContext.getSession().setUserName("foo");
        }
        RequestWorkItem workItem = new RequestWorkItem(rm, requestMsg, null, null, id, workContext);
        workItem.setOriginalCommand(originalCommand);
        DQPCore.ClientState state = rm.getClientState(id.getConnectionID(), true);
        rm.addRequest(id, workItem, state);
        return workItem;
    }

    public void testGetConnectorInfo() {
        DQPCore rm = new DQPCore();
        rm.setTransactionService((TransactionService)new FakeTransactionService());
        RequestMessage r0 = new RequestMessage("foo");
        RequestID requestID = new RequestID(SESSION_STRING, 1L);
        RequestWorkItem workItem = TestDQPCoreRequestHandling.addRequest(rm, r0, requestID, null, null);
        AtomicRequestMessage atomicReq = new AtomicRequestMessage(workItem.requestMsg, workItem.getDqpWorkContext(), 1);
        DataTierTupleSource info = (DataTierTupleSource)Mockito.mock(DataTierTupleSource.class);
        workItem.addConnectorRequest(atomicReq.getAtomicRequestID(), info);
        DataTierTupleSource arInfo = workItem.getConnectorRequest(atomicReq.getAtomicRequestID());
        TestDQPCoreRequestHandling.assertTrue((arInfo == info ? 1 : 0) != 0);
    }

    public void testRemoveConnectorInfo() {
        DQPCore rm = new DQPCore();
        rm.setTransactionService((TransactionService)new FakeTransactionService());
        RequestMessage r0 = new RequestMessage("foo");
        RequestID requestID = new RequestID(SESSION_STRING, 1L);
        RequestWorkItem workItem = TestDQPCoreRequestHandling.addRequest(rm, r0, requestID, null, null);
        AtomicRequestMessage atomicReq = new AtomicRequestMessage(workItem.requestMsg, workItem.getDqpWorkContext(), 1);
        DataTierTupleSource info = (DataTierTupleSource)Mockito.mock(DataTierTupleSource.class);
        workItem.addConnectorRequest(atomicReq.getAtomicRequestID(), info);
        workItem.closeAtomicRequest(atomicReq.getAtomicRequestID());
        DataTierTupleSource arInfo = workItem.getConnectorRequest(atomicReq.getAtomicRequestID());
        TestDQPCoreRequestHandling.assertNull((Object)arInfo);
    }
}

