/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process.multisource;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.teiid.dqp.internal.process.multisource.MultiSourceCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.AllCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.FakeCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;

public class TestMultiSourceCapabilitiesFinder
extends TestCase {
    public void test1() throws Exception {
        String SINGLE_MODEL = "singleModel";
        String MULTI_MODEL = "multiModel";
        FakeCapabilitiesFinder realFinder = new FakeCapabilitiesFinder();
        realFinder.addCapabilities("singleModel", (SourceCapabilities)new AllCapabilities());
        realFinder.addCapabilities("multiModel", (SourceCapabilities)new AllCapabilities());
        ArrayList<String> models = new ArrayList<String>();
        models.add("multiModel");
        MultiSourceCapabilitiesFinder finder = new MultiSourceCapabilitiesFinder((CapabilitiesFinder)realFinder, models);
        SourceCapabilities singleCaps = finder.findCapabilities("singleModel");
        TestMultiSourceCapabilitiesFinder.assertEquals((boolean)true, (boolean)singleCaps.supportsCapability(SourceCapabilities.Capability.QUERY_UNION));
        TestMultiSourceCapabilitiesFinder.assertEquals((boolean)true, (boolean)singleCaps.supportsCapability(SourceCapabilities.Capability.QUERY_ORDERBY));
        TestMultiSourceCapabilitiesFinder.assertEquals((boolean)true, (boolean)singleCaps.supportsCapability(SourceCapabilities.Capability.QUERY_SELECT_DISTINCT));
        TestMultiSourceCapabilitiesFinder.assertEquals((boolean)true, (boolean)singleCaps.supportsCapability(SourceCapabilities.Capability.QUERY_AGGREGATES_AVG));
        SourceCapabilities multiCaps = finder.findCapabilities("multiModel");
        TestMultiSourceCapabilitiesFinder.assertEquals((boolean)false, (boolean)multiCaps.supportsCapability(SourceCapabilities.Capability.QUERY_UNION));
        TestMultiSourceCapabilitiesFinder.assertEquals((boolean)false, (boolean)multiCaps.supportsCapability(SourceCapabilities.Capability.QUERY_ORDERBY));
        TestMultiSourceCapabilitiesFinder.assertEquals((boolean)false, (boolean)multiCaps.supportsCapability(SourceCapabilities.Capability.QUERY_SELECT_DISTINCT));
        TestMultiSourceCapabilitiesFinder.assertEquals((boolean)false, (boolean)multiCaps.supportsCapability(SourceCapabilities.Capability.QUERY_AGGREGATES_AVG));
    }
}

