/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.QueryOptimizer;
import org.teiid.query.optimizer.TestLimit;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.FakeCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.optimizer.relational.AliasGenerator;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.CapabilitiesUtil;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.relational.AccessNode;
import org.teiid.query.processor.relational.DependentAccessNode;
import org.teiid.query.processor.relational.EnhancedSortMergeJoinStrategy;
import org.teiid.query.processor.relational.GroupingNode;
import org.teiid.query.processor.relational.JoinNode;
import org.teiid.query.processor.relational.JoinStrategy;
import org.teiid.query.processor.relational.MergeJoinStrategy;
import org.teiid.query.processor.relational.NestedLoopJoinStrategy;
import org.teiid.query.processor.relational.NestedTableJoinStrategy;
import org.teiid.query.processor.relational.NullNode;
import org.teiid.query.processor.relational.PlanExecutionNode;
import org.teiid.query.processor.relational.ProjectIntoNode;
import org.teiid.query.processor.relational.ProjectNode;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.RelationalPlan;
import org.teiid.query.processor.relational.SelectNode;
import org.teiid.query.processor.relational.SortNode;
import org.teiid.query.processor.relational.SortUtility;
import org.teiid.query.processor.relational.UnionAllNode;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.TestResolver;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.GroupCollectorVisitor;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.util.CommandContext;
import org.teiid.query.validator.Validator;
import org.teiid.query.validator.ValidatorReport;
import org.teiid.translator.ExecutionFactory;

public class TestOptimizer {
    public static final int[] FULL_PUSHDOWN = new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final boolean SHOULD_SUCCEED = true;
    public static final boolean SHOULD_FAIL = false;
    private static final Class<?>[] COUNT_TYPES = new Class[]{AccessNode.class, DependentAccessNode.class, DependentSelectNode.class, DependentProjectNode.class, DupRemoveNode.class, GroupingNode.class, NestedLoopJoinStrategy.class, MergeJoinStrategy.class, NullNode.class, PlanExecutionNode.class, ProjectNode.class, SelectNode.class, SortNode.class, UnionAllNode.class};
    public static final boolean DEBUG = false;

    public static BasicSourceCapabilities getTypicalCapabilities() {
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_DISTINCT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER_FULL, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_BETWEEN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_ORDERED, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_LIKE, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_LIKE_ESCAPE, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_ISNULL, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_OR, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_NOT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY_UNRELATED, true);
        caps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)new Integer(1000));
        return caps;
    }

    public static CapabilitiesFinder getGenericFinder(boolean supportsJoins) {
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        if (!supportsJoins) {
            caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, false);
            caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, false);
        }
        return new DefaultCapabilitiesFinder((SourceCapabilities)caps);
    }

    public static CapabilitiesFinder getGenericFinder() {
        return TestOptimizer.getGenericFinder(true);
    }

    public static ProcessorPlan helpPlan(String sql, QueryMetadataInterface md, String[] expectedAtomic) {
        return TestOptimizer.helpPlan(sql, md, null, TestOptimizer.getGenericFinder(), expectedAtomic, true);
    }

    public static ProcessorPlan helpPlan(String sql, QueryMetadataInterface md, String[] expected, CapabilitiesFinder capFinder, ComparisonMode mode) throws TeiidComponentException, TeiidProcessingException {
        return TestOptimizer.helpPlan(sql, md, null, capFinder, expected, mode);
    }

    public static ProcessorPlan helpPlan(String sql, QueryMetadataInterface md, String[] expectedAtomic, ComparisonMode mode) throws TeiidComponentException, TeiidProcessingException {
        return TestOptimizer.helpPlan(sql, md, null, TestOptimizer.getGenericFinder(), expectedAtomic, mode);
    }

    public static ProcessorPlan helpPlan(String sql, QueryMetadataInterface md, List<String> bindings, CapabilitiesFinder capFinder, String[] expectedAtomic, boolean shouldSucceed) {
        Command command;
        try {
            command = TestOptimizer.helpGetCommand(sql, md, bindings);
        }
        catch (TeiidException err) {
            throw new TeiidRuntimeException((Throwable)err);
        }
        return TestOptimizer.helpPlanCommand(command, md, capFinder, null, expectedAtomic, shouldSucceed ? ComparisonMode.CORRECTED_COMMAND_STRING : ComparisonMode.FAILED_PLANNING);
    }

    public static ProcessorPlan helpPlan(String sql, QueryMetadataInterface md, List<String> bindings, CapabilitiesFinder capFinder, String[] expectedAtomic, ComparisonMode mode) throws TeiidComponentException, TeiidProcessingException {
        Command command = TestOptimizer.helpGetCommand(sql, md, bindings);
        return TestOptimizer.helpPlanCommand(command, md, capFinder, null, expectedAtomic, mode);
    }

    public static Command helpGetCommand(String sql, QueryMetadataInterface md, List<String> bindings) throws TeiidComponentException, TeiidProcessingException {
        Command command = null;
        if (bindings != null && !bindings.isEmpty()) {
            command = TestResolver.helpResolveWithBindings(sql, md, bindings);
        } else {
            command = QueryParser.getQueryParser().parseCommand(sql);
            QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)md);
        }
        ValidatorReport repo = Validator.validate((LanguageObject)command, (QueryMetadataInterface)md);
        ArrayList failures = new ArrayList();
        repo.collectInvalidObjects(failures);
        if (failures.size() > 0) {
            Assert.fail((String)("Exception during validation (" + repo));
        }
        command = QueryRewriter.rewrite((Command)command, (QueryMetadataInterface)md, (CommandContext)new CommandContext());
        return command;
    }

    public static ProcessorPlan helpPlanCommand(Command command, QueryMetadataInterface md, CapabilitiesFinder capFinder, AnalysisRecord analysisRecord, String[] expectedAtomic, ComparisonMode mode) {
        if (capFinder == null) {
            capFinder = TestOptimizer.getGenericFinder();
        }
        ProcessorPlan plan = TestOptimizer.getPlan(command, md, capFinder, analysisRecord, mode != ComparisonMode.FAILED_PLANNING, new CommandContext());
        if (mode == ComparisonMode.CORRECTED_COMMAND_STRING) {
            TestOptimizer.checkAtomicQueries(expectedAtomic, plan, md, capFinder);
        } else if (mode == ComparisonMode.EXACT_COMMAND_STRING) {
            TestOptimizer.checkAtomicQueries(expectedAtomic, plan);
        }
        return plan;
    }

    public static void checkAtomicQueries(String[] expectedAtomic, ProcessorPlan plan) {
        Set<String> actualQueries = TestOptimizer.getAtomicQueries(plan);
        if (actualQueries.size() != 1 || expectedAtomic.length != 1) {
            HashSet<String> expectedQueries = new HashSet<String>(Arrays.asList(expectedAtomic));
            Assert.assertEquals((String)"Did not get expected atomic queries: ", expectedQueries, actualQueries);
        } else {
            Assert.assertEquals((String)"Did not get expected atomic query: ", (Object)expectedAtomic[0], (Object)actualQueries.iterator().next());
        }
    }

    public static void checkAtomicQueries(String[] expectedAtomic, ProcessorPlan plan, QueryMetadataInterface md, CapabilitiesFinder capFinder) {
        Set<String> actualQueries = TestOptimizer.getAtomicQueries(plan);
        HashSet<String> expectedQueries = new HashSet<String>();
        for (int i = 0; i < expectedAtomic.length; ++i) {
            String sql = expectedAtomic[i];
            try {
                Command command = TestOptimizer.helpGetCommand(sql, md, null);
                Collection groups = GroupCollectorVisitor.getGroupsIgnoreInlineViews((LanguageObject)command, (boolean)false);
                GroupSymbol symbol = (GroupSymbol)groups.iterator().next();
                Object modelId = md.getModelID(symbol.getMetadataID());
                boolean supportsGroupAliases = CapabilitiesUtil.supportsGroupAliases((Object)modelId, (QueryMetadataInterface)md, (CapabilitiesFinder)capFinder);
                boolean supportsProjection = CapabilitiesUtil.supports((SourceCapabilities.Capability)SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, (Object)modelId, (QueryMetadataInterface)md, (CapabilitiesFinder)capFinder);
                command.acceptVisitor((LanguageVisitor)new AliasGenerator(supportsGroupAliases, !supportsProjection));
                expectedQueries.add(command.toString());
                continue;
            }
            catch (Exception err) {
                throw new RuntimeException(err);
            }
        }
        Assert.assertEquals((String)"Did not get expected atomic queries: ", expectedQueries, actualQueries);
    }

    public static ProcessorPlan getPlan(Command command, QueryMetadataInterface md, CapabilitiesFinder capFinder, AnalysisRecord analysisRecord, boolean shouldSucceed, CommandContext cc) {
        ProcessorPlan plan = null;
        if (analysisRecord == null) {
            analysisRecord = new AnalysisRecord(false, false);
        }
        Throwable exception = null;
        try {
            plan = QueryOptimizer.optimizePlan((Command)command, (QueryMetadataInterface)md, null, (CapabilitiesFinder)capFinder, (AnalysisRecord)analysisRecord, (CommandContext)cc);
        }
        catch (QueryPlannerException e) {
            exception = e;
        }
        catch (TeiidComponentException e) {
            exception = e;
        }
        catch (Throwable e) {
            throw new TeiidRuntimeException(e);
        }
        if (!shouldSucceed) {
            Assert.assertNotNull((String)"Expected exception but did not get one.", (Object)exception);
            return null;
        }
        if (plan == null) {
            throw new TeiidRuntimeException(exception);
        }
        Assert.assertNotNull((String)"Output elements are null", (Object)plan.getOutputElements());
        return plan;
    }

    public static Set<String> getAtomicQueries(ProcessorPlan plan) {
        HashSet<Command> atomicQueries = new HashSet<Command>();
        if (plan instanceof RelationalPlan) {
            TestOptimizer.getAtomicCommands(((RelationalPlan)plan).getRootNode(), atomicQueries);
        }
        HashSet<String> stringQueries = new HashSet<String>();
        for (Command command : atomicQueries) {
            stringQueries.add(command.toString());
        }
        return stringQueries;
    }

    private static void getAtomicCommands(RelationalNode node, Set<Command> atomicQueries) {
        if (node instanceof AccessNode) {
            AccessNode accessNode = (AccessNode)node;
            atomicQueries.add(accessNode.getCommand());
        }
        RelationalNode[] children = node.getChildren();
        for (int i = 0; i < children.length && children[i] != null; ++i) {
            TestOptimizer.getAtomicCommands(children[i], atomicQueries);
        }
    }

    public static void checkNodeTypes(ProcessorPlan root, int[] expectedCounts) {
        TestOptimizer.checkNodeTypes(root, expectedCounts, COUNT_TYPES);
    }

    public static void checkNodeTypes(ProcessorPlan root, int[] expectedCounts, Class<?>[] types) {
        if (!(root instanceof RelationalPlan)) {
            return;
        }
        int[] actualCounts = new int[types.length];
        TestOptimizer.collectCounts(((RelationalPlan)root).getRootNode(), actualCounts, types);
        for (int i = 0; i < expectedCounts.length; ++i) {
            Assert.assertEquals((String)("Did not find the correct number of nodes for type " + types[i]), (long)expectedCounts[i], (long)actualCounts[i]);
        }
    }

    static void collectCounts(RelationalNode relationalNode, int[] counts, Class<?>[] types) {
        Class<?> nodeType = relationalNode.getClass();
        if (nodeType.equals(JoinNode.class)) {
            JoinStrategy strategy = ((JoinNode)relationalNode).getJoinStrategy();
            if (((JoinNode)relationalNode).getJoinType().equals((Object)JoinType.JOIN_SEMI)) {
                TestOptimizer.updateCounts(SemiJoin.class, counts, types);
            } else if (((JoinNode)relationalNode).getJoinType().equals((Object)JoinType.JOIN_ANTI_SEMI)) {
                TestOptimizer.updateCounts(AntiSemiJoin.class, counts, types);
            }
            if (strategy instanceof NestedLoopJoinStrategy) {
                TestOptimizer.updateCounts(NestedLoopJoinStrategy.class, counts, types);
            } else if (strategy instanceof MergeJoinStrategy) {
                TestOptimizer.updateCounts(MergeJoinStrategy.class, counts, types);
                if (strategy instanceof EnhancedSortMergeJoinStrategy) {
                    TestOptimizer.updateCounts(EnhancedSortMergeJoinStrategy.class, counts, types);
                }
            } else if (strategy instanceof NestedTableJoinStrategy) {
                TestOptimizer.updateCounts(NestedTableJoinStrategy.class, counts, types);
            }
            if (((JoinNode)relationalNode).isDependent()) {
                TestOptimizer.updateCounts(DependentJoin.class, counts, types);
            }
        } else if (nodeType.equals(ProjectNode.class)) {
            if (ValueIteratorProviderCollectorVisitor.getValueIteratorProviders((Collection)((ProjectNode)relationalNode).getSelectSymbols()).isEmpty()) {
                TestOptimizer.updateCounts(ProjectNode.class, counts, types);
            } else {
                TestOptimizer.updateCounts(DependentProjectNode.class, counts, types);
            }
        } else if (nodeType.equals(SelectNode.class)) {
            if (ValueIteratorProviderCollectorVisitor.getValueIteratorProviders((LanguageObject)((SelectNode)relationalNode).getCriteria()).isEmpty()) {
                TestOptimizer.updateCounts(SelectNode.class, counts, types);
            } else {
                TestOptimizer.updateCounts(DependentSelectNode.class, counts, types);
            }
        } else if (nodeType.equals(SortNode.class)) {
            SortUtility.Mode mode = ((SortNode)relationalNode).getMode();
            switch (mode) {
                case DUP_REMOVE: {
                    TestOptimizer.updateCounts(DupRemoveNode.class, counts, types);
                    break;
                }
                case DUP_REMOVE_SORT: {
                    TestOptimizer.updateCounts(DupRemoveSortNode.class, counts, types);
                    break;
                }
                case SORT: {
                    TestOptimizer.updateCounts(SortNode.class, counts, types);
                }
            }
        } else {
            TestOptimizer.updateCounts(nodeType, counts, types);
        }
        RelationalNode[] children = relationalNode.getChildren();
        for (int i = 0; i < children.length && children[i] != null; ++i) {
            TestOptimizer.collectCounts(children[i], counts, types);
        }
    }

    private static void updateCounts(Class<?> nodeClass, int[] counts, Class<?>[] types) {
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].equals(nodeClass)) continue;
            counts[i] = counts[i] + 1;
            return;
        }
    }

    public static void checkDependentJoinCount(ProcessorPlan plan, int expectedCount) {
        TestOptimizer.checkNodeTypes(plan, new int[]{expectedCount}, new Class[]{DependentJoin.class});
    }

    public static TransformationMetadata example1() {
        MetadataStore metadataStore = new MetadataStore();
        Schema pm1 = RealMetadataFactory.createPhysicalModel("pm1", metadataStore);
        Schema pm2 = RealMetadataFactory.createPhysicalModel("pm2", metadataStore);
        Schema vm1 = RealMetadataFactory.createVirtualModel("vm1", metadataStore);
        Table pm1g1 = RealMetadataFactory.createPhysicalGroup("g1", pm1);
        Table pm1g2 = RealMetadataFactory.createPhysicalGroup("g2", pm1);
        Table pm1g3 = RealMetadataFactory.createPhysicalGroup("g3", pm1);
        Table pm1g4 = RealMetadataFactory.createPhysicalGroup("g4", pm1);
        Table pm1g5 = RealMetadataFactory.createPhysicalGroup("g5", pm1);
        Table pm1g6 = RealMetadataFactory.createPhysicalGroup("g6", pm1);
        Table pm1g7 = RealMetadataFactory.createPhysicalGroup("g7", pm1);
        Table pm1g8 = RealMetadataFactory.createPhysicalGroup("g8", pm1);
        Table pm2g1 = RealMetadataFactory.createPhysicalGroup("g1", pm2);
        Table pm2g2 = RealMetadataFactory.createPhysicalGroup("g2", pm2);
        Table pm2g3 = RealMetadataFactory.createPhysicalGroup("g3", pm2);
        RealMetadataFactory.createElements(pm1g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(pm1g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(pm1g3, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(pm1g4, new String[]{"e1"}, new String[]{"string"});
        RealMetadataFactory.createElements(pm1g5, new String[]{"e1"}, new String[]{"string"});
        RealMetadataFactory.createElements(pm1g6, new String[]{"e1"}, new String[]{"string"});
        RealMetadataFactory.createElements(pm1g7, new String[]{"e1"}, new String[]{"string"});
        RealMetadataFactory.createElements(pm1g8, new String[]{"e1"}, new String[]{"string"});
        RealMetadataFactory.createElements(pm2g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(pm2g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(pm2g3, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        QueryNode vm1g1n1 = new QueryNode("SELECT * FROM pm1.g1");
        Table vm1g1 = RealMetadataFactory.createUpdatableVirtualGroup("g1", vm1, vm1g1n1);
        QueryNode vm1g2n1 = new QueryNode("SELECT * FROM pm1.g1");
        Table vm1g2 = RealMetadataFactory.createUpdatableVirtualGroup("g2", vm1, vm1g2n1);
        QueryNode vm1sub1n1 = new QueryNode("SELECT * FROM vm1.g1 WHERE e1 IN (SELECT e1 FROM vm1.g3)");
        Table vm1sub1 = RealMetadataFactory.createVirtualGroup("sub1", vm1, vm1sub1n1);
        QueryNode vm1g3n1 = new QueryNode("SELECT * FROM pm1.g2");
        Table vm1g3 = RealMetadataFactory.createUpdatableVirtualGroup("g3", vm1, vm1g3n1);
        QueryNode vm1g4n1 = new QueryNode("SELECT pm1.g1.e1,  g2.e1 FROM pm1.g1, pm1.g2 g2 WHERE pm1.g1.e1= g2.e1");
        Table vm1g4 = RealMetadataFactory.createUpdatableVirtualGroup("g4", vm1, vm1g4n1);
        QueryNode vm1g5n1 = new QueryNode("SELECT DISTINCT pm1.g1.e1 FROM pm1.g1 ORDER BY pm1.g1.e1");
        Table vm1g5 = RealMetadataFactory.createUpdatableVirtualGroup("g5", vm1, vm1g5n1);
        QueryNode vm1g6n1 = new QueryNode("SELECT e1, convert(e2, string), 3 as e3, ((e2+e4)/3) as e4 FROM pm1.g1");
        Table vm1g6 = RealMetadataFactory.createUpdatableVirtualGroup("g6", vm1, vm1g6n1);
        QueryNode vm1u1n1 = new QueryNode("SELECT * FROM pm1.g1 UNION SELECT * FROM pm1.g2 UNION ALL SELECT * FROM pm1.g3");
        Table vm1u1 = RealMetadataFactory.createUpdatableVirtualGroup("u1", vm1, vm1u1n1);
        QueryNode vm1u2n1 = new QueryNode("SELECT * FROM pm1.g1 UNION SELECT * FROM pm1.g2");
        Table vm1u2 = RealMetadataFactory.createUpdatableVirtualGroup("u2", vm1, vm1u2n1);
        QueryNode vm1u3n1 = new QueryNode("SELECT e1 FROM pm1.g1 UNION SELECT convert(e2, string) as x FROM pm1.g2");
        Table vm1u3 = RealMetadataFactory.createUpdatableVirtualGroup("u3", vm1, vm1u3n1);
        QueryNode vm1u4n1 = new QueryNode("SELECT concat(e1, 'x') as v1 FROM pm1.g1 UNION ALL SELECT e1 FROM pm1.g2");
        Table vm1u4 = RealMetadataFactory.createUpdatableVirtualGroup("u4", vm1, vm1u4n1);
        QueryNode vm1u5n1 = new QueryNode("SELECT concat(e1, 'x') as v1 FROM pm1.g1 UNION ALL SELECT concat('a', e1) FROM pm1.g2");
        Table vm1u5 = RealMetadataFactory.createUpdatableVirtualGroup("u5", vm1, vm1u5n1);
        QueryNode vm1u6n1 = new QueryNode("SELECT x1.e1 AS elem, 'xyz' AS const FROM pm1.g1 AS x1");
        Table vm1u6 = RealMetadataFactory.createUpdatableVirtualGroup("u6", vm1, vm1u6n1);
        QueryNode vm1u7n1 = new QueryNode("SELECT 's1' AS const, e1 FROM pm1.g1 UNION ALL SELECT 's2', e1 FROM pm1.g2");
        Table vm1u7 = RealMetadataFactory.createUpdatableVirtualGroup("u7", vm1, vm1u7n1);
        QueryNode vm1u8n1 = new QueryNode("SELECT const, e1 FROM vm1.u7 UNION ALL SELECT 's3', e1 FROM pm1.g3");
        Table vm1u8 = RealMetadataFactory.createUpdatableVirtualGroup("u8", vm1, vm1u8n1);
        QueryNode vm1u9n1 = new QueryNode("SELECT e1 as a, e1 as b FROM pm1.g1 UNION ALL SELECT e1, e1 FROM pm1.g2");
        Table vm1u9 = RealMetadataFactory.createUpdatableVirtualGroup("u9", vm1, vm1u9n1);
        QueryNode vm1a1n1 = new QueryNode("SELECT e1, SUM(e2) AS sum_e2 FROM pm1.g1 GROUP BY e1");
        Table vm1a1 = RealMetadataFactory.createUpdatableVirtualGroup("a1", vm1, vm1a1n1);
        QueryNode vm1a2n1 = new QueryNode("SELECT e1, SUM(e2) AS sum_e2 FROM pm1.g1 GROUP BY e1 HAVING SUM(e2) > 5");
        Table vm1a2 = RealMetadataFactory.createUpdatableVirtualGroup("a2", vm1, vm1a2n1);
        QueryNode vm1a3n1 = new QueryNode("SELECT SUM(e2) AS sum_e2 FROM pm1.g1");
        Table vm1a3 = RealMetadataFactory.createUpdatableVirtualGroup("a3", vm1, vm1a3n1);
        QueryNode vm1a4n1 = new QueryNode("SELECT COUNT(*) FROM pm1.g1");
        Table vm1a4 = RealMetadataFactory.createUpdatableVirtualGroup("a4", vm1, vm1a4n1);
        QueryNode vm1a5n1 = new QueryNode("SELECT vm1.a4.count FROM vm1.a4 UNION ALL SELECT COUNT(*) FROM pm1.g1");
        Table vm1a5 = RealMetadataFactory.createUpdatableVirtualGroup("a5", vm1, vm1a5n1);
        QueryNode vm1a6n1 = new QueryNode("SELECT COUNT(*) FROM vm1.u2");
        Table vm1a6 = RealMetadataFactory.createUpdatableVirtualGroup("a6", vm1, vm1a6n1);
        QueryNode vm1g7n1 = new QueryNode("select DECODESTRING(e1, 'S,Pay,P,Rec') as e1, e2 FROM pm1.g1");
        Table vm1g7 = RealMetadataFactory.createVirtualGroup("g7", vm1, vm1g7n1);
        RealMetadataFactory.createElements(vm1g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(vm1g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(vm1g3, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(vm1sub1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(vm1g4, new String[]{"e1", "e2"}, new String[]{"string", "string"});
        RealMetadataFactory.createElements(vm1g5, new String[]{"e1"}, new String[]{"string"});
        RealMetadataFactory.createElements(vm1g6, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "string", "integer", "double"});
        RealMetadataFactory.createElements(vm1g7, new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        RealMetadataFactory.createElements(vm1u1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(vm1u2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(vm1u3, new String[]{"e1"}, new String[]{"string"});
        RealMetadataFactory.createElements(vm1u4, new String[]{"v1"}, new String[]{"string"});
        RealMetadataFactory.createElements(vm1u5, new String[]{"v1"}, new String[]{"string"});
        RealMetadataFactory.createElements(vm1u6, new String[]{"elem", "const"}, new String[]{"string", "string"});
        RealMetadataFactory.createElements(vm1u7, new String[]{"const", "e1"}, new String[]{"string", "string"});
        RealMetadataFactory.createElements(vm1u8, new String[]{"const", "e1"}, new String[]{"string", "string"});
        RealMetadataFactory.createElements(vm1u9, new String[]{"a", "b"}, new String[]{"string", "string"});
        RealMetadataFactory.createElements(vm1a1, new String[]{"e1", "sum_e2"}, new String[]{"string", "long"});
        RealMetadataFactory.createElements(vm1a2, new String[]{"e1", "sum_e2"}, new String[]{"string", "long"});
        RealMetadataFactory.createElements(vm1a3, new String[]{"sum_e2"}, new String[]{"long"});
        RealMetadataFactory.createElements(vm1a4, new String[]{"count"}, new String[]{"integer"});
        RealMetadataFactory.createElements(vm1a5, new String[]{"count"}, new String[]{"integer"});
        RealMetadataFactory.createElements(vm1a6, new String[]{"count"}, new String[]{"integer"});
        return RealMetadataFactory.createTransformationMetadata(metadataStore, "example1", new FunctionTree[0]);
    }

    @Test
    public void testVirtualSubqueryINClause_8096() {
        TestOptimizer.helpPlan("SELECT * FROM vm1.sub1", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT pm1.g1.e1, pm1.g1.e2, pm1.g1.e3, pm1.g1.e4 FROM pm1.g1"});
    }

    @Test
    public void testQueryPhysical() {
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT pm1.g1.e1, e2, pm1.g1.e3 as a, e4 as b FROM pm1.g1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT pm1.g1.e1, e2, pm1.g1.e3, e4 FROM pm1.g1"});
        Assert.assertTrue((!plan.requiresTransaction(true) ? 1 : 0) != 0);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testSelectStarPhysical() {
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT * FROM pm1.g1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT pm1.g1.e1, pm1.g1.e2, pm1.g1.e3, pm1.g1.e4 FROM pm1.g1"});
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testQuerySingleSourceVirtual() {
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT * FROM vm1.g1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT pm1.g1.e1, pm1.g1.e2, pm1.g1.e3, pm1.g1.e4 FROM pm1.g1"});
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testQueryMultiSourceVirtual() {
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT * FROM vm1.g2", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT g_0.e1, g_0.e2, g_1.e3, g_1.e4 FROM pm1.g1 AS g_0, pm1.g2 AS g_1 WHERE g_0.e1 = g_1.e1"});
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPhysicalVirtualJoinWithCriteria() throws Exception {
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT vm1.g2.e1 from vm1.g2, pm1.g3 where vm1.g2.e1=pm1.g3.e1 and vm1.g2.e2 > 0", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT g_0.e1 FROM pm1.g1 AS g_0, pm1.g2 AS g_1, pm1.g3 AS g_2 WHERE (g_0.e1 = g_1.e1) AND (g_0.e1 = g_2.e1) AND (g_0.e2 > 0)"}, ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testQueryWithExpression() {
        TestOptimizer.helpPlan("SELECT e4 FROM pm3.g1 WHERE e4 < convert('2001-11-01 10:30:40.42', timestamp)", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT e4 FROM pm3.g1 WHERE e4 < {ts'2001-11-01 10:30:40.42'}"});
    }

    @Test
    public void testInsert() {
        TestOptimizer.helpPlan("Insert into pm1.g1 (pm1.g1.e1, pm1.g1.e2) values ('MyString', 1)", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"INSERT INTO pm1.g1 (pm1.g1.e1, pm1.g1.e2) VALUES ('MyString', 1)"});
    }

    @Test
    public void testUpdate1() {
        TestOptimizer.helpPlan("Update pm1.g1 Set pm1.g1.e1= LTRIM('MyString'), pm1.g1.e2= 1 where pm1.g1.e3= 'true'", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"UPDATE pm1.g1 SET pm1.g1.e1 = 'MyString', pm1.g1.e2 = 1 WHERE pm1.g1.e3 = TRUE"});
    }

    @Test
    public void testUpdate2() throws Exception {
        BasicSourceCapabilities bsc = TestOptimizer.getTypicalCapabilities();
        bsc.setFunctionSupport("convert", true);
        DefaultCapabilitiesFinder dcf = new DefaultCapabilitiesFinder((SourceCapabilities)bsc);
        TestOptimizer.helpPlan("Update pm1.g1 Set pm1.g1.e1= LTRIM('MyString'), pm1.g1.e2= 1 where pm1.g1.e2= convert(pm1.g1.e4, integer)", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"UPDATE pm1.g1 SET e1 = 'MyString', e2 = 1 WHERE pm1.g1.e2 = convert(pm1.g1.e4, integer)"}, (CapabilitiesFinder)dcf, ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testDelete() throws Exception {
        BasicSourceCapabilities bsc = TestOptimizer.getTypicalCapabilities();
        bsc.setFunctionSupport("convert", true);
        DefaultCapabilitiesFinder dcf = new DefaultCapabilitiesFinder((SourceCapabilities)bsc);
        TestOptimizer.helpPlan("Delete from pm1.g1 where pm1.g1.e1 = cast(pm1.g1.e2 AS string)", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"DELETE FROM pm1.g1 WHERE pm1.g1.e1 = convert(pm1.g1.e2, string)"}, (CapabilitiesFinder)dcf, ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testCopyInAcrossJoin() throws Exception {
        ProcessorPlan plan = TestOptimizer.helpPlan("select pm1.g1.e1, pm2.g2.e1 from pm1.g1, pm2.g2 where pm1.g1.e1=pm2.g2.e1 and pm1.g1.e1 IN ('a', 'b')", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT g_0.e1 AS c_0 FROM pm2.g2 AS g_0 WHERE g_0.e1 IN ('a', 'b') ORDER BY c_0", "SELECT g_0.e1 AS c_0 FROM pm1.g1 AS g_0 WHERE g_0.e1 IN ('a', 'b') ORDER BY c_0"}, ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testCopyMatchAcrossJoin() throws Exception {
        TestOptimizer.helpPlan("select pm1.g1.e1, pm2.g2.e1 from pm1.g1, pm2.g2 where pm1.g1.e1=pm2.g2.e1 and pm1.g1.e1 LIKE '%1'", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT g_0.e1 AS c_0 FROM pm1.g1 AS g_0 WHERE g_0.e1 LIKE '%1' ORDER BY c_0", "SELECT g_0.e1 AS c_0 FROM pm2.g2 AS g_0 WHERE g_0.e1 LIKE '%1' ORDER BY c_0"}, ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testCopyOrAcrossJoin() throws Exception {
        TestOptimizer.helpPlan("select pm1.g1.e1, pm1.g2.e1 from pm1.g1, pm1.g2 where pm1.g1.e1=pm1.g2.e1 and (pm1.g1.e1 = 'abc' OR pm1.g1.e1 = 'def')", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT pm1.g1.e1 FROM pm1.g1 WHERE (pm1.g1.e1 = 'abc') OR (pm1.g1.e1 = 'def')", "SELECT pm1.g2.e1 FROM pm1.g2 WHERE (pm1.g2.e1 = 'abc') OR (pm1.g2.e1 = 'def')"}, TestOptimizer.getGenericFinder(false), ComparisonMode.CORRECTED_COMMAND_STRING);
    }

    @Test
    public void testCopyMultiElementCritAcrossJoin() throws Exception {
        TestOptimizer.helpPlan("select pm1.g1.e1, pm1.g2.e1 from pm1.g1, pm1.g2 where pm1.g1.e1=pm1.g2.e1 and pm1.g1.e2=pm1.g2.e2 and (pm1.g1.e1 = 'abc' OR pm1.g1.e2 = 5)", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT pm1.g2.e1, pm1.g2.e2 FROM pm1.g2 WHERE (pm1.g2.e1 = 'abc') OR (pm1.g2.e2 = 5)", "SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1 WHERE (pm1.g1.e1 = 'abc') OR (pm1.g1.e2 = 5)"}, TestOptimizer.getGenericFinder(false), ComparisonMode.CORRECTED_COMMAND_STRING);
    }

    @Test
    public void testCantCopyAcrossJoin1() throws Exception {
        TestOptimizer.helpPlan("select pm1.g1.e1, pm1.g2.e1 from pm1.g1, pm1.g2 where pm1.g1.e1=pm1.g2.e1 and concat(pm1.g1.e1, pm1.g1.e2) = 'abc'", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1", "SELECT pm1.g2.e1 FROM pm1.g2"}, TestOptimizer.getGenericFinder(false), ComparisonMode.CORRECTED_COMMAND_STRING);
    }

    @Test
    public void testCantCopyAcrossJoin2() throws Exception {
        TestOptimizer.helpPlan("select pm1.g1.e1, pm1.g2.e1 from pm1.g1, pm1.g2 where pm1.g1.e1=pm1.g2.e1 and (pm1.g1.e1 = 'abc' OR pm1.g1.e2 = 5)", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT pm1.g1.e1 FROM pm1.g1 WHERE (pm1.g1.e1 = 'abc') OR (pm1.g1.e2 = 5)", "SELECT pm1.g2.e1 FROM pm1.g2"}, TestOptimizer.getGenericFinder(false), ComparisonMode.CORRECTED_COMMAND_STRING);
    }

    @Test
    public void testPushingCriteriaThroughFrame1() {
        TestOptimizer.helpPlan("select * from vm1.g1, vm1.g2 where vm1.g1.e1='abc' and vm1.g1.e1=vm1.g2.e1", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT g1__1.e1, g1__1.e2, g1__1.e3, g1__1.e4 FROM pm1.g1 AS g1__1 WHERE g1__1.e1 = 'abc'", "SELECT pm1.g1.e1, pm1.g1.e2, pm1.g1.e3, pm1.g1.e4 FROM pm1.g1 WHERE pm1.g1.e1 = 'abc'"});
    }

    @Test
    public void testPushingCriteriaThroughFrame2() throws Exception {
        TestOptimizer.helpPlan("select * from vm1.g1, vm1.g3 where vm1.g1.e1='abc' and vm1.g1.e1=vm1.g3.e1", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT pm1.g2.e1, pm1.g2.e2, pm1.g2.e3, pm1.g2.e4 FROM pm1.g2 WHERE pm1.g2.e1 = 'abc'", "SELECT pm1.g1.e1, pm1.g1.e2, pm1.g1.e3, pm1.g1.e4 FROM pm1.g1 WHERE pm1.g1.e1 = 'abc'"}, TestOptimizer.getGenericFinder(false), ComparisonMode.CORRECTED_COMMAND_STRING);
    }

    @Test
    public void testPushingCriteriaThroughFrame3() {
        TestOptimizer.helpPlan("select * from vm1.g1, vm1.g2, vm1.g1 as a where vm1.g1.e1='abc' and vm1.g1.e1=vm1.g2.e1 and vm1.g1.e1=a.e1", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT g1__1.e1, g1__1.e2, g1__1.e3, g1__1.e4 FROM pm1.g1 AS g1__1 WHERE g1__1.e1 = 'abc'", "SELECT pm1.g1.e1, pm1.g1.e2, pm1.g1.e3, pm1.g1.e4 FROM pm1.g1 WHERE pm1.g1.e1 = 'abc'", "SELECT g1__2.e1, g1__2.e2, g1__2.e3, g1__2.e4 FROM pm1.g1 AS g1__2 WHERE g1__2.e1 = 'abc'"});
    }

    @Test
    public void testPushingCriteriaThroughUnion1() {
        TestOptimizer.helpPlan("select e1 from vm1.u1 where e1='abc'", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT pm1.g3.e1, pm1.g3.e2, pm1.g3.e3, pm1.g3.e4 FROM pm1.g3 WHERE pm1.g3.e1 = 'abc'", "SELECT pm1.g2.e1, pm1.g2.e2, pm1.g2.e3, pm1.g2.e4 FROM pm1.g2 WHERE pm1.g2.e1 = 'abc'", "SELECT pm1.g1.e1, pm1.g1.e2, pm1.g1.e3, pm1.g1.e4 FROM pm1.g1 WHERE pm1.g1.e1 = 'abc'"});
    }

    @Test
    public void testPushingCriteriaThroughUnion2() {
        TestOptimizer.helpPlan("select e1 from vm1.u2 where e1='abc'", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT pm1.g2.e1, pm1.g2.e2, pm1.g2.e3, pm1.g2.e4 FROM pm1.g2 WHERE pm1.g2.e1 = 'abc'", "SELECT pm1.g1.e1, pm1.g1.e2, pm1.g1.e3, pm1.g1.e4 FROM pm1.g1 WHERE pm1.g1.e1 = 'abc'"});
    }

    @Test
    public void testPushingCriteriaThroughUnion3() {
        TestOptimizer.helpPlan("select e1 from vm1.u1 where e1='abc' and e2=5", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT pm1.g3.e1, pm1.g3.e2, pm1.g3.e3, pm1.g3.e4 FROM pm1.g3 WHERE (pm1.g3.e1 = 'abc') AND (pm1.g3.e2 = 5)", "SELECT pm1.g2.e1, pm1.g2.e2, pm1.g2.e3, pm1.g2.e4 FROM pm1.g2 WHERE (pm1.g2.e1 = 'abc') AND (pm1.g2.e2 = 5)", "SELECT pm1.g1.e1, pm1.g1.e2, pm1.g1.e3, pm1.g1.e4 FROM pm1.g1 WHERE (pm1.g1.e1 = 'abc') AND (pm1.g1.e2 = 5)"});
    }

    @Test
    public void testPushingCriteriaThroughUnion4() {
        TestOptimizer.helpPlan("select e1 from vm1.u1 where e1='abc' or e2=5", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT pm1.g3.e1, pm1.g3.e2, pm1.g3.e3, pm1.g3.e4 FROM pm1.g3 WHERE (pm1.g3.e1 = 'abc') OR (pm1.g3.e2 = 5)", "SELECT pm1.g1.e1, pm1.g1.e2, pm1.g1.e3, pm1.g1.e4 FROM pm1.g1 WHERE (pm1.g1.e1 = 'abc') OR (pm1.g1.e2 = 5)", "SELECT pm1.g2.e1, pm1.g2.e2, pm1.g2.e3, pm1.g2.e4 FROM pm1.g2 WHERE (pm1.g2.e1 = 'abc') OR (pm1.g2.e2 = 5)"});
    }

    @Test
    public void testPushingCriteriaThroughUnion5() {
        TestOptimizer.helpPlan("select e1 from vm1.u3 where e1='abc'", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT DISTINCT e1 FROM pm1.g1 WHERE e1 = 'abc'"});
    }

    @Test
    public void testPushCriteriaThroughUnion6() {
        TestOptimizer.helpPlan("select v1 from vm1.u4 where vm1.u4.v1='x'", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT e1 FROM pm1.g1", "SELECT e1 FROM pm1.g2 WHERE e1 = 'x'"});
    }

    @Test
    public void testPushCriteriaThroughUnion7() {
        TestOptimizer.helpPlan("select v1 from vm1.u5 where vm1.u5.v1='x'", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT e1 FROM pm1.g1", "SELECT e1 FROM pm1.g2"});
    }

    @Test
    public void testPushCriteriaThroughUnion8() {
        TestOptimizer.helpPlan("select v1 from vm1.u5 where length(v1) > 0", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT e1 FROM pm1.g1", "SELECT e1 FROM pm1.g2"});
    }

    @Test
    public void testPushCriteriaThroughUnion11() {
        TestOptimizer.helpPlan("select * from vm1.u8 where const = 's3' or e1 is null", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT e1 FROM pm1.g3", "SELECT e1 FROM pm1.g2 WHERE e1 IS NULL", "SELECT e1 FROM pm1.g1 WHERE e1 IS NULL"});
    }

    @Test
    public void testPushCriteriaThroughUnion12() {
        TestOptimizer.helpPlan("select * from vm1.u8 where const = 's1' or e1 is null", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT e1 FROM pm1.g3 WHERE e1 IS NULL", "SELECT e1 FROM pm1.g2 WHERE e1 IS NULL", "SELECT e1 FROM pm1.g1"});
    }

    @Test
    public void testCountStarNoRows() {
        ProcessorPlan plan = TestOptimizer.helpPlan("select count(*) from vm1.u4", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT 1 FROM pm1.g2", "SELECT 1 FROM pm1.g1"});
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1});
    }

    @Test
    public void testPushingCriteriaWithCopy() {
        ProcessorPlan plan = TestOptimizer.helpPlan("select vm1.u1.e1 from vm1.u1, pm1.g1 where vm1.u1.e1='abc' and vm1.u1.e1=pm1.g1.e1", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT 1 FROM pm1.g1 WHERE pm1.g1.e1 = 'abc'", "SELECT pm1.g3.e1, pm1.g3.e2, pm1.g3.e3, pm1.g3.e4 FROM pm1.g3 WHERE pm1.g3.e1 = 'abc'", "SELECT pm1.g2.e1, pm1.g2.e2, pm1.g2.e3, pm1.g2.e4 FROM pm1.g2 WHERE pm1.g2.e1 = 'abc'", "SELECT pm1.g1.e1, pm1.g1.e2, pm1.g1.e3, pm1.g1.e4 FROM pm1.g1 WHERE pm1.g1.e1 = 'abc'"});
        TestOptimizer.checkNodeTypes(plan, new int[]{4, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 2});
    }

    @Test
    public void testVirtualGroupWithAliasedElement() {
        TestOptimizer.helpPlan("select elem FROM vm1.u6 where elem='abc' and const='xyz'", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT x1.e1 FROM pm1.g1 AS x1 WHERE x1.e1 = 'abc'"});
    }

    @Test
    public void testPushThroughGroup1() {
        TestOptimizer.helpPlan("select * FROM vm1.a1 WHERE e1 = 'x'", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT e1, e2 FROM pm1.g1 WHERE e1 = 'x'"});
    }

    @Test
    public void testPushThroughGroup2() {
        TestOptimizer.helpPlan("select * FROM vm1.a2 WHERE e1 = 'x'", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT e1, e2 FROM pm1.g1 WHERE e1 = 'x'"});
    }

    @Test
    public void testPushThroughGroup3() {
        TestOptimizer.helpPlan("select * FROM vm1.a3 WHERE sum_e2 > 0", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT e2 FROM pm1.g1"});
    }

    @Test
    public void testPushMultiGroupCriteria() {
        ProcessorPlan plan = TestOptimizer.helpPlan("select pm2.g1.e1 from pm2.g1, pm2.g2 where pm2.g1.e1 = pm2.g2.e1 and (pm2.g1.e2 = 1 OR pm2.g2.e2 = 2)", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT pm2.g1.e1 FROM pm2.g1, pm2.g2 WHERE (pm2.g1.e1 = pm2.g2.e1) AND ((pm2.g1.e2 = 1) OR (pm2.g2.e2 = 2))"});
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testSimpleCrossJoin1() throws Exception {
        TestOptimizer.helpPlan("select pm1.g1.e1 FROM pm1.g1, pm1.g2", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT pm1.g1.e1 FROM pm1.g1", "SELECT pm1.g2.e1 FROM pm1.g2"}, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testSimpleCrossJoin2() {
        TestOptimizer.helpPlan("select pm2.g1.e1 FROM pm2.g1, pm2.g2", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT pm2.g1.e1 FROM pm2.g1, pm2.g2"});
    }

    @Test
    public void testSimpleCrossJoin3() {
        TestOptimizer.helpPlan("select pm2.g1.e1 FROM pm2.g1 CROSS JOIN pm2.g2", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT pm2.g1.e1 FROM pm2.g1, pm2.g2"});
    }

    @Test
    public void testMultiSourceCrossJoin() throws Exception {
        TestOptimizer.helpPlan("select pm1.g1.e1 FROM pm1.g1, pm1.g2, pm1.g3", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT pm1.g1.e1 FROM pm1.g1", "SELECT pm1.g2.e1 FROM pm1.g2", "SELECT pm1.g3.e1 FROM pm1.g3"}, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testSingleSourceCrossJoin() {
        TestOptimizer.helpPlan("select pm2.g1.e1 FROM pm2.g1, pm2.g2, pm2.g3", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT pm2.g1.e1 FROM pm2.g1, pm2.g2, pm2.g3"});
    }

    @Test
    public void testSelfJoins() {
        TestOptimizer.helpPlan("select pm2.g1.e1 FROM pm2.g1 JOIN pm2.g1 AS x ON pm2.g1.e1=x.e1", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT pm2.g1.e1 FROM pm2.g1 order by e1", "SELECT x.e1 FROM pm2.g1 AS x order by e1"});
    }

    @Test
    public void testDefect5282_1() {
        TestOptimizer.helpPlan("select * FROM vm1.a4 WHERE vm1.a4.count > 0", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT 1 FROM pm1.g1"});
    }

    @Test
    public void testDefect5282_2() {
        TestOptimizer.helpPlan("select count(*) FROM vm1.a4", (QueryMetadataInterface)TestOptimizer.example1(), new String[0]);
    }

    @Test
    public void testDefect5282_3() {
        TestOptimizer.helpPlan("select * FROM vm1.a5 WHERE vm1.a5.count > 0", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT 1 FROM pm1.g1"});
    }

    @Test
    public void testDepJoinHintBaseline() throws Exception {
        ProcessorPlan plan = TestOptimizer.helpPlan("select * FROM vm1.g4", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT pm1.g1.e1 FROM pm1.g1", "SELECT pm1.g2.e1 FROM pm1.g2"}, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testDefect6425_1() {
        TestOptimizer.helpPlan("select * from vm1.u9", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT e1 FROM pm1.g1", "SELECT e1 FROM pm1.g2"});
    }

    @Test
    public void testDefect6425_2() {
        TestOptimizer.helpPlan("select count(*) from vm1.u9", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT 1 FROM pm1.g1", "SELECT 1 FROM pm1.g2"});
    }

    @Test
    public void testPushMatchCritWithReference() throws Exception {
        ArrayList<String> bindings = new ArrayList<String>();
        bindings.add("pm1.g2.e1");
        TestOptimizer.helpPlan("select e1 FROM pm1.g1 WHERE e1 LIKE ?", (QueryMetadataInterface)TestOptimizer.example1(), bindings, null, new String[]{"SELECT g_0.e1 FROM pm1.g1 AS g_0 WHERE g_0.e1 LIKE pm1.g2.e1"}, ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testDefect6517() {
        TestOptimizer.helpPlan("select count(*) from vm1.g5", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT DISTINCT pm1.g1.e1 FROM pm1.g1"});
    }

    @Test
    public void testDefect5283() {
        TestOptimizer.helpPlan("select * from vm1.a6", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT pm1.g1.e1, pm1.g1.e2, pm1.g1.e3, pm1.g1.e4 FROM pm1.g1", "SELECT pm1.g2.e1, pm1.g2.e2, pm1.g2.e3, pm1.g2.e4 FROM pm1.g2"});
    }

    @Test
    public void testManyJoinsOverThreshold() throws Exception {
        long begin = System.currentTimeMillis();
        TestOptimizer.helpPlan("SELECT pm1.g1.e1 FROM pm1.g1, pm1.g2, pm1.g3, pm1.g4, pm1.g5, pm1.g6, pm1.g7, pm1.g8, pm1.g1 AS x, pm1.g2 AS y WHERE pm1.g1.e1 = pm1.g2.e1 AND pm1.g2.e1 = pm1.g3.e1 AND pm1.g3.e1 = pm1.g4.e1 AND pm1.g4.e1 = pm1.g5.e1 AND pm1.g5.e1=pm1.g6.e1 AND pm1.g6.e1=pm1.g7.e1 AND pm1.g7.e1=pm1.g8.e1", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT pm1.g1.e1 FROM pm1.g1", "SELECT pm1.g2.e1 FROM pm1.g2", "SELECT pm1.g3.e1 FROM pm1.g3", "SELECT pm1.g4.e1 FROM pm1.g4", "SELECT pm1.g5.e1 FROM pm1.g5", "SELECT pm1.g6.e1 FROM pm1.g6", "SELECT pm1.g7.e1 FROM pm1.g7", "SELECT pm1.g8.e1 FROM pm1.g8", "SELECT x.e1 FROM pm1.g1 AS x", "SELECT y.e1 FROM pm1.g2 AS y"}, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), ComparisonMode.CORRECTED_COMMAND_STRING);
        long elapsed = System.currentTimeMillis() - begin;
        Assert.assertTrue((String)("Did not plan many join query in reasonable time frame: " + elapsed + " ms"), (elapsed < 4000L ? 1 : 0) != 0);
    }

    @Test
    public void testAggregateWithoutGroupBy() {
        ProcessorPlan plan = TestOptimizer.helpPlan("select count(e2) from pm1.g1", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT e2 FROM pm1.g1"});
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testHavingWithoutGroupBy() {
        ProcessorPlan plan = TestOptimizer.helpPlan("select count(e2) from pm1.g1 HAVING count(e2) > 0", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT e2 FROM pm1.g1"});
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0});
    }

    @Test
    public void testHavingAndGroupBy() {
        ProcessorPlan plan = TestOptimizer.helpPlan("select e1, count(e2) from pm1.g1 group by e1 having count(e2) > 0 and sum(e2) > 0", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT e1, e2 FROM pm1.g1"});
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0});
    }

    @Test
    public void testAllJoinsInSingleClause() throws Exception {
        ProcessorPlan plan = TestOptimizer.helpPlan("select pm1.g1.e1 FROM pm1.g1 join (pm1.g2 right outer join pm1.g3 on pm1.g2.e1=pm1.g3.e1) on pm1.g1.e1=pm1.g3.e1", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT pm1.g1.e1 FROM pm1.g1", "SELECT pm1.g2.e1 FROM pm1.g2", "SELECT pm1.g3.e1 FROM pm1.g3"}, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{3, 0, 0, 0, 0, 0, 0, 2, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testSelectCountStarFalseCriteria() {
        ProcessorPlan plan = TestOptimizer.helpPlan("Select count(*) from pm1.g1 where 1=0", (QueryMetadataInterface)TestOptimizer.example1(), new String[0]);
        TestOptimizer.checkNodeTypes(plan, new int[]{0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0});
    }

    @Test
    public void testSubquery1() {
        ProcessorPlan plan = TestOptimizer.helpPlan("Select e1 from (select e1 FROM pm1.g1) AS x", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT e1 FROM pm1.g1"});
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testSubquery2() {
        ProcessorPlan plan = TestOptimizer.helpPlan("Select e1, a from (select e1 FROM pm1.g1) AS x, (select e1 as a FROM pm1.g2) AS y WHERE x.e1=y.a", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT g_0.e1, g_1.e1 FROM pm1.g1 AS g_0, pm1.g2 AS g_1 WHERE g_0.e1 = g_1.e1"});
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testSubquery3() {
        ProcessorPlan plan = TestOptimizer.helpPlan("Select e1 from (select e1 FROM pm1.g1) AS x WHERE x.e1 = 'a'", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT e1 FROM pm1.g1 WHERE e1 = 'a'"});
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testSubquery4() {
        ProcessorPlan plan = TestOptimizer.helpPlan("Select e1 from (select e1 FROM pm1.g1 WHERE e1 = 'a') AS x", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT e1 FROM pm1.g1 WHERE e1 = 'a'"});
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testSubqueryInClause1() {
        ProcessorPlan plan = TestOptimizer.helpPlan("Select e1 from pm1.g1 where e1 in (select e1 FROM pm2.g1)", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT e1 FROM pm1.g1"});
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testCompareSubquery1() {
        ProcessorPlan plan = TestOptimizer.helpPlan("Select e1 from pm1.g1 where e1 < ALL (select e1 FROM pm2.g1)", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT e1 FROM pm1.g1"});
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testCompareSubquery3() {
        ProcessorPlan plan = TestOptimizer.helpPlan("Select e1 from pm1.g1 where e1 >= all (select e1 FROM pm2.g1)", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT e1 FROM pm1.g1"});
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testExistsSubquery1() {
        ProcessorPlan plan = TestOptimizer.helpPlan("Select e1 from pm1.g1 where exists (select e1 FROM pm2.g1)", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT e1 FROM pm1.g1"});
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testNotPushDistinct() throws Exception {
        ProcessorPlan plan = TestOptimizer.helpPlan("select distinct e1 from pm1.g1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT pm1.g1.e1 FROM pm1.g1"}, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    }

    @Test
    public void testPushDistinct() {
        ProcessorPlan plan = TestOptimizer.helpPlan("select distinct e1 from pm3.g1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT DISTINCT e1 FROM pm3.g1"});
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushDistinctSort() {
        ProcessorPlan plan = TestOptimizer.helpPlan("select distinct e1 from pm3.g1 order by e1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT DISTINCT e1 FROM pm3.g1 ORDER BY e1"});
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushDistinctWithCriteria() {
        ProcessorPlan plan = TestOptimizer.helpPlan("select distinct e1 from pm3.g1 where e1 = 'x'", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT DISTINCT e1 FROM pm3.g1 WHERE e1 = 'x'"});
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushDistinctVirtual1() {
        ProcessorPlan plan = TestOptimizer.helpPlan("select * from vm1.g12", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT DISTINCT pm3.g1.e1, pm3.g1.e2, pm3.g1.e3, pm3.g1.e4 FROM pm3.g1"});
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushDistinctVirtual2() {
        ProcessorPlan plan = TestOptimizer.helpPlan("select DISTINCT * from vm1.g12", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT DISTINCT pm3.g1.e1, pm3.g1.e2, pm3.g1.e3, pm3.g1.e4 FROM pm3.g1"});
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushDistinctVirtual3() {
        ProcessorPlan plan = TestOptimizer.helpPlan("select DISTINCT * from vm1.g12 ORDER BY e1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT DISTINCT pm3.g1.e1, pm3.g1.e2, pm3.g1.e3, pm3.g1.e4 FROM pm3.g1 ORDER BY pm3.g1.e1"});
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushDistinctVirtual4() {
        ProcessorPlan plan = TestOptimizer.helpPlan("select * from vm1.g13", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT DISTINCT pm3.g1.e1, pm3.g1.e2, pm3.g1.e3, pm3.g1.e4 FROM pm3.g1"});
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushDistinctVirtual5() {
        ProcessorPlan plan = TestOptimizer.helpPlan("select DISTINCT * from vm1.g13", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT DISTINCT pm3.g1.e1, pm3.g1.e2, pm3.g1.e3, pm3.g1.e4 FROM pm3.g1"});
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushDistinctVirtual6() {
        ProcessorPlan plan = TestOptimizer.helpPlan("select DISTINCT * from vm1.g13 ORDER BY e1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT DISTINCT pm3.g1.e1, pm3.g1.e2, pm3.g1.e3, pm3.g1.e4 FROM pm3.g1 ORDER BY pm3.g1.e1"});
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushDistinctVirtual7() {
        ProcessorPlan plan = TestOptimizer.helpPlan("select * from vm1.g14", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT pm3.g1.e1, pm3.g1.e2, pm3.g1.e3, pm3.g1.e4 FROM pm3.g1"});
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushDistinctVirtual8() {
        ProcessorPlan plan = TestOptimizer.helpPlan("select DISTINCT * from vm1.g14", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT DISTINCT pm3.g1.e1, pm3.g1.e2, pm3.g1.e3, pm3.g1.e4 FROM pm3.g1"});
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushDistinctVirtual9() {
        ProcessorPlan plan = TestOptimizer.helpPlan("select DISTINCT * from vm1.g14 ORDER BY e1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT DISTINCT pm3.g1.e1, pm3.g1.e2, pm3.g1.e3, pm3.g1.e4 FROM pm3.g1 ORDER BY pm3.g1.e1"});
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushDistinctWithExpressions() {
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT DISTINCT * FROM vm1.g15", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT e1, e2 FROM pm3.g1"});
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testNestedSubquery() {
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT IntKey, LongNum FROM (SELECT IntKey, LongNum FROM (SELECT IntKey, LongNum, DoubleNum FROM BQT2.SmallA ) AS x ) AS y ORDER BY IntKey", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), new String[]{"SELECT IntKey, LongNum FROM BQT2.SmallA order by intkey"});
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushOrderBy() {
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT pm3.g1.e1 FROM pm3.g1 ORDER BY e1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT pm3.g1.e1 FROM pm3.g1 ORDER BY pm3.g1.e1"});
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testDontPushOrderByWithJoin() {
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT pm3.g1.e1, pm3.g1.e2 FROM pm3.g1 INNER JOIN pm2.g2 ON pm3.g1.e1 = pm2.g2.e1 ORDER BY pm3.g1.e2", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT pm3.g1.e1, pm3.g1.e2 FROM pm3.g1 ORDER BY pm3.g1.e1", "SELECT pm2.g2.e1 FROM pm2.g2 ORDER BY pm2.g2.e1"});
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0});
    }

    @Test
    public void testPushOrderByThroughFrame() {
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT e1, e2 FROM vm1.g14 ORDER BY e2", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT pm3.g1.e1, pm3.g1.e2 FROM pm3.g1 ORDER BY pm3.g1.e2"});
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushOrderByThroughFrame2() {
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT e1, e2 FROM vm1.g1 ORDER BY e2", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1 order by e2"});
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushOrderByThroughFrame4_Union() {
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT e1, e2 FROM vm1.g17 ORDER BY e1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT pm3.g1.e1, pm3.g1.e2 FROM pm3.g1", "SELECT pm3.g2.e1, pm3.g2.e2 FROM pm3.g2"});
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1});
    }

    @Test
    public void testOuterJoinDefect7945() {
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT BQT1.SmallA.IntKey AS SmallA_IntKey, BQT2.MediumB.IntKey AS MediumB_IntKey, BQT3.MediumB.IntKey AS MediumC_IntKey FROM (BQT1.SmallA RIGHT OUTER JOIN BQT2.MediumB ON BQT1.SmallA.IntKey = BQT2.MediumB.IntKey) RIGHT OUTER JOIN BQT3.MediumB ON BQT2.MediumB.IntKey = BQT3.MediumB.IntKey WHERE BQT3.MediumB.IntKey < 1500", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), new String[]{"SELECT BQT3.MediumB.IntKey FROM BQT3.MediumB WHERE BQT3.MediumB.IntKey < 1500 order by intkey", "SELECT BQT1.SmallA.IntKey FROM BQT1.SmallA WHERE BQT1.SmallA.IntKey < 1500 order by intkey", "SELECT BQT2.MediumB.IntKey FROM BQT2.MediumB WHERE BQT2.MediumB.IntKey < 1500 order by intkey"});
        TestOptimizer.checkNodeTypes(plan, new int[]{3, 0, 0, 0, 0, 0, 0, 2, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testFunctionSimplification1() {
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT x FROM vm1.g18 WHERE x = 92.0", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT e4 FROM pm1.g1 WHERE e4 = 0.92"});
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testCantPushJoin1() {
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT a.e1, b.e2 FROM pm1.g1 a, pm1.g2 b WHERE a.e1 = b.e1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, TestOptimizer.getGenericFinder(false), new String[]{"SELECT a.e1 FROM pm1.g1 AS a", "SELECT b.e1, b.e2 FROM pm1.g2 AS b"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
        Assert.assertTrue((boolean)plan.requiresTransaction(true));
        Assert.assertFalse((boolean)plan.requiresTransaction(false));
    }

    @Test
    public void testCantPushJoin2() {
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT a.e1, b.e2 FROM pm1.g1 a, pm1.g2 b, pm2.g1 c WHERE a.e1 = b.e1 AND b.e1 = c.e1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, TestOptimizer.getGenericFinder(false), new String[]{"SELECT a.e1 FROM pm1.g1 AS a", "SELECT b.e1, b.e2 FROM pm1.g2 AS b", "SELECT c.e1 FROM pm2.g1 AS c"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{3, 0, 0, 0, 0, 0, 0, 2, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testPushSelfJoin1() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_SELFJOIN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT a.e1, b.e2 FROM pm1.g1 a, pm1.g1 b WHERE a.e1 = b.e1", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT a.e1, b.e2 FROM pm1.g1 AS a, pm1.g1 AS b WHERE a.e1 = b.e1"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushSelfJoin2() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_SELFJOIN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT a.e1 AS x, concat(a.e2, b.e2) AS y FROM pm1.g1 a, pm1.g1 b WHERE a.e1 = b.e1", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT a.e1, a.e2, b.e2 FROM pm1.g1 AS a, pm1.g1 AS b WHERE a.e1 = b.e1"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testPushOuterJoin1() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT pm1.g1.e1 FROM pm1.g1 RIGHT OUTER JOIN pm1.g2 ON pm1.g1.e1 = pm1.g2.e1", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT pm1.g1.e1 FROM pm1.g2 LEFT OUTER JOIN pm1.g1 ON pm1.g1.e1 = pm1.g2.e1"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushOuterJoin2() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT pm1.g1.e1 FROM pm1.g1 RIGHT OUTER JOIN pm1.g2 ON pm1.g1.e1 = pm1.g2.e1", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT pm1.g1.e1 FROM pm1.g1", "SELECT pm1.g2.e1 FROM pm1.g2"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testPushOuterJoin3() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT pm1.g1.e1 FROM pm1.g1 RIGHT OUTER JOIN pm1.g2 ON pm1.g1.e1 = pm1.g2.e1 || 'x'", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT pm1.g1.e1 FROM pm1.g1", "SELECT pm1.g2.e1 FROM pm1.g2"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 0, 0});
    }

    @Test
    public void testPushGroupBy1() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT e1, e2 as x FROM pm1.g1 GROUP BY e1, e2", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT e1, e2 FROM pm1.g1 GROUP BY e1, e2"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushGroupBy2() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT e1, max(e2) as x FROM pm1.g1 GROUP BY e1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT e1, MAX(e2) FROM pm1.g1 GROUP BY e1"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushGroupBy3() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT e1, e2 as x FROM pm1.g1 GROUP BY e1, e2", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT e1, e2 FROM pm1.g1"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testPushGroupBy4() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT x+2 AS y FROM (SELECT e1, max(e2) as x FROM pm1.g1 GROUP BY e1) AS z", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT MAX(e2) FROM pm1.g1 GROUP BY e1"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testPushHaving1() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT e1 FROM pm1.g1 GROUP BY e1 HAVING MAX(e1) = 'zzz'", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT e1 FROM pm1.g1 GROUP BY e1 HAVING MAX(e1) = 'zzz'"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushHaving2() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT e1 FROM pm1.g1 GROUP BY e1 HAVING MAX(e1) = 'zzz'", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT e1 FROM pm1.g1"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0});
    }

    @Test
    public void testPushHaving3() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT e1 FROM pm1.g1 GROUP BY e1 HAVING MAX(e1) = 'zzz'", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT e1 FROM pm1.g1"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0});
    }

    @Test
    public void testPushAggregate1() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT MAX(e1) FROM pm1.g1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT MAX(e1) FROM pm1.g1"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushAggregate2() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT MAX(e1) FROM pm1.g1 GROUP BY e1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT MAX(e1) FROM pm1.g1 GROUP BY e1"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushAggregate3() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT e2, MAX(e1) FROM pm1.g1 GROUP BY e2", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT e2, MAX(e1) FROM pm1.g1 GROUP BY e2"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushAggregate4() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_ORDERED, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT e2, MAX(e1) FROM pm1.g1 GROUP BY e2 HAVING COUNT(e1) > 0", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT e2, MAX(e1) FROM pm1.g1 GROUP BY e2 HAVING COUNT(e1) > 0"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushAggregate5() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_ORDERED, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT e2, MAX(e1) FROM pm1.g1 GROUP BY e2 HAVING COUNT(e1) > 0", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT e2, e1 FROM pm1.g1"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0});
    }

    @Test
    public void testPushAggregate6() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT COUNT(length(e1)) FROM pm1.g1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT e1 FROM pm1.g1"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testPushAggregate7() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT COUNT(*) FROM pm1.g1 GROUP BY e1 HAVING length(e1) > 0", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT e1 FROM pm1.g1"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0});
    }

    @Test
    public void testPushAggregate8() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_CORRELATED, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_SCALAR, true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        String sqlIn = "SELECT intkey FROM bqt1.smalla AS sa WHERE (sa.intkey = 46) AND (sa.stringkey IN (46)) AND (sa.datevalue = (SELECT MAX(sa.datevalue) FROM bqt1.smalla AS sb WHERE (sb.intkey = sa.intkey) AND (sa.stringkey = sb.stringkey) ))";
        String sqlOut = "SELECT g_0.IntKey FROM BQT1.SmallA AS g_0 WHERE (g_0.IntKey = 46) AND (g_0.StringKey = '46') AND (g_0.DateValue = (SELECT MAX(g_0.DateValue) FROM BQT1.SmallA AS g_1 WHERE (g_1.IntKey = g_0.IntKey) AND (g_1.StringKey = g_0.StringKey)))";
        ProcessorPlan plan = TestOptimizer.helpPlan(sqlIn, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)capFinder, new String[]{sqlOut}, ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testQueryManyJoin() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT pm1.g1.e1 FROM pm1.g1 JOIN ((pm1.g2 JOIN pm1.g3 ON pm1.g2.e1=pm1.g3.e1) JOIN pm1.g4 ON pm1.g3.e1=pm1.g4.e1) ON pm1.g1.e1=pm1.g4.e1", (QueryMetadataInterface)metadata, new String[]{"SELECT g_0.e1 FROM pm1.g1 AS g_0, pm1.g2 AS g_1, pm1.g3 AS g_2, pm1.g4 AS g_3 WHERE (g_1.e1 = g_2.e1) AND (g_2.e1 = g_3.e1) AND (g_0.e1 = g_3.e1)"}, ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushSelectDistinct() {
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT DISTINCT e1 FROM pm3.g1", (QueryMetadataInterface)metadata, new String[]{"SELECT DISTINCT e1 FROM pm3.g1"});
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushFunctionInCriteria1() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setFunctionSupport("ucase", true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT e1 FROM pm1.g1 WHERE upper(e1) = 'X'", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT e1 FROM pm1.g1 WHERE ucase(e1) = 'X'"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushFunctionInSelect1() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setFunctionSupport("ucase", true);
        caps.setFunctionSupport("lcase", true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT lower(e1) FROM pm1.g1 WHERE upper(e1) = 'X'", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT lower(e1) FROM pm1.g1 WHERE ucase(e1) = 'X'"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushFunctionInSelect2() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setFunctionSupport("ucase", true);
        caps.setFunctionSupport("lcase", true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT lower(e1), upper(e1), e2 FROM pm1.g1 WHERE upper(e1) = 'X'", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT lower(e1), upper(e1), e2 FROM pm1.g1 WHERE ucase(e1) = 'X'"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushFunctionInSelect3() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setFunctionSupport("ucase", true);
        caps.setFunctionSupport("lcase", false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT lower(e1), upper(e1) FROM pm1.g1 WHERE upper(e1) = 'X'", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT e1 FROM pm1.g1 WHERE ucase(e1) = 'X'"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testPushFunctionInSelect4() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setFunctionSupport("ucase", true);
        caps.setFunctionSupport("lcase", true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT x FROM (SELECT lower(e1) AS x, upper(e1) AS y FROM pm1.g1 WHERE upper(e1) = 'X') AS z", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT lcase(e1) FROM pm1.g1 WHERE ucase(e1) = 'X'"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushFunctionInSelect5() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setFunctionSupport("ucase", true);
        caps.setFunctionSupport("lcase", true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT y, e, x FROM (SELECT lower(e1) AS x, upper(e1) AS y, 5 as z, e1 AS e FROM pm1.g1 WHERE upper(e1) = 'X') AS w", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT ucase(e1), e1, lcase(e1) FROM pm1.g1 WHERE ucase(e1) = 'X'"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushFunctionInSelect6_defect_10081() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setFunctionSupport("upper", true);
        caps.setFunctionSupport("lower", false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT upper(lower(e1)) FROM pm1.g1", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT e1 FROM pm1.g1"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testPushFunctionInSelectWithOrderBy1() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        caps.setFunctionSupport("ucase", true);
        caps.setFunctionSupport("lcase", true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT e1, lower(e1) FROM pm1.g1 WHERE upper(e1) = 'X' ORDER BY e1", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT e1, lcase(e1) FROM pm1.g1 WHERE ucase(e1) = 'X' ORDER BY e1"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushFunctionInSelectWithOrderBy1a() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        caps.setFunctionSupport("ucase", true);
        caps.setFunctionSupport("lcase", true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT e1, lower(e1) AS x FROM pm1.g1 WHERE upper(e1) = 'X' ORDER BY x", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT e1, lcase(e1) AS x FROM pm1.g1 WHERE ucase(e1) = 'X' ORDER BY x"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushFunctionInSelectWithOrderBy2() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        caps.setFunctionSupport("ucase", true);
        caps.setFunctionSupport("lcase", true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT e1, x FROM (SELECT e1, lower(e1) AS x FROM pm1.g1 WHERE upper(e1) = 'X') AS z ORDER BY x", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT e1, lcase(e1) AS EXPR FROM pm1.g1 WHERE ucase(e1) = 'X' ORDER BY EXPR"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushFunctionInJoin1() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setFunctionSupport("ucase", true);
        caps.setFunctionSupport("convert", true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT pm1.g1.e1, pm1.g2.e3 FROM pm1.g1, pm1.g2 WHERE pm1.g1.e1 = convert(pm1.g2.e2, string) AND upper(pm1.g1.e1) = 'X'", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT pm1.g1.e1, pm1.g2.e3 FROM pm1.g1, pm1.g2 WHERE (pm1.g1.e1 = convert(pm1.g2.e2, string)) AND (ucase(pm1.g1.e1) = 'X') AND (ucase(convert(pm1.g2.e2, string)) = 'X')"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushFunctionInJoin2() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setFunctionSupport("ucase", true);
        caps.setFunctionSupport("convert", true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT pm1.g1.e1, pm1.g2.e3 FROM pm1.g1, pm1.g2, pm1.g3 WHERE pm1.g1.e1 = convert(pm1.g2.e2, string) AND pm1.g1.e1 = concat(pm1.g3.e1, 'a') AND upper(pm1.g1.e1) = 'X'", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT pm1.g1.e1, pm1.g2.e3 FROM pm1.g1, pm1.g2 WHERE (pm1.g1.e1 = convert(pm1.g2.e2, string)) AND (ucase(pm1.g1.e1) = 'X') AND (ucase(convert(pm1.g2.e2, string)) = 'X')", "SELECT pm1.g3.e1 FROM pm1.g3"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 1, 0, 0});
    }

    @Test
    public void testPushFunctionInJoin3() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setFunctionSupport("ucase", true);
        caps.setFunctionSupport("convert", true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT pm1.g1.e1, pm1.g2.e3 FROM pm1.g1, pm1.g2, (SELECT e1 AS x FROM pm1.g3) AS g WHERE pm1.g1.e1 = convert(pm1.g2.e2, string) AND pm1.g1.e1 = concat(g.x, 'a') AND upper(pm1.g1.e1) = 'X'", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT pm1.g1.e1, pm1.g2.e3 FROM pm1.g1, pm1.g2 WHERE (pm1.g1.e1 = convert(pm1.g2.e2, string)) AND (ucase(pm1.g1.e1) = 'X') AND (ucase(convert(pm1.g2.e2, string)) = 'X')", "SELECT e1 FROM pm1.g3"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 1, 0, 0});
    }

    @Test
    public void testUnionOverFunctions() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setFunctionSupport("convert", true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT StringCol AS E FROM (SELECT CONVERT(BQT1.SmallA.IntNum, string) AS StringCol, BQT1.SmallA.IntNum AS IntCol FROM BQT1.SmallA UNION ALL SELECT BQT1.SmallB.StringNum, CONVERT(BQT1.SmallB.StringNum, integer) FROM BQT1.SmallB) AS x", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT CONVERT(BQT1.SmallA.IntNum, string) FROM BQT1.SmallA", "SELECT BQT1.SmallB.StringNum FROM BQT1.SmallB"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1});
    }

    @Test
    public void testDefect9827() {
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT intkey, c FROM (SELECT DISTINCT b.intkey, b.intnum, a.stringkey AS c FROM bqt1.smalla AS a, bqt1.smallb AS b WHERE a.INTKEY = b.INTKEY) AS x ORDER BY x.intkey", (QueryMetadataInterface)metadata, new String[]{"SELECT DISTINCT b.intkey, b.intnum, a.stringkey FROM bqt1.smalla AS a, bqt1.smallb AS b WHERE a.INTKEY = b.INTKEY"});
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0});
    }

    @Test
    public void testCrossJoinNoElementCriteriaOptimization2() {
        ProcessorPlan plan = TestOptimizer.helpPlan("select Y.e1, Y.e2 FROM vm1.g1 X, vm1.g1 Y where {b'true'} = {b'true'}", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT 1 FROM pm1.g1 AS g1__1", "SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1"});
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testCrossJoinNoElementCriteriaOptimization3() {
        ProcessorPlan plan = TestOptimizer.helpPlan("select Y.e1, Y.e2 FROM vm1.g1 X, vm1.g1 Y where {b'true'} in (select e3 FROM vm1.g1)", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT 1 FROM pm1.g1 AS g1__1", "SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1"});
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testCrossJoinNoElementCriteriaOptimization4() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN_SUBQUERY, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("select Y.e1, Y.e2 FROM vm1.g1 X, vm1.g1 Y where {b'true'} in (select e3 FROM vm1.g1)", (QueryMetadataInterface)TestOptimizer.example1(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT 1 FROM pm1.g1 AS g1__1 WHERE TRUE IN (SELECT pm1.g1.e3 FROM pm1.g1)", "SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testCopyCriteriaWithOuterJoin_defect10050() {
        ProcessorPlan plan = TestOptimizer.helpPlan("select pm2.g1.e1, pm2.g2.e1 from pm2.g1 left outer join pm2.g2 on pm2.g1.e1=pm2.g2.e1 where pm2.g1.e1 IN ('a', 'b')", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT pm2.g1.e1, pm2.g2.e1 FROM pm2.g1 LEFT OUTER JOIN pm2.g2 ON pm2.g1.e1 = pm2.g2.e1 AND pm2.g2.e1 IN ('a', 'b') WHERE pm2.g1.e1 IN ('a', 'b')"});
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testCopyCriteriaWithOuterJoin2_defect10050() {
        ProcessorPlan plan = TestOptimizer.helpPlan("select pm2.g1.e1, pm2.g2.e1 from pm2.g1 left outer join pm2.g2 on pm2.g1.e1=pm2.g2.e1 and pm2.g1.e2=pm2.g2.e2 where pm2.g1.e1 = 'a' and pm2.g1.e2 = 1", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT g_0.e1, g_1.e1 FROM pm2.g1 AS g_0 LEFT OUTER JOIN pm2.g2 AS g_1 ON g_0.e1 = g_1.e1 AND g_0.e2 = g_1.e2 AND g_1.e1 = 'a' AND g_1.e2 = 1 WHERE (g_0.e1 = 'a') AND (g_0.e2 = 1)"});
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testCopyCriteriaWithOuterJoin5_defect10050() {
        ProcessorPlan plan = TestOptimizer.helpPlan("select pm2.g1.e1, pm2.g2.e1, pm2.g3.e1 from ( (pm2.g1 right outer join pm2.g2 on pm2.g1.e1=pm2.g2.e1) right outer join pm2.g3 on pm2.g2.e1=pm2.g3.e1) where pm2.g3.e1 = 'a'", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT g_2.e1, g_1.e1, g_0.e1 FROM pm2.g3 AS g_0 LEFT OUTER JOIN (pm2.g2 AS g_1 LEFT OUTER JOIN pm2.g1 AS g_2 ON g_2.e1 = g_1.e1 AND g_2.e1 = 'a') ON g_1.e1 = g_0.e1 AND g_1.e1 = 'a' WHERE g_0.e1 = 'a'"});
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testCopyCriteriaWithOuterJoin6_defect10050() {
        ProcessorPlan plan = TestOptimizer.helpPlan("select pm2.g1.e1, pm2.g2.e1 from pm2.g1 left outer join pm2.g2 on pm2.g2.e1=pm2.g1.e1 where pm2.g1.e1 IN ('a', 'b')", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT pm2.g1.e1, pm2.g2.e1 FROM pm2.g1 LEFT OUTER JOIN pm2.g2 ON pm2.g2.e1 = pm2.g1.e1 AND pm2.g2.e1 IN ('a', 'b') WHERE pm2.g1.e1 IN ('a', 'b')"});
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testCopyCriteriaWithOuterJoin7_defect10050() {
        ProcessorPlan plan = TestOptimizer.helpPlan("select pm2.g1.e1, pm2.g2.e1 from pm2.g1 right outer join pm2.g2 on pm2.g2.e1=pm2.g1.e1 where pm2.g2.e1 IN ('a', 'b')", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT pm2.g1.e1, pm2.g2.e1 FROM pm2.g2 LEFT OUTER JOIN pm2.g1 ON pm2.g2.e1 = pm2.g1.e1 AND pm2.g1.e1 IN ('a', 'b') WHERE pm2.g2.e1 IN ('a', 'b')"});
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testCleanCriteria() {
        ProcessorPlan plan = TestOptimizer.helpPlan("select pm2.g1.e1, pm2.g2.e1 from pm2.g1, pm2.g2 where pm2.g1.e1=pm2.g2.e1 and pm2.g1.e2 IN (1, 2)", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT pm2.g1.e1, pm2.g2.e1 FROM pm2.g1, pm2.g2 WHERE (pm2.g1.e1 = pm2.g2.e1) AND (pm2.g1.e2 IN (1, 2))"});
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testCleanCriteria2() {
        ProcessorPlan plan = TestOptimizer.helpPlan("select pm2.g1.e1, pm2.g2.e1 from pm2.g1, pm2.g2 where pm2.g1.e1=pm2.g2.e1 and pm2.g1.e1 = 'a'", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT g_0.e1, g_1.e1 FROM pm2.g1 AS g_0, pm2.g2 AS g_1 WHERE (g_0.e1 = g_1.e1) AND (g_0.e1 = 'a') AND (g_1.e1 = 'a')"});
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testCleanCriteria3() {
        ProcessorPlan plan = TestOptimizer.helpPlan("select pm2.g1.e1, pm2.g2.e1 from pm2.g1 inner join pm2.g2 on pm2.g1.e1=pm2.g2.e1 where pm2.g1.e1 = 'a'", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT g_0.e1, g_1.e1 FROM pm2.g1 AS g_0, pm2.g2 AS g_1 WHERE (g_0.e1 = g_1.e1) AND (g_0.e1 = 'a') AND (g_1.e1 = 'a')"});
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushSubqueryInWhereClause1() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN_SUBQUERY, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("Select e1 from pm1.g1 where e1 in (select e1 FROM pm1.g2)", (QueryMetadataInterface)TestOptimizer.example1(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT e1 FROM pm1.g1 WHERE e1 IN (SELECT e1 FROM pm1.g2)"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushSubqueryInWhereClause2() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN_SUBQUERY, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("Select e1 from pm1.g1 where e1 in (select max(e1) FROM pm1.g2)", (QueryMetadataInterface)TestOptimizer.example1(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT e1 FROM pm1.g1 WHERE e1 IN (SELECT MAX(e1) FROM pm1.g2)"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushSubqueryInWhereClause3() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN_SUBQUERY, true);
        caps.setFunctionSupport("ltrim", true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)new BasicSourceCapabilities());
        ProcessorPlan plan = TestOptimizer.helpPlan("Select e1 from pm1.g1 where e1 in (SELECT ltrim(e1) FROM pm1.g2)", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT e1 FROM pm1.g1 WHERE e1 IN (SELECT ltrim(e1) FROM pm1.g2)"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushSubqueryInWhereClause4() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN_SUBQUERY, true);
        caps.setFunctionSupport("ltrim", true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)new BasicSourceCapabilities());
        ProcessorPlan plan = TestOptimizer.helpPlan("Select e1 from pm1.g1 where e1 in (SELECT ltrim(e1) as m FROM pm1.g2)", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT e1 FROM pm1.g1 WHERE e1 IN (SELECT ltrim(e1) FROM pm1.g2)"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testAliasingDefect1() {
        String sql = "SELECT e1 FROM vm1.g1 X WHERE e2 = (SELECT MAX(e2) FROM vm1.g1 Y WHERE X.e1 = Y.e1)";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_CORRELATED, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_SCALAR, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_SELFJOIN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g1__1.e1 FROM pm1.g1 AS g1__1 WHERE g1__1.e2 = (SELECT MAX(pm1.g1.e2) FROM pm1.g1 WHERE pm1.g1.e1 = g1__1.e1)"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testAliasingDefect2() throws TeiidComponentException, TeiidProcessingException {
        String sql = "SELECT X.e1 FROM vm1.g1 X, vm1.g1 Z WHERE X.e2 = (SELECT MAX(e2) FROM vm1.g1 Y WHERE X.e1 = Y.e1 AND Y.e2 = Z.e2) AND X.e1 = Z.e1";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_CORRELATED, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_SCALAR, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_SELFJOIN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e1 FROM pm1.g1 AS g_0, pm1.g1 AS g_1 WHERE (g_0.e1 = g_1.e1) AND (g_0.e2 = (SELECT MAX(g_2.e2) FROM pm1.g1 AS g_2 WHERE (g_2.e1 = g_0.e1) AND (g_2.e2 = g_1.e2)))"}, ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testAliasingDefect3() throws Exception {
        String sql = "SELECT X.e1 FROM pm1.g2, vm1.g1 X WHERE X.e2 = ALL (SELECT MAX(e2) FROM vm1.g1 Y WHERE X.e1 = Y.e1) AND X.e1 = pm1.g2.e1";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_QUANTIFIED_ALL, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_CORRELATED, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_SCALAR, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_SELFJOIN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_1.e1 FROM pm1.g2 AS g_0, pm1.g1 AS g_1 WHERE (g_1.e1 = g_0.e1) AND (g_1.e2 = ALL (SELECT MAX(g_2.e2) FROM pm1.g1 AS g_2 WHERE g_2.e1 = g_1.e1))"}, ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testUseMergeJoin3() throws Exception {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm1.g2 WHERE pm1.g1.e1 = pm1.g2.e1";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1();
        RealMetadataFactory.setCardinality("pm1.g1", 11, (QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT pm1.g1.e1 FROM pm1.g1 ORDER BY pm1.g1.e1", "SELECT pm1.g2.e1 FROM pm1.g2 ORDER BY pm1.g2.e1"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testUseMergeJoin4() throws Exception {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm1.g2 WHERE pm1.g1.e1 = pm1.g2.e1";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1();
        RealMetadataFactory.setCardinality("pm1.g1", 510, (QueryMetadataInterface)metadata);
        RealMetadataFactory.setCardinality("pm1.g2", 1010, (QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT pm1.g1.e1 FROM pm1.g1 ORDER BY pm1.g1.e1", "SELECT pm1.g2.e1 FROM pm1.g2 ORDER BY pm1.g2.e1"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testUseMergeJoin5_CostsNotKnown() {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm1.g2 WHERE pm1.g1.e1 = pm1.g2.e1";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT pm1.g1.e1 FROM pm1.g1", "SELECT pm1.g2.e1 FROM pm1.g2"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testUseMergeJoin7() throws Exception {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm2.g2 WHERE pm1.g1.e1 = pm2.g2.e1";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1();
        RealMetadataFactory.setCardinality("pm1.g1", 510, (QueryMetadataInterface)metadata);
        RealMetadataFactory.setCardinality("pm1.g2", 1010, (QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT pm1.g1.e1 FROM pm1.g1 ORDER BY pm1.g1.e1", "SELECT pm2.g2.e1 FROM pm2.g2"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testUseMergeJoin7a() throws Exception {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm2.g2 WHERE pm1.g1.e1 = pm2.g2.e1";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1();
        RealMetadataFactory.setCardinality("pm1.g1", 510, (QueryMetadataInterface)metadata);
        RealMetadataFactory.setCardinality("pm1.g2", 1010, (QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT pm1.g1.e1 FROM pm1.g1", "SELECT pm2.g2.e1 FROM pm2.g2 ORDER BY pm2.g2.e1"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testUseMergeJoin8() throws Exception {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm2.g2 WHERE concat(pm1.g1.e1, 'x') = pm2.g2.e1";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_SELFJOIN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1();
        RealMetadataFactory.setCardinality("pm1.g1", 510, (QueryMetadataInterface)metadata);
        RealMetadataFactory.setCardinality("pm1.g2", 1010, (QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT pm1.g1.e1 FROM pm1.g1", "SELECT pm2.g2.e1 FROM pm2.g2 ORDER BY pm2.g2.e1"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 0, 0});
    }

    @Test
    public void testUseMergeJoin9() throws Exception {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm1.g2 WHERE concat(pm1.g1.e1, 'x') = concat(pm1.g2.e1, 'x')";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_SELFJOIN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1();
        RealMetadataFactory.setCardinality("pm1.g1", 510, (QueryMetadataInterface)metadata);
        RealMetadataFactory.setCardinality("pm1.g2", 1010, (QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT pm1.g1.e1 FROM pm1.g1", "SELECT pm1.g2.e1 FROM pm1.g2"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 3, 0, 0, 0});
    }

    @Test
    public void testMultiMergeJoin1() throws Exception {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm1.g2, pm1.g3 WHERE pm1.g1.e1 = pm1.g2.e1 AND pm1.g2.e1 = pm1.g3.e1";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1();
        RealMetadataFactory.setCardinality("pm1.g1", 74, (QueryMetadataInterface)metadata);
        RealMetadataFactory.setCardinality("pm1.g2", 266, (QueryMetadataInterface)metadata);
        RealMetadataFactory.setCardinality("pm1.g3", 266, (QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT pm1.g1.e1 FROM pm1.g1", "SELECT pm1.g2.e1 FROM pm1.g2", "SELECT pm1.g3.e1 FROM pm1.g3"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{3, 0, 0, 0, 0, 0, 0, 2, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testLargeSetCriteria() {
        String sql = "SELECT BQT1.SmallA.IntKey FROM BQT1.SmallA INNER JOIN BQT2.SmallB ON BQT1.SmallA.IntKey = BQT2.SmallB.IntKey WHERE BQT1.SmallA.IntKey IN (1,2,3,4,5)";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)new Integer(1));
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT2", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT BQT1.SmallA.IntKey FROM BQT1.SmallA ORDER BY BQT1.SmallA.IntKey", "SELECT BQT2.SmallB.IntKey FROM BQT2.SmallB ORDER BY BQT2.SmallB.IntKey"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 2, 0, 0});
    }

    @Test
    public void testMergeJoin_defect11236() {
        String sql = "SELECT BQT1.SmallA.IntKey FROM BQT1.SmallA, BQT1.SmallB WHERE BQT1.SmallA.IntKey = (BQT1.SmallB.IntKey + 1)";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        caps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)new Integer(1000));
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT BQT1.SmallB.IntKey FROM BQT1.SmallB", "SELECT BQT1.SmallA.IntKey FROM BQT1.SmallA ORDER BY BQT1.SmallA.IntKey"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 0, 0});
    }

    @Test
    public void testNoFrom() {
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT 1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[0]);
        TestOptimizer.checkNodeTypes(plan, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testINCriteria_defect10718() throws Exception {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm1.g2 WHERE pm1.g1.e1 = pm1.g2.e1";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT, true);
        caps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)new Integer(1000));
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1();
        RealMetadataFactory.setCardinality("pm1.g1", 9, (QueryMetadataInterface)metadata);
        RealMetadataFactory.setCardinality("pm1.g2", 1010, (QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT pm1.g1.e1 FROM pm1.g1 ORDER BY pm1.g1.e1", "SELECT pm1.g2.e1 FROM pm1.g2 ORDER BY pm1.g2.e1"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0});
    }

    @Test
    public void testDefect10711() {
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT * from vm1.g1a as X", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT pm1.g1.e1, pm1.g1.e2, pm1.g1.e3, pm1.g1.e4 FROM pm1.g1"});
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testAggregateNoGroupByWithExpression() {
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT 5, SUM(IntKey) FROM BQT1.SmallA", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), new String[]{"SELECT IntKey FROM BQT1.SmallA"});
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testLookupFunction() {
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT e1 FROM pm1.g2 WHERE LOOKUP('pm1.g1','e1', 'e2', 1) IS NULL", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT e1 FROM pm1.g2 WHERE LOOKUP('pm1.g1', 'e1', 'e2', 1) IS NULL"});
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testLookupFunction2() throws Exception {
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT e1 FROM pm1.g2 WHERE LOOKUP('pm1.g1','e1', 'e2', e2) IS NULL", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT g_0.e2, g_0.e1 FROM pm1.g2 AS g_0"}, ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0});
    }

    @Test
    public void testLookupFunctionInSelect() {
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT e1, LOOKUP('pm1.g1','e1', 'e2', 1) FROM pm1.g2", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT e1, LOOKUP('pm1.g1','e1', 'e2', 1) FROM pm1.g2"});
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testCase1649() {
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT * FROM (SELECT DISTINCT IntKey FROM BQT1.SmallA UNION ALL SELECT IntNum FROM BQT1.SmallA) AS x WHERE IntKey = 0", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), new String[]{"SELECT DISTINCT IntKey FROM BQT1.SmallA WHERE IntKey = 0", "SELECT IntNum FROM BQT1.SmallA WHERE IntNum = 0"});
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1});
    }

    @Test
    public void testCase1727_1() {
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT * FROM (SELECT IntKey a, IntNum b FROM BQT1.SmallA UNION ALL SELECT Intkey, Intkey FROM BQT1.SmallA) as x WHERE b = 0", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), new String[]{"SELECT IntKey, IntNum FROM BQT1.SmallA WHERE IntNum = 0", "SELECT IntKey FROM BQT1.SmallA WHERE IntKey = 0"});
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1});
    }

    @Test
    public void testCase1727_2() {
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT * FROM (SELECT IntKey a, IntKey b FROM BQT1.SmallA UNION ALL SELECT IntKey, IntNum FROM BQT1.SmallA) as x WHERE b = 0", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), new String[]{"SELECT IntKey, IntNum FROM BQT1.SmallA WHERE IntNum = 0", "SELECT IntKey FROM BQT1.SmallA WHERE IntKey = 0"});
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1});
    }

    @Test
    public void testCountStarOverSelectDistinct() {
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT COUNT(*) FROM (SELECT DISTINCT IntNum, Intkey FROM bqt1.smalla) AS x", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), new String[]{"SELECT DISTINCT IntNum, Intkey FROM bqt1.smalla"});
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testVirtualGroup1() {
        ProcessorPlan plan = TestOptimizer.helpPlan("select e2 from vm1.g35", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT e2 FROM pm1.g1"});
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testBQT9500_126() throws Exception {
        String sql = "SELECT IntKey, LongNum, expr FROM (SELECT IntKey, LongNum, concat(LongNum, 'abc') as expr FROM BQT2.SmallA ) AS x ORDER BY IntKey";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), new String[]{"SELECT g_0.IntKey AS c_0, g_0.LongNum AS c_1 FROM BQT2.SmallA AS g_0 ORDER BY c_0"}, ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0});
    }

    public void helpTestUnionPushdown(boolean queryHasOrderBy, boolean hasUnionCapability, boolean hasUnionOrderByCapability) {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, hasUnionCapability);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, hasUnionOrderByCapability);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SET_ORDER_BY, hasUnionOrderByCapability);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        String sqlUnion = "SELECT IntKey FROM BQT1.SmallA UNION ALL SELECT IntKey FROM BQT1.SmallB";
        String sqlOrderBy = sqlUnion + " ORDER BY IntKey";
        String sql = null;
        sql = queryHasOrderBy ? sqlOrderBy : sqlUnion;
        String[] expectedSql = null;
        expectedSql = hasUnionCapability ? (queryHasOrderBy && hasUnionOrderByCapability ? new String[]{sqlOrderBy} : new String[]{sqlUnion}) : new String[]{"SELECT IntKey FROM BQT1.SmallA", "SELECT IntKey FROM BQT1.SmallB"};
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, expectedSql, true);
        int accessCount = hasUnionCapability ? 1 : 2;
        int projectCount = 0;
        int sortCount = 0;
        if (!(!queryHasOrderBy || hasUnionCapability && hasUnionOrderByCapability)) {
            sortCount = 1;
        }
        int unionCount = hasUnionCapability ? 0 : 1;
        TestOptimizer.checkNodeTypes(plan, new int[]{accessCount, 0, 0, 0, 0, 0, 0, 0, 0, 0, projectCount, 0, sortCount, unionCount});
    }

    @Test
    public void testUnionPushdown1() {
        this.helpTestUnionPushdown(false, false, false);
    }

    @Test
    public void testUnionPushdown2() {
        this.helpTestUnionPushdown(false, true, false);
    }

    @Test
    public void testUnionPushdown3() {
        this.helpTestUnionPushdown(true, false, false);
    }

    @Test
    public void testUnionPushdown4() {
        this.helpTestUnionPushdown(true, true, false);
    }

    @Test
    public void testUnionPushdown5() {
        this.helpTestUnionPushdown(true, true, true);
    }

    @Test
    public void testUnionPushdownWithSelectNoFrom() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SET_ORDER_BY, false);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT 1 UNION ALL SELECT 2", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)capFinder, new String[0], true);
        TestOptimizer.checkNodeTypes(plan, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 1});
    }

    @Test
    public void testUnionPushdownWithSelectNoFromFirstBranch() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SET_ORDER_BY, false);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT 1 UNION ALL SELECT IntKey FROM BQT1.SmallA", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT IntKey FROM BQT1.SmallA"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1});
    }

    @Test
    public void testUnionPushdownWithSelectNoFromSecondBranch() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SET_ORDER_BY, false);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT IntKey FROM BQT1.SmallA UNION ALL SELECT 1", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT IntKey FROM BQT1.SmallA"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1});
    }

    @Test
    public void testUnionPushdownMultipleBranches() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SET_ORDER_BY, false);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT IntKey FROM BQT1.SmallA UNION ALL SELECT IntKey FROM BQT1.SmallB UNION ALL SELECT IntKey FROM BQT1.SmallA", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT IntKey FROM BQT1.SmallA UNION ALL SELECT IntKey FROM BQT1.SmallB UNION ALL SELECT IntKey FROM BQT1.SmallA"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testUnionPushdownMultipleBranchesMixedModels1() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SET_ORDER_BY, false);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT2", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT IntKey FROM BQT1.SmallA UNION ALL SELECT IntKey FROM BQT1.SmallB UNION ALL SELECT IntKey FROM BQT2.SmallA", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT IntKey FROM BQT1.SmallA UNION ALL SELECT IntKey FROM BQT1.SmallB", "SELECT IntKey FROM BQT2.SmallA"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1});
    }

    @Test
    public void testUnionPushdownMultipleBranchesNoDupRemoval() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SET_ORDER_BY, false);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT IntKey FROM BQT1.SmallA UNION SELECT IntKey FROM BQT1.SmallB UNION SELECT IntKey FROM BQT1.SmallA", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT IntKey FROM BQT1.SmallA UNION SELECT IntKey FROM BQT1.SmallB UNION SELECT IntKey FROM BQT1.SmallA"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testAggregateOverUnionPushdown() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SET_ORDER_BY, false);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT COUNT(*) FROM (SELECT IntKey FROM BQT1.SmallA UNION SELECT IntKey FROM BQT1.SmallB) AS x", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT IntKey FROM BQT1.SmallA UNION SELECT IntKey FROM BQT1.SmallB"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testUnionPushdownWithFunctionsAndAliases() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SET_ORDER_BY, false);
        caps.setFunctionSupport("+", true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT IntKey+2, StringKey AS x FROM BQT1.SmallA UNION SELECT IntKey, StringKey FROM BQT1.SmallB", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT (IntKey + 2), StringKey AS x FROM BQT1.SmallA UNION SELECT IntKey, StringKey FROM BQT1.SmallB"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testUnionPushdownWithInternalOrderBy() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SET_ORDER_BY, false);
        caps.setFunctionSupport("+", true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("(SELECT IntKey FROM BQT1.SmallA ORDER BY IntKey) UNION ALL SELECT IntKey FROM BQT1.SmallB", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT IntKey FROM BQT1.SmallA UNION ALL SELECT IntKey FROM BQT1.SmallB"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testUnionPushdownWithInternalDistinct() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_DISTINCT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SET_ORDER_BY, false);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT DISTINCT IntKey FROM BQT1.SmallA UNION ALL SELECT IntKey FROM BQT1.SmallB", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT DISTINCT IntKey FROM BQT1.SmallA UNION ALL SELECT IntKey FROM BQT1.SmallB"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testUnionNoAllPushdownInInlineView() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SET_ORDER_BY, false);
        caps.setFunctionSupport("+", true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT x FROM (SELECT IntKey+2, StringKey AS x FROM BQT1.SmallA UNION SELECT IntKey, StringKey FROM BQT1.SmallB) AS g", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT (IntKey + 2), StringKey AS x FROM BQT1.SmallA UNION SELECT IntKey, StringKey FROM BQT1.SmallB"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testUnionAllPushdownInInlineView() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SET_ORDER_BY, false);
        caps.setFunctionSupport("+", true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT x FROM (SELECT IntKey+2, StringKey AS x FROM BQT1.SmallA UNION ALL SELECT IntKey, StringKey FROM BQT1.SmallB) AS g", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT StringKey AS x FROM BQT1.SmallA UNION ALL SELECT StringKey FROM BQT1.SmallB"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testUnionAllPushdownVirtualGroup() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SET_ORDER_BY, true);
        caps.setFunctionSupport("convert", true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT * FROM vm1.g4", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT e1 FROM pm1.g1 UNION ALL SELECT convert(e2, string) FROM pm1.g2"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testUnionAllPushdownVirtualGroup2() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SET_ORDER_BY, true);
        capFinder.addCapabilities("pm3", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT e2 FROM vm1.g17", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT pm3.g1.e2 FROM pm3.g1 UNION ALL SELECT pm3.g2.e2 FROM pm3.g2"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testUnionAllPushdownVirtualGroup3() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SET_ORDER_BY, true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT * FROM (SELECT intkey, 5 FROM BQT1.SmallA UNION ALL SELECT intnum, 10 FROM bqt1.smalla) AS x", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT intkey FROM BQT1.SmallA", "SELECT IntNum FROM bqt1.smalla"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 1});
    }

    @Test
    public void testUnionAllPushdownVirtualGroup4() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SET_ORDER_BY, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT * FROM (SELECT intkey, 5 FROM BQT1.SmallA UNION ALL SELECT intnum, 10 FROM bqt1.smalla) AS x", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT intkey, 5 FROM BQT1.SmallA UNION ALL SELECT IntNum, 10 FROM bqt1.smalla"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushCaseInSelect() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_CASE, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SEARCHED_CASE, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT CASE WHEN e1 = 'a' THEN 10 ELSE 0 END FROM pm1.g1", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT CASE WHEN e1 = 'a' THEN 10 ELSE 0 END FROM pm1.g1"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testCantPushCaseInSelectWithFunction() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_CASE, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT CASE e1 WHEN 'a' THEN 10 ELSE (e2+0) END FROM pm1.g1", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT e1, e2 FROM pm1.g1"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testPushSearchedCaseInSelect() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SEARCHED_CASE, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT CASE WHEN e1 = 'a' THEN 10 ELSE 0 END FROM pm1.g1", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT CASE WHEN e1 = 'a' THEN 10 ELSE 0 END FROM pm1.g1"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testCantPushSearchedCaseInSelectWithFunction() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SEARCHED_CASE, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT CASE WHEN e1 = 'a' THEN 10 ELSE (e2+0) END FROM pm1.g1", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT e1, e2 FROM pm1.g1"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testPushdownFunctionNotEvaluated() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_ORDERED, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_NOT, true);
        caps.setFunctionSupport("xyz", true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT e1 FROM pm1.g1 WHERE xyz() > 0", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT e1 FROM pm1.g1 WHERE xyz() > 0"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testNoSourceQuery() {
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT * FROM (select parsetimestamp(x,'yyyy-MM-dd') as c1 from (select '2004-10-20' as x) as y) as z WHERE c1= '2004-10-20 00:00:00.0'", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), new String[0]);
        TestOptimizer.checkNodeTypes(plan, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 1, 0, 0});
    }

    @Test
    public void testDefect14510LookupFunction() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SEARCHED_CASE, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQT();
        RealMetadataFactory.setCardinality("bqt1.smallb", 1010, (QueryMetadataInterface)metadata);
        RealMetadataFactory.setCardinality("bqt1.smalla", 9, (QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT BQT1.SmallA.IntKey FROM BQT1.SmallA, BQT1.SmallB WHERE (BQT1.SmallA.IntKey = lookup('BQT1.SmallB', 'IntKey', 'StringKey', BQT1.SmallB.StringKey)) AND (BQT1.SmallA.IntKey = 1)", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_1.StringKey, g_0.IntKey FROM BQT1.SmallA AS g_0, BQT1.SmallB AS g_1 WHERE g_0.IntKey = 1"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0});
    }

    @Test
    public void testDefect14510LookupFunction2() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SEARCHED_CASE, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)new Integer(1000));
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQT();
        RealMetadataFactory.setCardinality("bqt1.mediumb", 1010, (QueryMetadataInterface)metadata);
        RealMetadataFactory.setCardinality("bqt1.smalla", 9, (QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT BQT1.SmallA.IntKey, BQT1.MediumB.IntKey FROM BQT1.SmallA LEFT OUTER JOIN BQT1.MediumB ON BQT1.SmallA.IntKey = lookup('BQT1.MediumB', 'IntKey', 'StringKey', BQT1.MediumB.StringKey)", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT BQT1.SmallA.IntKey FROM BQT1.SmallA", "SELECT BQT1.MediumB.StringKey, BQT1.MediumB.IntKey FROM BQT1.MediumB"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 1, 0, 0});
    }

    @Test
    public void testDefect14510LookupFunction3() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SEARCHED_CASE, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)new Integer(1000));
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQT();
        RealMetadataFactory.setCardinality("bqt1.mediumb", 1010, (QueryMetadataInterface)metadata);
        RealMetadataFactory.setCardinality("bqt1.smalla", 9, (QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT BQT1.SmallA.IntKey, BQT1.MediumB.IntKey FROM BQT1.MediumB RIGHT OUTER JOIN BQT1.SmallA ON BQT1.SmallA.IntKey = lookup('BQT1.MediumB', 'IntKey', 'StringKey',BQT1.MediumB.StringKey)", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT BQT1.SmallA.IntKey FROM BQT1.SmallA", "SELECT BQT1.MediumB.StringKey, BQT1.MediumB.IntKey FROM BQT1.MediumB"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 1, 0, 0});
    }

    @Test
    public void testCase2125() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_ORDERED, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_NOT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_AVG, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_SUM, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_SCALAR, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_CORRELATED, true);
        caps.setFunctionSupport("convert", true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        String sql = "SELECT OD.IntKEy, P.IntKEy, O.IntKey FROM (bqt1.smalla AS OD INNER JOIN bqt1.smallb AS P ON OD.StringKey = P.StringKey) INNER JOIN bqt1.mediuma AS O ON O.IntKey = OD.IntKey WHERE (OD.IntNum > (SELECT SUM(IntNum) FROM bqt1.smalla)) AND (P.longnum > (SELECT AVG(LongNum) FROM bqt1.smallb WHERE bqt1.smallb.datevalue = O.datevalue))";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_1.LongNum, g_2.DateValue, g_0.IntKey, g_1.IntKey, g_2.IntKey FROM BQT1.SmallA AS g_0, BQT1.SmallB AS g_1, BQT1.MediumA AS g_2 WHERE (g_0.StringKey = g_1.StringKey) AND (g_2.IntKey = g_0.IntKey) AND (convert(g_0.IntNum, long) > (SELECT SUM(g_3.IntNum) FROM BQT1.SmallA AS g_3))"}, ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testPushdownLiteralInSelectUnderAggregate() {
        String sql = "SELECT COUNT(*) FROM (SELECT '' AS y, a.IntKey FROM BQT1.SmallA a union all select '', b.intkey from bqt1.smallb b) AS x";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT_STAR, true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT 1 AS c_0 FROM BQT1.SmallA AS a UNION ALL SELECT 1 AS c_0 FROM bqt1.smallb AS b"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testPushdownLiteralInSelectUnderAggregate2() {
        String sql = "SELECT SUM(z) FROM (SELECT '' AS y, a.IntKey as z FROM BQT1.SmallA a union all select b.stringkey, 0 from bqt1.smallb b) AS x group by z";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT_STAR, true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT a.IntKey AS z FROM BQT1.SmallA AS a UNION ALL SELECT 0 FROM bqt1.smallb AS b"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testPushdownLiteralInSelectUnderAggregate3() {
        String sql = "SELECT code, SUM(ID) FROM (SELECT IntKey AS ID, '' AS Code FROM BQT1.SmallA union all select intkey, stringkey from bqt1.smallb b) AS x group by code";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT_STAR, true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT '' AS Code, IntKey AS ID FROM BQT1.SmallA UNION ALL SELECT stringkey, intkey FROM bqt1.smallb AS b"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testPushdownLiteralInSelectWithOrderBy() {
        String sql = "SELECT 1, concat('a', 'b' ) AS X FROM BQT1.SmallA where intkey = 0 UNION ALL select 2, 'Hello2' from BQT1.SmallA where intkey = 1 order by X desc";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SET_ORDER_BY, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT 1, 'ab' AS X FROM BQT1.SmallA WHERE intkey = 0 UNION ALL SELECT 2, 'Hello2' FROM BQT1.SmallA WHERE IntKey = 1 ORDER BY X DESC"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testUpdateWithElement() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setFunctionSupport("+", true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        String sql = "UPDATE BQT1.SmallA SET IntKey = IntKey + 1";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)capFinder, new String[]{"UPDATE BQT1.SmallA SET IntKey = (IntKey + 1)"}, ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testCase2187() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_ORDERED, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER_FULL, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_SELFJOIN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        String sql = "SELECT t.intkey FROM (SELECT a.IntKey FROM bqt1.smalla a left outer join bqt1.smallb b on a.intkey=b.intkey, bqt1.smalla x) as t full outer JOIN bqt1.smallb c on t.intkey = c.intkey";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT a.IntKey FROM ((bqt1.smalla AS a LEFT OUTER JOIN bqt1.smallb AS b ON a.intkey = b.intkey) CROSS JOIN bqt1.smalla AS x) FULL OUTER JOIN bqt1.smallb AS c ON a.IntKey = c.intkey"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testMultiUnionMergeVirtual() throws Exception {
        String sql = "SELECT * FROM (SELECT IntKey, 'a' AS s FROM (SELECT intkey, stringkey from BQT1.SmallA) as a union all select IntKey, 'b' FROM (SELECT intkey, stringkey from BQT1.SmallA) as b union all select IntKey, 'c' FROM (SELECT intkey, stringkey from BQT1.SmallA) as c ) AS x";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_2.IntKey AS c_0, 'a' AS c_1 FROM BQT1.SmallA AS g_2 UNION ALL SELECT g_1.IntKey AS c_0, 'b' AS c_1 FROM BQT1.SmallA AS g_1 UNION ALL SELECT g_0.IntKey AS c_0, 'c' AS c_1 FROM BQT1.SmallA AS g_0"}, ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testDefect16848_groupAliasNotSupported_1() {
        String sql = "SELECT sa.intkey, sa.objectvalue FROM bqt1.smalla AS sa WHERE (sa.intkey = 46) AND (sa.stringkey IN (46)) AND (sa.datevalue = (SELECT MAX(sb.datevalue) FROM bqt1.smalla AS sb WHERE (sb.intkey = sa.intkey) AND (sa.stringkey = sb.stringkey) ))";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        RelationalPlan plan = (RelationalPlan)TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT BQT1.SmallA.datevalue, BQT1.SmallA.intkey, BQT1.SmallA.stringkey, BQT1.SmallA.objectvalue FROM BQT1.SmallA WHERE (BQT1.SmallA.intkey = 46) AND (BQT1.SmallA.stringkey = '46')"}, true);
        TestOptimizer.checkNodeTypes((ProcessorPlan)plan, new int[]{1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0});
        ProcessorPlan subplan = ((SubqueryContainer)ValueIteratorProviderCollectorVisitor.getValueIteratorProviders((LanguageObject)((SelectNode)plan.getRootNode().getChildren()[0]).getCriteria()).get(0)).getCommand().getProcessorPlan();
        Set<String> actualQueries = TestOptimizer.getAtomicQueries(subplan);
        HashSet<String> expectedQueries = new HashSet<String>(Arrays.asList("SELECT BQT1.SmallA.DateValue FROM BQT1.SmallA WHERE (BQT1.SmallA.IntKey = sa.IntKey) AND (BQT1.SmallA.StringKey = sa.StringKey)"));
        Assert.assertEquals((String)"Did not get expected atomic queries for subplan: ", expectedQueries, actualQueries);
        TestOptimizer.checkNodeTypes(subplan, new int[]{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testFunctionOfAggregate1() {
        String sql = "SELECT SUM(IntKey) + 1 AS x FROM BQT1.SmallA GROUP BY IntKey";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_SUM, true);
        caps.setFunctionSupport("+", true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT (SUM(IntKey) + 1) FROM BQT1.SmallA GROUP BY IntKey"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testFunctionOfAggregateCantPush1() {
        String sql = "SELECT SUM(IntKey) + 1 AS x FROM BQT1.SmallA GROUP BY IntKey";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT IntKey FROM BQT1.SmallA"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testFunctionOfAggregateCantPush3() {
        String sql = "SELECT avg(intkey) * 2 FROM BQT1.SmallA ";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT intkey FROM BQT1.SmallA"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0});
    }

    private void helpTestCase2589NonPushdown(String sql, String[] expected) {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER_FULL, false);
        caps.setFunctionSupport("concat", true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, expected, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    private void helpTestCase2589(String sql, String expected) throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER_FULL, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SET_ORDER_BY, true);
        caps.setFunctionSupport("concat", true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{expected}, ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testCase2589() throws Exception {
        String sql = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumA LEFT OUTER JOIN VQT.SmallA_2589 ON MediumA.IntKey = SmallA_2589.IntKey";
        String expected = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumA LEFT OUTER JOIN BQT1.SmallA ON BQT1.MediumA.IntKey = BQT1.SmallA.IntKey AND BQT1.SmallA.StringNum = '10'";
        this.helpTestCase2589(sql, expected);
    }

    @Test
    public void testCase2589a() throws Exception {
        String sql = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumA LEFT OUTER JOIN VQT.SmallA_2589a ON MediumA.IntKey = SmallA_2589a.IntKey";
        String expected = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumA LEFT OUTER JOIN (BQT1.SmallA INNER JOIN BQT1.SmallB ON BQT1.SmallA.IntKey = BQT1.SmallB.IntKey) ON BQT1.MediumA.IntKey = BQT1.SmallA.IntKey AND BQT1.SmallA.StringNum = '10'";
        this.helpTestCase2589(sql, expected);
    }

    @Test
    public void testCase2589b() throws Exception {
        String sql = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumA LEFT OUTER JOIN VQT.SmallA_2589b ON MediumA.IntKey = SmallA_2589b.IntKey";
        String expected = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumA LEFT OUTER JOIN (BQT1.SmallA INNER JOIN BQT1.SmallB ON BQT1.SmallA.StringKey = BQT1.SmallB.StringKey) ON BQT1.MediumA.IntKey = BQT1.SmallA.IntKey AND BQT1.SmallA.StringNum = '10'";
        this.helpTestCase2589(sql, expected);
    }

    @Test
    public void testCase2589c() throws Exception {
        String sql = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumB, BQT1.MediumA LEFT OUTER JOIN VQT.SmallA_2589b ON MediumA.IntKey = SmallA_2589b.IntKey WHERE BQT1.MediumB.IntKey = BQT1.MediumA.IntKey";
        String expected = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumB INNER JOIN (BQT1.MediumA LEFT OUTER JOIN (BQT1.SmallA INNER JOIN BQT1.SmallB ON BQT1.SmallA.StringKey = BQT1.SmallB.StringKey) ON BQT1.MediumA.IntKey = BQT1.SmallA.IntKey AND BQT1.SmallA.StringNum = '10') ON BQT1.MediumB.IntKey = BQT1.MediumA.IntKey";
        this.helpTestCase2589(sql, expected);
    }

    @Test
    public void testCase2589d() throws Exception {
        String sql = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumB INNER JOIN (BQT1.MediumA LEFT OUTER JOIN VQT.SmallA_2589b ON MediumA.IntKey = SmallA_2589b.IntKey) ON BQT1.MediumB.IntKey = BQT1.MediumA.IntKey";
        String expected = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumB INNER JOIN (BQT1.MediumA LEFT OUTER JOIN (BQT1.SmallA INNER JOIN BQT1.SmallB ON BQT1.SmallA.StringKey = BQT1.SmallB.StringKey) ON BQT1.MediumA.IntKey = BQT1.SmallA.IntKey AND BQT1.SmallA.StringNum = '10') ON BQT1.MediumB.IntKey = BQT1.MediumA.IntKey";
        this.helpTestCase2589(sql, expected);
    }

    @Test
    public void testCase2589e() throws Exception {
        String sql = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumB LEFT OUTER JOIN (BQT1.MediumA LEFT OUTER JOIN VQT.SmallA_2589b ON MediumA.IntKey = SmallA_2589b.IntKey) ON BQT1.MediumB.IntKey = BQT1.MediumA.IntKey";
        String expected = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumB LEFT OUTER JOIN (BQT1.MediumA LEFT OUTER JOIN (BQT1.SmallA INNER JOIN BQT1.SmallB ON BQT1.SmallA.StringKey = BQT1.SmallB.StringKey) ON BQT1.MediumA.IntKey = BQT1.SmallA.IntKey AND BQT1.SmallA.StringNum = '10') ON BQT1.MediumB.IntKey = BQT1.MediumA.IntKey";
        this.helpTestCase2589(sql, expected);
    }

    @Test
    public void testCase2589f() throws Exception {
        String sql = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumB LEFT OUTER JOIN (BQT1.MediumA INNER JOIN VQT.SmallA_2589b ON MediumA.IntKey = SmallA_2589b.IntKey) ON BQT1.MediumB.IntKey = BQT1.MediumA.IntKey";
        String expected = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumB LEFT OUTER JOIN (BQT1.MediumA INNER JOIN (BQT1.SmallA INNER JOIN BQT1.SmallB ON BQT1.SmallA.StringKey = BQT1.SmallB.StringKey) ON BQT1.MediumA.IntKey = BQT1.SmallA.IntKey) ON BQT1.MediumB.IntKey = BQT1.MediumA.IntKey AND BQT1.SmallA.StringNum = '10'";
        this.helpTestCase2589(sql, expected);
    }

    @Test
    public void testCase2589g() throws Exception {
        String sql = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumB LEFT OUTER JOIN (BQT1.MediumA INNER JOIN VQT.SmallA_2589c ON MediumA.IntKey = SmallA_2589c.IntKey) ON BQT1.MediumB.IntKey = BQT1.MediumA.IntKey";
        String expected = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumB LEFT OUTER JOIN (BQT1.MediumA INNER JOIN (BQT1.SmallA INNER JOIN BQT1.SmallB ON BQT1.SmallA.StringKey = BQT1.SmallB.StringKey AND concat(BQT1.SmallA.StringNum, BQT1.SmallB.StringNum) = '1010') ON BQT1.MediumA.IntKey = BQT1.SmallA.IntKey) ON BQT1.MediumB.IntKey = BQT1.MediumA.IntKey";
        this.helpTestCase2589(sql, expected);
    }

    @Test
    public void testCase2589h() throws Exception {
        String sql = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumA LEFT OUTER JOIN VQT.SmallA_2589c ON MediumA.IntKey = SmallA_2589c.IntKey";
        String expected = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumA LEFT OUTER JOIN (BQT1.SmallA INNER JOIN BQT1.SmallB ON BQT1.SmallA.StringKey = BQT1.SmallB.StringKey AND concat(BQT1.SmallA.StringNum, BQT1.SmallB.StringNum) = '1010') ON BQT1.MediumA.IntKey = BQT1.SmallA.IntKey";
        this.helpTestCase2589(sql, expected);
    }

    @Test
    public void testCase2589i() throws Exception {
        String sql = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumA LEFT OUTER JOIN VQT.SmallA_2589d ON MediumA.IntKey = SmallA_2589d.IntKey";
        String expected = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumA LEFT OUTER JOIN (BQT1.SmallA INNER JOIN BQT1.SmallB ON BQT1.SmallA.StringKey = BQT1.SmallB.StringKey) ON BQT1.MediumA.IntKey = BQT1.SmallA.IntKey AND BQT1.SmallA.StringNum = '10' AND BQT1.SmallA.IntNum = 10";
        this.helpTestCase2589(sql, expected);
    }

    @Test
    public void testCase2589j() throws Exception {
        String sql = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumA INNER JOIN VQT.SmallA_2589 ON MediumA.IntKey = SmallA_2589.IntKey";
        String expected = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumA, BQT1.SmallA WHERE (BQT1.MediumA.IntKey = BQT1.SmallA.IntKey) AND (BQT1.SmallA.StringNum = '10')";
        this.helpTestCase2589(sql, expected);
    }

    @Test
    public void testCase2589k() throws Exception {
        String sql = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumA INNER JOIN VQT.SmallA_2589b ON MediumA.IntKey = SmallA_2589b.IntKey";
        String expected = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumA, BQT1.SmallA, BQT1.SmallB WHERE (BQT1.SmallA.StringKey = BQT1.SmallB.StringKey) AND (BQT1.MediumA.IntKey = BQT1.SmallA.IntKey) AND (BQT1.SmallA.StringNum = '10')";
        this.helpTestCase2589(sql, expected);
    }

    @Test
    public void testCase2589l() throws Exception {
        String sql = "SELECT BQT1.MediumA.IntKey FROM VQT.SmallA_2589 RIGHT OUTER JOIN BQT1.MediumA ON MediumA.IntKey = SmallA_2589.IntKey";
        String expected = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumA LEFT OUTER JOIN BQT1.SmallA ON BQT1.MediumA.IntKey = BQT1.SmallA.IntKey AND BQT1.SmallA.StringNum = '10'";
        this.helpTestCase2589(sql, expected);
    }

    @Test
    public void testCase2589m() {
        String sql = "SELECT BQT1.MediumA.IntKey FROM VQT.SmallA_2589 FULL OUTER JOIN BQT1.MediumA ON MediumA.IntKey = SmallA_2589.IntKey";
        String[] expected = new String[]{"SELECT BQT1.MediumA.IntKey FROM BQT1.MediumA", "SELECT BQT1.SmallA.IntKey FROM BQT1.SmallA WHERE StringNum = '10'"};
        this.helpTestCase2589NonPushdown(sql, expected);
    }

    @Test
    public void testCase2589n() {
        String sql = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumA FULL OUTER JOIN VQT.SmallA_2589b ON MediumA.IntKey = SmallA_2589b.IntKey";
        String[] expected = new String[]{"SELECT BQT1.MediumA.IntKey FROM BQT1.MediumA", "SELECT BQT1.SmallA.IntKey FROM BQT1.SmallA, BQT1.SmallB WHERE (BQT1.SmallA.StringKey = BQT1.SmallB.StringKey) AND (BQT1.SmallA.StringNum = '10')"};
        this.helpTestCase2589NonPushdown(sql, expected);
    }

    @Test
    public void testCase2589o() throws Exception {
        String sql = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumA LEFT OUTER JOIN VQT.SmallA_2589f ON MediumA.IntKey = SmallA_2589f.IntKey";
        String expected = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumA LEFT OUTER JOIN BQT1.SmallA ON BQT1.MediumA.IntKey = BQT1.SmallA.IntKey AND BQT1.SmallA.StringNum = '10'";
        this.helpTestCase2589(sql, expected);
    }

    @Test
    public void testCase2589p() throws Exception {
        String sql = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumA LEFT OUTER JOIN VQT.SmallA_2589g ON MediumA.IntKey = SmallA_2589g.IntKey";
        String expected = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumA LEFT OUTER JOIN (BQT1.SmallA INNER JOIN BQT1.SmallB ON BQT1.SmallA.StringKey = BQT1.SmallB.StringKey) ON BQT1.MediumA.IntKey = BQT1.SmallA.IntKey AND BQT1.SmallA.StringNum = '10'";
        this.helpTestCase2589(sql, expected);
    }

    @Test
    public void testCase2589q() throws Exception {
        String sql = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumA LEFT OUTER JOIN VQT.SmallA_2589h ON MediumA.IntKey = SmallA_2589h.IntKey";
        String expected = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumA LEFT OUTER JOIN (BQT1.SmallA INNER JOIN BQT1.SmallB ON BQT1.SmallA.StringKey = BQT1.SmallB.StringKey) ON BQT1.MediumA.IntKey = BQT1.SmallA.IntKey AND BQT1.SmallA.StringNum = '10'";
        this.helpTestCase2589(sql, expected);
    }

    @Test
    public void testCase2589r() throws Exception {
        String sql = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumA LEFT OUTER JOIN VQT.SmallA_2589i ON MediumA.IntKey = SmallA_2589i.IntKey";
        String expected = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumA LEFT OUTER JOIN (BQT1.SmallA INNER JOIN BQT1.SmallB ON BQT1.SmallA.StringKey = BQT1.SmallB.StringKey) ON BQT1.MediumA.IntKey = BQT1.SmallA.IntKey AND BQT1.SmallA.StringNum = '10' AND BQT1.SmallB.StringNum = '10'";
        this.helpTestCase2589(sql, expected);
    }

    @Test
    public void testCase2589s() throws Exception {
        String sql = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumA LEFT OUTER JOIN VQT.SmallA_2589 ON MediumA.IntKey = SmallA_2589.IntKey WHERE BQT1.MediumA.IntNum = 10";
        String expected = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumA LEFT OUTER JOIN BQT1.SmallA ON BQT1.MediumA.IntKey = BQT1.SmallA.IntKey AND BQT1.SmallA.StringNum = '10' WHERE BQT1.MediumA.IntNum = 10";
        this.helpTestCase2589(sql, expected);
    }

    @Test
    public void testCase2589t() throws Exception {
        String sql = "SELECT z.IntKey FROM (SELECT IntKey FROM BQT1.MediumA WHERE BQT1.MediumA.IntNum = 10) as z LEFT OUTER JOIN VQT.SmallA_2589 ON z.IntKey = SmallA_2589.IntKey";
        String expected = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumA LEFT OUTER JOIN BQT1.SmallA ON BQT1.MediumA.IntKey = BQT1.SmallA.IntKey AND BQT1.SmallA.StringNum = '10' WHERE BQT1.MediumA.IntNum = 10";
        this.helpTestCase2589(sql, expected);
    }

    @Test
    public void testCase2589u() throws Exception {
        String sql = "SELECT z.IntKey FROM (SELECT IntKey FROM BQT1.MediumA WHERE IntNum = 10) as z LEFT OUTER JOIN (SELECT IntKey FROM BQT1.SmallA WHERE StringNum = '10') as y ON z.IntKey = y.IntKey";
        String expected = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumA LEFT OUTER JOIN BQT1.SmallA ON BQT1.MediumA.IntKey = BQT1.SmallA.IntKey AND BQT1.SmallA.StringNum = '10' WHERE BQT1.MediumA.IntNum = 10";
        this.helpTestCase2589(sql, expected);
    }

    @Test
    public void testCase2589v() {
        String sql = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumA LEFT OUTER JOIN VQT.SmallA_2589 ON MediumA.IntKey = SmallA_2589.IntKey";
        String[] expected = new String[]{"SELECT BQT1.MediumA.IntKey FROM BQT1.MediumA", "SELECT BQT1.SmallA.IntKey FROM BQT1.SmallA WHERE StringNum = '10'"};
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER_FULL, false);
        caps.setFunctionSupport("concat", true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, expected, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testCase2589w() {
        String sql = "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumA FULL OUTER JOIN VQT.SmallA_2589 ON MediumA.IntKey = SmallA_2589.IntKey";
        String[] expected = new String[]{"SELECT BQT1.MediumA.IntKey FROM BQT1.MediumA", "SELECT BQT1.SmallA.IntKey FROM BQT1.SmallA WHERE StringNum = '10'"};
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER_FULL, false);
        caps.setFunctionSupport("concat", true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, expected, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testCase2589x() throws Exception {
        String sql = "SELECT BQT1.MediumA.IntKey FROM BQT2.SmallA INNER JOIN (BQT1.MediumA LEFT OUTER JOIN (SELECT IntKey FROM BQT1.SmallA WHERE StringNum = '10') as y ON MediumA.IntKey = y.IntKey) ON BQT2.SmallA.IntKey = BQT1.MediumA.IntKey";
        String[] expected = new String[]{"SELECT BQT2.SmallA.IntKey FROM BQT2.SmallA", "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumA LEFT OUTER JOIN BQT1.SmallA ON BQT1.MediumA.IntKey = BQT1.SmallA.IntKey AND BQT1.SmallA.StringNum = '10'"};
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER_FULL, true);
        caps.setFunctionSupport("concat", true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT2", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, expected, ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testCase2589y() throws Exception {
        String sql = "SELECT L.IntKey, y.IntKey, z.IntKey FROM (BQT1.MediumB as L LEFT OUTER JOIN (SELECT IntKey FROM BQT1.MediumA as M WHERE M.IntNum = 4) as y ON y.IntKey = L.IntKey) LEFT OUTER JOIN (SELECT IntKey FROM BQT1.SmallA as S WHERE S.StringNum = '10') as z ON z.IntKey = y.IntKey";
        String expected = "SELECT BQT1.MediumB.IntKey, BQT1.MediumA.IntKey, BQT1.SmallA.IntKey FROM (BQT1.MediumB LEFT OUTER JOIN BQT1.MediumA ON BQT1.MediumA.IntKey = BQT1.MediumB.IntKey AND BQT1.MediumA.IntNum = 4) LEFT OUTER JOIN BQT1.SmallA ON BQT1.SmallA.IntKey = BQT1.MediumA.IntKey AND BQT1.SmallA.StringNum = '10'";
        this.helpTestCase2589(sql, expected);
    }

    @Test
    public void testCase2589z() {
        String sql = "SELECT BQT1.MediumA.IntKey FROM BQT2.SmallA INNER JOIN (BQT1.MediumA LEFT OUTER JOIN (SELECT BQT1.SmallA.IntKey FROM BQT1.SmallA, BQT1.SmallB WHERE BQT1.SmallA.IntKey = BQT1.SmallB.IntKey AND BQT1.SmallA.StringNum = '10') as y ON MediumA.IntKey = y.IntKey) ON BQT2.SmallA.IntKey = BQT1.MediumA.IntKey";
        String[] expected = new String[]{"SELECT BQT2.SmallA.IntKey FROM BQT2.SmallA", "SELECT BQT1.MediumA.IntKey FROM BQT1.MediumA LEFT OUTER JOIN (BQT1.SmallA INNER JOIN BQT1.SmallB ON BQT1.SmallA.IntKey = BQT1.SmallB.IntKey) ON BQT1.MediumA.IntKey = BQT1.SmallA.IntKey AND BQT1.SmallA.StringNum = '10'"};
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER_FULL, true);
        caps.setFunctionSupport("concat", true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT2", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, expected, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testCase2589aa() throws Exception {
        String sql = "SELECT * FROM (SELECT z.IntKey FROM (SELECT IntKey FROM BQT1.MediumA WHERE IntNum = 10) as z LEFT OUTER JOIN (SELECT IntKey FROM BQT1.SmallA WHERE StringNum = '10') as y ON z.IntKey = y.IntKey UNION ALL SELECT z.IntKey FROM (SELECT IntKey FROM BQT1.MediumA WHERE IntNum = 10) as z LEFT OUTER JOIN (SELECT IntKey FROM BQT1.SmallA WHERE StringNum = '10') as y ON z.IntKey = y.IntKey) as x";
        String expected = "SELECT BQT1.MediumA.IntKey AS c_0 FROM BQT1.MediumA LEFT OUTER JOIN BQT1.SmallA ON BQT1.MediumA.IntKey = BQT1.SmallA.IntKey AND BQT1.SmallA.StringNum = '10' WHERE BQT1.MediumA.IntNum = 10 UNION ALL SELECT BQT1.MediumA.IntKey AS c_0 FROM BQT1.MediumA LEFT OUTER JOIN BQT1.SmallA ON BQT1.MediumA.IntKey = BQT1.SmallA.IntKey AND BQT1.SmallA.StringNum = '10' WHERE BQT1.MediumA.IntNum = 10";
        this.helpTestCase2589(sql, expected);
    }

    @Test
    public void testOrderByDuplicates() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_ORDERED, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER_FULL, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_SELFJOIN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        String sql = "SELECT intkey, x FROM (select intkey, intkey x from bqt1.smalla) z ORDER BY x, intkey";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.IntKey FROM BQT1.SmallA AS g_0 ORDER BY g_0.IntKey"}, ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testCase2507() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_ORDERED, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER_FULL, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_SELFJOIN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        caps.setFunctionSupport("||", true);
        caps.setFunctionSupport("concat", true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        String sql = "SELECT vqt.smallb.a12345 FROM vqt.smallb ORDER BY vqt.smallb.a12345";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT Concat(stringKey, stringNum) AS EXPR FROM BQT1.SmallA ORDER BY EXPR"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testCase2507A() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_ORDERED, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER_FULL, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_SELFJOIN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        caps.setFunctionSupport("concat", true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        String sql = "SELECT CONCAT(bqt1.smalla.stringKey, bqt1.smalla.stringNum) as EXPR, bqt1.smalla.stringKey as EXPR_1 FROM bqt1.smalla  ORDER BY EXPR, EXPR_1";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT CONCAT(bqt1.smalla.stringKey, bqt1.smalla.stringNum) AS EXPR, bqt1.smalla.stringKey AS EXPR_1 FROM bqt1.smalla ORDER BY EXPR, EXPR_1"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testCase2507B() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_ORDERED, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER_FULL, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_SELFJOIN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        caps.setFunctionSupport("concat", true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        String sql = "SELECT CONCAT(bqt1.smalla.stringKey, bqt1.smalla.stringNum), bqt1.smalla.stringKey as EXPR_1 FROM bqt1.smalla ORDER BY EXPR_1";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT CONCAT(bqt1.smalla.stringKey, bqt1.smalla.stringNum), bqt1.smalla.stringKey AS EXPR_1 FROM bqt1.smalla ORDER BY EXPR_1"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPushCrossJoins() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_ORDERED, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER_FULL, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_SELFJOIN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        String sql = "SELECT b1.intkey from (bqt1.SmallA a1 cross join bqt1.smalla a2 cross join bqt1.mediuma b1)  left outer join bqt1.mediumb b2 on b1.intkey = b2.intkey";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_2.IntKey FROM ((BQT1.SmallA AS g_0 CROSS JOIN BQT1.SmallA AS g_1) CROSS JOIN BQT1.MediumA AS g_2) LEFT OUTER JOIN BQT1.MediumB AS g_3 ON g_2.IntKey = g_3.IntKey"}, ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testCase3023() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_ORDERED, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER_FULL, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_SELFJOIN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        caps.setFunctionSupport("concat", true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        String sql = "SELECT bqt1.SmallA.intkey from (bqt1.SmallA inner join (SELECT BAD.intkey from bqt1.SmallB as BAD left outer join bqt1.MediumB on BAD.intkey = bqt1.MediumB.intkey) as X on bqt1.SmallA.intkey = X.intkey) inner join bqt1.MediumA on X.intkey = bqt1.MediumA.intkey";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT bqt1.SmallA.intkey FROM (bqt1.SmallA INNER JOIN (bqt1.SmallB AS BAD LEFT OUTER JOIN bqt1.MediumB ON BAD.intkey = bqt1.MediumB.intkey) ON bqt1.SmallA.intkey = BAD.intkey) INNER JOIN bqt1.MediumA ON BAD.intkey = bqt1.MediumA.intkey"}, true);
    }

    @Test
    public void testCase3367() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        TransformationMetadata metadata = TestOptimizer.example1();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN_SUBQUERY, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_CORRELATED, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("select e1 from pm1.g1 where pm1.g1.e1 IN (SELECT pm1.g2.e1 FROM pm1.g2 WHERE (pm1.g1.e1 = 2))", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT e1 FROM pm1.g1 WHERE pm1.g1.e1 IN (SELECT pm1.g2.e1 FROM pm1.g2 WHERE pm1.g1.e1 = '2')"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testCase3778() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_SELFJOIN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN_SUBQUERY, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("select a.e1, b.e1 from vm2.g1 a, vm2.g1 b where a.e1 = b.e1 and a.e2 in (select e2 from vm1.g1)", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e1, g_2.e1 FROM pm1.g1 AS g_0, pm1.g2 AS g_1, pm1.g1 AS g_2, pm1.g2 AS g_3 WHERE (g_2.e2 = g_3.e2) AND (g_0.e2 = g_1.e2) AND (g_0.e1 = g_2.e1) AND (g_0.e2 IN (SELECT g_4.e2 FROM pm1.g1 AS g_4))"}, ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testCase3832() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_ORDERED, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        caps.setFunctionSupport("concat", true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT2", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        String sql = "select bqt1.smalla.intkey from bqt1.smalla, bqt2.smalla, bqt2.smallb where bqt1.smalla.intkey = bqt2.smalla.intkey and bqt1.smalla.intkey = bqt2.smallb.intkey and bqt2.smalla.stringkey = bqt2.smallb.stringkey";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT BQT2.SmallB.IntKey, BQT2.SmallA.IntKey FROM BQT2.SmallA, BQT2.SmallB WHERE BQT2.SmallA.StringKey = BQT2.SmallB.StringKey ORDER BY BQT2.SmallB.IntKey, BQT2.SmallA.IntKey", "SELECT BQT1.SmallA.IntKey FROM BQT1.SmallA ORDER BY BQT1.SmallA.IntKey"}, ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testDefect21972() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_SCALAR, true);
        caps.setFunctionSupport("convert", true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "select pm1.g1.e1, pm1.g1.e2 from pm1.g1 where e1 = convert((exec pm1.sq11(e2, 2)), integer)";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1"}, true);
    }

    @Test
    public void testExpressionSymbolPreservation() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_SELFJOIN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        capFinder.addCapabilities("BQT2", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        String sql = "SELECT * from (select '1' as test, intkey from bqt2.smalla) foo, (select '2' as test, intkey from bqt2.smalla) foo2 where foo.intkey = foo2.intkey";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.IntKey, g_1.IntKey FROM BQT2.SmallA AS g_0, BQT2.SmallA AS g_1 WHERE g_0.IntKey = g_1.IntKey"}, ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testBadCollapseUnion() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "select convert(e2+1,string) from pm1.g1 union all select e1 from pm1.g2";
        String[] expectedSql = new String[]{"SELECT e2 FROM pm1.g1", "SELECT e1 FROM pm1.g2"};
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, expectedSql, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1});
    }

    @Test
    public void testCase3966() {
        ProcessorPlan plan = TestOptimizer.helpPlan("insert into vm1.g37 (e1, e2, e3, e4) values('test', 1, convert('true', boolean) , convert('12', double) )", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"INSERT INTO pm4.g1 (pm4.g1.e1, pm4.g1.e2, pm4.g1.e3, pm4.g1.e4) VALUES ('test', 1, TRUE, 12.0)"});
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testCase4017() throws Exception {
        String sql = "SELECT env('soap_host') AS HOST, intkey from bqt2.smalla";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), new String[]{"SELECT BQT2.SmallA.IntKey FROM BQT2.SmallA"}, ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testCase4265() throws Exception {
        String sql = "SELECT X.intkey, Y.intkey FROM BQT1.SmallA X, BQT1.SmallA Y WHERE X.IntKey <> Y.IntKey and Y.IntKey = 1";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), new String[]{"SELECT g_0.IntKey FROM BQT1.SmallA AS g_0 WHERE g_0.IntKey <> 1", "SELECT g_0.IntKey FROM BQT1.SmallA AS g_0 WHERE g_0.IntKey = 1"}, ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testCase4265ControlTest() throws Exception {
        String sql = "SELECT X.intkey, Y.intkey FROM BQT1.SmallA X, BQT1.SmallA Y WHERE X.IntKey = Y.IntKey and Y.IntKey = 1";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), new String[]{"SELECT g_0.IntKey FROM BQT1.SmallA AS g_0 WHERE g_0.IntKey = 1"}, ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testExistsCriteriaInSelect() {
        String sql = "select intkey, case when exists (select stringkey from bqt1.smallb) then 'nuge' end as a from vqt.smalla";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), new String[]{"SELECT BQT1.SmallA.IntKey FROM BQT1.SmallA"});
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    }

    @Test
    public void testScalarSubQueryInSelect() {
        String sql = "select intkey, case when (select stringkey from bqt1.smallb) is not null then 'nuge' end as a from vqt.smalla";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), new String[]{"SELECT BQT1.SmallA.IntKey FROM BQT1.SmallA"});
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    }

    @Test
    public void testCase4263() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        TransformationMetadata metadata = TestOptimizer.example1();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_CORRELATED, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_SCALAR, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_SELFJOIN, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("select vm1.g1.e1 from vm1.g1 left outer join (select * from vm1.g2 as v where v.e1 = (select max(vm1.g2.e1) from vm1.g2 where v.e1 = vm1.g2.e1)) f2 on (f2.e1 = vm1.g1.e1)", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g1__1.e1 FROM pm1.g1 AS g1__1 LEFT OUTER JOIN pm1.g1 AS g1__2 ON g1__2.e1 = g1__1.e1 AND g1__2.e1 = (SELECT MAX(pm1.g1.e1) FROM pm1.g1 WHERE pm1.g1.e1 = g1__2.e1)"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testCase4263b() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        TransformationMetadata metadata = TestOptimizer.example1();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_CORRELATED, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_SELFJOIN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("select vm1.g1.e1 from vm1.g1 left outer join (select * from vm1.g2 as v where v.e1 = (select max(pm2.g1.e1) from pm2.g1 where v.e1 = pm2.g1.e1)) f2 on (f2.e1 = vm1.g1.e1)", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT pm1.g1.e1 FROM pm1.g1", "SELECT g1__1.e1 FROM pm1.g1 AS g1__1"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testCase4279() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        TransformationMetadata metadata = TestOptimizer.example1();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_CORRELATED, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_SELFJOIN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_CASE, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SEARCHED_CASE, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("select * from (select v1.e1, v2.e1 as e1_1, v1.e2, v2.e2 as e2_2 from (select * from vm1.g7 where vm1.g7.e2 = 1) v1 left outer join (select * from vm1.g7 where vm1.g7.e2 = 1) v2 on v1.e2 = v2.e2) as v3 where v3.e2 = 1", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT CASE WHEN g_0.e1 = 'S' THEN 'Pay' WHEN g_0.e1 = 'P' THEN 'Rec' ELSE g_0.e1 END, CASE WHEN g_1.e1 = 'S' THEN 'Pay' WHEN g_1.e1 = 'P' THEN 'Rec' ELSE g_1.e1 END, g_0.e2, g_1.e2 FROM pm1.g1 AS g_0 LEFT OUTER JOIN pm1.g1 AS g_1 ON g_0.e2 = g_1.e2 AND g_1.e2 = 1 WHERE g_0.e2 = 1"}, ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testCase4312() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        caps.setFunctionSupport("+", true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TestOptimizer.helpPlan("select ? + 1, pm1.g1.e1 AS EXPR_1 FROM pm1.g1", (QueryMetadataInterface)TestOptimizer.example1(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT (? + 1) AS expr, pm1.g1.e1 FROM pm1.g1"}, true);
    }

    @Test
    public void testCase2507_2() {
        String sql = "SELECT a FROM (SELECT concat(BQT1.SmallA.StringKey, BQT1.SmallA.StringNum) as a FROM BQT1.SmallA, BQT1.SmallB WHERE SmallA.IntKey = SmallB.IntKey) as X ORDER BY X.a";
        String expected = "SELECT concat(BQT1.SmallA.StringKey, BQT1.SmallA.StringNum) AS EXPR FROM BQT1.SmallA, BQT1.SmallB WHERE BQT1.SmallA.IntKey = BQT1.SmallB.IntKey ORDER BY EXPR";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER_FULL, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        caps.setFunctionSupport("concat", true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{expected}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    private void helpTestCase2430and2507(String sql, String expected) {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_ORDERED, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER_FULL, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_SELFJOIN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        caps.setFunctionSupport("concat", true);
        caps.setFunctionSupport("+", true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{expected}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testCase2430D() {
        String sql = "SELECT bqt1.smalla.longnum + bqt1.smalla.longnum as c1234567890123456789012345678901234567890, bqt1.smalla.doublenum as EXPR FROM bqt1.smalla ORDER BY c1234567890123456789012345678901234567890, EXPR ";
        String expected = "SELECT (bqt1.smalla.longnum + bqt1.smalla.longnum) AS c1234567890123456789012345678901234567890, bqt1.smalla.doublenum AS EXPR FROM bqt1.smalla ORDER BY c1234567890123456789012345678901234567890, EXPR";
        this.helpTestCase2430and2507(sql, expected);
    }

    @Test
    public void testCase2430E() {
        String sql = "SELECT CONCAT(bqt1.smalla.stringKey, bqt1.smalla.stringNum) as c1234567890123456789012345678901234567890, CONCAT(bqt1.smalla.stringKey, bqt1.smalla.stringNum) AS EXPR FROM bqt1.smalla ORDER BY c1234567890123456789012345678901234567890, EXPR ";
        String expected = "SELECT CONCAT(bqt1.smalla.stringKey, bqt1.smalla.stringNum) AS c_0 FROM bqt1.smalla ORDER BY c_0";
        this.helpTestCase2430and2507(sql, expected);
    }

    @Test
    public void testCase2430G() {
        String sql = "SELECT CONCAT(bqt1.smalla.stringKey, bqt1.smalla.stringNum) as c1234567890123456789012345678901234567890, CONCAT(bqt1.smalla.stringKey, bqt1.smalla.stringNum) AS EXPR FROM bqt1.smalla ORDER BY c1234567890123456789012345678901234567890";
        String expected = "SELECT CONCAT(bqt1.smalla.stringKey, bqt1.smalla.stringNum) AS c_0 FROM bqt1.smalla ORDER BY c_0";
        this.helpTestCase2430and2507(sql, expected);
    }

    @Test
    public void testCase2507_1() {
        String sql = "SELECT a FROM (SELECT concat(BQT1.SmallA.StringKey, BQT1.SmallA.StringNum) as a FROM BQT1.SmallA) as X ORDER BY X.a";
        String expected = "SELECT concat(BQT1.SmallA.StringKey, BQT1.SmallA.StringNum) AS EXPR FROM BQT1.SmallA ORDER BY EXPR";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        caps.setFunctionSupport("concat", true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{expected}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testDefect23614() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_QUANTIFIED_ALL, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_QUANTIFIED_SOME, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN_SUBQUERY, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_SCALAR, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_CORRELATED, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT intkey FROM bqt1.smalla AS n WHERE intkey = (SELECT MAX(intkey) FROM bqt1.smallb AS s WHERE s.stringkey = concat(n.stringkey, 'a') )", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT intkey, n.stringkey FROM bqt1.smalla AS n"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testSameConnector() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        caps.setSourceProperty(SourceCapabilities.Capability.CONNECTOR_ID, (Object)"1");
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT2", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT A.IntKey, B.IntKey FROM BQT1.SmallA A LEFT OUTER JOIN BQT2.MediumB B ON A.IntKey = B.IntKey", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT A.IntKey, B.IntKey FROM BQT1.SmallA AS A LEFT OUTER JOIN BQT2.MediumB AS B ON A.IntKey = B.IntKey"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
        plan = TestOptimizer.helpPlan("SELECT A.IntKey FROM BQT1.SmallA A UNION select B.intkey from BQT2.MediumB B", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT A.IntKey FROM BQT1.SmallA AS A UNION SELECT B.intkey FROM BQT2.MediumB AS B"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testCase4898() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT 'a' as A FROM BQT1.SmallA A UNION select 'b' as B from BQT1.MediumB B", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT 'a' AS A FROM BQT1.SmallA AS A UNION SELECT 'b' FROM BQT1.MediumB AS B"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testDefect13971() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_DISTINCT, true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        String sql = "select b from (select distinct booleanvalue b, intkey from bqt1.smalla) as x";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT DISTINCT booleanvalue, intkey FROM bqt1.smalla"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testCase5067() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        String sql = "SELECT a.intkey as stringkey, b.stringkey as key2 from bqt1.smalla a, bqt1.smallb b where a.intkey = b.intkey order by stringkey";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT a.intkey AS stringkey, b.stringkey AS key2 FROM bqt1.smalla AS a, bqt1.smallb AS b WHERE a.intkey = b.intkey ORDER BY stringkey"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testDontPushConvertObject() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setFunctionSupport("convert", true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT intkey from bqt1.smalla WHERE stringkey = convert(objectvalue, string)", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT stringkey, objectvalue, intkey FROM bqt1.smalla"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0});
    }

    @Test
    public void testDontPushConvertClobToString() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setFunctionSupport("convert", true);
        capFinder.addCapabilities("LOB", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT ClobValue from LOB.LobTbl WHERE convert(ClobValue, string) = ?", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT ClobValue FROM LOB.LobTbl"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0});
    }

    @Test
    public void testSelectIntoWithDistinct() throws Exception {
        String sql = "select distinct e1 into #temp from pm1.g1";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, new String[]{"SELECT DISTINCT g_0.e1 FROM pm1.g1 AS g_0"}, ComparisonMode.EXACT_COMMAND_STRING);
        Assert.assertFalse((boolean)plan.requiresTransaction(false));
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
        TestOptimizer.checkNodeTypes(plan, new int[]{1}, new Class[]{ProjectIntoNode.class});
    }

    @Test
    public void testInsertQueryExpression() throws Exception {
        String sql = "insert into pm1.g1 (e1) select e1 from pm1.g2";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, new String[]{"SELECT g_0.e1 FROM pm1.g2 AS g_0"}, ComparisonMode.EXACT_COMMAND_STRING);
        Assert.assertTrue((boolean)plan.requiresTransaction(false));
        TestOptimizer.checkNodeTypes(plan, new int[]{1}, new Class[]{ProjectIntoNode.class});
    }

    @Test
    public void testInsertQueryExpression1() throws Exception {
        String sql = "insert into pm1.g1 (e1) select e1 || 1 from pm1.g2";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, new String[]{"SELECT g_0.e1 FROM pm1.g2 AS g_0"}, ComparisonMode.EXACT_COMMAND_STRING);
        Assert.assertTrue((boolean)plan.requiresTransaction(false));
        TestOptimizer.checkNodeTypes(plan, new int[]{1}, new Class[]{ProjectIntoNode.class});
    }

    @Test
    public void testCorrelatedSubqueryOverJoin() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_CORRELATED, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_EXISTS, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        String sql = "select pm1.g1.e1 from pm1.g1, (select * from pm1.g2) y where (pm1.g1.e1 = y.e1) and exists (select e2 from pm1.g2 where e1 = y.e1) and exists (select e3 from pm1.g2 where e1 = y.e1)";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e1 FROM pm1.g1 AS g_0, pm1.g2 AS g_1 WHERE (g_0.e1 = g_1.e1) AND (EXISTS (SELECT g_2.e2 FROM pm1.g2 AS g_2 WHERE g_2.e1 = g_1.e1)) AND (EXISTS (SELECT g_3.e3 FROM pm1.g2 AS g_3 WHERE g_3.e1 = g_1.e1))"}, ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testMaxFromGroups() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setSourceProperty(SourceCapabilities.Capability.MAX_QUERY_FROM_GROUPS, (Object)new Integer(1));
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        TestOptimizer.helpPlan("select pm2.g1.e1 FROM pm2.g1 CROSS JOIN pm2.g2", (QueryMetadataInterface)TestOptimizer.example1(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT pm2.g1.e1 FROM pm2.g1", "SELECT 1 FROM pm2.g2"}, true);
    }

    @Test
    public void testCase6249() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT_STAR, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_SELFJOIN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_INLINE_VIEWS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FUNCTIONS_IN_GROUP_BY, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        caps.setFunctionSupport("convert", true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT2", (SourceCapabilities)TestOptimizer.getTypicalCapabilities());
        String sql = "select count(*) from (select intkey from bqt1.smalla union all select intkey from bqt1.smallb) as a";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT COUNT(*) FROM (SELECT 1 FROM bqt1.smalla UNION ALL SELECT 1 FROM bqt1.smallb) AS a"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testCase6181() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FUNCTIONS_IN_GROUP_BY, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_CASE, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SEARCHED_CASE, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_INLINE_VIEWS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        caps.setFunctionSupport("convert", true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "select a.e1 from (select 1 e1) a, (select e1, 1 as a, x from (select e1, CASE WHEN e1 = 'a' THEN e2 ELSE e3 END as x from pm1.g2) y group by e1, x) b where a.e1 = b.x";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT v_0.c_0 FROM (SELECT CASE WHEN g_0.e1 = 'a' THEN g_0.e2 ELSE convert(g_0.e3, integer) END AS c_0 FROM pm1.g2 AS g_0 GROUP BY g_0.e1, CASE WHEN g_0.e1 = 'a' THEN g_0.e2 ELSE convert(g_0.e3, integer) END) AS v_0 WHERE v_0.c_0 IN (<dependent values>) ORDER BY c_0"}, ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 0, 0});
    }

    @Test
    public void testCase6325() {
        String sql = "select e1 into #temp from pm4.g1 where e1='1'";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, new String[]{"SELECT e1 FROM pm4.g1 WHERE e1 = '1'"});
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testCase6364() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FUNCTIONS_IN_GROUP_BY, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_SUM, true);
        caps.setFunctionSupport("+", true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        String sql = "select * from (SELECT 1+ SUM(intnum) AS s FROM bqt1.smalla) a WHERE a.s>10";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT (1 + SUM(intnum)) FROM bqt1.smalla HAVING SUM(intnum) > 9"}, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testExceptPushdown() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_EXCEPT, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "select e1 from pm1.g1 except select e1 from pm1.g2";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_1.e1 AS c_0 FROM pm1.g1 AS g_1 EXCEPT SELECT g_0.e1 AS c_0 FROM pm1.g2 AS g_0"}, ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testCase6597() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_LIKE, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_NOT, false);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        String sql = "select IntKey from bqt1.smalla where stringkey not like '2%'";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT stringkey, IntKey FROM bqt1.smalla"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0});
    }

    @Test
    public void testCopyCriteriaWithIsNull() {
        String sql = "select * from (select a.intnum, a.intkey y, b.intkey from bqt1.smalla a, bqt2.smalla b where a.intkey = b.intkey) x where intkey is null";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), new String[0]);
    }

    @Test
    public void testBetween() {
        TestOptimizer.helpPlan("select * from pm1.g1 where e2 between 1 and 2", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT pm1.g1.e1, pm1.g1.e2, pm1.g1.e3, pm1.g1.e4 FROM pm1.g1 WHERE (e2 >= 1) AND (e2 <= 2)"});
    }

    @Test
    public void testBetweenInCase() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SEARCHED_CASE, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TestOptimizer.helpPlan("select case when e2 between 3 and 5 then e2 else -1 end from pm1.g1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT CASE WHEN (e2 >= 3) AND (e2 <= 5) THEN e2 ELSE -1 END FROM pm1.g1"}, true);
    }

    @Test
    public void testBetweenInCaseInSum() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SEARCHED_CASE, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_SUM, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TestOptimizer.helpPlan("select sum(case when e2 between 3 and 5 then e2 else -1 end) from pm1.g1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT SUM(CASE WHEN (e2 >= 3) AND (e2 <= 5) THEN e2 ELSE -1 END) FROM pm1.g1"}, true);
    }

    @Test
    public void testBetweenInCaseInSumWithGroupBy() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SEARCHED_CASE, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_SUM, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TestOptimizer.helpPlan("select sum(case when e2 between 3 and 5 then e2 else -1 end) from pm1.g1 group by e1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT SUM(CASE WHEN (e2 >= 3) AND (e2 <= 5) THEN e2 ELSE -1 END) FROM pm1.g1 GROUP BY e1"}, true);
    }

    @Test
    public void testAmbiguousAliasFunctionInSubQuerySource() throws Exception {
        String sql = "SELECT CONVERT(A.e2, biginteger) AS e2 FROM (   SELECT CONVERT(e2, long) AS e2 FROM pm1.g1 AS A) AS A";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, new String[]{"SELECT e2 FROM pm1.g1 AS A"});
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setFunctionSupport("convert", true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT CONVERT(CONVERT(g_0.e2, long), biginteger) FROM pm1.g1 AS g_0"}, ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testNestedTable() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_INLINE_VIEWS, true);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("select pm2.g1.e1, x.e1 from pm2.g1, table(select * from pm2.g2 where pm2.g1.e1=pm2.g2.e1) x where pm2.g1.e2 IN (1, 2)", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT g_0.e1 FROM pm2.g2 AS g_0 WHERE g_0.e1 = pm2.g1.e1", "SELECT g_0.e1 FROM pm2.g1 AS g_0 WHERE g_0.e2 IN (1, 2)"}, capFinder, ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1}, new Class[]{NestedTableJoinStrategy.class});
    }

    @Test
    public void testUpdatePushdownFails() {
        TestOptimizer.helpPlan("update pm1.g1 set e1 = 1 where exists (select 1 from pm1.g2)", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, null, null, false);
    }

    @Test
    public void testUnnamedAggInView() throws Exception {
        MetadataStore metadataStore = new MetadataStore();
        Schema bqt1 = RealMetadataFactory.createPhysicalModel("BQT1", metadataStore);
        Schema vqt = RealMetadataFactory.createVirtualModel("VQT", metadataStore);
        Table bqt1SmallA = RealMetadataFactory.createPhysicalGroup("SmallA", bqt1);
        RealMetadataFactory.createElement("col", bqt1SmallA, "string");
        Table agg3 = RealMetadataFactory.createVirtualGroup("Agg3", vqt, new QueryNode("select count(*) from smalla"));
        RealMetadataFactory.createElement("count", agg3, "integer");
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata(metadataStore, "x", new FunctionTree[0]);
        BasicSourceCapabilities bac = TestOptimizer.getTypicalCapabilities();
        bac.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_INLINE_VIEWS, true);
        bac.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT_STAR, true);
        bac.setCapabilitySupport(SourceCapabilities.Capability.QUERY_GROUP_BY, true);
        TestOptimizer.helpPlan("select count(*) from agg3", (QueryMetadataInterface)metadata, new String[0], (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)bac), ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testMergeGroupBy1() throws Exception {
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.ROW_LIMIT, true);
        caps.setFunctionSupport("+", true);
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT a, b FROM (select 1 as a, 2 as b from pm1.g1) as x group by a, b", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps), new String[]{"SELECT pm1.g1.e1 FROM pm1.g1 LIMIT 1"}, ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testNonJoinComparison() throws Exception {
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_ONLY_LITERAL_COMPARE, true);
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT intkey from bqt1.smalla where intkey = intnum", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps), new String[]{"SELECT BQT1.SmallA.IntKey, BQT1.SmallA.IntNum FROM BQT1.SmallA"}, ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0});
    }

    @Test
    public void testConvertSignature() throws Exception {
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setFunctionSupport("convert", true);
        caps.setTranslator((ExecutionFactory)new ExecutionFactory<Object, Object>(){

            public boolean supportsConvert(int fromType, int toType) {
                return fromType == 5 && toType == 0;
            }
        });
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT e1 from pm1.g1 where e1 = e2 and e1 = e3", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps), new String[]{"SELECT pm1.g1.e1, pm1.g1.e3 FROM pm1.g1 WHERE pm1.g1.e1 = convert(pm1.g1.e2, string)"}, ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0});
    }

    @Test
    public void testParseFormat() throws Exception {
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.ONLY_FORMAT_LITERALS, true);
        caps.setFunctionSupport("formattimestamp", true);
        caps.setFunctionSupport("parsebigdecimal", true);
        caps.setTranslator((ExecutionFactory)new ExecutionFactory<Object, Object>(){

            public boolean supportsFormatLiteral(String literal, ExecutionFactory.Format format) {
                return format == ExecutionFactory.Format.DATE && literal.equals("yyyy") || format == ExecutionFactory.Format.NUMBER && literal.equals("$");
            }
        });
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT stringkey from bqt1.smalla where formattimestamp(timestampvalue, 'yyyy') = '1921' and parsebigdecimal(stringkey, '$') = 1 and formattimestamp(timestampvalue, 'yy') = '19'", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps), new String[]{"SELECT g_0.TimestampValue, g_0.StringKey FROM BQT1.SmallA AS g_0 WHERE (formattimestamp(g_0.TimestampValue, 'yyyy') = '1921') AND (parsebigdecimal(g_0.StringKey, '$') = 1)"}, ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0});
    }

    @Test
    public void testDistinctConstant() throws Exception {
        String sql = "select distinct 1 from pm1.g1";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, TestOptimizer.getGenericFinder(), new String[]{"SELECT DISTINCT 1 FROM pm1.g1 AS g_0"}, ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testDistinctConstant1() throws Exception {
        String sql = "select distinct 1 from pm1.g1";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), new String[]{"SELECT pm1.g1.e1 FROM pm1.g1"}, ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0}, TestLimit.NODE_TYPES);
    }

    @Test
    public void testDistinctConstant2() throws Exception {
        String sql = "select distinct 1 from pm1.g1";
        BasicSourceCapabilities bsc = TestOptimizer.getTypicalCapabilities();
        bsc.setCapabilitySupport(SourceCapabilities.Capability.ROW_LIMIT, true);
        DefaultCapabilitiesFinder capFinder = new DefaultCapabilitiesFinder((SourceCapabilities)bsc);
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT 1 AS c_0 FROM pm1.g1 AS g_0 LIMIT 1"}, ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN);
    }

    @Test
    public void testPlanNodeAnnotation() throws Exception {
        PlanNode pn = new PlanNode();
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        Schema modelID = metadata.getMetadataStore().getSchema("pm1");
        AnalysisRecord record = new AnalysisRecord(true, true);
        pn.recordDebugAnnotation("hello", (Object)modelID, "world", record, (QueryMetadataInterface)metadata);
        Assert.assertEquals((Object)"[QueryAnnotation<Relational Planner, LOW,hello pm1,world Unknown: 0(groups=[]>]", (Object)record.getAnnotations().toString());
    }

    @Test
    public void testRecursiveView() throws Exception {
        String ddl = "CREATE view x (y string) as (select * from x)";
        TransformationMetadata metadata = RealMetadataFactory.fromDDL(ddl, "x", "phy");
        TestOptimizer.getPlan(TestOptimizer.helpGetCommand("select * from x", (QueryMetadataInterface)metadata, null), (QueryMetadataInterface)metadata, TestOptimizer.getGenericFinder(), null, false, null);
    }

    public static enum ComparisonMode {
        EXACT_COMMAND_STRING,
        CORRECTED_COMMAND_STRING,
        FAILED_PLANNING;

    }

    public static interface DupRemoveSortNode {
    }

    public static interface DupRemoveNode {
    }

    public static interface DependentProjectNode {
    }

    public static interface AntiSemiJoin {
    }

    public static interface SemiJoin {
    }

    public static interface DependentSelectNode {
    }

    public static interface DependentJoin {
    }
}

