/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.parser;

import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.DuplicateRecordException;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataException;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.ParseException;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.metadata.MetadataValidator;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.parser.SQLParserUtil;
import org.teiid.query.validator.ValidatorReport;

public class TestDDLParser {
    private QueryParser parser = new QueryParser();

    @Test
    public void testForeignTable() throws Exception {
        String ddl = "CREATE FOREIGN TABLE G1(\ne1 integer primary key,\ne2 varchar(10) unique,\ne3 date not null unique,\ne4 decimal(12,3) options (searchable 'unsearchable'),\ne5 integer auto_increment INDEX OPTIONS (UUID 'uuid', NAMEINSOURCE 'nis', SELECTABLE 'NO'),\ne6 varchar index default 'hello')\nOPTIONS (CARDINALITY 12, UUID 'uuid2',  UPDATABLE 'true', FOO 'BAR', ANNOTATION 'Test Table')";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        NavigableMap tableMap = s.getTables();
        Assert.assertTrue((String)"Table not found", (boolean)tableMap.containsKey("G1"));
        Table table = (Table)tableMap.get("G1");
        Assert.assertTrue((boolean)table.isPhysical());
        Assert.assertFalse((boolean)table.isVirtual());
        Assert.assertFalse((boolean)table.isSystem());
        Assert.assertFalse((boolean)table.isMaterialized());
        Assert.assertFalse((boolean)table.isDeletePlanEnabled());
        Assert.assertEquals((Object)"uuid2", (Object)table.getUUID());
        Assert.assertEquals((long)12L, (long)table.getCardinality());
        Assert.assertTrue((boolean)table.supportsUpdate());
        Assert.assertEquals((Object)"BAR", table.getProperties().get("FOO"));
        Assert.assertEquals((Object)"Test Table", (Object)table.getAnnotation());
        Assert.assertEquals((long)6L, (long)table.getColumns().size());
        List columns = table.getColumns();
        Column e1 = (Column)columns.get(0);
        Column e2 = (Column)columns.get(1);
        Column e3 = (Column)columns.get(2);
        Column e4 = (Column)columns.get(3);
        Column e5 = (Column)columns.get(4);
        Column e6 = (Column)columns.get(5);
        Assert.assertEquals((Object)"e1", (Object)e1.getName());
        Assert.assertEquals((Object)"int", (Object)e1.getDatatype().getName());
        Assert.assertEquals((String)"primary key not same", (Object)e1, table.getPrimaryKey().getColumns().get(0));
        Assert.assertEquals((Object)"e2", (Object)e2.getName());
        Assert.assertEquals((Object)"string", (Object)e2.getDatatype().getName());
        Assert.assertEquals((String)"unique", (Object)e2, ((KeyRecord)table.getUniqueKeys().get(0)).getColumns().get(0));
        Assert.assertEquals((Object)BaseColumn.NullType.Nullable, (Object)e2.getNullType());
        Assert.assertEquals((long)10L, (long)e2.getLength());
        Assert.assertEquals((long)0L, (long)e2.getPrecision());
        Assert.assertEquals((Object)"e3", (Object)e3.getName());
        Assert.assertEquals((Object)"date", (Object)e3.getDatatype().getName());
        Assert.assertEquals((String)"unique", (Object)e3, ((KeyRecord)table.getUniqueKeys().get(1)).getColumns().get(0));
        Assert.assertEquals((Object)BaseColumn.NullType.No_Nulls, (Object)e3.getNullType());
        Assert.assertEquals((Object)"e4", (Object)e4.getName());
        Assert.assertEquals((Object)"bigdecimal", (Object)e4.getDatatype().getName());
        Assert.assertEquals((Object)false, (Object)e4.isAutoIncremented());
        Assert.assertEquals((long)12L, (long)e4.getPrecision());
        Assert.assertEquals((long)3L, (long)e4.getScale());
        Assert.assertEquals((Object)Column.SearchType.Unsearchable, (Object)e4.getSearchType());
        Assert.assertEquals((Object)"e5", (Object)e5.getName());
        Assert.assertEquals((Object)"int", (Object)e5.getDatatype().getName());
        Assert.assertEquals((Object)true, (Object)e5.isAutoIncremented());
        Assert.assertEquals((Object)"uuid", (Object)e5.getUUID());
        Assert.assertEquals((Object)"nis", (Object)e5.getNameInSource());
        Assert.assertEquals((Object)false, (Object)e5.isSelectable());
        Assert.assertEquals((String)"index", (Object)e5, ((KeyRecord)table.getIndexes().get(0)).getColumns().get(0));
        Assert.assertEquals((Object)"e6", (Object)e6.getName());
        Assert.assertEquals((Object)"string", (Object)e6.getDatatype().getName());
        Assert.assertEquals((String)"index", (Object)e6, ((KeyRecord)table.getIndexes().get(1)).getColumns().get(0));
        Assert.assertEquals((Object)"hello", (Object)e6.getDefaultValue());
    }

    @Test(expected=MetadataException.class)
    public void testDuplicatePrimarykey() throws Exception {
        String ddl = "CREATE FOREIGN TABLE G1( e1 integer primary key, e2 varchar primary key)";
        MetadataStore mds = new MetadataStore();
        MetadataFactory mf = new MetadataFactory(null, 1, "model", TestDDLParser.getDataTypes(), new Properties(), null);
        this.parser.parseDDL(mf, ddl);
        mf.mergeInto(mds);
    }

    @Test
    public void testUDT() throws Exception {
        String ddl = "CREATE FOREIGN TABLE G1( e1 integer, e2 varchar OPTIONS (UDT 'NMTOKENS(12,13,14)'))";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        NavigableMap tableMap = s.getTables();
        Assert.assertTrue((String)"Table not found", (boolean)tableMap.containsKey("G1"));
        Table table = (Table)tableMap.get("G1");
        Assert.assertEquals((Object)"NMTOKENS", (Object)((Column)table.getColumns().get(1)).getDatatype().getName());
        Assert.assertEquals((long)12L, (long)((Column)table.getColumns().get(1)).getLength());
        Assert.assertEquals((long)13L, (long)((Column)table.getColumns().get(1)).getPrecision());
        Assert.assertEquals((long)14L, (long)((Column)table.getColumns().get(1)).getScale());
    }

    @Test
    public void testFBI() throws Exception {
        String ddl = "CREATE FOREIGN TABLE G1(e1 integer, e2 varchar, CONSTRAINT fbi INDEX (UPPER(e2)))";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        NavigableMap tableMap = s.getTables();
        Table table = (Table)tableMap.get("G1");
        Assert.assertEquals((long)1L, (long)table.getFunctionBasedIndexes().size());
    }

    @Test
    public void testMultiKeyPK() throws Exception {
        String ddl = "CREATE FOREIGN TABLE G1( e1 integer, e2 varchar, e3 date, PRIMARY KEY (e1, e2))";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        NavigableMap tableMap = s.getTables();
        Assert.assertTrue((String)"Table not found", (boolean)tableMap.containsKey("G1"));
        Table table = (Table)tableMap.get("G1");
        Assert.assertEquals(table.getColumns().subList(0, 2), (Object)table.getPrimaryKey().getColumns());
    }

    @Test
    public void testOptionsKey() throws Exception {
        String ddl = "CREATE FOREIGN TABLE G1( e1 integer, e2 varchar, e3 date, UNIQUE (e1) OPTIONS (CUSTOM_PROP 'VALUE'))";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        NavigableMap tableMap = s.getTables();
        Assert.assertTrue((String)"Table not found", (boolean)tableMap.containsKey("G1"));
        Table table = (Table)tableMap.get("G1");
        KeyRecord record = (KeyRecord)table.getAllKeys().iterator().next();
        Assert.assertEquals((Object)"VALUE", (Object)record.getProperty("CUSTOM_PROP", false));
    }

    @Test
    public void testConstraints() throws Exception {
        String ddl = "CREATE FOREIGN TABLE G1( e1 integer, e2 varchar, e3 date,  PRIMARY KEY (e1, e2), INDEX(e2, e3), ACCESSPATTERN(e1), UNIQUE(e1), ACCESSPATTERN(e2, e3))";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        NavigableMap tableMap = s.getTables();
        Assert.assertTrue((String)"Table not found", (boolean)tableMap.containsKey("G1"));
        Table table = (Table)tableMap.get("G1");
        Assert.assertEquals(table.getColumns().subList(0, 2), (Object)table.getPrimaryKey().getColumns());
        Assert.assertEquals(table.getColumns().subList(1, 3), (Object)((KeyRecord)table.getIndexes().get(0)).getColumns());
        Assert.assertEquals(table.getColumns().subList(0, 1), (Object)((KeyRecord)table.getUniqueKeys().get(0)).getColumns());
        Assert.assertEquals((long)2L, (long)table.getAccessPatterns().size());
        Assert.assertEquals(table.getColumns().subList(0, 1), (Object)((KeyRecord)table.getAccessPatterns().get(0)).getColumns());
        Assert.assertEquals(table.getColumns().subList(1, 3), (Object)((KeyRecord)table.getAccessPatterns().get(1)).getColumns());
    }

    @Test
    public void testConstraints2() throws Exception {
        String ddl = "CREATE FOREIGN TABLE G1( e1 integer, e2 varchar, e3 date, ACCESSPATTERN(e1), UNIQUE(e1), ACCESSPATTERN(e2, e3))";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        NavigableMap tableMap = s.getTables();
        Assert.assertTrue((String)"Table not found", (boolean)tableMap.containsKey("G1"));
        Table table = (Table)tableMap.get("G1");
        Assert.assertEquals(table.getColumns().subList(0, 1), (Object)((KeyRecord)table.getUniqueKeys().get(0)).getColumns());
        Assert.assertEquals((long)2L, (long)table.getAccessPatterns().size());
        Assert.assertEquals(table.getColumns().subList(0, 1), (Object)((KeyRecord)table.getAccessPatterns().get(0)).getColumns());
        Assert.assertEquals(table.getColumns().subList(1, 3), (Object)((KeyRecord)table.getAccessPatterns().get(1)).getColumns());
    }

    @Test(expected=MetadataException.class)
    public void testWrongPrimarykey() throws Exception {
        String ddl = "CREATE FOREIGN TABLE G1( e1 integer, e2 varchar, PRIMARY KEY (e3))";
        MetadataStore mds = new MetadataStore();
        MetadataFactory mf = new MetadataFactory(null, 1, "model", TestDDLParser.getDataTypes(), new Properties(), null);
        this.parser.parseDDL(mf, ddl);
        mf.mergeInto(mds);
    }

    @Test
    public void testFK() throws Exception {
        String ddl = "CREATE FOREIGN TABLE G1(g1e1 integer, g1e2 varchar, PRIMARY KEY(g1e1, g1e2));\nCREATE FOREIGN TABLE G2( g2e1 integer, g2e2 varchar, FOREIGN KEY (g2e1, g2e2) REFERENCES G1 (g1e1, g1e2))";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        NavigableMap tableMap = s.getTables();
        Assert.assertEquals((long)2L, (long)tableMap.size());
        Assert.assertTrue((String)"Table not found", (boolean)tableMap.containsKey("G1"));
        Assert.assertTrue((String)"Table not found", (boolean)tableMap.containsKey("G2"));
        Table table = (Table)tableMap.get("G2");
        ForeignKey fk = (ForeignKey)table.getForeignKeys().get(0);
        Assert.assertEquals((Object)fk.getColumns(), (Object)table.getColumns());
        Assert.assertEquals((Object)"G1", (Object)fk.getReferenceTableName());
    }

    @Test
    public void testOptionalFK() throws Exception {
        String ddl = "CREATE FOREIGN TABLE G1(g1e1 integer, g1e2 varchar, PRIMARY KEY(g1e1, g1e2));\nCREATE FOREIGN TABLE G2( g2e1 integer, g2e2 varchar, PRIMARY KEY(g2e1, g2e2),FOREIGN KEY (g2e1, g2e2) REFERENCES G1)";
        MetadataFactory s = TestDDLParser.helpParse(ddl, "model");
        NavigableMap tableMap = s.getSchema().getTables();
        Assert.assertEquals((long)2L, (long)tableMap.size());
        Assert.assertTrue((String)"Table not found", (boolean)tableMap.containsKey("G1"));
        Assert.assertTrue((String)"Table not found", (boolean)tableMap.containsKey("G2"));
        Table table = (Table)tableMap.get("G2");
        ForeignKey fk = (ForeignKey)table.getForeignKeys().get(0);
        Assert.assertEquals((Object)fk.getColumns(), (Object)table.getColumns());
        Assert.assertEquals((Object)"G1", (Object)fk.getReferenceTableName());
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("myVDB");
        ModelMetaData modelOne = new ModelMetaData();
        modelOne.setName("model");
        vdb.addModel(modelOne);
        ValidatorReport report = new MetadataValidator().validate(vdb, s.asMetadataStore());
        Assert.assertFalse((boolean)report.hasItems());
        Assert.assertEquals((Object)fk.getPrimaryKey().getColumns(), (Object)((Table)tableMap.get("G1")).getColumns());
    }

    @Test
    public void testOptionalFKFail() throws Exception {
        String ddl = "CREATE FOREIGN TABLE G1(g1e1 integer, g1e2 varchar);\nCREATE FOREIGN TABLE G2( g2e1 integer, g2e2 varchar, PRIMARY KEY(g2e1, g2e2),FOREIGN KEY (g2e1, g2e2) REFERENCES G1)";
        MetadataFactory s = TestDDLParser.helpParse(ddl, "model");
        NavigableMap tableMap = s.getSchema().getTables();
        Assert.assertEquals((long)2L, (long)tableMap.size());
        Assert.assertTrue((String)"Table not found", (boolean)tableMap.containsKey("G1"));
        Assert.assertTrue((String)"Table not found", (boolean)tableMap.containsKey("G2"));
        Table table = (Table)tableMap.get("G2");
        ForeignKey fk = (ForeignKey)table.getForeignKeys().get(0);
        Assert.assertEquals((Object)fk.getColumns(), (Object)table.getColumns());
        Assert.assertEquals((Object)"G1", (Object)fk.getReferenceTableName());
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("myVDB");
        ModelMetaData modelOne = new ModelMetaData();
        modelOne.setName("model");
        vdb.addModel(modelOne);
        ValidatorReport report = new MetadataValidator().validate(vdb, s.asMetadataStore());
        Assert.assertTrue((boolean)report.hasItems());
    }

    @Test
    public void testFKAccrossSchemas() throws Exception {
        String ddl = "CREATE FOREIGN TABLE G1(g1e1 integer, g1e2 varchar, PRIMARY KEY(g1e1, g1e2));\n";
        String ddl2 = "CREATE FOREIGN TABLE G2( g2e1 integer, g2e2 varchar, PRIMARY KEY(g2e1, g2e2),FOREIGN KEY (g2e1, g2e2) REFERENCES model.G1)";
        MetadataFactory f1 = TestDDLParser.helpParse(ddl, "model");
        MetadataFactory f2 = TestDDLParser.helpParse(ddl2, "model2");
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("myVDB");
        ModelMetaData modelOne = new ModelMetaData();
        modelOne.setName("model");
        vdb.addModel(modelOne);
        ModelMetaData modelTwo = new ModelMetaData();
        modelTwo.setName("model2");
        vdb.addModel(modelTwo);
        MetadataStore s = f1.asMetadataStore();
        f2.mergeInto(s);
        ValidatorReport report = new MetadataValidator().validate(vdb, s);
        Assert.assertFalse((boolean)report.hasItems());
        Table table = s.getSchema("model2").getTable("G2");
        ForeignKey fk = (ForeignKey)table.getForeignKeys().get(0);
        Assert.assertEquals((Object)fk.getColumns(), (Object)table.getColumns());
        Assert.assertEquals((Object)"model.G1", (Object)fk.getReferenceTableName());
        Assert.assertEquals((Object)fk.getPrimaryKey().getColumns(), (Object)s.getSchema("model").getTable("G1").getColumns());
    }

    @Test(expected=MetadataException.class)
    public void testTableWithPlan() throws Exception {
        String ddl = "CREATE foreign table G1 as select 1";
        MetadataStore mds = new MetadataStore();
        MetadataFactory mf = new MetadataFactory(null, 1, "model", TestDDLParser.getDataTypes(), new Properties(), null);
        this.parser.parseDDL(mf, ddl);
        mf.mergeInto(mds);
    }

    @Test
    public void testViewWithoutColumns() throws Exception {
        MetadataStore mds = new MetadataStore();
        MetadataFactory mf = new MetadataFactory(null, 1, "VM1", TestDDLParser.getDataTypes(), new Properties(), null);
        this.parser.parseDDL(mf, "CREATE VIEW V1 AS SELECT * FROM PM1.G1");
        mf.mergeInto(mds);
    }

    @Test
    public void testMultipleCommands() throws Exception {
        String ddl = "CREATE VIEW V1 AS SELECT * FROM PM1.G1 CREATE PROCEDURE FOO(P1 integer) RETURNS (e1 integer, e2 varchar) AS SELECT * FROM PM1.G1;";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        NavigableMap tableMap = s.getTables();
        Table table = (Table)tableMap.get("V1");
        Assert.assertNotNull((Object)table);
        Assert.assertEquals((Object)"SELECT * FROM PM1.G1", (Object)table.getSelectTransformation());
        NavigableMap procedureMap = s.getProcedures();
        Procedure p = (Procedure)procedureMap.get("FOO");
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((Object)"SELECT * FROM PM1.G1;", (Object)p.getQueryPlan());
    }

    @Test
    public void testMultipleCommands2() throws Exception {
        String ddl = "             CREATE VIRTUAL PROCEDURE getTweets(query varchar) RETURNS (created_on varchar(25), from_user varchar(25), to_user varchar(25), \n                 profile_image_url varchar(25), source varchar(25), text varchar(140)) AS \n                select tweet.* from \n\t                (call twitter.invokeHTTP(action => 'GET', endpoint =>querystring('',query as \"q\"))) w, \n\t                XMLTABLE('results' passing JSONTOXML('myxml', w.result) columns \n\t                created_on string PATH 'created_at', \n\t                from_user string PATH 'from_user',\n\t                to_user string PATH 'to_user',\t\n\t                profile_image_url string PATH 'profile_image_url',\t\n\t                source string PATH 'source',\t\n\t                text string PATH 'text') tweet;                CREATE VIEW Tweet AS select * FROM twitterview.getTweets;";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        NavigableMap tableMap = s.getTables();
        Table table = (Table)tableMap.get("Tweet");
        Assert.assertNotNull((Object)table);
        NavigableMap procedureMap = s.getProcedures();
        Procedure p = (Procedure)procedureMap.get("getTweets");
        Assert.assertNotNull((Object)p);
    }

    @Test
    public void testView() throws Exception {
        String ddl = "CREATE View G1( e1 integer, e2 varchar) OPTIONS (CARDINALITY 12) AS select e1, e2 from foo.bar";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        NavigableMap tableMap = s.getTables();
        Table table = (Table)tableMap.get("G1");
        Assert.assertEquals((Object)"SELECT e1, e2 FROM foo.bar", (Object)table.getSelectTransformation());
        Assert.assertEquals((long)12L, (long)table.getCardinality());
    }

    @Test
    public void testPushdownFunctionNoArgs() throws Exception {
        String ddl = "CREATE FOREIGN FUNCTION SourceFunc() RETURNS integer OPTIONS (UUID 'hello world')";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        FunctionMethod fm = s.getFunction("hello world");
        Assert.assertNotNull((Object)fm);
        Assert.assertEquals((Object)"integer", (Object)fm.getOutputParameter().getType());
        Assert.assertEquals((Object)FunctionMethod.PushDown.MUST_PUSHDOWN, (Object)fm.getPushdown());
    }

    @Test(expected=DuplicateRecordException.class)
    public void testDuplicateFunctions() throws Exception {
        String ddl = "CREATE FUNCTION SourceFunc() RETURNS integer; CREATE FUNCTION SourceFunc() RETURNS string";
        TestDDLParser.helpParse(ddl, "model");
    }

    @Test(expected=DuplicateRecordException.class)
    public void testDuplicateFunctions1() throws Exception {
        String ddl = "CREATE FUNCTION SourceFunc() RETURNS string OPTIONS (UUID 'a'); CREATE FUNCTION SourceFunc1() RETURNS string OPTIONS (UUID 'a')";
        TestDDLParser.helpParse(ddl, "model");
    }

    @Test
    public void testDuplicateFunctions2() throws Exception {
        String ddl = "CREATE FUNCTION SourceFunc() RETURNS string; CREATE FUNCTION SourceFunc(param string) RETURNS string";
        TestDDLParser.helpParse(ddl, "model");
    }

    @Test
    public void testUDF() throws Exception {
        String ddl = "CREATE VIRTUAL FUNCTION SourceFunc(flag boolean, msg varchar) RETURNS varchar OPTIONS(CATEGORY 'misc', DETERMINISM 'DETERMINISTIC', \"NULL-ON-NULL\" 'true', JAVA_CLASS 'foo', JAVA_METHOD 'bar', RANDOM 'any', UUID 'x')";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        FunctionMethod fm = s.getFunction("x");
        Assert.assertNotNull((Object)fm);
        Assert.assertEquals((Object)"string", (Object)fm.getOutputParameter().getType());
        Assert.assertEquals((Object)FunctionMethod.PushDown.CAN_PUSHDOWN, (Object)fm.getPushdown());
        Assert.assertEquals((long)2L, (long)fm.getInputParameterCount());
        Assert.assertEquals((Object)"flag", (Object)((FunctionParameter)fm.getInputParameters().get(0)).getName());
        Assert.assertEquals((Object)"boolean", (Object)((FunctionParameter)fm.getInputParameters().get(0)).getType());
        Assert.assertEquals((Object)"msg", (Object)((FunctionParameter)fm.getInputParameters().get(1)).getName());
        Assert.assertEquals((Object)"string", (Object)((FunctionParameter)fm.getInputParameters().get(1)).getType());
        Assert.assertFalse((boolean)((FunctionParameter)fm.getInputParameters().get(1)).isVarArg());
        Assert.assertEquals((Object)FunctionMethod.Determinism.DETERMINISTIC, (Object)fm.getDeterminism());
        Assert.assertEquals((Object)"misc", (Object)fm.getCategory());
        Assert.assertEquals((Object)true, (Object)fm.isNullOnNull());
        Assert.assertEquals((Object)"foo", (Object)fm.getInvocationClass());
        Assert.assertEquals((Object)"bar", (Object)fm.getInvocationMethod());
        Assert.assertEquals((Object)"any", fm.getProperties().get("RANDOM"));
    }

    @Test
    public void testUDAggregate() throws Exception {
        String ddl = "CREATE VIRTUAL FUNCTION SourceFunc(flag boolean, msg varchar) RETURNS varchar OPTIONS(CATEGORY 'misc', AGGREGATE 'true', \"allows-distinct\" 'true', UUID 'y')";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        FunctionMethod fm = s.getFunction("y");
        Assert.assertNotNull((Object)fm);
        Assert.assertEquals((Object)"string", (Object)fm.getOutputParameter().getType());
        Assert.assertEquals((Object)FunctionMethod.PushDown.CAN_PUSHDOWN, (Object)fm.getPushdown());
        Assert.assertEquals((long)2L, (long)fm.getInputParameterCount());
        Assert.assertEquals((Object)"flag", (Object)((FunctionParameter)fm.getInputParameters().get(0)).getName());
        Assert.assertEquals((Object)"boolean", (Object)((FunctionParameter)fm.getInputParameters().get(0)).getType());
        Assert.assertEquals((Object)"msg", (Object)((FunctionParameter)fm.getInputParameters().get(1)).getName());
        Assert.assertEquals((Object)"string", (Object)((FunctionParameter)fm.getInputParameters().get(1)).getType());
        Assert.assertFalse((boolean)((FunctionParameter)fm.getInputParameters().get(1)).isVarArg());
        Assert.assertNotNull((Object)fm.getAggregateAttributes());
        Assert.assertTrue((boolean)fm.getAggregateAttributes().allowsDistinct());
        Assert.assertEquals((Object)FunctionMethod.Determinism.DETERMINISTIC, (Object)fm.getDeterminism());
        Assert.assertEquals((Object)"misc", (Object)fm.getCategory());
        Assert.assertFalse((boolean)fm.isNullOnNull());
    }

    @Test
    public void testVarArgs() throws Exception {
        String ddl = "CREATE FUNCTION SourceFunc(flag boolean) RETURNS varchar options (varargs 'true', UUID 'z')";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        FunctionMethod fm = s.getFunction("z");
        Assert.assertTrue((boolean)((FunctionParameter)fm.getInputParameters().get(0)).isVarArg());
    }

    @Test
    public void testMixedCaseTypes() throws Exception {
        String ddl = "CREATE FUNCTION SourceFunc(flag Boolean) RETURNS varchaR options (UUID 'z')";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        FunctionMethod fm = s.getFunction("z");
        Assert.assertEquals((Object)"boolean", (Object)((FunctionParameter)fm.getInputParameters().get(0)).getType());
    }

    @Test(expected=MetadataException.class)
    public void testInvalidFunctionBody() throws Exception {
        String ddl = "CREATE FUNCTION SourceFunc(flag boolean) RETURNS varchar AS SELECT 'a';";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        FunctionMethod fm = s.getFunction("z");
        Assert.assertTrue((boolean)((FunctionParameter)fm.getInputParameters().get(0)).isVarArg());
    }

    @Test(expected=MetadataException.class)
    public void testInvalidProcedureBody() throws Exception {
        String ddl = "CREATE FOREIGN PROCEDURE SourceFunc(flag boolean) RETURNS varchar AS SELECT 'a';";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        FunctionMethod fm = s.getFunction("z");
        Assert.assertTrue((boolean)((FunctionParameter)fm.getInputParameters().get(0)).isVarArg());
    }

    @Test
    public void testVirtualProcedure() throws Exception {
        String ddl = "CREATE VIRTUAL PROCEDURE myProc(OUT p1 boolean, p2 varchar, INOUT p3 decimal) RETURNS (r1 varchar, r2 decimal) OPTIONS(RANDOM 'any', UUID 'uuid', NAMEINSOURCE 'nis', ANNOTATION 'desc', UPDATECOUNT '2') AS /*+ cache */ BEGIN select * from foo; END";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        Procedure proc = s.getProcedure("myProc");
        Assert.assertNotNull((Object)proc);
        Assert.assertTrue((boolean)proc.isVirtual());
        Assert.assertFalse((boolean)proc.isFunction());
        Assert.assertEquals((long)3L, (long)proc.getParameters().size());
        Assert.assertEquals((Object)"p1", (Object)((ProcedureParameter)proc.getParameters().get(0)).getName());
        Assert.assertEquals((Object)"boolean", (Object)((ProcedureParameter)proc.getParameters().get(0)).getDatatype().getName());
        Assert.assertEquals((Object)ProcedureParameter.Type.Out, (Object)((ProcedureParameter)proc.getParameters().get(0)).getType());
        Assert.assertEquals((Object)"p2", (Object)((ProcedureParameter)proc.getParameters().get(1)).getName());
        Assert.assertEquals((Object)"string", (Object)((ProcedureParameter)proc.getParameters().get(1)).getDatatype().getName());
        Assert.assertEquals((Object)ProcedureParameter.Type.In, (Object)((ProcedureParameter)proc.getParameters().get(1)).getType());
        Assert.assertEquals((Object)"p3", (Object)((ProcedureParameter)proc.getParameters().get(2)).getName());
        Assert.assertEquals((Object)"bigdecimal", (Object)((ProcedureParameter)proc.getParameters().get(2)).getDatatype().getName());
        Assert.assertEquals((Object)ProcedureParameter.Type.InOut, (Object)((ProcedureParameter)proc.getParameters().get(2)).getType());
        ColumnSet ret = proc.getResultSet();
        Assert.assertNotNull((Object)ret);
        Assert.assertEquals((long)2L, (long)ret.getColumns().size());
        Assert.assertEquals((Object)"r1", (Object)((Column)ret.getColumns().get(0)).getName());
        Assert.assertEquals((Object)"string", (Object)((Column)ret.getColumns().get(0)).getDatatype().getName());
        Assert.assertEquals((Object)"r2", (Object)((Column)ret.getColumns().get(1)).getName());
        Assert.assertEquals((Object)"bigdecimal", (Object)((Column)ret.getColumns().get(1)).getDatatype().getName());
        Assert.assertEquals((Object)"uuid", (Object)proc.getUUID());
        Assert.assertEquals((Object)"nis", (Object)proc.getNameInSource());
        Assert.assertEquals((Object)"desc", (Object)proc.getAnnotation());
        Assert.assertEquals((long)2L, (long)proc.getUpdateCount());
        Assert.assertEquals((Object)"any", proc.getProperties().get("RANDOM"));
        Assert.assertEquals((Object)"/*+ cache */ BEGIN\nSELECT * FROM foo;\nEND", (Object)proc.getQueryPlan());
    }

    @Test
    public void testInsteadOfTrigger() throws Exception {
        String ddl = "CREATE VIEW G1( e1 integer, e2 varchar) AS select * from foo;CREATE TRIGGER ON G1 INSTEAD OF INSERT AS FOR EACH ROW \nBEGIN ATOMIC \ninsert into g1 (e1, e2) values (1, 'trig');\nEND;CREATE View G2( e1 integer, e2 varchar) AS select * from foo;";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        NavigableMap tableMap = s.getTables();
        Assert.assertTrue((String)"Table not found", (boolean)tableMap.containsKey("G1"));
        Assert.assertTrue((String)"Table not found", (boolean)tableMap.containsKey("G2"));
        Assert.assertEquals((Object)"FOR EACH ROW\nBEGIN ATOMIC\nINSERT INTO g1 (e1, e2) VALUES (1, 'trig');\nEND", (Object)s.getTable("G1").getInsertPlan());
    }

    @Test
    public void testSourceProcedure() throws Exception {
        String ddl = "CREATE FOREIGN PROCEDURE myProc(OUT p1 boolean, p2 varchar, INOUT p3 decimal) RETURNS (r1 varchar, r2 decimal)OPTIONS(RANDOM 'any', UUID 'uuid', NAMEINSOURCE 'nis', ANNOTATION 'desc', UPDATECOUNT '2');";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        Procedure proc = s.getProcedure("myProc");
        Assert.assertNotNull((Object)proc);
        Assert.assertFalse((boolean)proc.isVirtual());
        Assert.assertFalse((boolean)proc.isFunction());
        Assert.assertEquals((long)3L, (long)proc.getParameters().size());
        Assert.assertEquals((Object)"p1", (Object)((ProcedureParameter)proc.getParameters().get(0)).getName());
        Assert.assertEquals((Object)"boolean", (Object)((ProcedureParameter)proc.getParameters().get(0)).getDatatype().getName());
        Assert.assertEquals((Object)ProcedureParameter.Type.Out, (Object)((ProcedureParameter)proc.getParameters().get(0)).getType());
        Assert.assertEquals((Object)"p2", (Object)((ProcedureParameter)proc.getParameters().get(1)).getName());
        Assert.assertEquals((Object)"string", (Object)((ProcedureParameter)proc.getParameters().get(1)).getDatatype().getName());
        Assert.assertEquals((Object)ProcedureParameter.Type.In, (Object)((ProcedureParameter)proc.getParameters().get(1)).getType());
        Assert.assertEquals((Object)"p3", (Object)((ProcedureParameter)proc.getParameters().get(2)).getName());
        Assert.assertEquals((Object)"bigdecimal", (Object)((ProcedureParameter)proc.getParameters().get(2)).getDatatype().getName());
        Assert.assertEquals((Object)ProcedureParameter.Type.InOut, (Object)((ProcedureParameter)proc.getParameters().get(2)).getType());
        ColumnSet ret = proc.getResultSet();
        Assert.assertNotNull((Object)ret);
        Assert.assertEquals((long)2L, (long)ret.getColumns().size());
        Assert.assertEquals((Object)"r1", (Object)((Column)ret.getColumns().get(0)).getName());
        Assert.assertEquals((Object)"string", (Object)((Column)ret.getColumns().get(0)).getDatatype().getName());
        Assert.assertEquals((Object)"r2", (Object)((Column)ret.getColumns().get(1)).getName());
        Assert.assertEquals((Object)"bigdecimal", (Object)((Column)ret.getColumns().get(1)).getDatatype().getName());
        Assert.assertEquals((Object)"uuid", (Object)proc.getUUID());
        Assert.assertEquals((Object)"nis", (Object)proc.getNameInSource());
        Assert.assertEquals((Object)"desc", (Object)proc.getAnnotation());
        Assert.assertEquals((long)2L, (long)proc.getUpdateCount());
        Assert.assertEquals((Object)"any", proc.getProperties().get("RANDOM"));
    }

    @Test
    public void testNamespace() throws Exception {
        String ddl = "set namespace 'http://teiid.org' AS teiid";
        MetadataStore mds = new MetadataStore();
        MetadataFactory mf = new MetadataFactory(null, 1, "model", TestDDLParser.getDataTypes(), new Properties(), null);
        this.parser.parseDDL(mf, ddl);
        mf.mergeInto(mds);
        Assert.assertTrue((boolean)mf.getNamespaces().keySet().contains("teiid"));
        Assert.assertEquals((Object)"http://teiid.org", mf.getNamespaces().get("teiid"));
    }

    public static MetadataFactory helpParse(String ddl, String model) {
        MetadataFactory mf = new MetadataFactory(null, 1, model, TestDDLParser.getDataTypes(), new Properties(), null);
        QueryParser.getQueryParser().parseDDL(mf, ddl);
        return mf;
    }

    public static Map<String, Datatype> getDataTypes() {
        return SystemMetadata.getInstance().getRuntimeTypeMap();
    }

    @Test
    public void testKeyResolve() {
        MetadataFactory mf = new MetadataFactory(null, 1, "foo", TestDDLParser.getDataTypes(), new Properties(), null);
        mf.addNamespace("x", "http://x");
        Assert.assertEquals((Object)"{http://x}z", (Object)SQLParserUtil.resolvePropertyKey((MetadataFactory)mf, (String)"x:z"));
        Assert.assertEquals((Object)"y:z", (Object)SQLParserUtil.resolvePropertyKey((MetadataFactory)mf, (String)"y:z"));
    }

    @Test
    public void testCreateError() {
        try {
            TestDDLParser.helpParse("CREATE foreign FUNCTION convert(msg integer, type varchar) RETURNS varchar", "x");
            Assert.fail();
        }
        catch (ParseException e) {
            Assert.assertEquals((Object)"TEIID30386 org.teiid.api.exception.query.QueryParserException: TEIID31100 Parsing error: Encountered \"CREATE foreign FUNCTION [*]convert[*](msg\" at line 1, column 25.\nWas expecting: id", (Object)e.getMessage());
        }
    }
}

