/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.api.exception.query.QueryProcessingException;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.FakeDataStore;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.resolver.TestResolver;
import org.teiid.query.util.CommandContext;
import org.teiid.query.validator.TestUpdateValidator;

public class TestTriggerActions {
    private static final String GX = "GX";
    private static final String VM1 = "VM1";

    @Test
    public void testInsert() throws Exception {
        TransformationMetadata metadata = TestUpdateValidator.example1();
        TestUpdateValidator.createView("select 1 as x, 2 as y", metadata, GX);
        Table t = (Table)((Schema)metadata.getMetadataStore().getSchemas().get(VM1)).getTables().get(GX);
        t.setDeletePlan("");
        t.setUpdatePlan("");
        t.setInsertPlan("FOR EACH ROW BEGIN insert into pm1.g1 (e1) values (new.x); END");
        String sql = "insert into gx (x, y) values (1, 2)";
        FakeDataManager dm = new FakeDataManager();
        FakeDataStore.addTable("pm1.g1", dm, (QueryMetadataInterface)metadata);
        CommandContext context = TestProcessor.createCommandContext();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestResolver.helpResolve(sql, (QueryMetadataInterface)metadata), (QueryMetadataInterface)metadata, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps), context);
        List[] expected = new List[]{Arrays.asList(1)};
        TestProcessor.helpProcess(plan, context, dm, expected);
    }

    @Test
    public void testInsertWithDefault() throws Exception {
        TransformationMetadata metadata = TestUpdateValidator.example1();
        TestUpdateValidator.createView("select 1 as x, 2 as y", metadata, GX);
        Table t = (Table)((Schema)metadata.getMetadataStore().getSchemas().get(VM1)).getTables().get(GX);
        t.setDeletePlan("");
        t.setUpdatePlan("");
        t.setInsertPlan("FOR EACH ROW BEGIN insert into pm1.g1 (e1) values (new.x); END");
        String sql = "insert into gx (x) values (1)";
        FakeDataManager dm = new FakeDataManager();
        FakeDataStore.addTable("pm1.g1", dm, (QueryMetadataInterface)metadata);
        CommandContext context = TestProcessor.createCommandContext();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestResolver.helpResolve(sql, (QueryMetadataInterface)metadata), (QueryMetadataInterface)metadata, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps), context);
        List[] expected = new List[]{Arrays.asList(1)};
        TestProcessor.helpProcess(plan, context, dm, expected);
    }

    @Test
    public void testInsertWithQueryExpression() throws Exception {
        TransformationMetadata metadata = TestUpdateValidator.example1();
        TestUpdateValidator.createView("select '1' as x, 2 as y", metadata, GX);
        Table t = (Table)((Schema)metadata.getMetadataStore().getSchemas().get(VM1)).getTables().get(GX);
        t.setDeletePlan("");
        t.setUpdatePlan("");
        t.setInsertPlan("FOR EACH ROW BEGIN insert into pm1.g1 (e1) values (new.x); END");
        String sql = "insert into gx (x, y) select e1, e2 from pm1.g1";
        FakeDataManager dm = new FakeDataManager();
        FakeDataStore.addTable("pm1.g1", dm, (QueryMetadataInterface)metadata);
        CommandContext context = TestProcessor.createCommandContext();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestResolver.helpResolve(sql, (QueryMetadataInterface)metadata), (QueryMetadataInterface)metadata, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps), context);
        List[] expected = new List[]{Arrays.asList(6)};
        TestProcessor.helpProcess(plan, context, dm, expected);
    }

    @Test
    public void testDynamic() throws Exception {
        TransformationMetadata metadata = TestUpdateValidator.example1();
        TestUpdateValidator.createView("select '1' as x, 2 as y", metadata, GX);
        Table t = (Table)((Schema)metadata.getMetadataStore().getSchemas().get(VM1)).getTables().get(GX);
        t.setDeletePlan("FOR EACH ROW BEGIN ATOMIC END");
        t.setUpdatePlan("");
        t.setInsertPlan("FOR EACH ROW BEGIN execute immediate 'delete from gx where gx.x = new.x'; END");
        String sql = "insert into gx (x, y) select e1, e2 from pm1.g1";
        FakeDataManager dm = new FakeDataManager();
        FakeDataStore.addTable("pm1.g1", dm, (QueryMetadataInterface)metadata);
        CommandContext context = TestProcessor.createCommandContext();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestResolver.helpResolve(sql, (QueryMetadataInterface)metadata), (QueryMetadataInterface)metadata, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps), context);
        List[] expected = new List[]{Arrays.asList(6)};
        TestProcessor.helpProcess(plan, context, dm, expected);
    }

    @Test
    public void testDynamicUpdate() throws Exception {
        TransformationMetadata metadata = TestUpdateValidator.example1();
        TestUpdateValidator.createView("select '1' as x, 2 as y", metadata, GX);
        Table t = (Table)((Schema)metadata.getMetadataStore().getSchemas().get(VM1)).getTables().get(GX);
        t.setDeletePlan("");
        t.setUpdatePlan("FOR EACH ROW BEGIN execute immediate 'update pm1.g1 set e1 = new.x where e2 = new.y'; END");
        t.setInsertPlan("");
        String sql = "update gx set x = 1 where y = 2";
        HardcodedDataManager dm = new HardcodedDataManager();
        dm.addData("UPDATE pm1.g1 SET e1 = '1' WHERE e2 = 2", new List[]{Arrays.asList(1)});
        CommandContext context = TestProcessor.createCommandContext();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestResolver.helpResolve(sql, (QueryMetadataInterface)metadata), (QueryMetadataInterface)metadata, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps), context);
        List[] expected = new List[]{Arrays.asList(1)};
        TestProcessor.helpProcess(plan, context, dm, expected);
    }

    @Test
    public void testDynamicRecursion() throws Exception {
        TransformationMetadata metadata = TestUpdateValidator.example1();
        TestUpdateValidator.createView("select 'a' as x, 2 as y", metadata, GX);
        Table t = (Table)((Schema)metadata.getMetadataStore().getSchemas().get(VM1)).getTables().get(GX);
        t.setDeletePlan("FOR EACH ROW BEGIN ATOMIC insert into gx (x, y) values (old.x, old.y); END");
        t.setUpdatePlan("");
        t.setInsertPlan("FOR EACH ROW BEGIN execute immediate 'delete from gx where gx.x = new.x'; END");
        String sql = "insert into gx (x, y) select e1, e2 from pm1.g1";
        FakeDataManager dm = new FakeDataManager();
        FakeDataStore.addTable("pm1.g1", dm, (QueryMetadataInterface)metadata);
        CommandContext context = TestProcessor.createCommandContext();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestResolver.helpResolve(sql, (QueryMetadataInterface)metadata), (QueryMetadataInterface)metadata, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps), context);
        try {
            TestProcessor.helpProcess(plan, context, dm, null);
            Assert.fail();
        }
        catch (QueryProcessingException e) {
            Assert.assertEquals((Object)"TEIID30168 Couldn't execute the dynamic SQL command \"EXECUTE IMMEDIATE 'delete from gx where gx.x = new.x'\" with the SQL statement \"'delete from gx where gx.x = new.x'\" due to: TEIID30347 There is a recursive invocation of group 'I gx'. Please correct the SQL.", (Object)e.getMessage());
        }
    }

    @Test
    public void testDelete() throws Exception {
        TransformationMetadata metadata = TestUpdateValidator.example1();
        TestUpdateValidator.createView("select 1 as x, 2 as y", metadata, GX);
        Table t = (Table)((Schema)metadata.getMetadataStore().getSchemas().get(VM1)).getTables().get(GX);
        t.setDeletePlan("FOR EACH ROW BEGIN delete from pm1.g1 where e2 = old.x; END");
        t.setUpdatePlan("");
        t.setInsertPlan("");
        String sql = "delete from gx where y = 2";
        FakeDataManager dm = new FakeDataManager();
        FakeDataStore.addTable("pm1.g1", dm, (QueryMetadataInterface)metadata);
        CommandContext context = TestProcessor.createCommandContext();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestResolver.helpResolve(sql, (QueryMetadataInterface)metadata), (QueryMetadataInterface)metadata, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps), context);
        List[] expected = new List[]{Arrays.asList(1)};
        TestProcessor.helpProcess(plan, context, dm, expected);
    }

    @Test
    public void testUpdate() throws Exception {
        TransformationMetadata metadata = TestUpdateValidator.example1();
        TestUpdateValidator.createView("select 1 as x, 2 as y", metadata, GX);
        Table t = (Table)((Schema)metadata.getMetadataStore().getSchemas().get(VM1)).getTables().get(GX);
        t.setDeletePlan("");
        t.setUpdatePlan("FOR EACH ROW BEGIN update pm1.g1 set e2 = new.y where e2 = old.y; END");
        t.setInsertPlan("");
        String sql = "update gx set y = 5";
        FakeDataManager dm = new FakeDataManager();
        FakeDataStore.addTable("pm1.g1", dm, (QueryMetadataInterface)metadata);
        CommandContext context = TestProcessor.createCommandContext();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestResolver.helpResolve(sql, (QueryMetadataInterface)metadata), (QueryMetadataInterface)metadata, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps), context);
        List[] expected = new List[]{Arrays.asList(1)};
        TestProcessor.helpProcess(plan, context, dm, expected);
        Assert.assertEquals((Object)"UPDATE pm1.g1 SET e2 = 5 WHERE e2 = 2", (Object)dm.getQueries().get(0));
    }

    @Test
    public void testUpdateWithChanging() throws Exception {
        TransformationMetadata metadata = TestUpdateValidator.example1();
        TestUpdateValidator.createView("select 1 as x, 2 as y", metadata, GX);
        Table t = (Table)((Schema)metadata.getMetadataStore().getSchemas().get(VM1)).getTables().get(GX);
        t.setDeletePlan("");
        t.setUpdatePlan("FOR EACH ROW BEGIN update pm1.g1 set e2 = case when changing.y then new.y end where e2 = old.y; END");
        t.setInsertPlan("");
        String sql = "update gx set y = 5";
        FakeDataManager dm = new FakeDataManager();
        FakeDataStore.addTable("pm1.g1", dm, (QueryMetadataInterface)metadata);
        CommandContext context = TestProcessor.createCommandContext();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestResolver.helpResolve(sql, (QueryMetadataInterface)metadata), (QueryMetadataInterface)metadata, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps), context);
        List[] expected = new List[]{Arrays.asList(1)};
        TestProcessor.helpProcess(plan, context, dm, expected);
        Assert.assertEquals((Object)"UPDATE pm1.g1 SET e2 = 5 WHERE e2 = 2", (Object)dm.getQueries().get(0));
    }

    @Test
    public void testUpdateWithNonConstant() throws Exception {
        TransformationMetadata metadata = TestUpdateValidator.example1();
        TestUpdateValidator.createView("select 1 as x, 2 as y", metadata, GX);
        Table t = (Table)((Schema)metadata.getMetadataStore().getSchemas().get(VM1)).getTables().get(GX);
        t.setDeletePlan("");
        t.setUpdatePlan("FOR EACH ROW BEGIN update pm1.g1 set e2 = new.y where e2 = old.y; END");
        t.setInsertPlan("");
        String sql = "update gx set y = x";
        FakeDataManager dm = new FakeDataManager();
        FakeDataStore.addTable("pm1.g1", dm, (QueryMetadataInterface)metadata);
        CommandContext context = TestProcessor.createCommandContext();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestResolver.helpResolve(sql, (QueryMetadataInterface)metadata), (QueryMetadataInterface)metadata, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps), context);
        List[] expected = new List[]{Arrays.asList(1)};
        TestProcessor.helpProcess(plan, context, dm, expected);
        Assert.assertEquals((Object)"UPDATE pm1.g1 SET e2 = 1 WHERE e2 = 2", (Object)dm.getQueries().get(0));
    }
}

