/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import junit.framework.TestCase;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;

public class TestSubqueryFromClause
extends TestCase {
    public TestSubqueryFromClause(String arg0) {
        super(arg0);
    }

    public static SubqueryFromClause example1() {
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((Expression)new ElementSymbol("a"));
        select.addSymbol((Expression)new ElementSymbol("b"));
        query.setSelect(select);
        From from = new From();
        from.addGroup(new GroupSymbol("m.g"));
        query.setFrom(from);
        CompareCriteria crit = new CompareCriteria();
        crit.setLeftExpression((Expression)new ElementSymbol("a"));
        crit.setRightExpression((Expression)new Constant((Object)new Integer(5)));
        crit.setOperator(1);
        query.setCriteria((Criteria)crit);
        return new SubqueryFromClause("temp", (Command)query);
    }

    public static SubqueryFromClause example2() {
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((Expression)new ElementSymbol("c"));
        select.addSymbol((Expression)new ElementSymbol("d"));
        query.setSelect(select);
        From from = new From();
        from.addGroup(new GroupSymbol("m.g2"));
        query.setFrom(from);
        CompareCriteria crit = new CompareCriteria();
        crit.setLeftExpression((Expression)new ElementSymbol("c"));
        crit.setRightExpression((Expression)new Constant((Object)new Integer(10)));
        crit.setOperator(1);
        query.setCriteria((Criteria)crit);
        return new SubqueryFromClause("temp", (Command)query);
    }

    public static SubqueryFromClause example3() {
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((Expression)new ElementSymbol("a"));
        select.addSymbol((Expression)new ElementSymbol("b"));
        query.setSelect(select);
        From from = new From();
        from.addGroup(new GroupSymbol("m.g"));
        query.setFrom(from);
        CompareCriteria crit = new CompareCriteria();
        crit.setLeftExpression((Expression)new ElementSymbol("a"));
        crit.setRightExpression((Expression)new Constant((Object)new Integer(5)));
        crit.setOperator(1);
        query.setCriteria((Criteria)crit);
        return new SubqueryFromClause("temp2", (Command)query);
    }

    public void testSelfEquivalence() {
        SubqueryFromClause s1 = TestSubqueryFromClause.example1();
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s1);
    }

    public void testEquivalence() {
        SubqueryFromClause s1 = TestSubqueryFromClause.example1();
        SubqueryFromClause s1a = TestSubqueryFromClause.example1();
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s1a);
    }

    public void testEquivalenceDifferentName() {
        SubqueryFromClause s1 = TestSubqueryFromClause.example1();
        SubqueryFromClause s2 = TestSubqueryFromClause.example3();
        int equals = -1;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s2);
    }

    public void testCommandNonEquivalence() {
        SubqueryFromClause s1 = TestSubqueryFromClause.example1();
        SubqueryFromClause s2 = TestSubqueryFromClause.example2();
        int equals = -1;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s2);
    }

    public void testEquivalenceDifferentOptional() {
        SubqueryFromClause s1 = TestSubqueryFromClause.example1();
        SubqueryFromClause s2 = TestSubqueryFromClause.example1();
        s2.setOptional(true);
        int equals = -1;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s2);
    }

    public void testClone() {
        SubqueryFromClause s1 = TestSubqueryFromClause.example1();
        FromClause clonedS1 = s1.clone();
        TestSubqueryFromClause.assertEquals((Object)s1, (Object)clonedS1);
    }
}

