/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer;

import org.junit.Test;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.FakeCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.translator.ExecutionFactory;

public class TestJoinPushdownRestrictions {
    @Test
    public void testThetaRestriction() throws Exception {
        String sql = "select pm1.g1.e2, pm1.g2.e2 from pm1.g1 inner join pm1.g2 on (pm1.g1.e2 + pm1.g2.e2 = 5)";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setSourceProperty(SourceCapabilities.Capability.JOIN_CRITERIA_ALLOWED, (Object)ExecutionFactory.SupportedJoinCriteria.THETA);
        caps.setFunctionSupport("+", true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT g_0.e2 FROM pm1.g2 AS g_0", "SELECT g_0.e2 FROM pm1.g1 AS g_0"}, capFinder, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        caps.setSourceProperty(SourceCapabilities.Capability.JOIN_CRITERIA_ALLOWED, (Object)ExecutionFactory.SupportedJoinCriteria.ANY);
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT g_0.e2, g_1.e2 FROM pm1.g1 AS g_0, pm1.g2 AS g_1 WHERE (g_0.e2 + g_1.e2) = 5"}, capFinder, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testEquiRestriction() throws Exception {
        String sql = "select pm1.g1.e2, pm1.g2.e2 from pm1.g1 inner join pm1.g2 on (pm1.g1.e2 < pm1.g2.e2)";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setSourceProperty(SourceCapabilities.Capability.JOIN_CRITERIA_ALLOWED, (Object)ExecutionFactory.SupportedJoinCriteria.EQUI);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT g_0.e2 FROM pm1.g2 AS g_0", "SELECT g_0.e2 FROM pm1.g1 AS g_0"}, capFinder, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        caps.setSourceProperty(SourceCapabilities.Capability.JOIN_CRITERIA_ALLOWED, (Object)ExecutionFactory.SupportedJoinCriteria.THETA);
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT g_0.e2, g_1.e2 FROM pm1.g1 AS g_0, pm1.g2 AS g_1 WHERE g_0.e2 < g_1.e2"}, capFinder, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testKeyRestriction() throws Exception {
        String sql = "select pm1.g1.e2, pm1.g2.e2 from pm1.g1 inner join pm1.g2 on (pm1.g1.e2 = pm1.g2.e2)";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setSourceProperty(SourceCapabilities.Capability.JOIN_CRITERIA_ALLOWED, (Object)ExecutionFactory.SupportedJoinCriteria.KEY);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT g_0.e2 AS c_0 FROM pm1.g1 AS g_0 ORDER BY c_0", "SELECT g_0.e2 AS c_0 FROM pm1.g2 AS g_0 ORDER BY c_0"}, capFinder, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        caps.setSourceProperty(SourceCapabilities.Capability.JOIN_CRITERIA_ALLOWED, (Object)ExecutionFactory.SupportedJoinCriteria.EQUI);
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT g_0.e2, g_1.e2 FROM pm1.g1 AS g_0, pm1.g2 AS g_1 WHERE g_0.e2 = g_1.e2"}, capFinder, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testKeyRestriction1() throws Exception {
        String sql = "select a.e1, b.e1 from pm4.g1 a inner join pm4.g2 b on (a.e1 = b.e1 and a.e2 = b.e2) left outer join pm4.g1 c on (c.e1 = b.e1 and c.e2 = b.e2)";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_SELFJOIN, true);
        caps.setSourceProperty(SourceCapabilities.Capability.JOIN_CRITERIA_ALLOWED, (Object)ExecutionFactory.SupportedJoinCriteria.KEY);
        capFinder.addCapabilities("pm4", (SourceCapabilities)caps);
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example4(), new String[]{"SELECT g_1.e1 AS c_0, g_1.e2 AS c_1, g_0.e1 AS c_2 FROM pm4.g1 AS g_0, pm4.g2 AS g_1 WHERE (g_0.e1 = g_1.e1) AND (g_0.e2 = g_1.e2) ORDER BY c_0, c_1", "SELECT g_0.e1 AS c_0, g_0.e2 AS c_1 FROM pm4.g1 AS g_0 ORDER BY c_0, c_1"}, capFinder, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testKeyPasses() throws Exception {
        String sql = "select a.e1, b.e1 from pm4.g1 a, pm4.g2 b where a.e1 = b.e1 and a.e2 = b.e2";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setSourceProperty(SourceCapabilities.Capability.JOIN_CRITERIA_ALLOWED, (Object)ExecutionFactory.SupportedJoinCriteria.KEY);
        capFinder.addCapabilities("pm4", (SourceCapabilities)caps);
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example4(), new String[]{"SELECT g_0.e1, g_1.e1 FROM pm4.g1 AS g_0, pm4.g2 AS g_1 WHERE (g_0.e1 = g_1.e1) AND (g_0.e2 = g_1.e2)"}, capFinder, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testCrossJoinWithRestriction() throws Exception {
        String sql = "select pm1.g1.e2, pm1.g2.e2 from pm1.g1, pm1.g2";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setSourceProperty(SourceCapabilities.Capability.JOIN_CRITERIA_ALLOWED, (Object)ExecutionFactory.SupportedJoinCriteria.THETA);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT g_0.e2 FROM pm1.g2 AS g_0", "SELECT g_0.e2 FROM pm1.g1 AS g_0"}, capFinder, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testOuterRestriction() throws Exception {
        String sql = "select pm1.g1.e2, pm1.g2.e2 from pm1.g1 inner join pm1.g2 on (pm1.g1.e2 + pm1.g2.e2 = 5)";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_ISNULL, false);
        caps.setSourceProperty(SourceCapabilities.Capability.JOIN_CRITERIA_ALLOWED, (Object)ExecutionFactory.SupportedJoinCriteria.ANY);
        caps.setFunctionSupport("+", true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT g_0.e2 FROM pm1.g2 AS g_0", "SELECT g_0.e2 FROM pm1.g1 AS g_0"}, capFinder, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testOuterPreservation() throws Exception {
        String sql = "select pm1.g1.e2, pm1.g2.e2 from pm1.g1 left outer join pm1.g2 on (pm1.g1.e2 = pm1.g2.e2) where pm1.g2.e1 = 'a'";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, false);
        caps.setSourceProperty(SourceCapabilities.Capability.JOIN_CRITERIA_ALLOWED, (Object)ExecutionFactory.SupportedJoinCriteria.ANY);
        caps.setFunctionSupport("+", true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT g_0.e2, g_1.e2 FROM pm1.g1 AS g_0 LEFT OUTER JOIN pm1.g2 AS g_1 ON g_0.e2 = g_1.e2 WHERE g_1.e1 = 'a'"}, capFinder, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testOuterPreservation1() throws Exception {
        String sql = "select pm1.g1.e2, pm1.g2.e2 from pm1.g1 inner join pm1.g2 on (pm1.g1.e2 = pm1.g2.e2)";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, false);
        caps.setSourceProperty(SourceCapabilities.Capability.JOIN_CRITERIA_ALLOWED, (Object)ExecutionFactory.SupportedJoinCriteria.ANY);
        caps.setFunctionSupport("+", true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT g_0.e2, g_1.e2 FROM pm1.g1 AS g_0 LEFT OUTER JOIN pm1.g2 AS g_1 ON g_0.e2 = g_1.e2 WHERE g_1.e2 IS NOT NULL"}, capFinder, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testCriteriaRestrictionWithNonJoinCriteria() throws Exception {
        String sql = "select pm1.g1.e2, pm1.g2.e2 from pm1.g1 left outer join pm1.g2 on (pm1.g1.e2 = pm1.g2.e2 and pm1.g2.e1 = 'hello')";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER, true);
        caps.setSourceProperty(SourceCapabilities.Capability.JOIN_CRITERIA_ALLOWED, (Object)ExecutionFactory.SupportedJoinCriteria.THETA);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT g_0.e2 AS c_0 FROM pm1.g1 AS g_0 ORDER BY c_0", "SELECT g_0.e2 AS c_0 FROM pm1.g2 AS g_0 WHERE g_0.e1 = 'hello' ORDER BY c_0"}, capFinder, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }
}

