/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.plantree;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.NodeFactory;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.sql.symbol.GroupSymbol;

public class TestNodeEditor
extends TestCase {
    public TestNodeEditor(String arg0) {
        super(arg0);
    }

    public PlanNode buildTree(Object[] nodeNames) {
        if (nodeNames == null) {
            return null;
        }
        PlanNode node = this.buildNamedNode((String)nodeNames[0]);
        for (int i = 1; i < nodeNames.length; ++i) {
            PlanNode childNode = null;
            childNode = nodeNames[i] instanceof String ? this.buildNamedNode((String)nodeNames[i]) : this.buildTree((Object[])nodeNames[i]);
            node.addLastChild(childNode);
        }
        return node;
    }

    private PlanNode buildNamedNode(String name) {
        PlanNode node = new PlanNode();
        node.addGroup(new GroupSymbol(name));
        return node;
    }

    public PlanNode exampleTree1() {
        return this.buildTree(new Object[]{"node_0", new Object[]{"node_1", "node_1_1", "node_1_2"}, new Object[]{"node_2", "node_2_1"}});
    }

    public void testRemoveLastChildNode() {
        PlanNode tree = this.exampleTree1();
        ArrayList<PlanNode> expectedChildren = new ArrayList<PlanNode>();
        expectedChildren.add(tree.getFirstChild());
        expectedChildren.addAll(tree.getLastChild().getChildren());
        NodeEditor.removeChildNode((PlanNode)tree, (PlanNode)tree.getLastChild());
        List actualChildren = tree.getChildren();
        TestNodeEditor.assertEquals((String)"Didn't get expected children after removing last child", expectedChildren, (Object)actualChildren);
    }

    public void testFindNodePreOrder1() {
        PlanNode node1 = NodeFactory.getNewNode((int)8);
        PlanNode node2 = NodeFactory.getNewNode((int)4);
        PlanNode node3 = NodeFactory.getNewNode((int)1);
        PlanNode node4 = NodeFactory.getNewNode((int)1);
        node1.addLastChild(node2);
        node2.addLastChild(node3);
        node2.addLastChild(node4);
        TestNodeEditor.assertEquals((String)"Found wrong node", (Object)node1, (Object)NodeEditor.findNodePreOrder((PlanNode)node1, (int)8));
        TestNodeEditor.assertEquals((String)"Found wrong node", (Object)node2, (Object)NodeEditor.findNodePreOrder((PlanNode)node1, (int)4));
        TestNodeEditor.assertEquals((String)"Found wrong node", (Object)node3, (Object)NodeEditor.findNodePreOrder((PlanNode)node1, (int)1));
        TestNodeEditor.assertEquals((String)"Found wrong node", null, (Object)NodeEditor.findNodePreOrder((PlanNode)node1, (int)128));
        TestNodeEditor.assertEquals((String)"Found wrong node", null, (Object)NodeEditor.findNodePreOrder((PlanNode)node1, (int)1, (int)4));
    }

    public void testFindParent() {
        PlanNode node0 = NodeFactory.getNewNode((int)64);
        PlanNode node1 = NodeFactory.getNewNode((int)8);
        PlanNode node2 = NodeFactory.getNewNode((int)4);
        PlanNode node3 = NodeFactory.getNewNode((int)1);
        PlanNode node4 = NodeFactory.getNewNode((int)1);
        node0.addLastChild(node1);
        node1.addLastChild(node2);
        node2.addLastChild(node3);
        node2.addLastChild(node4);
        TestNodeEditor.assertEquals((String)"Found wrong node", (Object)node1, (Object)NodeEditor.findParent((PlanNode)node4, (int)8));
        TestNodeEditor.assertNull((String)"Found wrong node", (Object)NodeEditor.findParent((PlanNode)node1, (int)8));
        TestNodeEditor.assertNull((String)"Found wrong node", (Object)NodeEditor.findParent((PlanNode)node4, (int)8, (int)20));
        TestNodeEditor.assertNull((String)"Found wrong node", (Object)NodeEditor.findParent((PlanNode)node1, (int)128));
    }
}

