/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.Test;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.api.exception.query.QueryProcessingException;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.util.CommandContext;

public class TestRowBasedSecurity {
    static CommandContext context = TestRowBasedSecurity.createContext();

    private static CommandContext createContext() {
        context = TestProcessor.createCommandContext();
        DQPWorkContext workContext = new DQPWorkContext();
        HashMap<String, DataPolicyMetadata> policies = new HashMap<String, DataPolicyMetadata>();
        DataPolicyMetadata policy = new DataPolicyMetadata();
        DataPolicyMetadata.PermissionMetaData pmd = new DataPolicyMetadata.PermissionMetaData();
        pmd.setResourceName("pm1.g1");
        pmd.setCondition("e1 = user()");
        DataPolicyMetadata.PermissionMetaData pmd1 = new DataPolicyMetadata.PermissionMetaData();
        pmd1.setResourceName("pm1.g2");
        pmd1.setCondition("foo = bar");
        policy.addPermission(new DataPolicyMetadata.PermissionMetaData[]{pmd, pmd1});
        policies.put("some-role", policy);
        workContext.setPolicies(policies);
        context.setDQPWorkContext(workContext);
        return context;
    }

    @Test
    public void testSelectFilter() throws Exception {
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1", new List[]{Arrays.asList("a", 1), Arrays.asList("b", 2)});
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("select e2 from pm1.g1"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)new DefaultCapabilitiesFinder(), context);
        List[] expectedResults = new List[]{};
        TestProcessor.helpProcess(plan, context, dataManager, expectedResults);
    }

    @Test
    public void testDeleteFilter() throws Exception {
        HardcodedDataManager dataManager = new HardcodedDataManager();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("delete from pm1.g1 where e1 = 'a'"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestOptimizer.getGenericFinder(), context);
        List[] expectedResults = new List[]{Arrays.asList(0)};
        TestProcessor.helpProcess(plan, context, dataManager, expectedResults);
    }

    @Test(expected=QueryPlannerException.class)
    public void testInsertConstraint() throws Exception {
        HardcodedDataManager dataManager = new HardcodedDataManager();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("insert into pm1.g1 (e1) values ('a')"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestOptimizer.getGenericFinder(), context);
        List[] expectedResults = new List[]{Arrays.asList(0)};
        TestProcessor.helpProcess(plan, context, dataManager, expectedResults);
    }

    @Test(expected=QueryProcessingException.class)
    public void testInsertConstraintWithQueryExpression() throws Exception {
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT pm1.g3.e1 FROM pm1.g3", new List[]{Arrays.asList("a"), Arrays.asList("b")});
        BasicSourceCapabilities bsc = new BasicSourceCapabilities();
        bsc.setCapabilitySupport(SourceCapabilities.Capability.INSERT_WITH_QUERYEXPRESSION, true);
        DefaultCapabilitiesFinder capFinder = new DefaultCapabilitiesFinder((SourceCapabilities)bsc);
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("insert into pm1.g1 (e1) select e1 from pm1.g3"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)capFinder, context);
        List[] expectedResults = new List[]{Arrays.asList(0)};
        TestProcessor.helpProcess(plan, context, dataManager, expectedResults);
    }

    @Test
    public void testInsertConstraintWithQueryExpression1() throws Exception {
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT pm1.g3.e1 FROM pm1.g3", new List[]{Arrays.asList("a")});
        dataManager.addData("INSERT INTO pm1.g1 (e1) VALUES ('user')", new List[]{Arrays.asList(1)});
        BasicSourceCapabilities bsc = new BasicSourceCapabilities();
        bsc.setCapabilitySupport(SourceCapabilities.Capability.INSERT_WITH_QUERYEXPRESSION, true);
        DefaultCapabilitiesFinder capFinder = new DefaultCapabilitiesFinder((SourceCapabilities)bsc);
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("insert into pm1.g1 (e1) select user() from pm1.g3"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)capFinder, context);
        List[] expectedResults = new List[]{Arrays.asList(1)};
        TestProcessor.helpProcess(plan, context, dataManager, expectedResults);
    }

    @Test
    public void testInsertFilter1() throws Exception {
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("INSERT INTO pm1.g1 (e1) VALUES ('user')", new List[]{Arrays.asList(1)});
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("insert into pm1.g1 (e1) values ('user')"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestOptimizer.getGenericFinder(), context);
        List[] expectedResults = new List[]{Arrays.asList(1)};
        TestProcessor.helpProcess(plan, context, dataManager, expectedResults);
    }

    @Test(expected=QueryPlannerException.class)
    public void testUpdateFilter() throws Exception {
        HardcodedDataManager dataManager = new HardcodedDataManager();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("update pm1.g1 set e1 = 'a' where e2 = 5"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestOptimizer.getGenericFinder(), context);
        List[] expectedResults = new List[]{Arrays.asList(0)};
        TestProcessor.helpProcess(plan, context, dataManager, expectedResults);
    }

    @Test(expected=QueryPlannerException.class)
    public void testUpdateFilter1() throws Exception {
        HardcodedDataManager dataManager = new HardcodedDataManager();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("update pm1.g1 set e1 = e3 where e2 = 5"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestOptimizer.getGenericFinder(), context);
        List[] expectedResults = new List[]{Arrays.asList(0)};
        TestProcessor.helpProcess(plan, context, dataManager, expectedResults);
    }

    @Test(expected=QueryProcessingException.class)
    public void testUpdateFilter2() throws Exception {
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT g_0.e3, g_0.e1 FROM pm1.g1 AS g_0 WHERE (g_0.e1 = 'user') AND (g_0.e2 = 5)", new List[]{Arrays.asList(Boolean.TRUE, "user")});
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("update pm1.g1 set e1 = e3 || 'r' where e2 = 5"), (QueryMetadataInterface)RealMetadataFactory.example4(), TestOptimizer.getGenericFinder(), context);
        List[] expectedResults = new List[]{Arrays.asList(0)};
        TestProcessor.helpProcess(plan, context, dataManager, expectedResults);
    }

    @Test(expected=QueryMetadataException.class)
    public void testBadFilter() throws Exception {
        HardcodedDataManager dataManager = new HardcodedDataManager();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("select e2 from pm1.g2"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)new DefaultCapabilitiesFinder(), context);
        List[] expectedResults = new List[]{};
        TestProcessor.helpProcess(plan, context, dataManager, expectedResults);
    }
}

