/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.proc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.api.exception.query.QueryProcessingException;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.dqp.service.TransactionContext;
import org.teiid.dqp.service.TransactionService;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.QueryOptimizer;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.processor.xml.TestXMLProcessor;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.TestProcedureResolving;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.util.CommandContext;
import org.teiid.query.validator.Validator;
import org.teiid.query.validator.ValidatorFailure;
import org.teiid.query.validator.ValidatorReport;

public class TestProcedureProcessor {
    private static final boolean DEBUG = false;

    public static ProcessorPlan getProcedurePlan(String userQuery, QueryMetadataInterface metadata) throws Exception {
        return TestProcedureProcessor.getProcedurePlan(userQuery, metadata, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessorPlan getProcedurePlan(String userQuery, QueryMetadataInterface metadata, CapabilitiesFinder capabilitiesFinder) throws Exception {
        ProcessorPlan plan;
        Command userCommand = QueryParser.getQueryParser().parseCommand(userQuery);
        QueryResolver.resolveCommand((Command)userCommand, (QueryMetadataInterface)metadata);
        ValidatorReport report = Validator.validate((LanguageObject)userCommand, (QueryMetadataInterface)metadata);
        if (report.hasItems()) {
            ValidatorFailure firstFailure = (ValidatorFailure)report.getItems().iterator().next();
            throw new QueryValidatorException(firstFailure.getMessage());
        }
        QueryRewriter.rewrite((Command)userCommand, (QueryMetadataInterface)metadata, (CommandContext)new CommandContext());
        AnalysisRecord analysisRecord = new AnalysisRecord(false, false);
        if (capabilitiesFinder == null) {
            capabilitiesFinder = new DefaultCapabilitiesFinder();
        }
        ProcessorPlan processorPlan = plan = QueryOptimizer.optimizePlan((Command)userCommand, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capabilitiesFinder, (AnalysisRecord)analysisRecord, null);
        return processorPlan;
    }

    public static void helpTestProcess(ProcessorPlan procPlan, List[] expectedResults, ProcessorDataManager dataMgr, QueryMetadataInterface metadata) throws Exception {
        CommandContext context = new CommandContext((Object)"pID", null, null, null, 1);
        if (!(metadata instanceof TempMetadataAdapter)) {
            metadata = new TempMetadataAdapter(metadata, new TempMetadataStore());
        }
        context.setMetadata(metadata);
        TestProcessor.helpProcess(procPlan, context, dataMgr, expectedResults);
        Assert.assertNotNull((String)"Expected processing to fail", (Object)expectedResults);
    }

    private void helpTestProcessFailure(ProcessorPlan procPlan, FakeDataManager dataMgr, String failMessage, QueryMetadataInterface metadata) throws Exception {
        try {
            TestProcedureProcessor.helpTestProcess(procPlan, null, dataMgr, metadata);
        }
        catch (TeiidException ex) {
            Assert.assertEquals((Object)failMessage, (Object)ex.getMessage());
        }
    }

    private FakeDataManager exampleDataManager(QueryMetadataInterface metadata) throws TeiidException {
        FakeDataManager dataMgr = new FakeDataManager();
        dataMgr.registerTuples(metadata, "pm1.g1", new List[]{Arrays.asList("First", 5, new Boolean(true), new Double(1.003)), Arrays.asList("Second", 15, new Boolean(true), new Double(2.003)), Arrays.asList("Third", 51, new Boolean(true), new Double(3.003))});
        dataMgr.registerTuples(metadata, "pm1.g2", new List[]{Arrays.asList("First", 5, new Boolean(true), new Double(1.003)), Arrays.asList("Second", 15, new Boolean(true), new Double(2.003)), Arrays.asList("Third", 51, new Boolean(true), new Double(3.003))});
        return dataMgr;
    }

    private FakeDataManager exampleDataManager2(QueryMetadataInterface metadata) throws TeiidException {
        FakeDataManager dataMgr = new FakeDataManager();
        dataMgr.registerTuples(metadata, "pm1.g1", new List[]{Arrays.asList("First", 5, new Boolean(true), new Double(1.003)), Arrays.asList("Second", 15, new Boolean(true), new Double(2.003)), Arrays.asList("Third", 51, new Boolean(true), new Double(3.003))});
        dataMgr.registerTuples(metadata, "pm1.g2", new List[]{Arrays.asList("First", 5, new Boolean(true), new Double(1.003)), Arrays.asList("Second", 15, new Boolean(true), new Double(2.003)), Arrays.asList("Third", 51, new Boolean(true), new Double(3.003))});
        dataMgr.registerTuples(metadata, "pm2.g1", new List[]{Arrays.asList("First", 5, new Boolean(true), new Double(1.003)), Arrays.asList("Second", 15, new Boolean(true), new Double(2.003)), Arrays.asList("Third", 51, new Boolean(true), new Double(3.003))});
        dataMgr.registerTuples(metadata, "pm2.g2", new List[]{Arrays.asList("First", 5, new Boolean(true), new Double(1.003)), Arrays.asList("Second", 15, new Boolean(true), new Double(2.003)), Arrays.asList("Third", 51, new Boolean(true), new Double(3.003))});
        return dataMgr;
    }

    private FakeDataManager exampleDataManagerPm5(QueryMetadataInterface metadata) throws TeiidException {
        FakeDataManager dataMgr = new FakeDataManager();
        dataMgr.registerTuples(metadata, "pm5.g3", new List[]{Arrays.asList("First", new Short(5), new Boolean(true), new Double(1.003)), Arrays.asList("Second", new Short(15), new Boolean(true), new Double(2.003)), Arrays.asList("Third", new Short(51), new Boolean(true), new Double(3.003))});
        return dataMgr;
    }

    @Test
    public void testVirtualProcedure() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp2()";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First"), Arrays.asList("Second"), Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedureWithBlockedException() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp2()";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        dataMgr.setBlockOnce();
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First"), Arrays.asList("Second"), Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure2() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp3()";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure3() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp4()";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure4() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp5()";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure5() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp6()";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("Second")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure6() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp7(5)";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("Second")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure7() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp8(51)";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure8() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp9(51)";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure9() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp10(51)";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure10() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp13()";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("Third", 5)};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure11() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp14()";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First"), Arrays.asList("Second"), Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure12() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp15()";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        dataMgr.registerTuples((QueryMetadataInterface)metadata, "pm1.g2", new List[]{Arrays.asList("First", 5, new Boolean(true), new Double(1.003)), Arrays.asList("Third", 51, new Boolean(true), new Double(3.003))});
        List[] expected = new List[]{Arrays.asList("First"), Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure13() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp16()";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        dataMgr.registerTuples((QueryMetadataInterface)metadata, "pm1.g2", new List[]{Arrays.asList("First", 5, new Boolean(true), new Double(1.003)), Arrays.asList("Third", 51, new Boolean(true), new Double(3.003))});
        List[] expected = new List[]{Arrays.asList("First"), Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure14() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp17()";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure15() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp19()";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First"), Arrays.asList("Second"), Arrays.asList("Third"), Arrays.asList("First"), Arrays.asList("Second"), Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure16() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp20()";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First"), Arrays.asList("Second"), Arrays.asList("Third"), Arrays.asList("Fourth")};
        CommandContext context = new CommandContext((Object)"pID", null, null, null, 1);
        context.setMetadata((QueryMetadataInterface)metadata);
        context.setProcessorBatchSize(1);
        TestProcessor.helpProcess(plan, context, dataMgr, expected);
    }

    @Test
    public void testVirtualProcedure17() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp21(7)";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First", 5), Arrays.asList("Second", 15), Arrays.asList("Third", 51), Arrays.asList("Fourth", 7)};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure18() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp22(7)";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("Second", 15), Arrays.asList("Third", 51)};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure19() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp23(7)";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("Second", 15)};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure19WithBlockedException() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp23(7)";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("Second", 15)};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedureNoDataInTempTable() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp25()";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure30() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp30()";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First"), Arrays.asList("Second"), Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure31() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp31(51)";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedureDefect14282() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp24()";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("Second")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDefect16193() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp35(51)";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure16602() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp37()";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        HardcodedDataManager dataMgr = new HardcodedDataManager();
        dataMgr.addData("INSERT INTO pm1.g1 (e2) VALUES (5)", new List[]{Arrays.asList(1)});
        List[] expected = new List[]{Arrays.asList("1")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDefect16649_1() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp38()";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("Second")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDefect16649_2() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp39()";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("Second")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDefect16694() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp40()";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("Second")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDefect16707() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp44(2)";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First"), Arrays.asList("Second"), Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDefect16707_1() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp43(2)";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First"), Arrays.asList("Second"), Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDefect17451() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp45()";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        dataMgr.registerTuples((QueryMetadataInterface)metadata, "pm1.g2", new List[]{Arrays.asList("First", 5, new Boolean(true), new Double(1.003)), Arrays.asList("Third", 51, new Boolean(true), new Double(3.003))});
        List[] expected = new List[]{Arrays.asList("First"), Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure46() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp46()";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First"), Arrays.asList("Second"), Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDefect19982() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp55(5)";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First", 5), Arrays.asList("Second", 5), Arrays.asList("Third", 5)};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testCase3521() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp1()";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("Second")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDynamicCommandWithIntoExpression() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1();
        String query = "CREATE VIRTUAL PROCEDURE BEGIN\nexecute string 'SELECT e1 FROM pm1.g1 WHERE e1 = ''First''' as x string into #temp; declare string VARIABLES.RESULT = select x from #temp;select VARIABLES.RESULT; END";
        this.addProc(metadata, query);
        String userUpdateStr = "EXEC pm1.sq2()";
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    private void addProc(TransformationMetadata metadata, String query) {
        this.addProc(metadata, "sq2", query, new String[]{"e1"}, new String[]{"string"}, new String[0], new String[0]);
    }

    private void addProc(TransformationMetadata metadata, String name, String query, String[] rsCols, String[] rsTypes, String[] params, String[] paramTypes) {
        Schema pm1 = metadata.getMetadataStore().getSchema("PM1");
        pm1.getProcedures().remove(name.toUpperCase());
        ColumnSet<Procedure> rs2 = RealMetadataFactory.createResultSet("rs1", rsCols, rsTypes);
        QueryNode sq2n1 = new QueryNode(query);
        ArrayList<ProcedureParameter> procParams = new ArrayList<ProcedureParameter>(params.length);
        for (int i = 0; i < params.length; ++i) {
            procParams.add(RealMetadataFactory.createParameter(params[i], 1, paramTypes[i]));
        }
        Procedure sq1 = RealMetadataFactory.createVirtualProcedure(name, pm1, procParams, sq2n1);
        sq1.setResultSet(rs2);
    }

    @Test
    public void testDynamicCommandWithIntoAndLoop() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1();
        StringBuffer procedure = new StringBuffer("CREATE VIRTUAL PROCEDURE \n");
        procedure.append("BEGIN\n");
        procedure.append("declare integer VARIABLES.e2_total=0;\n");
        procedure.append("execute string 'SELECT e1, e2 FROM pm1.g1' as e1 string, e2 integer into #temp;\n");
        procedure.append("loop on (Select e2 from #temp where e2 > 2) as mycursor\n");
        procedure.append("BEGIN\n");
        procedure.append("IF (mycursor.e2>5) \n");
        procedure.append("VARIABLES.e2_total=VARIABLES.e2_total+mycursor.e2;\n");
        procedure.append("END\n");
        procedure.append("SELECT cast(VARIABLES.e2_total as string);\n");
        procedure.append("END");
        this.addProc(metadata, procedure.toString());
        String userUpdateStr = "EXEC pm1.sq2()";
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("66")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDynamicCommandWithParameter() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1();
        this.addProc(metadata, "sq2", "CREATE VIRTUAL PROCEDURE BEGIN\nexecute string 'SELECT e1, e2 FROM pm1.g1 WHERE e1=pm1.sq2.in' as e1 string, e2 integer; END", new String[]{"e1", "e2"}, new String[]{"string", "integer"}, new String[]{"in"}, new String[]{"string"});
        String userUpdateStr = "EXEC pm1.sq2('First')";
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First", 5)};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDynamicCommandWithUsing() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1();
        this.addProc(metadata, "sq2", "CREATE VIRTUAL PROCEDURE BEGIN\nexecute string 'SELECT e1, e2 FROM pm1.g1 WHERE e1=using.id' using id=pm1.sq2.in; END", new String[]{"e1", "e2"}, new String[]{"string", "integer"}, new String[]{"in"}, new String[]{"string"});
        String userUpdateStr = "EXEC pm1.sq2('First')";
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First", 5)};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDynamicCommandWithVariable() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1();
        this.addProc(metadata, "sq2", "CREATE VIRTUAL PROCEDURE BEGIN\ndeclare string VARIABLES.x; VARIABLES.x = pm1.sq2.in; execute string 'SELECT e1, e2 FROM pm1.g1 WHERE e1=VARIABLES.x'; END", new String[]{"e1", "e2"}, new String[]{"string", "integer"}, new String[]{"in"}, new String[]{"string"});
        String userUpdateStr = "EXEC pm1.sq2('First')";
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First", 5)};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDynamicCommandValidationFails() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1();
        this.addProc(metadata, "sq2", "CREATE VIRTUAL PROCEDURE BEGIN\ndeclare object VARIABLES.x; execute string 'SELECT xmlelement(name elem, x)'; select '1', 2; END", new String[]{"e1", "e2"}, new String[]{"string", "integer"}, new String[]{"in"}, new String[]{"string"});
        String userUpdateStr = "EXEC pm1.sq2('First')";
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        try {
            TestProcedureProcessor.helpTestProcess(plan, null, dataMgr, (QueryMetadataInterface)metadata);
            Assert.fail((String)"exception expected");
        }
        catch (QueryProcessingException e) {
            // empty catch block
        }
    }

    @Test
    public void testDynamicCommandWithSingleSelect() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1();
        this.addProc(metadata, "CREATE VIRTUAL PROCEDURE BEGIN\nexecute string 'SELECT 26'; END");
        String userUpdateStr = "EXEC pm1.sq2()";
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("26")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDynamicCommandTypeConversion() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1();
        this.addProc(metadata, "sq2", "CREATE VIRTUAL PROCEDURE BEGIN\ndeclare string VARIABLES.x; VARIABLES.x = 'a'; execute string 'SELECT e2 ' || ' FROM pm1.g1 ' || ' where e1=pm1.sq2.in'; END", new String[]{"e1"}, new String[]{"string"}, new String[]{"in"}, new String[]{"string"});
        String userUpdateStr = "EXEC pm1.sq2('First')";
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("5")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDynamicCommandRecursion() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1();
        this.addProc(metadata, "sq2", "CREATE VIRTUAL PROCEDURE BEGIN\nexecute string 'EXEC pm1.sq2(''First'')' as e1 string, e2 integer; END", new String[]{"e1", "e2"}, new String[]{"string", "integer"}, new String[]{"in"}, new String[]{"string"});
        String userUpdateStr = "EXEC pm1.sq2('First')";
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        this.helpTestProcessFailure(plan, dataMgr, "TEIID30168 Couldn't execute the dynamic SQL command \"EXECUTE IMMEDIATE 'EXEC pm1.sq2(''First'')' AS e1 string, e2 integer\" with the SQL statement \"'EXEC pm1.sq2(''First'')'\" due to: TEIID30347 There is a recursive invocation of group 'pm1.sq2'. Please correct the SQL.", (QueryMetadataInterface)metadata);
    }

    @Test(expected=QueryPlannerException.class)
    public void testDynamicCommandIncorrectProjectSymbolCount() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1();
        this.addProc(metadata, "sq1", "CREATE VIRTUAL PROCEDURE BEGIN\nSELECT pm1.g1.e1 FROM pm1.g1; END", new String[]{"e1"}, new String[]{"string"}, new String[]{"in"}, new String[]{"string"});
        this.addProc(metadata, "sq2", "CREATE VIRTUAL PROCEDURE BEGIN\nexecute string 'EXEC pm1.sq1(''First'')' as e1 string, e2 integer; END", new String[]{"e1"}, new String[]{"string"}, new String[]{"in"}, new String[]{"string"});
        String userUpdateStr = "EXEC pm1.sq2('test')";
        TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDynamicCommandPositional() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1();
        this.addProc(metadata, "sq2", "CREATE VIRTUAL PROCEDURE BEGIN\nexecute string 'select e1 as x, e2 from pm1.g1'; END", new String[]{"e1", "e2"}, new String[]{"string", "string"}, new String[]{"in"}, new String[]{"string"});
        String userUpdateStr = "EXEC pm1.sq2('test')";
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        TestProcedureProcessor.helpTestProcess(plan, new List[]{Arrays.asList("First", "5"), Arrays.asList("Second", "15"), Arrays.asList("Third", "51")}, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDynamicCommandIncorrectProjectSymbolDatatypes() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1();
        this.addProc(metadata, "sq2", "CREATE VIRTUAL PROCEDURE BEGIN\nexecute string 'select e1 from pm1.g1'; END", new String[]{"e1"}, new String[]{"integer"}, new String[0], new String[0]);
        String userUpdateStr = "EXEC pm1.sq2()";
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        this.helpTestProcessFailure(plan, dataMgr, "TEIID30168 Couldn't execute the dynamic SQL command \"EXECUTE IMMEDIATE 'select e1 from pm1.g1'\" with the SQL statement \"'select e1 from pm1.g1'\" due to: The datatype 'string' for element 'e1' in the dynamic SQL cannot be implicitly converted to 'integer'.", (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDynamicCommandWithTwoDynamicStatements() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1();
        this.addProc(metadata, "sq1", "CREATE VIRTUAL PROCEDURE BEGIN\nexecute string 'select e1 as x, e2 from pm1.g1'; END", new String[]{"e1", "e2"}, new String[]{"string", "string"}, new String[0], new String[0]);
        String userUpdateStr = "EXEC pm1.sq1()";
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First", "5"), Arrays.asList("Second", "15"), Arrays.asList("Third", "51")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testAssignmentWithCase() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1();
        String sql = new StringBuffer("declare integer caseValue = ").append("CASE").append(" WHEN pm1.sq1.param='a' THEN 0").append(" WHEN pm1.sq1.param='b' THEN 1").append(" WHEN pm1.sq1.param='c' THEN 2").append(" WHEN pm1.sq1.param='d' THEN 3").append(" ELSE 9999").append(" END").toString();
        this.addProc(metadata, "sq1", "CREATE VIRTUAL PROCEDURE BEGIN\n" + sql + "; SELECT caseValue; END", new String[]{"e1"}, new String[]{"integer"}, new String[]{"param"}, new String[]{"string"});
        String userUpdateStr = "EXEC pm1.sq1('d')";
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList(3)};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDynamicCommandInsertIntoTempTableWithDifferentDatatypeFromSource() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1();
        this.addProc(metadata, "sq2", "CREATE VIRTUAL PROCEDURE BEGIN\nexecute string 'select e1,e2 from pm5.g3' as e1 string, e2 integer INTO #temp; select * from #temp; END", new String[]{"e1", "e2"}, new String[]{"string", "integer"}, new String[0], new String[0]);
        String userUpdateStr = "EXEC pm1.sq2()";
        FakeDataManager dataMgr = this.exampleDataManagerPm5((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First", 5), Arrays.asList("Second", 15), Arrays.asList("Third", 51)};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDynamicCommandWithVariableOnly() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1();
        this.addProc(metadata, "sq1", "CREATE VIRTUAL PROCEDURE BEGIN\nDECLARE string VARIABLES.CRIT = 'select e1, e2 from pm5.g3 where e2=using.id'; execute string VARIABLES.CRIT USING ID = pm1.sq1.param; END", new String[]{"e1", "e2"}, new String[]{"string", "short"}, new String[]{"param"}, new String[]{"short"});
        String userUpdateStr = "EXEC pm1.sq1(convert(5,short))";
        FakeDataManager dataMgr = this.exampleDataManagerPm5((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First", new Short(5))};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedureWithCreate() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp60()";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First"), Arrays.asList("Second"), Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedureWithCreateAndDrop() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp61()";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First"), Arrays.asList("Second"), Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedureWithCreateAndSelectInto() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp62()";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First"), Arrays.asList("Second"), Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDifferentlyScopedTempTables() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1();
        StringBuffer procedure = new StringBuffer("CREATE VIRTUAL PROCEDURE \n");
        procedure.append("BEGIN\n");
        procedure.append("declare integer VARIABLES.e2_total=0;\n");
        procedure.append("if (e2_total = 0)");
        procedure.append("BEGIN\n");
        procedure.append("select e1 into #temp from pm1.g1;\n");
        procedure.append("VARIABLES.e2_total=select count(*) from #temp;\n");
        procedure.append("END\n");
        procedure.append("if (e2_total = 3)");
        procedure.append("BEGIN\n");
        procedure.append("select e1 into #temp from pm1.g1;\n");
        procedure.append("VARIABLES.e2_total=select count(*) from #temp;\n");
        procedure.append("END\n");
        procedure.append("SELECT cast(VARIABLES.e2_total as string);\n");
        procedure.append("END");
        this.addProc(metadata, procedure.toString());
        String userUpdateStr = "EXEC pm1.sq2()";
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("3")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testLoopsWithBreak() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1();
        StringBuffer procedure = new StringBuffer("CREATE VIRTUAL PROCEDURE \n");
        procedure.append("BEGIN\n");
        procedure.append("declare integer VARIABLES.e2_total=0;\n");
        procedure.append("loop on (select e2 as x from pm1.g1) as mycursor\n");
        procedure.append("BEGIN\n");
        procedure.append("e2_total=e2_total+mycursor.x;\n");
        procedure.append("break;\n");
        procedure.append("END\n");
        procedure.append("loop on (select e2 as x from pm1.g1) as mycursor\n");
        procedure.append("BEGIN\n");
        procedure.append("e2_total=e2_total+mycursor.x;");
        procedure.append("END\n");
        procedure.append("SELECT cast(VARIABLES.e2_total as string);\n");
        procedure.append("END");
        this.addProc(metadata, procedure.toString());
        String userUpdateStr = "EXEC pm1.sq2()";
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("76")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testLoopsWithLabels() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1();
        StringBuffer procedure = new StringBuffer("CREATE VIRTUAL PROCEDURE \n");
        procedure.append("y: BEGIN\n");
        procedure.append("declare integer VARIABLES.e2_total=param1;\n");
        procedure.append("x: loop on (select e2 as x from pm1.g1) as mycursor\n");
        procedure.append("BEGIN\n");
        procedure.append("e2_total=e2_total+mycursor.x;\n");
        procedure.append("loop on (select e2 as x from pm1.g1) as mycursor1\n");
        procedure.append("BEGIN\n");
        procedure.append("if (e2_total < 5)\n");
        procedure.append("break x;\n");
        procedure.append("else if (e2_total > 50)\n");
        procedure.append("leave y;\n");
        procedure.append("e2_total=e2_total+mycursor1.x;");
        procedure.append("END\n");
        procedure.append("END\n");
        procedure.append("SELECT VARIABLES.e2_total;\n");
        procedure.append("END");
        this.addProc(metadata, "sq2", procedure.toString(), new String[]{"e1"}, new String[]{"integer"}, new String[]{"param1"}, new String[]{"integer"});
        String userUpdateStr = "EXEC pm1.sq2(1)";
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
        expected = new List[]{Arrays.asList(0)};
        userUpdateStr = "EXEC pm1.sq2(-5)";
        plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testCreateWithoutDrop() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1();
        StringBuffer procedure = new StringBuffer("CREATE VIRTUAL PROCEDURE \n");
        procedure.append("BEGIN\n");
        procedure.append("create local temporary table t1 (e1 integer);\n");
        procedure.append("create local temporary table T1 (e1 integer);\n");
        procedure.append("SELECT cast(e1 as string) from t1;\n");
        procedure.append("END");
        this.addProc(metadata, procedure.toString());
        String userUpdateStr = "EXEC pm1.sq2()";
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        this.helpTestProcessFailure(plan, dataMgr, "TEIID30229 Temporary table \"T1\" already exists.", (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDoubleDrop() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1();
        StringBuffer procedure = new StringBuffer("CREATE VIRTUAL PROCEDURE \n");
        procedure.append("BEGIN\n");
        procedure.append("create local temporary table t1 (e1 string);\n");
        procedure.append("select e1 into t1 from pm1.g1;\n");
        procedure.append("drop table t1;\n");
        procedure.append("drop table t1;\n");
        procedure.append("SELECT '1';\n");
        procedure.append("END");
        this.addProc(metadata, procedure.toString());
        String userUpdateStr = "EXEC pm1.sq2()";
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        TestProcedureProcessor.helpTestProcess(plan, new List[]{Arrays.asList("1")}, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testFunctionInput() throws Exception {
        MetadataStore metadataStore = new MetadataStore();
        Schema v1 = RealMetadataFactory.createVirtualModel("v1", metadataStore);
        ProcedureParameter p1 = RealMetadataFactory.createParameter("in", 1, "string");
        ColumnSet<Procedure> rs1 = RealMetadataFactory.createResultSet("v1.rs1", new String[]{"e1"}, new String[]{"string"});
        QueryNode n1 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN declare string VARIABLES.x = '1'; exec v1.vp2(concat(x, v1.vp1.in)); END");
        Procedure vt1 = RealMetadataFactory.createVirtualProcedure("vp1", v1, Arrays.asList(p1), n1);
        vt1.setResultSet(rs1);
        ProcedureParameter p2 = RealMetadataFactory.createParameter("in", 1, "string");
        QueryNode n2 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN select v1.vp2.in; end");
        Procedure vt2 = RealMetadataFactory.createVirtualProcedure("vp2", v1, Arrays.asList(p2), n2);
        vt2.setResultSet(RealMetadataFactory.createResultSet("v1.rs1", new String[]{"e1"}, new String[]{"string"}));
        String sql = "exec v1.vp1('1')";
        List[] expected = new List[]{Arrays.asList("11")};
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata(metadataStore, "foo", new FunctionTree[0]);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(sql, (QueryMetadataInterface)metadata);
        TestProcedureProcessor.helpTestProcess(plan, expected, new FakeDataManager(), (QueryMetadataInterface)metadata);
    }

    @Test
    public void testReferenceForwarding() throws Exception {
        String sql = "EXEC pm1.vsp49()";
        TransformationMetadata metadata = RealMetadataFactory.example1();
        this.addProc(metadata, "sq2", "CREATE VIRTUAL PROCEDURE BEGIN if (1 = 2) begin declare integer x = 1; end SELECT e1, e2 FROM pm1.g1 WHERE e1=pm1.sq2.in; END", new String[]{"e1", "e2"}, new String[]{"string", "integer"}, new String[]{"in"}, new String[]{"string"});
        List[] expected = new List[]{Arrays.asList("b", 2)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(sql, (QueryMetadataInterface)metadata);
        TestProcedureProcessor.helpTestProcess(plan, expected, dataManager, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testInsertAfterCreate() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1();
        StringBuffer procedure = new StringBuffer("CREATE VIRTUAL PROCEDURE \n").append("BEGIN\n").append("\n  create local temporary table #temp (e1 string, e2 string);").append("\n  insert into #temp (e1) values ('a');").append("\n  insert into #temp (e2) values ('b');").append("SELECT e2 as e1 from #temp;\n").append("END");
        this.addProc(metadata, procedure.toString());
        String userUpdateStr = "EXEC pm1.sq2()";
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        TestProcedureProcessor.helpTestProcess(plan, new List[]{Arrays.asList(new Object[]{null}), Arrays.asList("b")}, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEvaluatableSelectWithOrderBy() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1();
        StringBuffer procedure = new StringBuffer("CREATE VIRTUAL PROCEDURE \n").append("BEGIN\n").append("SELECT param from pm1.g1 order by param limit 1;\n").append("END");
        this.addProc(metadata, "sq1", procedure.toString(), new String[]{"e1"}, new String[]{"string"}, new String[]{"param"}, new String[]{"string"});
        String userUpdateStr = "EXEC pm1.sq1(1)";
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        TestProcedureProcessor.helpTestProcess(plan, new List[]{Arrays.asList("1")}, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEvaluatableSelectWithOrderBy1() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1();
        StringBuffer procedure = new StringBuffer("CREATE VIRTUAL PROCEDURE \n").append("BEGIN\n").append("SELECT param from pm1.g1 union select e1 from pm1.g1 order by param limit 2;\n").append("END");
        this.addProc(metadata, "sq1", procedure.toString(), new String[]{"e1"}, new String[]{"string"}, new String[]{"param"}, new String[]{"string"});
        String userUpdateStr = "EXEC pm1.sq1(1)";
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        TestProcedureProcessor.helpTestProcess(plan, new List[]{Arrays.asList("1"), Arrays.asList("First")}, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testNonDeterministicEvaluation() throws Exception {
        StringBuffer procedure = new StringBuffer("CREATE VIRTUAL PROCEDURE \n").append("BEGIN\n").append("DECLARE integer x = 0;\n").append("CREATE LOCAL TEMPORARY TABLE #TEMP (e1 integer);\n").append("while (x < 2)\n").append("BEGIN\n").append("insert into #temp (e1) values (convert(rand() * 1000, integer));\n").append("x = x + 1;\n").append("END\n").append("SELECT cast(e1 as string) FROM #TEMP;\n").append("END");
        QueryMetadataInterface metadata = this.createProcedureMetadata(procedure.toString());
        String userUpdateStr = "EXEC pm1.sq1()";
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, metadata);
        TestProcedureProcessor.helpTestProcess(plan, new List[]{Arrays.asList("240"), Arrays.asList("637")}, dataMgr, metadata);
    }

    private QueryMetadataInterface createProcedureMetadata(String procedure) {
        TransformationMetadata metadata = RealMetadataFactory.example1();
        this.addProc(metadata, "sq1", procedure, new String[]{"e1"}, new String[]{"string"}, new String[0], new String[0]);
        return metadata;
    }

    @Test
    public void testTempTableTypeConversion() throws Exception {
        String procedure = "CREATE VIRTUAL PROCEDURE\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "CREATE local temporary table temp (x string, y integer);\n";
        procedure = procedure + "Select pm1.g1.e2 as e1, pm1.g1.e2 into temp from pm1.g1 order by pm1.g1.e2 limit 1;\n";
        procedure = procedure + "Select x from temp;\n";
        procedure = procedure + "END\n";
        QueryMetadataInterface metadata = this.createProcedureMetadata(procedure);
        String userUpdateStr = "EXEC pm1.sq1()";
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, metadata);
        TestProcedureProcessor.helpTestProcess(plan, new List[]{Arrays.asList("5")}, dataMgr, metadata);
    }

    @Test
    public void testXMLWithExternalCriteria() throws Exception {
        TransformationMetadata metadata = TestXMLProcessor.exampleMetadata();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested((QueryMetadataInterface)metadata);
        String resultFile = "TestXMLProcessor-testNested2WithContextCriteria5d.xml";
        String expectedDoc = TestXMLProcessor.readFile(resultFile);
        Schema pm1 = (Schema)metadata.getMetadataStore().getSchemas().get("XMLTEST");
        ColumnSet<Procedure> rs2 = RealMetadataFactory.createResultSet("pm1.rs2", new String[]{"e1"}, new String[]{"xml"});
        ProcedureParameter rs2p2 = RealMetadataFactory.createParameter("input", 1, "integer");
        QueryNode sq2n1 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN\ndeclare integer VARIABLES.x = proc.input; SELECT * FROM xmltest.doc9 WHERE context(SupplierID, OrderID)=x OR OrderID='2'; END");
        Procedure sq2 = RealMetadataFactory.createVirtualProcedure("proc", pm1, Arrays.asList(rs2p2), sq2n1);
        sq2.setResultSet(rs2);
        String userUpdateStr = "EXEC proc(5)";
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList(expectedDoc)};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testXMLWithExternalCriteria_InXMLVar() throws Exception {
        TransformationMetadata metadata = TestXMLProcessor.exampleMetadata();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested((QueryMetadataInterface)metadata);
        String resultFile = "TestXMLProcessor-testNested2WithContextCriteria5d.xml";
        String expectedDoc = TestXMLProcessor.readFile(resultFile);
        expectedDoc = expectedDoc.replaceAll("\\r", "");
        Schema pm1 = (Schema)metadata.getMetadataStore().getSchemas().get("XMLTEST");
        ColumnSet<Procedure> rs2 = RealMetadataFactory.createResultSet("pm1.rs2", new String[]{"e1"}, new String[]{"xml"});
        ProcedureParameter rs2p2 = RealMetadataFactory.createParameter("input", 1, "integer");
        QueryNode sq2n1 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN\ndeclare integer VARIABLES.x = proc.input; declare xml y = SELECT * FROM xmltest.doc9 WHERE context(SupplierID, OrderID)=x OR OrderID='2'; select y; END");
        Procedure sq2 = RealMetadataFactory.createVirtualProcedure("proc", pm1, Arrays.asList(rs2p2), sq2n1);
        sq2.setResultSet(rs2);
        String userUpdateStr = "EXEC proc(5)";
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList(expectedDoc)};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testXMLWithExternalCriteria1() throws Exception {
        TransformationMetadata metadata = TestXMLProcessor.exampleMetadata();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested((QueryMetadataInterface)metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Catalogs>\n   <Catalog>\n      <Items>\n         <Item ItemID=\"001\">\n            <Name>Lamp</Name>\n            <Quantity>5</Quantity>\n            <Suppliers>\n               <Supplier SupplierID=\"52\">\n                  <Name>Biff's Stuff</Name>\n                  <Zip>22222</Zip>\n                  <Orders>\n                     <Order OrderID=\"2\">\n                        <OrderDate>12/31/01</OrderDate>\n                        <OrderQuantity>87</OrderQuantity>\n                        <OrderStatus>complete</OrderStatus>\n                     </Order>\n                  </Orders>\n               </Supplier>\n            </Suppliers>\n         </Item>\n         <Item ItemID=\"002\">\n            <Name>Screwdriver</Name>\n            <Quantity>100</Quantity>\n            <Suppliers/>\n         </Item>\n         <Item ItemID=\"003\">\n            <Name>Goat</Name>\n            <Quantity>4</Quantity>\n            <Suppliers/>\n         </Item>\n      </Items>\n   </Catalog>\n</Catalogs>";
        Schema pm1 = (Schema)metadata.getMetadataStore().getSchemas().get("XMLTEST");
        ColumnSet<Procedure> rs2 = RealMetadataFactory.createResultSet("pm1.rs2", new String[]{"e1"}, new String[]{"xml"});
        ProcedureParameter rs2p2 = RealMetadataFactory.createParameter("input", 1, "integer");
        QueryNode sq2n1 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN\ndeclare integer VARIABLES.x = xmltest.proc.input; SELECT * FROM xmltest.doc9 WHERE context(SupplierID, SupplierID)=x; END");
        Procedure sq2 = RealMetadataFactory.createVirtualProcedure("proc", pm1, Arrays.asList(rs2p2), sq2n1);
        sq2.setResultSet(rs2);
        String userUpdateStr = "EXEC xmltest.proc(52)";
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList(expectedDoc)};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testCase174806() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp63()";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("c")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testJoinProcAndPhysicalModel() throws Exception {
        String userUpdateStr = "select a.e1 from (EXEC pm1.vsp46()) as a, pm1.g1 where a.e1=pm1.g1.e1";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First"), Arrays.asList("Second"), Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDeclareWithQueryAssignment() throws Exception {
        String procedure = "CREATE VIRTUAL PROCEDURE \n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "   DECLARE integer VARIABLES.var1 = 0;\n";
        procedure = procedure + "   /* the following DECLARE with ASSIGNMENT to a query should work ";
        procedure = procedure + "      but in IT236455 it results in the assignment inside the LOOP ";
        procedure = procedure + "      to fail */ ";
        procedure = procedure + "   DECLARE integer VARIABLES.NLEVELS = SELECT COUNT(*) FROM (\n";
        procedure = procedure + "                                          SELECT 'Col1' AS ACol1, 'Col2' AS ACol2, convert(3, integer) AS ACol3\n";
        procedure = procedure + "                                       ) AS Src;\n";
        procedure = procedure + "   LOOP ON (\n";
        procedure = procedure + "      SELECT StaticTable.BCol1, StaticTable.BCol2, StaticTable.BCol3 FROM (\n";
        procedure = procedure + "         SELECT 'Col 1' AS BCol1, 'Col 2' AS BCol2, convert(3, integer) AS BCol3\n";
        procedure = procedure + "      ) AS StaticTable\n";
        procedure = procedure + "   ) AS L1\n";
        procedure = procedure + "   BEGIN\n";
        procedure = procedure + "      /* In IT236455 the following would fail as the results from ";
        procedure = procedure + "         the LOOP (L1) are not in scope when the assignment is being ";
        procedure = procedure + "         performed due to the query earlier being part of a DECLARE  ";
        procedure = procedure + "         statement. */  ";
        procedure = procedure + "      VARIABLES.var1 = L1.BCol3;\n";
        procedure = procedure + "   END\n";
        procedure = procedure + "   SELECT cast(VARIABLES.Var1 as string) AS e1;\n";
        procedure = procedure + "END\n";
        QueryMetadataInterface metadata = this.createProcedureMetadata(procedure);
        String userQuery = "SELECT e1 FROM (EXEC pm1.sq1()) as proc";
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userQuery, metadata);
        List[] expected = new List[]{Arrays.asList("3")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, metadata);
    }

    @Test
    public void testRemovalOfNonJoinCritWithReference() throws Exception {
        String proc = "";
        String sql = "";
        sql = sql + "SELECT \tpm1.g1.e1 AS pm1g1e1, \tpm2.g2.e1 AS pm2g2e1, \tpm1.g1.e2 AS pm1g1e2, \tpm2.g2.e2 AS pm2g2e2 FROM \tpm1.g1\tLEFT OUTER JOIN pm2.g2 \tON pm1.g1.e1 = pm2.g2.e1 \tAND pm2.g2.e2 = VARIABLES.myVar ";
        proc = proc + "CREATE VIRTUAL PROCEDURE BEGIN    declare integer myVar = 5;   " + sql + ";" + "END";
        TransformationMetadata metadata = RealMetadataFactory.example1();
        this.addProc(metadata, "sq1", proc, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "string", "integer", "integer"}, new String[0], new String[0]);
        String userQuery = "SELECT * FROM (EXEC pm1.sq1()) as proc";
        FakeDataManager dataMgr = this.exampleDataManager2((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userQuery, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First", "First", 5, 5), Arrays.asList("Second", null, 15, null), Arrays.asList("Third", null, 51, null)};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
        Assert.assertTrue((!plan.requiresTransaction(false) ? 1 : 0) != 0);
    }

    @Test
    public void testRemovalOfNonJoinCritWithReference2() throws Exception {
        String proc = "";
        String sql = "";
        sql = sql + "SELECT \tpm1.g1.e1 AS pm1g1e1, \tpm2.g2.e1 AS pm2g2e1, \tpm1.g1.e2 AS pm1g1e2, \tpm2.g2.e2 AS pm2g2e2 FROM \tpm1.g1\tLEFT OUTER JOIN pm2.g2 \tON pm1.g1.e1 = pm2.g2.e1 \tAND pm2.g2.e2 = VARIABLES.myVar ";
        proc = proc + "CREATE VIRTUAL PROCEDURE BEGIN    declare integer myVar = 5;   " + sql + ";" + "END";
        TransformationMetadata metadata = RealMetadataFactory.example1();
        this.addProc(metadata, "sq1", proc, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "string", "integer", "integer"}, new String[0], new String[0]);
        String userQuery = "SELECT * FROM (EXEC pm1.sq1()) as proc";
        FakeDataManager dataMgr = this.exampleDataManager2((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userQuery, (QueryMetadataInterface)metadata, TestOptimizer.getGenericFinder());
        List[] expected = new List[]{Arrays.asList("First", "First", 5, 5), Arrays.asList("Second", null, 15, null), Arrays.asList("Third", null, 51, null)};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testUpdateDeleteTemp() throws Exception {
        String proc = "CREATE VIRTUAL PROCEDURE BEGIN  select e1, e2, e3, e4 into #t1 from pm1.g1;\n update #t1 set e1 = 1 where e4 < 2;\n delete from #t1 where e4 > 2;\n select e1 from #t1;\nEND";
        QueryMetadataInterface metadata = this.createProcedureMetadata(proc);
        String userQuery = "SELECT * FROM (EXEC pm1.sq1()) as proc";
        FakeDataManager dataMgr = this.exampleDataManager2(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userQuery, metadata, TestOptimizer.getGenericFinder());
        List[] expected = new List[]{Arrays.asList(String.valueOf(1))};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, metadata);
    }

    @Test
    public void testTempSubqueryInput() throws Exception {
        String proc = "CREATE VIRTUAL PROCEDURE BEGIN  create local temporary table t1 (e1 string);\n select e1 into t1 from pm1.g1;\n select cast(e2 as string) from (exec pm1.sq2((select max(e1) from t1))) x;\nEND";
        QueryMetadataInterface metadata = this.createProcedureMetadata(proc);
        String userQuery = "SELECT * FROM (EXEC pm1.sq1()) as proc";
        FakeDataManager dataMgr = this.exampleDataManager2(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userQuery, metadata, TestOptimizer.getGenericFinder());
        List[] expected = new List[]{Arrays.asList("51")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, metadata);
    }

    @Test
    public void testUnambiguousVirtualProc() throws Exception {
        String userQuery = "EXEC MMSP6('1')";
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userQuery, (QueryMetadataInterface)metadata, TestOptimizer.getGenericFinder());
        List[] expected = new List[]{Arrays.asList("1")};
        TestProcedureProcessor.helpTestProcess(plan, expected, new HardcodedDataManager(), (QueryMetadataInterface)metadata);
    }

    @Test
    public void testParameterAssignments() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        String userQuery = "EXEC TEIIDSP7(1)";
        HardcodedDataManager dataMgr = new HardcodedDataManager();
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userQuery, (QueryMetadataInterface)metadata);
        dataMgr.addData("x = EXEC spTest9(1)", new List[]{Arrays.asList(3)});
        dataMgr.addData("EXEC spTest11(3, null)", new List[]{Arrays.asList("1", 1, null), Arrays.asList(null, null, 4)});
        List[] expected = new List[]{Arrays.asList("34")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testNonQueryPushdownValidation() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1();
        StringBuffer procedure = new StringBuffer("CREATE VIRTUAL PROCEDURE \n");
        procedure.append("BEGIN\n");
        procedure.append("create local temporary table x (y string);\n");
        procedure.append("declare string s = 'foo';\n");
        procedure.append("update x set y = in1 || s;\n");
        procedure.append("update pm1.g1 set e1 = lookup('pm1.g1', 'e1', 'e2', in1);\n");
        procedure.append("exec pm1.sq2(in1 || 'foo');\n");
        procedure.append("END");
        this.addProc(metadata, "sq1", procedure.toString(), new String[]{"e1", "e2"}, new String[]{"string", "integer"}, new String[]{"in1"}, new String[]{"integer"});
        String userUpdateStr = "EXEC pm1.sq1(1)";
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testReturnParamWithNoResultSetVirtual() throws Exception {
        String sql = "EXEC TEIIDSP8(51)";
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(sql, (QueryMetadataInterface)metadata);
        FakeDataManager dataMgr = new FakeDataManager();
        List[] expected = new List[]{Arrays.asList(51)};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test(expected=QueryProcessingException.class)
    public void testParamsWithResultSetVirtualNotNull() throws Exception {
        String sql = "{? = call TEIIDSP9(51)}";
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(sql, (QueryMetadataInterface)metadata);
        FakeDataManager dataMgr = new FakeDataManager();
        TestProcedureProcessor.helpTestProcess(plan, null, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testParamsWithResultSetVirtual() throws Exception {
        String sql = "{? = call TEIIDSP9(1)}";
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(sql, (QueryMetadataInterface)metadata);
        FakeDataManager dataMgr = new FakeDataManager();
        List[] expected = new List[]{Arrays.asList("hello", null, null), Arrays.asList(null, 1, 10)};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testBeginAtomic() throws Exception {
        String proc = "CREATE VIRTUAL PROCEDURE BEGIN ATOMIC select e1, e2, e3, e4 into #t1 from pm1.g1;\n update #t1 set e1 = 1 where e4 < 2;\n delete from #t1 where e4 > 2;\n select e2/\"in\" from #t1;\nEND";
        TransformationMetadata tm = RealMetadataFactory.example1();
        this.addProc(tm, "sq1", proc, new String[]{"e1"}, new String[]{"integer"}, new String[]{"in"}, new String[]{"integer"});
        FakeDataManager dataMgr = this.exampleDataManager((QueryMetadataInterface)tm);
        CommandContext context = new CommandContext((Object)"pID", null, null, null, 1);
        TempMetadataAdapter metadata = new TempMetadataAdapter((QueryMetadataInterface)tm, new TempMetadataStore());
        context.setMetadata((QueryMetadataInterface)metadata);
        TransactionContext tc = new TransactionContext();
        TransactionService ts = (TransactionService)Mockito.mock(TransactionService.class);
        context.setTransactionService(ts);
        context.setTransactionContext(tc);
        String userQuery = "EXEC pm1.sq1(1)";
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userQuery, (QueryMetadataInterface)tm, TestOptimizer.getGenericFinder());
        List[] expected = new List[]{Arrays.asList(5)};
        TestProcessor.helpProcess(plan, context, dataMgr, expected);
        ((TransactionService)Mockito.verify((Object)ts, (VerificationMode)Mockito.times((int)3))).begin(tc);
        ((TransactionService)Mockito.verify((Object)ts, (VerificationMode)Mockito.times((int)3))).commit(tc);
        tc = new TransactionContext();
        ts = (TransactionService)Mockito.mock(TransactionService.class);
        context.setTransactionService(ts);
        context.setTransactionContext(tc);
        userQuery = "EXEC pm1.sq1(0)";
        plan = TestProcedureProcessor.getProcedurePlan(userQuery, (QueryMetadataInterface)tm, TestOptimizer.getGenericFinder());
        expected = null;
        try {
            TestProcessor.helpProcess(plan, context, dataMgr, expected);
            Assert.fail();
        }
        catch (TeiidProcessingException e) {
            // empty catch block
        }
        ((TransactionService)Mockito.verify((Object)ts)).begin(tc);
        ((TransactionService)Mockito.verify((Object)ts, (VerificationMode)Mockito.times((int)2))).resume(tc);
        ((TransactionService)Mockito.verify((Object)ts, (VerificationMode)Mockito.times((int)0))).commit(tc);
        ((TransactionService)Mockito.verify((Object)ts)).rollback(tc);
    }

    @Test
    public void testVarArgs() throws Exception {
        String ddl = "create foreign procedure proc (x integer, VARIADIC z integer); create virtual procedure vproc (x integer, VARIADIC z integer) returns integer as begin \"return\" = z[2] + array_length(z); call proc(x, z); end;";
        TransformationMetadata tm = TestProcedureResolving.createMetadata(ddl);
        String sql = "call vproc(1, 2, 3)";
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(sql, (QueryMetadataInterface)tm);
        HardcodedDataManager dataManager = new HardcodedDataManager((QueryMetadataInterface)tm);
        dataManager.addData("EXEC proc(1, 2, 3)", new List[0]);
        List[] expected = new List[]{Arrays.asList(5)};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataManager, (QueryMetadataInterface)tm);
    }

    @Test
    public void testVarArgsVirtNotNull() throws Exception {
        String ddl = "create virtual procedure vproc (x integer, VARIADIC z integer NOT NULL) returns (y integer) as begin select array_length(z); end;";
        TransformationMetadata tm = TestProcedureResolving.createMetadata(ddl);
        String sql = "call vproc(1, null, 3)";
        try {
            TestProcedureProcessor.getProcedurePlan(sql, (QueryMetadataInterface)tm);
            Assert.fail();
        }
        catch (QueryValidatorException e) {
            // empty catch block
        }
        sql = "call vproc(1, (select cast(null as integer)), 3)";
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(sql, (QueryMetadataInterface)tm);
        HardcodedDataManager dataManager = new HardcodedDataManager();
        try {
            TestProcedureProcessor.helpTestProcess(plan, null, dataManager, (QueryMetadataInterface)tm);
            Assert.fail();
        }
        catch (QueryValidatorException e) {
            // empty catch block
        }
    }

    @Test
    public void testVarArgsFunctionInVirt() throws Exception {
        String ddl = "create virtual procedure proc (VARIADIC z STRING) returns string as \"return\" = coalesce(null, null, z);";
        TransformationMetadata tm = TestProcedureResolving.createMetadata(ddl);
        String sql = "call proc(1, 2, 3)";
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(sql, (QueryMetadataInterface)tm);
        HardcodedDataManager dataManager = new HardcodedDataManager((QueryMetadataInterface)tm);
        List[] expected = new List[]{Arrays.asList("1")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataManager, (QueryMetadataInterface)tm);
    }

    @Test
    public void testNestedBlock() throws Exception {
        String ddl = "create virtual procedure proc (z STRING) returns table (x string, y string) as begin declare string x = z; select x without return; begin select x, x; end end;";
        TransformationMetadata tm = TestProcedureResolving.createMetadata(ddl);
        String sql = "call proc('a')";
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(sql, (QueryMetadataInterface)tm);
        HardcodedDataManager dataManager = new HardcodedDataManager((QueryMetadataInterface)tm);
        List[] expected = new List[]{Arrays.asList("a", "a")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataManager, (QueryMetadataInterface)tm);
    }

    @Test
    public void testReturnStatement() throws Exception {
        String ddl = "create virtual procedure proc (OUT a string RESULT, z STRING) returns table (x string, y string) as begin declare string x = z; select x without return; if (z = 'a') return 2; else if (z = 'b') return; begin select x, x; end end;";
        TransformationMetadata tm = TestProcedureResolving.createMetadata(ddl);
        String sql = "{? = call proc('a')}";
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(sql, (QueryMetadataInterface)tm);
        HardcodedDataManager dataManager = new HardcodedDataManager((QueryMetadataInterface)tm);
        List[] expected = new List[]{Arrays.asList(null, null, "2")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataManager, (QueryMetadataInterface)tm);
        sql = "{? = call proc('b')}";
        plan = TestProcedureProcessor.getProcedurePlan(sql, (QueryMetadataInterface)tm);
        expected = new List[]{Arrays.asList(null, null, null)};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataManager, (QueryMetadataInterface)tm);
    }
}

