/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.processor.relational.FakeRelationalNode;
import org.teiid.query.processor.relational.RelationalNodeStatistics;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.util.CommandContext;

public class TestRelationalNodeStatistics
extends TestCase {
    private int actualNodeOutputRows;
    private int actualNodeNextBatchCalls;
    private int actualNodeCumulativeBlocks;
    private int actualNodeBlocks;

    public void testBatchTimer() {
        RelationalNodeStatistics testnodeStatistics = new RelationalNodeStatistics();
        testnodeStatistics.startBatchTimer();
        TestRelationalNodeStatistics.assertTrue((String)"The batch timer did not yield a start time", (testnodeStatistics.getBatchStartTime() != 0L ? 1 : 0) != 0);
        testnodeStatistics.stopBatchTimer();
        TestRelationalNodeStatistics.assertTrue((String)"The batch timer did not yield an end time", (testnodeStatistics.getBatchEndTime() != 0L ? 1 : 0) != 0);
    }

    public void testStatsCollection() throws TeiidComponentException, TeiidProcessingException {
        TupleBatch batch;
        List[] data = this.createData(1000);
        FakeRelationalNode fakeNode = this.createFakeNode(data);
        while (!(batch = fakeNode.nextBatch()).getTerminationFlag()) {
        }
        this.actualNodeBlocks = fakeNode.getNodeStatistics().getNodeBlocks();
        this.actualNodeNextBatchCalls = fakeNode.getNodeStatistics().getNodeNextBatchCalls();
        this.actualNodeOutputRows = fakeNode.getNodeStatistics().getNodeOutputRows();
        TestRelationalNodeStatistics.assertEquals((String)("The NodeOutputRows was Inccorrect. Correct: 1000 Actual: " + this.actualNodeOutputRows), (int)1000, (int)this.actualNodeOutputRows);
        TestRelationalNodeStatistics.assertEquals((String)("The NodeNextBatchCalls was Inccorrect. Correct: 10 Actual: " + this.actualNodeNextBatchCalls), (int)10, (int)this.actualNodeNextBatchCalls);
        TestRelationalNodeStatistics.assertEquals((String)("The NodeBlocks was Inccorrect. Correct: 0 Actual: " + this.actualNodeBlocks), (int)0, (int)this.actualNodeBlocks);
        TestRelationalNodeStatistics.assertEquals((String)("The NodeComulativeBlocks was Inccorrect. Correct: 0 Actual: " + this.actualNodeCumulativeBlocks), (int)0, (int)this.actualNodeCumulativeBlocks);
    }

    public void testDescriptionProperties() throws Exception {
        TupleBatch batch;
        List[] data = this.createData(1000);
        FakeRelationalNode fakeNode = this.createFakeNode(data);
        while (!(batch = fakeNode.nextBatch()).getTerminationFlag()) {
        }
        TestRelationalNodeStatistics.assertEquals((String)"FakeRelationalNode", (String)fakeNode.getDescriptionProperties().getName());
    }

    private FakeRelationalNode createFakeNode(List[] data) {
        ElementSymbol element = new ElementSymbol("a");
        element.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        elements.add(element);
        FakeRelationalNode fakeNode = new FakeRelationalNode(1, data, 100);
        fakeNode.setElements(elements);
        CommandContext context = new CommandContext((Object)"pid", "group", null, null, null, 1, true);
        fakeNode.initialize(context, BufferManagerFactory.getStandaloneBufferManager(), null);
        return fakeNode;
    }

    private List[] createData(int rows) {
        List[] data = new List[rows];
        for (int i = 0; i < rows; ++i) {
            data[i] = new ArrayList();
            data[i].add(new Integer(i));
        }
        return data;
    }
}

