/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.client.BatchSerializer;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.core.types.ArrayImpl;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.symbol.Array;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class TestArray {
    @Test
    public void testArrayValueCompare() {
        ArrayImpl a1 = new ArrayImpl(new Object[]{1, 2, 3});
        UnitTestUtil.helpTestEquivalence((int)0, (Object)a1, (Object)a1);
        ArrayImpl a2 = new ArrayImpl(new Object[]{1, 2});
        UnitTestUtil.helpTestEquivalence((int)1, (Object)a1, (Object)a2);
    }

    @Test
    public void testArrayValueToString() {
        ArrayImpl a1 = new ArrayImpl(new Object[]{1, "x'2", 3});
        Assert.assertEquals((Object)"(1, 'x''2', 3)", (Object)SQLStringVisitor.getSQLString((LanguageObject)new Constant((Object)a1)));
    }

    @Test
    public void testArrayClone() {
        Array array = new Array(DataTypeManager.DefaultDataClasses.OBJECT, Arrays.asList(new ElementSymbol("e1")));
        Array a1 = array.clone();
        Assert.assertNotSame((Object)a1, (Object)array);
        Assert.assertEquals((Object)a1, (Object)array);
        Assert.assertNotSame(a1.getExpressions().get(0), array.getExpressions().get(0));
    }

    @Test
    public void testArrayValueSerialization() throws Exception {
        ArrayImpl a1 = new ArrayImpl((Object[])new Integer[]{1, null, 3});
        ArrayImpl a2 = new ArrayImpl(null);
        String[] types = TupleBuffer.getTypeNames(Arrays.asList(new Array(Integer.class, null)));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        BatchSerializer.writeBatch((ObjectOutput)oos, (String[])types, Arrays.asList(Arrays.asList(a1), Arrays.asList(a2)));
        oos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        List batch = BatchSerializer.readBatch((ObjectInput)ois, (String[])types);
        Assert.assertEquals((Object)a1, ((List)batch.get(0)).get(0));
        try {
            ((java.sql.Array)((List)batch.get(1)).get(0)).getArray();
            Assert.fail();
        }
        catch (SQLException e) {
            // empty catch block
        }
    }

    @Test
    public void testZeroBasedArray() throws Exception {
        ArrayImpl a1 = new ArrayImpl((Object[])new Integer[]{1, 2, 3});
        a1.setZeroBased(true);
        Assert.assertEquals((Object)2, (Object)java.lang.reflect.Array.get(a1.getArray(1L, 1), 0));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testIndexOutOfBounds() throws Exception {
        ArrayImpl a1 = new ArrayImpl((Object[])new Integer[]{1, 2, 3});
        a1.getArray(-1L, 1);
    }
}

