/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.teiid.client.ResizingArrayList;
import org.teiid.common.buffer.AbstractTupleSource;
import org.teiid.common.buffer.BatchManager;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.IndexedTupleSource;
import org.teiid.common.buffer.LobManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.Streamable;
import org.teiid.core.util.Assertion;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.sql.symbol.Expression;

public class TupleBuffer {
    private BatchManager manager;
    private String tupleSourceID;
    private List<? extends Expression> schema;
    private int batchSize;
    private int rowCount;
    private boolean isFinal;
    private TreeMap<Integer, Long> batches = new TreeMap();
    private List<List<?>> batchBuffer;
    private boolean removed;
    private boolean forwardOnly;
    private LobManager lobManager;
    private String uuid;
    private Object rowSourceLock;

    public static String[] getTypeNames(List<? extends Expression> expressions) {
        if (expressions == null) {
            return null;
        }
        String[] types = new String[expressions.size()];
        ListIterator<? extends Expression> i = expressions.listIterator();
        while (i.hasNext()) {
            Expression expr = i.next();
            types[i.previousIndex()] = DataTypeManager.getDataTypeName(expr.getType());
        }
        return types;
    }

    public TupleBuffer(BatchManager manager, String id, List<? extends Expression> schema, LobManager lobManager, int batchSize) {
        this.manager = manager;
        this.tupleSourceID = id;
        this.schema = schema;
        this.lobManager = lobManager;
        this.batchSize = batchSize;
    }

    public void setRowSourceLock(Object rowSourceLock) {
        this.rowSourceLock = rowSourceLock;
    }

    public void setInlineLobs(boolean inline) {
        if (this.lobManager != null) {
            this.lobManager.setInlineLobs(inline);
        }
    }

    public void removeLobTracking() {
        if (this.lobManager != null) {
            this.lobManager.remove();
            this.lobManager = null;
        }
    }

    public String getId() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID().toString();
        }
        return this.uuid;
    }

    public void setId(String uuid) {
        this.uuid = uuid;
    }

    public boolean isLobs() {
        return this.lobManager != null;
    }

    public void addTuple(List<?> tuple) throws TeiidComponentException {
        if (this.isLobs()) {
            this.lobManager.updateReferences(tuple, LobManager.ReferenceMode.CREATE);
        }
        ++this.rowCount;
        if (this.batchBuffer == null) {
            this.batchBuffer = new ResizingArrayList(this.batchSize / 4);
        }
        this.batchBuffer.add(tuple);
        if (this.batchBuffer.size() == this.batchSize) {
            this.saveBatch(false);
        }
    }

    public void addTupleBatch(TupleBatch batch, boolean save) throws TeiidComponentException {
        block3: {
            List<List<?>> tuples;
            block2: {
                this.setRowCount(batch.getBeginRow() - 1);
                tuples = batch.getTuples();
                if (!save) break block2;
                for (int i = 0; i < batch.getRowCount(); ++i) {
                    this.addTuple(tuples.get(i));
                }
                break block3;
            }
            if (!this.isLobs()) break block3;
            for (int i = 0; i < batch.getRowCount(); ++i) {
                this.lobManager.updateReferences(tuples.get(i), LobManager.ReferenceMode.CREATE);
            }
        }
    }

    public void setRowCount(int rowCount) throws TeiidComponentException {
        assert (this.rowCount <= rowCount);
        if (this.rowCount != rowCount) {
            this.saveBatch(true);
            this.rowCount = rowCount;
        }
    }

    public void purge() {
        if (this.batchBuffer != null) {
            this.batchBuffer.clear();
        }
        for (Long batch : this.batches.values()) {
            this.manager.remove(batch);
        }
        if (this.lobManager != null) {
            this.lobManager.remove();
        }
        this.batches.clear();
    }

    public void persistLobs() throws TeiidComponentException {
        if (this.lobManager != null) {
            this.lobManager.persist();
        }
    }

    public void saveBatch() throws TeiidComponentException {
        this.saveBatch(false);
    }

    void saveBatch(boolean force) throws TeiidComponentException {
        Assertion.assertTrue((!this.isRemoved() ? 1 : 0) != 0);
        if (this.batchBuffer == null || this.batchBuffer.isEmpty() || !force && this.batchBuffer.size() < Math.max(1, this.batchSize / 32)) {
            return;
        }
        Long mbatch = this.manager.createManagedBatch(this.batchBuffer, null, false);
        this.batches.put(this.rowCount - this.batchBuffer.size() + 1, mbatch);
        this.batchBuffer = null;
    }

    public void close() throws TeiidComponentException {
        this.saveBatch(false);
        this.isFinal = true;
    }

    public TupleBatch getBatch(int row) throws TeiidComponentException {
        TupleBatch result = null;
        if (row > this.rowCount) {
            result = new TupleBatch(this.rowCount + 1, new List[0]);
        } else if (this.batchBuffer != null && row > this.rowCount - this.batchBuffer.size()) {
            result = new TupleBatch(this.rowCount - this.batchBuffer.size() + 1, this.batchBuffer);
            if (this.forwardOnly) {
                this.batchBuffer = null;
            }
        } else {
            if (this.batchBuffer != null && !this.batchBuffer.isEmpty()) {
                this.saveBatch(false);
            }
            Map.Entry<Integer, Long> entry = this.batches.floorEntry(row);
            Assertion.isNotNull(entry);
            Long batch = entry.getValue();
            List<List<?>> rows = this.manager.getBatch(batch, !this.forwardOnly);
            result = new TupleBatch((int)entry.getKey(), rows);
            if (this.isFinal && result.getEndRow() == this.rowCount) {
                result.setTerminationFlag(true);
            }
            if (this.forwardOnly) {
                this.batches.remove(entry.getKey());
            }
        }
        if (this.isFinal && result.getEndRow() == this.rowCount) {
            result.setTerminationFlag(true);
        }
        return result;
    }

    public void remove() {
        if (!this.removed) {
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
                LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Removing TupleBuffer:", this.tupleSourceID});
            }
            this.batchBuffer = null;
            this.purge();
            this.manager.remove();
            this.removed = true;
        }
    }

    public int getManagedRowCount() {
        if (!this.batches.isEmpty()) {
            int start = this.batches.firstKey();
            return this.rowCount - start + 1;
        }
        if (this.batchBuffer != null) {
            return this.batchBuffer.size();
        }
        return 0;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    public List<? extends Expression> getSchema() {
        return this.schema;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public Streamable<?> getLobReference(String id) throws TeiidComponentException {
        if (this.lobManager == null) {
            throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30032, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30032, new Object[0]));
        }
        return this.lobManager.getLobReference(id);
    }

    public void setForwardOnly(boolean forwardOnly) {
        this.forwardOnly = forwardOnly;
    }

    public IndexedTupleSource createIndexedTupleSource() {
        return this.createIndexedTupleSource(false);
    }

    public IndexedTupleSource createIndexedTupleSource(final boolean singleUse) {
        if (singleUse) {
            this.setForwardOnly(true);
        }
        return new AbstractTupleSource(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected List<?> finalRow() throws TeiidComponentException, TeiidProcessingException {
                if (TupleBuffer.this.isFinal) {
                    return null;
                }
                if (TupleBuffer.this.rowSourceLock == null) {
                    throw BlockedException.blockWithTrace("Blocking on non-final TupleBuffer", TupleBuffer.this.tupleSourceID, "size", TupleBuffer.this.getRowCount());
                }
                Object object = TupleBuffer.this.rowSourceLock;
                synchronized (object) {
                    while (!TupleBuffer.this.isFinal && this.available() < 1) {
                        try {
                            TupleBuffer.this.rowSourceLock.wait();
                        }
                        catch (InterruptedException e) {
                            throw new TeiidRuntimeException((Throwable)e);
                        }
                    }
                    return this.getCurrentTuple();
                }
            }

            @Override
            public int available() {
                return TupleBuffer.this.rowCount - this.getCurrentIndex() + 1;
            }

            @Override
            protected TupleBatch getBatch(int row) throws TeiidComponentException {
                return TupleBuffer.this.getBatch(row);
            }

            @Override
            public void closeSource() {
                super.closeSource();
                if (singleUse) {
                    TupleBuffer.this.remove();
                }
            }
        };
    }

    public String toString() {
        return this.tupleSourceID;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public boolean isForwardOnly() {
        return this.forwardOnly;
    }

    public void setPrefersMemory(boolean prefersMemory) {
        this.manager.setPrefersMemory(prefersMemory);
    }

    public String[] getTypes() {
        return this.manager.getTypes();
    }

    public int getLobCount() {
        if (this.lobManager == null) {
            return 0;
        }
        return this.lobManager.getLobCount();
    }

    public void truncateTo(int rowLimit) throws TeiidComponentException {
        TupleBatch last;
        if (this.rowCount <= rowLimit) {
            return;
        }
        TupleBatch tb = last = this.getBatch(rowLimit);
        if (this.batchBuffer != null) {
            this.batchBuffer.clear();
        }
        int begin = tb.getBeginRow();
        do {
            Long id;
            if (tb == null) {
                tb = this.getBatch(begin);
            }
            if ((id = this.batches.remove(begin)) != null) {
                this.manager.remove(id);
            }
            if (this.lobManager != null) {
                for (List<?> tuple : tb.getTuples()) {
                    this.lobManager.updateReferences(tuple, LobManager.ReferenceMode.REMOVE);
                }
            }
            begin = tb.getEndRow() + 1;
            tb = null;
        } while (begin <= this.rowCount);
        this.rowCount = last.getBeginRow() - 1;
        Iterator<List<?>> iter = last.getTuples().iterator();
        while (this.rowCount < rowLimit) {
            this.addTuple(iter.next());
        }
        this.saveBatch(false);
    }
}

